@echo off
:RESTART

@rem If you don't want REPL to print variable values automatically, set the below PRINT_REPL_VARS_AUTO value to false
set PRINT_REPL_VARS_AUTO=true

@rem this should point to the directory with ColdFusion's lib directory.
@rem if this is blank, this is probably a J2EE deployment and this should point
@rem to the /WEB-INF/cfusion directory
set CFUSION_HOME=%~dp0%\..
set CWD=%CD%

@rem This needs to point at the JAR file with the J2EE class files in it.
@rem It defaults to a value that is valid for the server install, but for
@rem a J2EE install you will need to modify it to point to the appropriate JAR file.
set J2EEJAR=%CFUSION_HOME%\runtime\lib\servlet-api.jar;%CFUSION_HOME%\runtime\lib\jsp-api.jar;%CFUSION_HOME%\runtime\lib\el-api.jar;%CFUSION_HOME%\runtime\lib\jasper.jar

@rem Following is the example for JBoss library path. Change it and uncomment it as per your Application server's JAR paths. 

@rem set J2EEJAR=C:\wildfly-31.0.1.Final\modules\system\layers\base\jakarta\servlet\api\main\jakarta.servlet-api-6.0.0.jar;C:\wildfly-31.0.1.Final\modules\system\layers\base\jakarta\servlet\jsp\api\main\jakarta.servlet.jsp-api-3.1.1.jar;C:\wildfly-31.0.1.Final\modules\system\layers\base\jakarta\el\api\main\jboss-el-api_5.0_spec-4.0.1.Final.jar;C:\wildfly-31.0.1.Final\modules\system\layers\base\io\undertow\jsp\main\jastow-2.2.7.Final.jar

@rem This needs to point to the WEB-INF directory for ColdFusion.
IF EXIST "%CFUSION_HOME%\wwwroot\WEB-INF" (
set WEBINF=%CFUSION_HOME%\wwwroot\WEB-INF
) ELSE (
set WEBINF=%CFUSION_HOME%\..
)

set PATH=%PATH%;%CFUSION_HOME%\runtime\jre\bin;%CFUSION_HOME%\runtime\bin

CALL "%CFUSION_HOME%\bin\findjava.bat"

@rem JVM argument usage 
@rem -Dcoldfusion.cli.log.level=Error/Info/Debug/Fatal/Warn - To control ColdFusion log level
@rem -Dcoldfusion.felix.log.level=Off/Error/Fatal/Warn/Debug - To control only felix log level

"%JAVACMD%" -Dtika.config=tika-config.xml -Djava.util.logging.config.file=%CFUSION_HOME%/lib/logging.properties --add-exports=java.desktop/sun.awt.image=ALL-UNNAMED --add-exports=java.desktop/sun.java2d=ALL-UNNAMED --add-exports=java.desktop/sun.awt=ALL-UNNAMED --add-opens=java.base/java.time=ALL-UNNAMED --add-opens=java.base/java.util=ALL-UNNAMED --add-opens=java.base/sun.security.rsa=ALL-UNNAMED --add-opens=java.base/sun.security.pkcs=ALL-UNNAMED --add-opens=java.base/sun.security.x509=ALL-UNNAMED --add-opens=java.base/sun.security.util=ALL-UNNAMED --add-opens=java.base/java.security=ALL-UNNAMED --add-opens=java.rmi/sun.rmi.transport=ALL-UNNAMED --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/sun.util.cldr=ALL-UNNAMED  --add-opens=java.base/sun.util.locale.provider=ALL-UNNAMED --add-opens=java.base/java.net=ALL-UNNAMED --add-opens=java.base/java.io=ALL-UNNAMED -cp "%J2EEJAR%;%WEBINF%\lib\*" -Dcom.sun.media.jai.disableMediaLib=true -Djava.awt.headless=true -Dfile.encoding=UTF8 -Dcoldfusion.repl.print=%PRINT_REPL_VARS_AUTO% -Dcoldfusion.home=%CFUSION_HOME% -Dcoldfusion.rootDir=%CFUSION_HOME% -Djava.security.policy=%CFUSION_HOME%/lib/coldfusion.policy -Djava.security.auth.policy=%CFUSION_HOME%/lib/neo_jaas.policy -Dcoldfusion.classPath=%CFUSION_HOME%/lib/updates,%CFUSION_HOME%/lib,%CFUSION_HOME%/lib/itext,%CFUSION_HOME%/runtime/lib,%CFUSION_HOME%/runtime/bin,%CFUSION_HOME%/bin/cf-bootstrap.jar,%CFUSION_HOME%/bin/cf-startup.jar,%CFUSION_HOME%/bin/cf-osgicli.jar,%CFUSION_HOME%/lib/axis2 -Djava.library.path=%CFUSION_HOME%/lib -Dcoldfusion.libPath=%CFUSION_HOME%/lib -Dcoldfusion.cli.log.level=Error -Dcoldfusion.felix.log.level=Off coldfusion.tools.CLIInvoker CLI %*

if ERRORLEVEL 10 goto RESTART






