@echo off

setlocal

@rem For EAR/WAR JEE deployments, you will need to modify it to point J2EEJAR to the appropriate jar file paths as per your application server.

@rem this should point to the directory with ColdFusions lib directory.

@rem if this is blank, this is probably a J2EE deployment and this should point

@rem to the /WEB-INF/cfusion directory

set CFUSION_HOME=%~dp0%\..



@rem This needs to point at the jar file with the J2EE class files in it.

@rem It defaults to a value that is valid for the server install, but for

@rem a J2EE install you will need to modify it to point to the appropriate jar file.

@rem Following is the example for JBoss library path. Change it and uncomment it as per your Application server's JAR paths. 

@rem set J2EEJAR=C:\wildfly-31.0.1.Final\modules\system\layers\base\jakarta\servlet\api\main\jakarta.servlet-api-6.0.0.jar


set J2EEJAR=%CFUSION_HOME%\runtime\lib\servlet-api.jar;%CFUSION_HOME%\runtime\lib\jsp-api.jar;%CFUSION_HOME%\runtime\lib\el-api.jar



@rem This needs to point to the WEB-INF directory of ColdFusion.

set WEBINF=%CFUSION_HOME%\wwwroot\WEB-INF

@rem For J2EE install

if NOT EXIST %WEBINF% (
    set WEBINF=%CFUSION_HOME%\..
	echo.
    echo "Note: For EAR/WAR JEE deployments, you will need to modify cfcompile script to set the variable J2EEJAR to your application server's jar file paths (servlet/jsp/el api)."
    echo "If you don't set, it you will get NoClassDefFoundError."
	echo.
)





set PATH=%PATH%;%CFUSION_HOME%\runtime\jre\bin;%CFUSION_HOME%\runtime\bin

if "%CFUSION_HOME%"=="" goto err_cfusion_home

if "%WEBINF%"=="" goto err_webinf



CALL "%CFUSION_HOME%\bin\findjava.bat"



set arg1=%1

if "%arg1%"=="-deploy" goto sourceless_deploy



set webroot=%~f1

set compdir=%~f2

if "%webroot%"=="" goto err_webroot

if "%compdir%"=="" goto setcompdir



goto aftercompdir



:setcompdir

set compdir=%~f1





:aftercompdir

"%JAVACMD%" --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/sun.util.cldr=ALL-UNNAMED  --add-opens=java.base/sun.util.locale.provider=ALL-UNNAMED -cp "%J2EEJAR%;%WEBINF%\lib\cfmx_bootstrap.jar;%WEBINF%\lib\cfx.jar;%WEBINF%\lib\cryptojce.jar" -Dcoldfusion.classPath=%CFUSION_HOME%/lib/updates,%CFUSION_HOME%/lib,%CFUSION_HOME%/../bundles,%CFUSION_HOME%/../bundles/repo -Dcoldfusion.libPath=%CFUSION_HOME%/lib coldfusion.tools.CommandLineInvoker Compiler -cfroot %CFUSION_HOME% -webinf %WEBINF% -webroot %webroot% %compdir%



goto end



:err_cfusion_home

echo.

echo CFUSION_HOME not set.  Please set CFUSION_HOME to your CFMX root directory

goto end



:err_webinf

echo.

echo WEBINF not set.  Please set WEBINF to your WEB-INF directory for ColdFusion.

goto end



:err_webroot

echo.

echo Webroot is not set. Please specify the location of the webroot directory

goto useage



:useage

echo.

echo To compile files into .class files

echo.

echo     "cfcompile.bat  <webroot directory>  <directory to compile>"

echo.

echo To compile files into a binary format without the need for source

echo.

echo     "cfcompile.bat -deploy <webroot directory> <directory to compile> <output directory>"

echo.

echo webroot directory - Specify the directory location of the webroot

echo.

echo directory to compile 

echo      Specify the fully qualified name of the directory where 

echo      the files are located to be compiled. This directory must be

echo      under the webroot directory.  If not specified, all ColdFusion

echo      templates in the webroot directory will be compiled.  This is 

echo      required for the -deploy option.

echo.

echo output directory

echo      Specify the directory to write the compiled deployable files to.

echo      this can not be the same directory as the source directory.

goto end

endlocal



:sourceless_deploy

set webroot=%~f2

set srcdir=%~f3

set deploydir=%~f4

if "%webroot%"=="" goto err_deploy_webroot

if "%srcdir%"=="" goto err_deploy_srcdir

if "%deploydir%"=="" goto err_deploy_dir



goto afterdeploycompdir



:afterdeploycompdir

"%JAVACMD%" --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/sun.util.cldr=ALL-UNNAMED  --add-opens=java.base/sun.util.locale.provider=ALL-UNNAMED -cp "%J2EEJAR%;%WEBINF%\lib\cfmx_bootstrap.jar;%WEBINF%\lib\cfx.jar;%WEBINF%\lib\cryptojce.jar" -Dcoldfusion.classPath=%CFUSION_HOME%/lib/updates,%CFUSION_HOME%/lib,%CFUSION_HOME%/../bundles,%CFUSION_HOME%/../bundles/repo -Dcoldfusion.libPath=%CFUSION_HOME%/lib coldfusion.tools.CommandLineInvoker Compiler -webinf %WEBINF% -webroot %webroot% -cfroot %CFUSION_HOME% -d -srcdir %srcdir% -deploydir %deploydir%





goto end



:err_deploy_srcdir

echo.

echo Source directory not set.  Please specify the directory you wish to compile

goto useage



:err_deploy_dir

echo.

echo Output directory not set.  Please specify the output directory

goto useage



:err_deploy_webroot

echo.

echo Webroot is not set. Please specify the location of the webroot directory

goto useage



endlocal



:end















