/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.FormatWidth;
import com.ibm.icu.util.UResourceBundle;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureUnit
implements Comparable<MeasureUnit>,
Serializable {
    private static final long serialVersionUID = -1839973855554750484L;
    private static final Map<String, Map<String, MeasureUnit>> cache = new HashMap<String, Map<String, MeasureUnit>>();
    protected final String type;
    protected final String code;
    static final UnicodeSet ASCII = new UnicodeSet(97, 122).freeze();
    static final UnicodeSet ASCII_HYPHEN = new UnicodeSet(45, 45, 97, 122).freeze();
    private static Factory UNIT_FACTORY = new Factory(){

        public MeasureUnit create(String type, String code) {
            return new MeasureUnit(type, code);
        }
    };
    static Factory CURRENCY_FACTORY = new Factory(){

        public MeasureUnit create(String type, String code) {
            return new Currency(code);
        }
    };
    public static final MeasureUnit G_FORCE;
    public static final MeasureUnit DEGREE;
    public static final MeasureUnit ARC_MINUTE;
    public static final MeasureUnit ARC_SECOND;
    public static final MeasureUnit ACRE;
    public static final MeasureUnit HECTARE;
    public static final MeasureUnit SQUARE_FOOT;
    public static final MeasureUnit SQUARE_KILOMETER;
    public static final MeasureUnit SQUARE_METER;
    public static final MeasureUnit SQUARE_MILE;
    public static final MeasureUnit DAY;
    public static final MeasureUnit HOUR;
    public static final MeasureUnit MILLISECOND;
    public static final MeasureUnit MINUTE;
    public static final MeasureUnit MONTH;
    public static final MeasureUnit SECOND;
    public static final MeasureUnit WEEK;
    public static final MeasureUnit YEAR;
    public static final MeasureUnit CENTIMETER;
    public static final MeasureUnit FOOT;
    public static final MeasureUnit INCH;
    public static final MeasureUnit KILOMETER;
    public static final MeasureUnit LIGHT_YEAR;
    public static final MeasureUnit METER;
    public static final MeasureUnit MILE;
    public static final MeasureUnit MILLIMETER;
    public static final MeasureUnit PICOMETER;
    public static final MeasureUnit YARD;
    public static final MeasureUnit GRAM;
    public static final MeasureUnit KILOGRAM;
    public static final MeasureUnit OUNCE;
    public static final MeasureUnit POUND;
    public static final MeasureUnit HORSEPOWER;
    public static final MeasureUnit KILOWATT;
    public static final MeasureUnit WATT;
    public static final MeasureUnit HECTOPASCAL;
    public static final MeasureUnit INCH_HG;
    public static final MeasureUnit MILLIBAR;
    public static final MeasureUnit KILOMETER_PER_HOUR;
    public static final MeasureUnit METER_PER_SECOND;
    public static final MeasureUnit MILE_PER_HOUR;
    public static final MeasureUnit CELSIUS;
    public static final MeasureUnit FAHRENHEIT;
    public static final MeasureUnit CUBIC_KILOMETER;
    public static final MeasureUnit CUBIC_MILE;
    public static final MeasureUnit LITER;

    protected MeasureUnit(String type, String code) {
        this.type = type;
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeasureUnit getInstance(String type, String code) {
        Class<MeasureUnit> clazz = MeasureUnit.class;
        synchronized (MeasureUnit.class) {
            MeasureUnit result;
            Map<String, MeasureUnit> tmp = cache.get(type);
            if (tmp != null && (result = tmp.get(code)) != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (type == null || !ASCII.containsAll(type) || code == null || !ASCII_HYPHEN.containsAll(code)) {
                throw new NullPointerException("The type or code are invalid.");
            }
            return MeasureUnit.addUnit(type, code, UNIT_FACTORY);
        }
    }

    protected static synchronized MeasureUnit addUnit(String type, String unitName, Factory factory) {
        Map<String, MeasureUnit> tmp = cache.get(type);
        if (tmp == null) {
            tmp = new HashMap<String, MeasureUnit>();
            cache.put(type, tmp);
        } else {
            type = tmp.entrySet().iterator().next().getValue().type;
        }
        MeasureUnit unit = tmp.get(unitName);
        if (unit == null) {
            unit = factory.create(type, unitName);
            tmp.put(unitName, unit);
        }
        return unit;
    }

    public static synchronized Set<String> getAvailableTypes() {
        return new HashSet<String>(cache.keySet());
    }

    public static synchronized Collection<MeasureUnit> getAvailable(String type) {
        Map<String, MeasureUnit> units = cache.get(type);
        return units == null ? null : new ArrayList<MeasureUnit>(units.values());
    }

    public static synchronized Set<MeasureUnit> getAvailable() {
        TreeSet<MeasureUnit> result = new TreeSet<MeasureUnit>();
        for (String type : new TreeSet<String>(MeasureUnit.getAvailableTypes())) {
            for (MeasureUnit unit : MeasureUnit.getAvailable(type)) {
                result.add(unit);
            }
        }
        return result;
    }

    public int hashCode() {
        return this.code.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            MeasureUnit c = (MeasureUnit)rhs;
            return this.type.equals(c.type) && this.code.equals(c.code);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int compareTo(MeasureUnit other) {
        int diff;
        return this == other ? 0 : ((diff = this.type.compareTo(other.type)) != 0 ? diff : this.code.compareTo(other.code));
    }

    public String toString() {
        return this.type + "-" + this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MeasureUnitProxy(this.type, this.code);
    }

    static {
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt52b", "en");
        for (FormatWidth key : FormatWidth.values()) {
            try {
                ICUResourceBundle unitsTypeRes = resource.getWithFallback(key.resourceKey);
                int size = unitsTypeRes.getSize();
                for (int index = 0; index < size; ++index) {
                    UResourceBundle unitsRes = unitsTypeRes.get(index);
                    String type = unitsRes.getKey();
                    int unitsSize = unitsRes.getSize();
                    for (int index2 = 0; index2 < unitsSize; ++index2) {
                        String unitName = unitsRes.get(index2).getKey();
                        MeasureUnit.addUnit(type, unitName, UNIT_FACTORY);
                    }
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt52b", "currencyNumericCodes", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle codeMap = bundle.get("codeMap");
            Enumeration<String> it = codeMap.getKeys();
            while (it.hasMoreElements()) {
                MeasureUnit.addUnit("currency", it.nextElement(), CURRENCY_FACTORY);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        G_FORCE = MeasureUnit.getInstance("acceleration", "g-force");
        DEGREE = MeasureUnit.getInstance("angle", "degree");
        ARC_MINUTE = MeasureUnit.getInstance("angle", "minute");
        ARC_SECOND = MeasureUnit.getInstance("angle", "second");
        ACRE = MeasureUnit.getInstance("area", "acre");
        HECTARE = MeasureUnit.getInstance("area", "hectare");
        SQUARE_FOOT = MeasureUnit.getInstance("area", "square-foot");
        SQUARE_KILOMETER = MeasureUnit.getInstance("area", "square-kilometer");
        SQUARE_METER = MeasureUnit.getInstance("area", "square-meter");
        SQUARE_MILE = MeasureUnit.getInstance("area", "square-mile");
        DAY = MeasureUnit.getInstance("duration", "day");
        HOUR = MeasureUnit.getInstance("duration", "hour");
        MILLISECOND = MeasureUnit.getInstance("duration", "millisecond");
        MINUTE = MeasureUnit.getInstance("duration", "minute");
        MONTH = MeasureUnit.getInstance("duration", "month");
        SECOND = MeasureUnit.getInstance("duration", "second");
        WEEK = MeasureUnit.getInstance("duration", "week");
        YEAR = MeasureUnit.getInstance("duration", "year");
        CENTIMETER = MeasureUnit.getInstance("length", "centimeter");
        FOOT = MeasureUnit.getInstance("length", "foot");
        INCH = MeasureUnit.getInstance("length", "inch");
        KILOMETER = MeasureUnit.getInstance("length", "kilometer");
        LIGHT_YEAR = MeasureUnit.getInstance("length", "light-year");
        METER = MeasureUnit.getInstance("length", "meter");
        MILE = MeasureUnit.getInstance("length", "mile");
        MILLIMETER = MeasureUnit.getInstance("length", "millimeter");
        PICOMETER = MeasureUnit.getInstance("length", "picometer");
        YARD = MeasureUnit.getInstance("length", "yard");
        GRAM = MeasureUnit.getInstance("mass", "gram");
        KILOGRAM = MeasureUnit.getInstance("mass", "kilogram");
        OUNCE = MeasureUnit.getInstance("mass", "ounce");
        POUND = MeasureUnit.getInstance("mass", "pound");
        HORSEPOWER = MeasureUnit.getInstance("power", "horsepower");
        KILOWATT = MeasureUnit.getInstance("power", "kilowatt");
        WATT = MeasureUnit.getInstance("power", "watt");
        HECTOPASCAL = MeasureUnit.getInstance("pressure", "hectopascal");
        INCH_HG = MeasureUnit.getInstance("pressure", "inch-hg");
        MILLIBAR = MeasureUnit.getInstance("pressure", "millibar");
        KILOMETER_PER_HOUR = MeasureUnit.getInstance("speed", "kilometer-per-hour");
        METER_PER_SECOND = MeasureUnit.getInstance("speed", "meter-per-second");
        MILE_PER_HOUR = MeasureUnit.getInstance("speed", "mile-per-hour");
        CELSIUS = MeasureUnit.getInstance("temperature", "celsius");
        FAHRENHEIT = MeasureUnit.getInstance("temperature", "fahrenheit");
        CUBIC_KILOMETER = MeasureUnit.getInstance("volume", "cubic-kilometer");
        CUBIC_MILE = MeasureUnit.getInstance("volume", "cubic-mile");
        LITER = MeasureUnit.getInstance("volume", "liter");
    }

    static final class MeasureUnitProxy
    implements Externalizable {
        private static final long serialVersionUID = -3910681415330989598L;
        private String type;
        private String code;

        public MeasureUnitProxy(String type, String code) {
            this.type = type;
            this.code = code;
        }

        public MeasureUnitProxy() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeUTF(this.type);
            out.writeUTF(this.code);
            out.writeShort(0);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            in.readByte();
            this.type = in.readUTF();
            this.code = in.readUTF();
            short extra = in.readShort();
            if (extra > 0) {
                byte[] extraBytes = new byte[extra];
                in.read(extraBytes, 0, extra);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return "currency".equals(this.type) ? Currency.getInstance(this.code) : MeasureUnit.getInstance(this.type, this.code);
        }
    }

    protected static interface Factory {
        public MeasureUnit create(String var1, String var2);
    }
}

