/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.StringUtils;

public abstract class AbstractCvsTask
extends Task {
    public static final int DEFAULT_COMPRESSION_LEVEL = 3;
    private static final int MAXIMUM_COMRESSION_LEVEL = 9;
    private Commandline cmd = new Commandline();
    private Vector vecCommandlines = new Vector();
    private String cvsRoot;
    private String cvsRsh;
    private String cvsPackage;
    private static final String DEFAULT_COMMAND = "checkout";
    private String command = null;
    private boolean quiet = false;
    private boolean reallyquiet = false;
    private int compression = 0;
    private boolean noexec = false;
    private int port = 0;
    private File passFile = null;
    private File dest;
    private boolean append = false;
    private File output;
    private File error;
    private boolean failOnError = false;
    private ExecuteStreamHandler executeStreamHandler;
    private OutputStream outputStream;
    private OutputStream errorStream;

    public void setExecuteStreamHandler(ExecuteStreamHandler handler) {
        this.executeStreamHandler = handler;
    }

    protected ExecuteStreamHandler getExecuteStreamHandler() {
        if (this.executeStreamHandler == null) {
            this.setExecuteStreamHandler(new PumpStreamHandler(this.getOutputStream(), this.getErrorStream()));
        }
        return this.executeStreamHandler;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected OutputStream getOutputStream() {
        if (this.outputStream == null) {
            if (this.output != null) {
                try {
                    this.setOutputStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getPath(), this.append))));
                }
                catch (IOException e) {
                    throw new BuildException(e, this.getLocation());
                }
            } else {
                this.setOutputStream(new LogOutputStream(this, 2));
            }
        }
        return this.outputStream;
    }

    protected void setErrorStream(OutputStream errorStream) {
        this.errorStream = errorStream;
    }

    protected OutputStream getErrorStream() {
        if (this.errorStream == null) {
            if (this.error != null) {
                try {
                    this.setErrorStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.error.getPath(), this.append))));
                }
                catch (IOException e) {
                    throw new BuildException(e, this.getLocation());
                }
            } else {
                this.setErrorStream(new LogOutputStream(this, 1));
            }
        }
        return this.errorStream;
    }

    /*
     * Loose catch block
     */
    protected void runCommand(Commandline toExecute) throws BuildException {
        block44: {
            IOException e22222;
            block42: {
                File defaultPassFile;
                Environment.Variable var;
                Environment env = new Environment();
                if (this.port > 0) {
                    var = new Environment.Variable();
                    var.setKey("CVS_CLIENT_PORT");
                    var.setValue(String.valueOf(this.port));
                    env.addVariable(var);
                }
                if (this.passFile == null && (defaultPassFile = new File(System.getProperty("cygwin.user.home", System.getProperty("user.home")) + File.separatorChar + ".cvspass")).exists()) {
                    this.setPassfile(defaultPassFile);
                }
                if (this.passFile != null) {
                    if (this.passFile.isFile() && this.passFile.canRead()) {
                        var = new Environment.Variable();
                        var.setKey("CVS_PASSFILE");
                        var.setValue(String.valueOf(this.passFile));
                        env.addVariable(var);
                        this.log("Using cvs passfile: " + String.valueOf(this.passFile), 2);
                    } else if (!this.passFile.canRead()) {
                        this.log("cvs passfile: " + String.valueOf(this.passFile) + " ignored as it is not readable", 1);
                    } else {
                        this.log("cvs passfile: " + String.valueOf(this.passFile) + " ignored as it is not a file", 1);
                    }
                }
                if (this.cvsRsh != null) {
                    var = new Environment.Variable();
                    var.setKey("CVS_RSH");
                    var.setValue(String.valueOf(this.cvsRsh));
                    env.addVariable(var);
                }
                Execute exe = new Execute(this.getExecuteStreamHandler(), null);
                exe.setAntRun(this.getProject());
                if (this.dest == null) {
                    this.dest = this.getProject().getBaseDir();
                }
                if (!this.dest.exists()) {
                    this.dest.mkdirs();
                }
                exe.setWorkingDirectory(this.dest);
                exe.setCommandline(toExecute.getCommandline());
                exe.setEnvironment(env.getVariables());
                String actualCommandLine = this.executeToString(exe);
                this.log(actualCommandLine, 3);
                int retCode = exe.execute();
                this.log("retCode=" + retCode, 4);
                if (this.failOnError && Execute.isFailure(retCode)) {
                    throw new BuildException("cvs exited with error code " + retCode + StringUtils.LINE_SEP + "Command line was [" + actualCommandLine + "]", this.getLocation());
                }
                Object var8_8 = null;
                if (this.outputStream == null) break block42;
                try {
                    this.outputStream.close();
                }
                catch (IOException e22222) {
                    // empty catch block
                }
            }
            if (this.errorStream != null) {
                try {
                    this.errorStream.close();
                }
                catch (IOException e22222) {}
            }
            break block44;
            {
                catch (IOException e3) {
                    IOException e22222;
                    if (this.failOnError) {
                        throw new BuildException(e3, this.getLocation());
                    }
                    this.log("Caught exception: " + e3.getMessage(), 1);
                    Object var8_9 = null;
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.close();
                        }
                        catch (IOException e22222) {
                            // empty catch block
                        }
                    }
                    if (this.errorStream != null) {
                        try {
                            this.errorStream.close();
                        }
                        catch (IOException e22222) {}
                    }
                    break block44;
                }
                catch (BuildException e4) {
                    IOException e22222;
                    if (this.failOnError) {
                        throw e4;
                    }
                    Throwable t = e4.getException();
                    if (t == null) {
                        t = e4;
                    }
                    this.log("Caught exception: " + t.getMessage(), 1);
                    Object var8_10 = null;
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.close();
                        }
                        catch (IOException e22222) {
                            // empty catch block
                        }
                    }
                    if (this.errorStream != null) {
                        try {
                            this.errorStream.close();
                        }
                        catch (IOException e22222) {}
                    }
                    break block44;
                }
                catch (Exception e5) {
                    IOException e22222;
                    if (this.failOnError) {
                        throw new BuildException(e5, this.getLocation());
                    }
                    this.log("Caught exception: " + e5.getMessage(), 1);
                    Object var8_11 = null;
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.close();
                        }
                        catch (IOException e22222) {
                            // empty catch block
                        }
                    }
                    if (this.errorStream != null) {
                        try {
                            this.errorStream.close();
                        }
                        catch (IOException e22222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e22222;
                Object var8_12 = null;
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e22222) {
                        // empty catch block
                    }
                }
                if (this.errorStream != null) {
                    try {
                        this.errorStream.close();
                    }
                    catch (IOException e22222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void execute() throws BuildException {
        String savedCommand = this.getCommand();
        if (this.getCommand() == null && this.vecCommandlines.size() == 0) {
            this.setCommand(DEFAULT_COMMAND);
        }
        String c = this.getCommand();
        Commandline cloned = null;
        if (c != null) {
            cloned = (Commandline)this.cmd.clone();
            cloned.createArgument(true).setLine(c);
            this.addConfiguredCommandline(cloned, true);
        }
        try {
            int i = 0;
            while (i < this.vecCommandlines.size()) {
                this.runCommand((Commandline)this.vecCommandlines.elementAt(i));
                ++i;
            }
            Object var6_5 = null;
            if (cloned != null) {
                this.removeCommandline(cloned);
            }
            this.setCommand(savedCommand);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (cloned != null) {
                this.removeCommandline(cloned);
            }
            this.setCommand(savedCommand);
            throw throwable;
        }
    }

    private String executeToString(Execute execute) {
        StringBuffer stringBuffer = new StringBuffer(Commandline.describeCommand(execute.getCommandline()));
        String newLine = StringUtils.LINE_SEP;
        String[] variableArray = execute.getEnvironment();
        if (variableArray != null) {
            stringBuffer.append(newLine);
            stringBuffer.append(newLine);
            stringBuffer.append("environment:");
            stringBuffer.append(newLine);
            int z = 0;
            while (z < variableArray.length) {
                stringBuffer.append(newLine);
                stringBuffer.append("\t");
                stringBuffer.append(variableArray[z]);
                ++z;
            }
        }
        return stringBuffer.toString();
    }

    public void setCvsRoot(String root) {
        if (root != null && root.trim().equals("")) {
            root = null;
        }
        this.cvsRoot = root;
    }

    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRsh(String rsh) {
        if (rsh != null && rsh.trim().equals("")) {
            rsh = null;
        }
        this.cvsRsh = rsh;
    }

    public String getCvsRsh() {
        return this.cvsRsh;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPassfile(File passFile) {
        this.passFile = passFile;
    }

    public File getPassFile() {
        return this.passFile;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public File getDest() {
        return this.dest;
    }

    public void setPackage(String p) {
        this.cvsPackage = p;
    }

    public String getPackage() {
        return this.cvsPackage;
    }

    public void setTag(String p) {
        if (p != null && p.trim().length() > 0) {
            this.addCommandArgument("-r");
            this.addCommandArgument(p);
        }
    }

    public void addCommandArgument(String arg) {
        this.addCommandArgument(this.cmd, arg);
    }

    public void addCommandArgument(Commandline c, String arg) {
        c.createArgument().setValue(arg);
    }

    public void setDate(String p) {
        if (p != null && p.trim().length() > 0) {
            this.addCommandArgument("-D");
            this.addCommandArgument(p);
        }
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public String getCommand() {
        return this.command;
    }

    public void setQuiet(boolean q) {
        this.quiet = q;
    }

    public void setReallyquiet(boolean q) {
        this.reallyquiet = q;
    }

    public void setNoexec(boolean ne) {
        this.noexec = ne;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected void configureCommandline(Commandline c) {
        if (c == null) {
            return;
        }
        c.setExecutable("cvs");
        if (this.cvsPackage != null) {
            c.createArgument().setLine(this.cvsPackage);
        }
        if (this.compression > 0 && this.compression <= 9) {
            c.createArgument(true).setValue("-z" + this.compression);
        }
        if (this.quiet && !this.reallyquiet) {
            c.createArgument(true).setValue("-q");
        }
        if (this.reallyquiet) {
            c.createArgument(true).setValue("-Q");
        }
        if (this.noexec) {
            c.createArgument(true).setValue("-n");
        }
        if (this.cvsRoot != null) {
            c.createArgument(true).setLine("-d" + this.cvsRoot);
        }
    }

    protected void removeCommandline(Commandline c) {
        this.vecCommandlines.removeElement(c);
    }

    public void addConfiguredCommandline(Commandline c) {
        this.addConfiguredCommandline(c, false);
    }

    public void addConfiguredCommandline(Commandline c, boolean insertAtStart) {
        if (c == null) {
            return;
        }
        this.configureCommandline(c);
        if (insertAtStart) {
            this.vecCommandlines.insertElementAt(c, 0);
        } else {
            this.vecCommandlines.addElement(c);
        }
    }

    public void setCompressionLevel(int level) {
        this.compression = level;
    }

    public void setCompression(boolean usecomp) {
        this.setCompressionLevel(usecomp ? 3 : 0);
    }
}

