/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MacroDef;

public class MacroInstance
extends Task
implements DynamicConfigurator {
    private MacroDef macroDef;
    private Map map = new HashMap();
    private Map nsElements = null;
    private Map presentElements = new HashMap();
    private Hashtable localProperties = new Hashtable();
    private static final int STATE_NORMAL = 0;
    private static final int STATE_EXPECT_BRACKET = 1;
    private static final int STATE_EXPECT_NAME = 2;
    private static final int STATE_EXPECT_EXCAPE = 3;

    public void setMacroDef(MacroDef macroDef) {
        this.macroDef = macroDef;
    }

    public void setDynamicAttribute(String name, String value) {
        this.map.put(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        if (this.getNsElements().get(name) == null) {
            throw new BuildException("unsupported element " + name);
        }
        if (this.presentElements.get(name) != null) {
            throw new BuildException("Element " + name + " already present");
        }
        Element ret = new Element();
        this.presentElements.put(name, ret);
        return ret;
    }

    private Map getNsElements() {
        if (this.nsElements == null) {
            this.nsElements = new HashMap();
            Iterator i = this.macroDef.getElements().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.nsElements.put((String)entry.getKey(), entry.getValue());
            }
        }
        return this.nsElements;
    }

    private String macroSubs(String s, Map macroMapping) {
        if (s == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        StringBuffer macroName = null;
        boolean inMacro = false;
        int state = 0;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '@') {
                        state = 1;
                        break;
                    }
                    ret.append(ch);
                    break;
                }
                case 1: {
                    if (ch == '{') {
                        state = 2;
                        macroName = new StringBuffer();
                        break;
                    }
                    if (ch == '@') {
                        state = 3;
                        break;
                    }
                    state = 0;
                    ret.append('@');
                    ret.append(ch);
                    break;
                }
                case 2: {
                    if (ch == '}') {
                        state = 0;
                        String name = macroName.toString();
                        String value = (String)macroMapping.get(name);
                        if (value == null) {
                            ret.append("@{" + name + "}");
                        } else {
                            ret.append(value);
                        }
                        macroName = null;
                        break;
                    }
                    macroName.append(ch);
                    break;
                }
                case 3: {
                    state = 0;
                    if (ch == '{') {
                        ret.append("@");
                    } else {
                        ret.append("@@");
                    }
                    ret.append(ch);
                    break;
                }
            }
            ++i;
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                ret.append('@');
                break;
            }
            case 2: {
                ret.append("@{");
                ret.append(macroName.toString());
                break;
            }
            case 3: {
                ret.append("@@");
                break;
            }
        }
        return ret.toString();
    }

    private UnknownElement copy(UnknownElement ue) {
        UnknownElement ret = new UnknownElement(ue.getTag());
        ret.setNamespace(ue.getNamespace());
        ret.setProject(this.getProject());
        ret.setQName(ue.getQName());
        ret.setTaskName(ue.getTaskName());
        ret.setLocation(ue.getLocation());
        if (this.getOwningTarget() == null) {
            Target t = new Target();
            t.setProject(this.getProject());
            ret.setOwningTarget(t);
        } else {
            ret.setOwningTarget(this.getOwningTarget());
        }
        RuntimeConfigurable rc = new RuntimeConfigurable(ret, ue.getTaskName());
        rc.setPolyType(ue.getWrapper().getPolyType());
        Hashtable map = ue.getWrapper().getAttributeMap();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            rc.setAttribute((String)entry.getKey(), this.macroSubs((String)entry.getValue(), this.localProperties));
        }
        rc.addText(this.macroSubs(ue.getWrapper().getText().toString(), this.localProperties));
        Enumeration e = ue.getWrapper().getChildren();
        while (e.hasMoreElements()) {
            RuntimeConfigurable r = (RuntimeConfigurable)e.nextElement();
            UnknownElement unknownElement = (UnknownElement)r.getProxy();
            String tag = unknownElement.getTaskType();
            MacroDef.TemplateElement templateElement = (MacroDef.TemplateElement)this.getNsElements().get(tag);
            if (templateElement == null) {
                UnknownElement child = this.copy(unknownElement);
                rc.addChild(child.getWrapper());
                ret.addChild(child);
                continue;
            }
            Element element = (Element)this.presentElements.get(tag);
            if (element == null) {
                if (templateElement.isOptional()) continue;
                throw new BuildException("Required nested element " + templateElement.getName() + " missing");
            }
            Iterator i2 = element.getUnknownElements().iterator();
            while (i2.hasNext()) {
                UnknownElement child = (UnknownElement)i2.next();
                rc.addChild(child.getWrapper());
                ret.addChild(child);
            }
        }
        return ret;
    }

    public void execute() {
        this.localProperties = new Hashtable();
        HashSet copyKeys = new HashSet(this.map.keySet());
        Iterator i = this.macroDef.getAttributes().iterator();
        while (i.hasNext()) {
            MacroDef.Attribute attribute = (MacroDef.Attribute)i.next();
            String value = (String)this.map.get(attribute.getName());
            if (value == null) {
                value = attribute.getDefault();
                value = this.macroSubs(value, this.localProperties);
            }
            if (value == null) {
                throw new BuildException("required attribute " + attribute.getName() + " not set");
            }
            this.localProperties.put(attribute.getName(), value);
            copyKeys.remove(attribute.getName());
        }
        if (copyKeys.contains("id")) {
            copyKeys.remove("id");
        }
        if (copyKeys.size() != 0) {
            throw new BuildException("Unknown attribute" + (copyKeys.size() > 1 ? "s " : " ") + copyKeys);
        }
        UnknownElement c = this.copy(this.macroDef.getNestedTask());
        c.init();
        try {
            c.perform();
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException(ex, this.getLocation());
        }
    }

    public static class Element
    implements TaskContainer {
        private List unknownElements = new ArrayList();

        public void addTask(Task nestedTask) {
            this.unknownElements.add(nestedTask);
        }

        public List getUnknownElements() {
            return this.unknownElements;
        }
    }
}

