/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LineTokenizer;

public class FileUtils {
    private static Random rand = new Random(System.currentTimeMillis());
    private static Object lockReflection = new Object();
    private static Method setLastModified = null;
    private boolean onNetWare = Os.isFamily("netware");
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    static /* synthetic */ Class class$java$io$File;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    protected FileUtils() {
    }

    public URL getFileURL(File file) throws MalformedURLException {
        return new URL(this.toURI(file.getAbsolutePath()));
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), null, false, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, false, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, preserveLastModified);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified, String encoding) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, preserveLastModified, encoding);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String encoding, Project project) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, filterChains, overwrite, preserveLastModified, encoding, project);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, filterChains, overwrite, preserveLastModified, inputEncoding, outputEncoding, project);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, null, false, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters) throws IOException {
        this.copyFile(sourceFile, destFile, filters, false, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite) throws IOException {
        this.copyFile(sourceFile, destFile, filters, overwrite, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(sourceFile, destFile, filters, overwrite, preserveLastModified, null);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified, String encoding) throws IOException {
        this.copyFile(sourceFile, destFile, filters, null, overwrite, preserveLastModified, encoding, null);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String encoding, Project project) throws IOException {
        this.copyFile(sourceFile, destFile, filters, filterChains, overwrite, preserveLastModified, encoding, encoding, project);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        block32: {
            block34: {
                FileInputStream in;
                block31: {
                    block35: {
                        BufferedReader in2;
                        block30: {
                            boolean filterChainsAvailable;
                            block33: {
                                BufferedReader in3;
                                block29: {
                                    File parent;
                                    if (!overwrite && destFile.exists() && destFile.lastModified() >= sourceFile.lastModified()) break block32;
                                    if (destFile.exists() && destFile.isFile()) {
                                        destFile.delete();
                                    }
                                    if ((parent = this.getParentFile(destFile)) != null && !parent.exists()) {
                                        parent.mkdirs();
                                    }
                                    boolean filterSetsAvailable = filters != null && filters.hasFilters();
                                    boolean bl = filterChainsAvailable = filterChains != null && filterChains.size() > 0;
                                    if (!filterSetsAvailable) break block33;
                                    in3 = null;
                                    BufferedWriter out = null;
                                    try {
                                        if (inputEncoding == null) {
                                            in3 = new BufferedReader(new FileReader(sourceFile));
                                        } else {
                                            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(sourceFile), inputEncoding);
                                            in3 = new BufferedReader(isr);
                                        }
                                        if (outputEncoding == null) {
                                            out = new BufferedWriter(new FileWriter(destFile));
                                        } else {
                                            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), outputEncoding);
                                            out = new BufferedWriter(osw);
                                        }
                                        if (filterChainsAvailable) {
                                            ChainReaderHelper crh = new ChainReaderHelper();
                                            crh.setBufferSize(8192);
                                            crh.setPrimaryReader(in3);
                                            crh.setFilterChains(filterChains);
                                            crh.setProject(project);
                                            Reader rdr = crh.getAssembledReader();
                                            in3 = new BufferedReader(rdr);
                                        }
                                        LineTokenizer lineTokenizer = new LineTokenizer();
                                        lineTokenizer.setIncludeDelims(true);
                                        String newline = null;
                                        String line = lineTokenizer.getToken(in3);
                                        while (line != null) {
                                            if (line.length() == 0) {
                                                out.newLine();
                                            } else {
                                                newline = filters.replaceTokens(line);
                                                out.write(newline);
                                            }
                                            line = lineTokenizer.getToken(in3);
                                        }
                                        Object var19_27 = null;
                                        if (out == null) break block29;
                                    }
                                    catch (Throwable throwable) {
                                        Object var19_28 = null;
                                        if (out != null) {
                                            out.close();
                                        }
                                        if (in3 != null) {
                                            in3.close();
                                        }
                                        throw throwable;
                                    }
                                    out.close();
                                }
                                if (in3 != null) {
                                    in3.close();
                                }
                                break block34;
                            }
                            if (!filterChainsAvailable && (inputEncoding == null || inputEncoding.equals(outputEncoding)) && (inputEncoding != null || outputEncoding == null)) break block35;
                            in2 = null;
                            BufferedWriter out = null;
                            try {
                                int nRead;
                                in2 = inputEncoding == null ? new BufferedReader(new FileReader(sourceFile)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), inputEncoding));
                                out = outputEncoding == null ? new BufferedWriter(new FileWriter(destFile)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), outputEncoding));
                                if (filterChainsAvailable) {
                                    ChainReaderHelper crh = new ChainReaderHelper();
                                    crh.setBufferSize(8192);
                                    crh.setPrimaryReader(in2);
                                    crh.setFilterChains(filterChains);
                                    crh.setProject(project);
                                    Reader rdr = crh.getAssembledReader();
                                    in2 = new BufferedReader(rdr);
                                }
                                char[] buffer = new char[8192];
                                while ((nRead = in2.read(buffer, 0, buffer.length)) != -1) {
                                    out.write(buffer, 0, nRead);
                                }
                                Object var21_30 = null;
                                if (out == null) break block30;
                            }
                            catch (Throwable throwable) {
                                Object var21_31 = null;
                                if (out != null) {
                                    out.close();
                                }
                                if (in2 != null) {
                                    in2.close();
                                }
                                throw throwable;
                            }
                            out.close();
                        }
                        if (in2 != null) {
                            in2.close();
                        }
                        break block34;
                    }
                    in = null;
                    FileOutputStream out = null;
                    try {
                        in = new FileInputStream(sourceFile);
                        out = new FileOutputStream(destFile);
                        byte[] buffer = new byte[8192];
                        int count = 0;
                        do {
                            out.write(buffer, 0, count);
                        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                        Object var23_33 = null;
                        if (out == null) break block31;
                    }
                    catch (Throwable throwable) {
                        Object var23_34 = null;
                        if (out != null) {
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            if (preserveLastModified) {
                this.setFileLastModified(destFile, sourceFile.lastModified());
            }
        }
    }

    protected final Method getSetLastModified() {
        if (JavaEnvUtils.isJavaVersion("1.1")) {
            return null;
        }
        Object object = lockReflection;
        synchronized (object) {
            if (setLastModified == null) {
                try {
                    setLastModified = (class$java$io$File == null ? (class$java$io$File = FileUtils.class$("java.io.File")) : class$java$io$File).getMethod("setLastModified", Long.TYPE);
                }
                catch (NoSuchMethodException nse) {
                    throw new BuildException("File.setlastModified not in JDK > 1.1?", nse);
                }
            }
        }
        return setLastModified;
    }

    public void setFileLastModified(File file, long time) throws BuildException {
        if (JavaEnvUtils.isJavaVersion("1.1")) {
            return;
        }
        Object[] times = new Long[]{time < 0L ? new Long(System.currentTimeMillis()) : new Long(time)};
        try {
            this.getSetLastModified().invoke((Object)file, times);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            throw new BuildException("Exception setting the modification time of " + file, nested);
        }
        catch (Throwable other) {
            throw new BuildException("Exception setting the modification time of " + file, other);
        }
    }

    public File resolveFile(File file, String filename) {
        filename = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (!this.onNetWare) {
            if (filename.startsWith(File.separator) || filename.length() >= 2 && Character.isLetter(filename.charAt(0)) && filename.charAt(1) == ':') {
                return this.normalize(filename);
            }
        } else {
            int colon = filename.indexOf(":");
            if (filename.startsWith(File.separator) || colon > -1) {
                return this.normalize(filename);
            }
        }
        if (file == null) {
            return new File(filename);
        }
        File helpFile = new File(file.getAbsolutePath());
        StringTokenizer tok = new StringTokenizer(filename, File.separator);
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (part.equals("..")) {
                if ((helpFile = this.getParentFile(helpFile)) != null) continue;
                String msg = "The file or path you specified (" + filename + ") is invalid relative to " + file.getPath();
                throw new BuildException(msg);
            }
            if (part.equals(".")) continue;
            helpFile = new File(helpFile, part);
        }
        return new File(helpFile.getAbsolutePath());
    }

    public File normalize(String path) {
        String orig = path;
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!this.onNetWare) {
            if (!(path.startsWith(File.separator) || path.length() >= 2 && Character.isLetter(path.charAt(0)) && colon == 1)) {
                String msg = path + " is not an absolute path";
                throw new BuildException(msg);
            }
        } else if (!path.startsWith(File.separator) && colon == -1) {
            String msg = path + " is not an absolute path";
            throw new BuildException(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (!this.onNetWare && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || this.onNetWare && colon > -1) {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            int i = 0;
            while (i < colon) {
                sbRoot.append(Character.toUpperCase(ca[i]));
                ++i;
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            int i2 = colon + 1;
            while (i2 < ca.length) {
                if (ca[i2] != '\\' || ca[i2] == '\\' && ca[i2 - 1] != '\\') {
                    sbPath.append(ca[i2]);
                }
                ++i2;
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        } else if (path.length() == 1) {
            root = File.separator;
            path = "";
        } else if (path.charAt(1) == File.separatorChar) {
            root = File.separator + File.separator;
            path = path.substring(2);
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        Stack<String> s = new Stack<String>();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new BuildException("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.size()) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
            ++i;
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return new File(path);
    }

    public String toVMSPath(File f) {
        String path = this.normalize(f.getAbsolutePath()).getPath();
        String name = f.getName();
        boolean isAbsolute = path.charAt(0) == File.separatorChar;
        boolean isDirectory = f.isDirectory() && !name.regionMatches(true, name.length() - 4, ".DIR", 0, 4);
        String device = null;
        StringBuffer directory = null;
        String file = null;
        int index = 0;
        if (isAbsolute) {
            index = path.indexOf(File.separatorChar, 1);
            if (index == -1) {
                return path.substring(1) + ":[000000]";
            }
            device = path.substring(1, index++);
        }
        if (isDirectory) {
            directory = new StringBuffer(path.substring(index).replace(File.separatorChar, '.'));
        } else {
            int dirEnd = path.lastIndexOf(File.separatorChar, path.length());
            if (dirEnd == -1 || dirEnd < index) {
                file = path.substring(index);
            } else {
                directory = new StringBuffer(path.substring(index, dirEnd).replace(File.separatorChar, '.'));
                index = dirEnd + 1;
                if (path.length() > index) {
                    file = path.substring(index);
                }
            }
        }
        if (!isAbsolute && directory != null) {
            directory.insert(0, '.');
        }
        String osPath = (device != null ? device + ":" : "") + (directory != null ? "[" + directory + "]" : "") + (file != null ? file : "");
        return osPath;
    }

    public File createTempFile(String prefix, String suffix, File parentDir) {
        File result = null;
        String parent = System.getProperty("java.io.tmpdir");
        if (parentDir != null) {
            parent = parentDir.getPath();
        }
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((result = new File(parent, prefix + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contentEquals(File f1, File f2) throws IOException {
        block29: {
            block26: {
                block28: {
                    block23: {
                        block24: {
                            block25: {
                                if (f1.exists() != f2.exists()) {
                                    return false;
                                }
                                if (!f1.exists()) {
                                    return true;
                                }
                                if (f1.isDirectory() != false) return false;
                                if (f2.isDirectory()) {
                                    return false;
                                }
                                if (this.fileNameEquals(f1, f2)) {
                                    return true;
                                }
                                if (f1.length() != f2.length()) {
                                    return false;
                                }
                                in1 = null;
                                in2 = null;
                                try {
                                    in1 = new BufferedInputStream(new FileInputStream(f1));
                                    in2 = new BufferedInputStream(new FileInputStream(f2));
                                    expectedByte = in1.read();
                                    while (true) {
                                        if (expectedByte == -1) {
                                            if (in2.read() == -1) break;
                                            var6_7 = false;
                                            break block23;
                                        }
                                        if (expectedByte != in2.read()) {
                                            var6_6 = false;
                                            var8_9 = null;
                                            if (in1 == null) break block24;
                                            break block25;
                                        }
                                        expectedByte = in1.read();
                                    }
                                    var6_8 = true;
                                    break block26;
                                }
                                catch (Throwable var7_17) {
                                    var8_12 = null;
                                    if (in1 != null) {
                                        try {
                                            in1.close();
                                        }
                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (in2 == null) throw var7_17;
                                    try {
                                        in2.close();
                                        throw var7_17;
                                    }
                                    catch (IOException e) {
                                        throw var7_17;
                                    }
                                }
                            }
                            ** try [egrp 1[TRYBLOCK] [1 : 182->189)] { 
lbl53:
                            // 1 sources

                            in1.close();
                            break block24;
lbl55:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if (in2 == null) return var6_6;
                        ** try [egrp 2[TRYBLOCK] [2 : 196->204)] { 
lbl60:
                        // 1 sources

                        in2.close();
                        return var6_6;
lbl62:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var6_6;
                    }
                    var8_10 = null;
                    if (in1 != null) {
                        ** try [egrp 1[TRYBLOCK] [1 : 182->189)] { 
lbl69:
                        // 1 sources

                        in1.close();
                        break block28;
lbl71:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                if (in2 == null) return var6_7;
                ** try [egrp 2[TRYBLOCK] [2 : 196->204)] { 
lbl76:
                // 1 sources

                in2.close();
                return var6_7;
lbl78:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var6_7;
            }
            var8_11 = null;
            if (in1 != null) {
                ** try [egrp 1[TRYBLOCK] [1 : 182->189)] { 
lbl85:
                // 1 sources

                in1.close();
                break block29;
lbl87:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (in2 == null) return var6_8;
        ** try [egrp 2[TRYBLOCK] [2 : 196->204)] { 
lbl92:
        // 1 sources

        in2.close();
        return var6_8;
lbl94:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var6_8;
    }

    public File getParentFile(File f) {
        String p;
        if (f != null && (p = f.getParent()) != null) {
            return new File(p);
        }
        return null;
    }

    public static final String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, 8192);
    }

    public static final String readFully(Reader rdr, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        int bufferLength = 0;
        String text = null;
        StringBuffer textBuffer = null;
        while (bufferLength != -1) {
            bufferLength = rdr.read(buffer);
            if (bufferLength == -1) continue;
            if (textBuffer == null) {
                textBuffer = new StringBuffer(new String(buffer, 0, bufferLength));
                continue;
            }
            textBuffer.append(new String(buffer, 0, bufferLength));
        }
        if (textBuffer != null) {
            text = textBuffer.toString();
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createNewFile(File f) throws IOException {
        if (f == null) return false;
        if (f.exists()) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(new byte[0]);
            Object var4_3 = null;
            if (fos == null) return true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        fos.close();
        return true;
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File resolvedParent = new File(parent.getCanonicalPath());
        File toTest = new File(resolvedParent, name);
        return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    public String removeLeadingPath(File leading, File path) {
        String p;
        String l = this.normalize(leading.getAbsolutePath()).getAbsolutePath();
        if (l.equals(p = this.normalize(path.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        if (p.startsWith(l)) {
            return p.substring(l.length());
        }
        return p;
    }

    public String toURI(String path) {
        boolean isDir = new File(path).isDirectory();
        StringBuffer sb = new StringBuffer("file:");
        try {
            path = this.normalize(path).getAbsolutePath();
            sb.append("//");
            if (!path.startsWith(File.separator)) {
                sb.append("/");
            }
        }
        catch (BuildException e) {
            // empty catch block
        }
        path = path.replace('\\', '/');
        StringCharacterIterator iter = new StringCharacterIterator(path);
        char c = iter.first();
        while (c != '\uffff') {
            if (isSpecial[c]) {
                sb.append('%');
                sb.append(escapedChar1[c]);
                sb.append(escapedChar2[c]);
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        if (isDir && !path.endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    public String fromURI(String uri) {
        String path = Locator.fromURI((String)uri);
        try {
            path = this.normalize(path).getAbsolutePath();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        return path;
    }

    public boolean fileNameEquals(File f1, File f2) {
        return this.normalize(f1.getAbsolutePath()).equals(this.normalize(f2.getAbsolutePath()));
    }

    public void rename(File from, File to) throws IOException {
        if (to.exists() && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = this.getParentFile(to);
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            this.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    public long getFileTimestampGranularity() {
        if (Os.isFamily("dos")) {
            return 2000L;
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 0;
        while (i <= 32) {
            FileUtils.isSpecial[i] = true;
            FileUtils.escapedChar1[i] = Character.forDigit(i >> 4, 16);
            FileUtils.escapedChar2[i] = Character.forDigit(i & 0xF, 16);
            ++i;
        }
        FileUtils.isSpecial[127] = true;
        FileUtils.escapedChar1[127] = 55;
        FileUtils.escapedChar2[127] = 70;
        char[] escChs = new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        int i2 = 0;
        while (i2 < len) {
            char ch = escChs[i2];
            FileUtils.isSpecial[ch] = true;
            FileUtils.escapedChar1[ch] = Character.forDigit(ch >> 4, 16);
            FileUtils.escapedChar2[ch] = Character.forDigit(ch & 0xF, 16);
            ++i2;
        }
    }
}

