/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.cfx;

import com.allaire.cfx.Query;
import java.util.Vector;

public class DebugQuery
implements Query {
    private String m_strName;
    private String[] m_columns;
    private Vector m_rows = new Vector();

    public DebugQuery(String name, String[] columns) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null passed as name argument to DebugQuery constructor");
        }
        if (columns == null) {
            throw new IllegalArgumentException("null passed as columns argument to DebugQuery constructor");
        }
        this.m_strName = name;
        this.setColumnsAsUpper(columns);
    }

    public DebugQuery(String name, String[] columns, String[][] data) throws IllegalArgumentException {
        this(name, columns);
        if (data != null && data.length > 0) {
            int nColumns = data[0].length;
            if (nColumns != columns.length) {
                throw new IllegalArgumentException("Invalid arguments to constructor of DebugQuery: The size of the columns array is inconsistent with the number of columns passed in the data argument.");
            }
            int nRows = data.length;
            for (int i = 0; i < nRows; ++i) {
                this.m_rows.addElement(data[i]);
            }
        }
    }

    @Override
    public String getName() {
        return this.m_strName;
    }

    @Override
    public int getRowCount() {
        return this.m_rows.size();
    }

    @Override
    public int getColumnIndex(String name) {
        for (int i = 0; i < this.m_columns.length; ++i) {
            if (!this.m_columns[i].equalsIgnoreCase(name)) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public String[] getColumns() {
        return this.m_columns;
    }

    @Override
    public String getData(int iRow, int iCol) throws IndexOutOfBoundsException {
        this.validateRowColIndex(iRow, iCol);
        String[] row = (String[])this.m_rows.elementAt(iRow - 1);
        return row[iCol - 1];
    }

    @Override
    public int addRow() {
        this.m_rows.addElement(new String[this.m_columns.length]);
        return this.getRowCount();
    }

    @Override
    public void setData(int iRow, int iCol, String data) throws IndexOutOfBoundsException {
        this.validateRowColIndex(iRow, iCol);
        String strData = data;
        if (strData == null) {
            strData = "";
        }
        String[] row = (String[])this.m_rows.elementAt(iRow - 1);
        row[iCol - 1] = strData;
    }

    private void setColumnsAsUpper(String[] columns) {
        this.m_columns = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.m_columns[i] = columns[i].toUpperCase();
        }
    }

    private void validateRowColIndex(int iRow, int iCol) throws IndexOutOfBoundsException {
        if (iRow < 1 || iRow > this.getRowCount()) {
            throw new IndexOutOfBoundsException("Invalid iRow index passed to getData or setData method (row indexes are 1-based): iRow=" + Integer.toString(iRow) + ", RowCount=" + Integer.toString(this.getRowCount()));
        }
        if (iCol < 1 || iCol > this.m_columns.length) {
            throw new IndexOutOfBoundsException("Invalid iCol index passed to getData or setData method (column indexes are 1-based): iCol=" + Integer.toString(iCol) + ", Columns=" + Integer.toString(this.m_columns.length));
        }
    }

    @Override
    public void sort(int iCol, String sort_order) {
    }

    @Override
    public void sort(String sort_string) {
    }
}

