/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.cfx;

import com.allaire.cfx.Query;
import com.allaire.cfx.Request;
import java.util.Enumeration;
import java.util.Hashtable;

public class DebugRequest
implements Request {
    Hashtable m_attributes = new Hashtable();
    Hashtable m_settings = new Hashtable();
    Query m_query = null;

    public DebugRequest(Hashtable attributes) throws IllegalArgumentException {
        if (attributes != null) {
            this.initializeVariables(attributes, this.m_attributes);
        }
    }

    public DebugRequest(Hashtable attributes, Query query) throws IllegalArgumentException {
        this(attributes);
        this.m_query = query;
    }

    public DebugRequest(Hashtable attributes, Query query, Hashtable settings) throws IllegalArgumentException {
        this(attributes, query);
        if (settings != null) {
            this.initializeVariables(settings, this.m_settings);
        }
    }

    @Override
    public String getSetting(String name) {
        if (name != null) {
            String strNameUpper = name.toUpperCase();
            String strSetting = (String)this.m_settings.get(strNameUpper);
            if (strSetting != null) {
                return strSetting;
            }
            return "";
        }
        return "";
    }

    @Override
    public Query getQuery() {
        return this.m_query;
    }

    @Override
    public boolean attributeExists(String name) {
        if (name != null) {
            return this.m_attributes.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAttribute(String name) {
        if (name != null) {
            String strNameUpper = name.toUpperCase();
            String strAttribute = (String)this.m_attributes.get(strNameUpper);
            if (strAttribute != null) {
                return strAttribute;
            }
            return "";
        }
        return "";
    }

    @Override
    public String getAttribute(String name, String def) {
        if (this.attributeExists(name)) {
            return this.getAttribute(name);
        }
        return def;
    }

    @Override
    public int getIntAttribute(String name) throws NumberFormatException {
        if (this.attributeExists(name)) {
            return Integer.parseInt(this.getAttribute(name));
        }
        return -1;
    }

    @Override
    public int getIntAttribute(String name, int def) {
        if (this.attributeExists(name)) {
            try {
                return Integer.parseInt(this.getAttribute(name));
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    @Override
    public String[] getAttributeList() {
        int nAttribs = this.m_attributes.size();
        String[] attribs = new String[nAttribs];
        int i = 0;
        Enumeration e = this.m_attributes.keys();
        while (e.hasMoreElements()) {
            attribs[i] = (String)e.nextElement();
            ++i;
        }
        return attribs;
    }

    @Override
    public boolean debug() {
        return true;
    }

    private void initializeVariables(Hashtable input, Hashtable target) {
        Enumeration e = input.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            target.put(strKey.toUpperCase(), input.get(strKey));
        }
    }
}

