/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.cfx;

import com.allaire.cfx.DebugQuery;
import com.allaire.cfx.Query;
import com.allaire.cfx.Response;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DebugResponse
implements Response {
    Hashtable m_variables = new Hashtable();
    Vector m_queries = new Vector();
    StringBuffer m_output = new StringBuffer();
    StringBuffer m_debugOutput = new StringBuffer();

    public DebugResponse() {
        this.write("\n[Output]\n");
    }

    public void printResults() {
        this.write("\n[Debug Output]\n");
        this.write(this.m_debugOutput.toString());
        this.writeHashtable("Variables Set", this.m_variables);
        Enumeration e = this.m_queries.elements();
        while (e.hasMoreElements()) {
            this.writeQuery((Query)e.nextElement());
        }
        System.out.print(this.m_output);
    }

    @Override
    public void write(String output) {
        if (output != null) {
            this.m_output.append(output + "\n");
        }
    }

    @Override
    public void setVariable(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null passed as name argument to setVariable method");
        }
        String strValue = value;
        if (strValue == null) {
            strValue = "";
        }
        this.m_variables.put(name, strValue);
    }

    @Override
    public Query addQuery(String name, String[] columns) throws IllegalArgumentException {
        DebugQuery query = new DebugQuery(name, columns);
        this.m_queries.addElement(query);
        return query;
    }

    @Override
    public void writeDebug(String output) {
        if (output != null) {
            this.m_debugOutput.append(output + "\n");
        }
    }

    private void writeHashtable(String strName, Hashtable table) {
        this.write("\n[" + strName + "]\n");
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            String strValue = (String)table.get(strKey);
            this.write(strKey + "=" + strValue);
        }
    }

    private void writeQuery(Query query) {
        this.write("\n[Query: " + query.getName() + "]\n");
        Object strColumns = "";
        String[] columnsOut = query.getColumns();
        int nColumnCount = columnsOut.length;
        String strPrefix = "";
        for (int i = 0; i < nColumnCount; ++i) {
            strColumns = (String)strColumns + strPrefix + columnsOut[i];
            if (strPrefix.length() != 0) continue;
            strPrefix = ", ";
        }
        this.write((String)strColumns + "\n");
        int nRowCount = query.getRowCount();
        for (int iRow = 1; iRow <= nRowCount; ++iRow) {
            StringBuffer buffRow = new StringBuffer();
            strPrefix = "";
            for (int iCol = 1; iCol <= nColumnCount; ++iCol) {
                buffRow.append(strPrefix + query.getData(iRow, iCol));
                if (strPrefix.length() != 0) continue;
                strPrefix = ", ";
            }
            this.write(buffRow.toString());
        }
    }
}

