/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bootstrap;

public class AppServerUtils {
    public static final int DEFAULT = 0;
    public static final int JRUN = 1;
    public static final int WEBSPHERE = 2;
    public static final int WEBLOGIC = 3;
    public static final int SUNONE = 4;
    public static final int TOMCAT = 5;
    public static final int IPLANET = 6;
    public static final int WEBSPHERE4 = 7;
    public static final int INTERSTAGE = 8;
    public static final int ORACLEAS = 9;
    public static final int JBOSS = 10;
    public static final int GLASSFISH = 11;
    public static final int UNDERTOW = 12;
    private static int appServerType = 0;
    private static int version = -1;
    private static final String[] AppServerTypeNames = new String[]{"default", "jrun", "websphere", "weblogic", "sunone", "tomcat", "iws6", "websphere4", "interstage", "oracle", "jboss", "glassfish", "undertow"};

    private static void setAppServerType(int type) {
        appServerType = type;
    }

    public static int getAppServerType() {
        return appServerType;
    }

    public static String getAppServerTypeName() {
        return AppServerTypeNames[appServerType];
    }

    public static void determineAppServerType(String serverinfo) {
        if (serverinfo.indexOf("Sun ONE") != -1) {
            AppServerUtils.setAppServerType(4);
        } else if (serverinfo.indexOf("WebLogic") != -1) {
            AppServerUtils.setAppServerType(3);
            String v = serverinfo.substring("WebLogic Server ".length(), serverinfo.indexOf(46));
            try {
                version = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (serverinfo.indexOf("WebSphere Application Server/4.") != -1) {
            AppServerUtils.setAppServerType(7);
            version = 4;
        } else if (serverinfo.indexOf("WebSphere") != -1) {
            AppServerUtils.setAppServerType(2);
            int i = serverinfo.indexOf(47);
            if (i > 0) {
                try {
                    String v = serverinfo.substring(i + 1);
                    int j = v.indexOf(46);
                    if (j != -1) {
                        v = v.substring(0, j);
                    }
                    version = Integer.parseInt(v);
                }
                catch (NumberFormatException v) {}
            }
        } else if (serverinfo.indexOf("JRun") != -1) {
            AppServerUtils.setAppServerType(1);
            version = 4;
        } else if (serverinfo.indexOf("iPlanet-WebServer-Enterprise/6.0") != -1) {
            AppServerUtils.setAppServerType(6);
            version = 6;
        } else if (serverinfo.indexOf("Tomcat") != -1) {
            AppServerUtils.setAppServerType(5);
            int i = serverinfo.indexOf(47);
            if (i > 0) {
                try {
                    String v = serverinfo.substring(i + 1);
                    int j = v.indexOf(46);
                    if (j != -1) {
                        v = v.substring(0, j);
                    }
                    version = Integer.parseInt(v);
                }
                catch (NumberFormatException v) {}
            }
        } else if (serverinfo.indexOf("JBoss") != -1 || serverinfo.indexOf("WildFly") != -1) {
            AppServerUtils.setAppServerType(10);
            int i = serverinfo.indexOf(47);
            if (i > 0) {
                try {
                    String v = serverinfo.substring(i + 1);
                    int j = v.indexOf(46);
                    if (j != -1) {
                        v = v.substring(0, j);
                    }
                    version = Integer.parseInt(v);
                }
                catch (NumberFormatException v) {}
            }
        } else if (serverinfo.indexOf("GlassFish") != -1) {
            AppServerUtils.setAppServerType(11);
        } else if (serverinfo.indexOf("INTERSTAGE") != -1) {
            AppServerUtils.setAppServerType(8);
        } else if (serverinfo.indexOf("Oracle") != -1) {
            AppServerUtils.setAppServerType(9);
        } else if (serverinfo.indexOf("Undertow") != -1) {
            AppServerUtils.setAppServerType(12);
            int i = serverinfo.indexOf(45);
            if (i > 0) {
                try {
                    String v = serverinfo.substring(i + 1);
                    int j = v.indexOf(46);
                    if (j != -1) {
                        v = v.substring(0, j);
                        v = v.trim();
                    } else {
                        v = v.trim();
                    }
                    version = Integer.parseInt(v);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            AppServerUtils.setAppServerType(0);
        }
    }

    public static int getAppServerVersion() {
        return version;
    }
}

