/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bootstrap;

import coldfusion.bootstrap.ChildFirstClassLoader;
import coldfusion.bootstrap.FelixClassloader;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class BootstrapClassLoader
extends URLClassLoader {
    private static BootstrapClassLoader instance;
    Properties prop1 = new Properties();
    String[] deferToSuper;
    String[] exceptionList;
    String Path;
    Map<String, Class> classCache = new HashMap<String, Class>();
    Map<String, Class> modulesClassCache = new HashMap<String, Class>();
    ClassLoader parentClassLoader = null;
    private ClassLoader iTextClassLoader = null;
    private static final String iTextPackageName = "com.lowagie.";
    private static String iTextResourceName;
    String updatesDirectory = null;
    String[] libDirs = null;
    private Map<String, URL> resourceCache = new HashMap<String, URL>();
    public static String PATH_SEP;
    public static String FILE_SEP;
    private static FelixClassloader felixClassLoader;

    public BootstrapClassLoader(URL[] classpath, ClassLoader parent, Properties p, String updatesDirectory, Vector libDirs, List<URL> iTextURLs) {
        super(classpath, parent);
        this.init(parent, updatesDirectory, p, libDirs, iTextURLs);
    }

    private void init(ClassLoader parent, String updatesDirectory, Properties p, Vector libDirectories, final List<URL> iTextURLs) {
        this.parentClassLoader = parent;
        this.updatesDirectory = updatesDirectory;
        this.prop1 = p;
        String vmVersion = (String)System.getProperties().get("java.runtime.version");
        String propValue = this.prop1.getProperty("loadByAppServer_" + (vmVersion = vmVersion.substring(0, 3)));
        if (propValue == null) {
            propValue = this.prop1.getProperty("loadByAppServer");
        }
        if (propValue != null) {
            this.deferToSuper = this.split(propValue, ",");
        }
        if ((propValue = this.prop1.getProperty("exceptions_" + vmVersion)) == null) {
            propValue = this.prop1.getProperty("exceptions");
        }
        if (propValue != null) {
            this.exceptionList = this.split(propValue, ",");
        }
        if (libDirectories != null) {
            this.libDirs = new String[libDirectories.size()];
            for (int i = 0; i < libDirectories.size(); ++i) {
                this.libDirs[i] = (String)libDirectories.get(i);
            }
        }
        final BootstrapClassLoader bscl = this;
        if (iTextURLs != null && iTextURLs.size() > 0) {
            this.iTextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new ChildFirstClassLoader(iTextURLs.toArray(new URL[iTextURLs.size()]), (ClassLoader)bscl, BootstrapClassLoader.iTextPackageName);
                }
            });
        }
    }

    public BootstrapClassLoader(URL[] classpath, ClassLoader parent, Properties p, Vector libDirectories, List<URL> iTextURLs) {
        super(classpath, parent);
        this.init(parent, null, p, libDirectories, iTextURLs);
    }

    private String[] split(String line, String sep) {
        if (sep == null) {
            sep = ",";
        }
        StringTokenizer st = new StringTokenizer(line, sep, false);
        int number = st.countTokens();
        ArrayList<String> L = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            L.add(i, st.nextToken().trim());
        }
        return L.toArray(new String[0]);
    }

    private boolean isStrInList(String name, String[] list) {
        boolean retValue = false;
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!name.startsWith(list[i])) continue;
                retValue = true;
                break;
            }
        }
        return retValue;
    }

    @Override
    public String findLibrary(String libname) {
        String mappedLibName;
        String path;
        File file;
        String updateName;
        if (this.updatesDirectory != null && libname != null && (updateName = (String)AccessController.doPrivileged(new PrivilegedAction(){
            final /* synthetic */ File val$file;
            {
                this.val$file = file;
            }

            public Object run() {
                String absPath = null;
                if (this.val$file.exists()) {
                    absPath = this.val$file.getAbsolutePath();
                }
                return absPath;
            }
        })) != null) {
            return updateName;
        }
        if (this.libDirs != null) {
            mappedLibName = System.mapLibraryName(libname);
            for (int i = 0; i < this.libDirs.length; ++i) {
                File file2;
                Object path2 = this.libDirs[i];
                if (!((String)path2).endsWith(File.separator)) {
                    path2 = (String)path2 + File.separator;
                }
                if (!(file2 = new File((String)(path2 = (String)path2 + mappedLibName))).exists()) continue;
                return file2.getAbsolutePath();
            }
        }
        return super.findLibrary(libname);
    }

    private boolean delegateToSuper(String name) {
        return this.isStrInList(name, this.deferToSuper) && !this.isStrInList(name, this.exceptionList);
    }

    public static void setFelixClassloader(FelixClassloader fcl) {
        felixClassLoader = fcl;
    }

    public void removeTagClasses() {
        this.classCache.entrySet().removeIf(e -> ((String)e.getKey()).endsWith("Tag") && !(((Class)e.getValue()).getClassLoader() instanceof BootstrapClassLoader));
        this.modulesClassCache.entrySet().removeIf(e -> ((String)e.getKey()).endsWith("Tag") && !(((Class)e.getValue()).getClassLoader() instanceof FelixClassloader));
    }

    public void removeQuartzClasses() {
        this.modulesClassCache.entrySet().removeIf(e -> ((String)e.getKey()).contains("quartz") && !(((Class)e.getValue()).getClassLoader() instanceof FelixClassloader));
    }

    public void removeORMClasses() {
        this.modulesClassCache.entrySet().removeIf(e -> ((String)e.getKey()).contains("hibernate") && !(((Class)e.getValue()).getClassLoader() instanceof FelixClassloader));
    }

    public void removeDerbyClasses() {
        this.modulesClassCache.entrySet().removeIf(e -> ((String)e.getKey()).contains("derby") && !(((Class)e.getValue()).getClassLoader() instanceof FelixClassloader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = null;
        c = this.classCache.get(name);
        if (c != null) {
            return c;
        }
        if (c == null) {
            BootstrapClassLoader bootstrapClassLoader = this;
            synchronized (bootstrapClassLoader) {
                c = this.classCache.get(name);
                if (c != null) {
                    return c;
                }
                if (this.delegateToSuper(name)) {
                    try {
                        c = this.parentClassLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        c = this.findClass(name);
                    }
                } else {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        if (name.startsWith(iTextPackageName) && this.iTextClassLoader != null) {
                            c = this.iTextClassLoader.loadClass(name);
                        }
                        try {
                            c = this.parentClassLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException ex) {
                            c = null;
                        }
                    }
                }
                if (c != null) {
                    this.classCache.put(name, c);
                }
                if (c == null && felixClassLoader != null) {
                    c = this.modulesClassCache.get(name);
                    if (c == null) {
                        try {
                            c = felixClassLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            c = null;
                        }
                    }
                    if (c != null) {
                        this.modulesClassCache.put(name, c);
                    }
                }
                if (c == null) {
                    throw new ClassNotFoundException(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public static synchronized BootstrapClassLoader instance() {
        return instance;
    }

    public static synchronized void setInstance(BootstrapClassLoader cl) {
        instance = cl;
    }

    public static Object invoke(String clsName) throws Exception {
        return BootstrapClassLoader.invoke(clsName, new Class[0], new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(String clsName, Class[] clsArr, Object[] objArr) throws Exception {
        Object retObj = null;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        BootstrapClassLoader cl = BootstrapClassLoader.instance();
        try {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            Class<?> cls = Class.forName(clsName, true, Thread.currentThread().getContextClassLoader());
            Object obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = cls.getMethod("invoke", clsArr);
            retObj = method.invoke(obj, objArr);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        return retObj;
    }

    @Override
    public URL getResource(String name) {
        URL object = this.resourceCache.get(name);
        if (object != null || this.resourceCache.containsKey(name)) {
            return object;
        }
        URL url = this.findResource(name);
        if (url == null && name.startsWith(iTextResourceName) && this.iTextClassLoader != null) {
            url = this.iTextClassLoader.getResource(name);
        }
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        this.resourceCache.put(name, url);
        return url;
    }

    static {
        iTextResourceName = "com/lowagie/";
        PATH_SEP = System.getProperty("path.separator");
        FILE_SEP = System.getProperty("file.separator");
        felixClassLoader = null;
    }
}

