/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bootstrap;

import coldfusion.bootstrap.ClassloaderHelper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;

public class BootstrapFilter
implements Filter {
    private Filter filter;
    ClassLoader bscl;

    public void init(FilterConfig filterConfig) throws ServletException {
        String filterClass = filterConfig.getInitParameter("filter.class");
        ClassloaderHelper cHelper = ClassloaderHelper.getInstance();
        cHelper.init(filterConfig.getServletContext());
        this.bscl = cHelper.getClassLoader();
        this.filter = cHelper.initFilterClass(filterClass, filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            if (cl != this.bscl) {
                Thread.currentThread().setContextClassLoader(this.bscl);
            }
            this.filter.doFilter(servletRequest, servletResponse, filterChain);
        }
        finally {
            if (cl != this.bscl) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public void destroy() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.bscl);
            this.filter.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

