/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bootstrap;

import coldfusion.bootstrap.ClassloaderHelper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.coyote.ajp.AjpProcessor;

public class BootstrapServlet
implements Servlet {
    Servlet servlet;
    Properties prop = null;
    ServletContext context;
    ServletConfig config;
    ClassloaderHelper cHelper = null;
    ClassLoader bscl;
    private static boolean isFiddleEnabled = Boolean.parseBoolean(System.getProperty("coldfusion.fiddle.enable", "false"));
    private static boolean asyncRequestFramework = false;
    private static long threadDeathThreadTimeout = 0L;
    private static long threadDeathThreadMemLimit = 0L;
    private static int asyncCoreThreads = 25;
    private static int asyncMaxThreads = 200;
    private static int asyncQueueSize = 1000;
    private static long asyncKeepAlive = 60000L;
    private static AtomicBoolean threadDeathFrameworkInitialized = new AtomicBoolean(false);
    private static ThreadGroup asyncThreadGroup = null;
    private static Thread[] threadList = new Thread[1000];
    private static Map<Long, ThreadParams> threadParamsMapCache = new HashMap<Long, ThreadParams>();
    private static final String CF_ASYNC_THREAD = "cf-async-";
    private ScheduledExecutorService threadDeathExecutor;

    public void init(ServletConfig config) throws ServletException {
        SecurityManager sm;
        this.config = config;
        this.context = config.getServletContext();
        String p = this.context.getRealPath("/");
        if (p == null) {
            throw new ServletException("STARTUP ERROR: Unable to call ServletContext.getRealPath(\"/\"). You may be running as an unexploded ear or war file, which ColdFusion doesn't support.");
        }
        this.cHelper = ClassloaderHelper.getInstance();
        this.cHelper.init(this.context);
        if (isFiddleEnabled && config.getServletName().equalsIgnoreCase("cfmservlet")) {
            this.initAsyncAndThreadKiller();
        }
        if ((sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(new RuntimePermission("setContextClassLoader"));
            }
            catch (Exception e) {
                throw new ServletException("STARTUP ERROR: Please change your server's policy file to give more access to ColdFusion.  See the installation instructions for more details.");
            }
        }
        if (isFiddleEnabled && threadDeathThreadTimeout > 0L) {
            this.initializeThreadDeathExecutor();
        }
        String servletClass = this.getInitParameter("servlet.class");
        this.servlet = this.cHelper.initServletClass(servletClass, this.getServletConfig());
        this.bscl = this.cHelper.getClassLoader();
    }

    private void initializeThreadDeathExecutor() {
        if (threadDeathFrameworkInitialized.compareAndSet(false, true)) {
            this.threadDeathExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    System.out.printf("Thread Death service started(timeout-%dms, memory limit-%dKB)\n", threadDeathThreadTimeout, threadDeathThreadMemLimit);
                    Thread thread = new Thread(r, "CFThreadDeath");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
            threadMxBean.setThreadContentionMonitoringEnabled(true);
            threadMxBean.setThreadCpuTimeEnabled(true);
            if (threadMxBean instanceof com.sun.management.ThreadMXBean) {
                com.sun.management.ThreadMXBean threadMxBeanSun = (com.sun.management.ThreadMXBean)threadMxBean;
                threadMxBeanSun.setThreadAllocatedMemoryEnabled(true);
            }
            this.threadDeathExecutor.scheduleAtFixedRate(new KillingTask(threadMxBean), 50L, 30L, TimeUnit.SECONDS);
        }
    }

    private void initAsyncAndThreadKiller() throws ServletException {
        block22: {
            Properties properties = new Properties();
            try {
                InputStream is = this.getServletConfig().getServletContext().getResourceAsStream("/WEB-INF/cffiddle.properties");
                properties.load(is);
                String requestFramework = (String)properties.get("cf.request.framework");
                if (requestFramework != null) {
                    boolean bl = asyncRequestFramework = requestFramework.equalsIgnoreCase("async");
                }
                if (asyncRequestFramework) {
                    asyncThreadGroup = new ThreadGroup("cfasyncgroup");
                }
                try {
                    String threadTimeout = (String)properties.get("threaddeath.thread.timeout");
                    if (threadTimeout != null) {
                        threadDeathThreadTimeout = Long.parseLong(threadTimeout);
                    }
                }
                catch (NumberFormatException threadTimeout) {
                    // empty catch block
                }
                try {
                    String memLimit = (String)properties.get("threaddeath.thread.memorylimit");
                    if (memLimit != null) {
                        threadDeathThreadMemLimit = Long.parseLong(memLimit);
                    }
                }
                catch (NumberFormatException memLimit) {
                    // empty catch block
                }
                if (!asyncRequestFramework) break block22;
                try {
                    int parseInt;
                    String asyncCoreThreadsStr = (String)properties.get("async.threadpool.corethreads");
                    if (asyncCoreThreadsStr != null && (parseInt = Integer.parseInt(asyncCoreThreadsStr)) >= 0) {
                        asyncCoreThreads = parseInt;
                    }
                }
                catch (NumberFormatException asyncCoreThreadsStr) {
                    // empty catch block
                }
                try {
                    long parseLong;
                    String asyncKeepAliveStr = (String)properties.get("async.threadpool.keepalive");
                    if (asyncKeepAliveStr != null && (parseLong = Long.parseLong(asyncKeepAliveStr)) > 0L) {
                        asyncKeepAlive = parseLong;
                    }
                }
                catch (NumberFormatException asyncKeepAliveStr) {
                    // empty catch block
                }
                try {
                    int parseInt;
                    String asyncMaxThreadsStr = (String)properties.get("async.threadpool.maxthreads");
                    if (asyncMaxThreadsStr != null && (parseInt = Integer.parseInt(asyncMaxThreadsStr)) > 0) {
                        asyncMaxThreads = parseInt;
                    }
                }
                catch (NumberFormatException asyncMaxThreadsStr) {
                    // empty catch block
                }
                try {
                    int parseInt;
                    String asyncQueueSizeStr = (String)properties.get("async.threadpool.queuesize");
                    if (asyncQueueSizeStr != null && (parseInt = Integer.parseInt(asyncQueueSizeStr)) >= 0) {
                        asyncQueueSize = parseInt;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                System.out.printf("Async Framework initialized with %d(core threads) %d(max threads) %d(keep alive time) %d(queue size)\n", asyncCoreThreads, asyncMaxThreads, asyncKeepAlive, asyncQueueSize);
            }
            catch (IOException e) {
                System.err.println("Unable to load cffiddle.properties file. ColdFusion will use default values for CFFiddle application.");
            }
        }
    }

    public static ThreadGroup getasyncThreadGroup() {
        return asyncThreadGroup;
    }

    public String getInitParameter(String param) {
        return this.config.getInitParameter(param);
    }

    public String getServletInfo() {
        return this.config.getServletContext().getServerInfo();
    }

    public void log(String str) {
        this.context.log(str);
    }

    public void log(String str, Throwable thr) {
        this.context.log(str, thr);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (asyncRequestFramework) {
            AjpProcessor ajpProcessor = (AjpProcessor)CoyoteAdapter.local.get();
            AsyncContext ac = req.startAsync();
            ac.setTimeout(60000L);
            BootstrapServlet.getAsyncRequestThreadPool().execute(new AsyncCFExecutor(ac, ajpProcessor).enableDebug(false));
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                if (this.bscl != cl) {
                    Thread.currentThread().setContextClassLoader(this.bscl);
                }
                this.servlet.service(req, resp);
            }
            finally {
                if (this.bscl != cl) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        }
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public void destroy() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cHelper.getClassLoader());
            if (this.threadDeathExecutor != null && !this.threadDeathExecutor.isShutdown()) {
                this.threadDeathExecutor.shutdownNow();
            }
            this.servlet.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static ExecutorService getAsyncRequestThreadPool() {
        return AsyncRequestThreadPool.INSTANCE;
    }

    class KillingTask
    implements Runnable {
        private final ThreadMXBean threadMxBean;

        public KillingTask() {
            this.threadMxBean = ManagementFactory.getThreadMXBean();
        }

        public KillingTask(ThreadMXBean threadMxBean) {
            this.threadMxBean = threadMxBean;
        }

        private boolean analyzeAndKillThread(Thread thread) {
            if (!thread.isAlive()) {
                return false;
            }
            if (!thread.getName().startsWith(BootstrapServlet.CF_ASYNC_THREAD)) {
                return false;
            }
            long threadid = thread.getId();
            ThreadParams requestThreadParams = threadParamsMapCache.get(threadid);
            if (requestThreadParams == null) {
                return false;
            }
            long threadAllocatedBytes = 0L;
            if (this.threadMxBean instanceof com.sun.management.ThreadMXBean) {
                threadAllocatedBytes = ((com.sun.management.ThreadMXBean)this.threadMxBean).getThreadAllocatedBytes(threadid);
            }
            long threadCpuTime = this.threadMxBean.getThreadCpuTime(threadid);
            long threadUserTime = this.threadMxBean.getThreadUserTime(threadid);
            threadCpuTime -= requestThreadParams.getCPUTime();
            threadUserTime -= requestThreadParams.getCPUUserTime();
            boolean kill = false;
            if (threadDeathThreadMemLimit > 0L && (threadAllocatedBytes -= requestThreadParams.getAllocatedMem()) > 0L && threadAllocatedBytes / 1000L >= threadDeathThreadMemLimit) {
                kill = true;
                System.out.printf("Thread %s(%d) misbehaving: Memory-%s\n", thread.getName(), thread.getId(), String.valueOf(threadAllocatedBytes / 1000L));
            } else if (threadDeathThreadTimeout > 0L && threadUserTime / 1000000L >= threadDeathThreadTimeout) {
                kill = true;
                System.out.printf("Thread %s(%d) misbehaving: CPU User time-%s\n", thread.getName(), thread.getId(), String.valueOf(threadUserTime / 1000000L));
            } else if (threadDeathThreadTimeout > 0L && threadCpuTime / 1000000L >= threadDeathThreadTimeout * 5L) {
                kill = true;
                System.out.printf("Thread %s(%d) misbehaving: CPU time-%s\n", thread.getName(), thread.getId(), String.valueOf(threadCpuTime / 1000000L));
            }
            if (kill) {
                return this.killThread(thread);
            }
            return false;
        }

        private boolean killThread(Thread thread) {
            StackTraceElement[] stackTrace = thread.getStackTrace();
            thread.interrupt();
            System.out.println("Rogue thread stopped - " + thread.getName() + "(" + thread.getId() + ")");
            return true;
        }

        @Override
        public void run() {
            asyncThreadGroup.enumerate(threadList);
            for (Thread thread : threadList) {
                if (thread == null || !this.analyzeAndKillThread(thread)) continue;
                threadParamsMapCache.remove(thread.getId());
            }
            Arrays.fill(threadList, null);
        }
    }

    class AsyncCFExecutor
    implements Runnable {
        final AsyncContext asynContext;
        final AjpProcessor ajpProcessor;
        private boolean debugFiddleRequest;

        public AsyncCFExecutor(AsyncContext asyncContext, AjpProcessor abstractAjpProcessor) {
            this.asynContext = asyncContext;
            this.ajpProcessor = abstractAjpProcessor;
        }

        public AsyncCFExecutor enableDebug(boolean debug) {
            this.debugFiddleRequest = debug;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.debugFiddleRequest) {
                System.out.println("AsyncFramework: About to start request");
            }
            CoyoteAdapter.local.set(this.ajpProcessor);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                this.setThreadParameters();
                ClassLoader clx = BootstrapServlet.this.cHelper.getClassLoader();
                Thread.currentThread().setContextClassLoader(clx);
                if (this.debugFiddleRequest) {
                    System.out.println("AsyncFramework: Forwarding request to servlet");
                }
                BootstrapServlet.this.servlet.service(this.asynContext.getRequest(), this.asynContext.getResponse());
                if (this.debugFiddleRequest) {
                    System.out.println("AsyncFramework: Request served");
                }
                try {
                    this.asynContext.complete();
                }
                catch (IllegalStateException e) {
                    System.out.println("Asnyc Complete Error: ");
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                ServletResponse response = null;
                try {
                    response = this.asynContext.getResponse();
                }
                catch (IllegalStateException e1) {
                    System.out.println("Async GetResponse: ");
                    e1.printStackTrace();
                }
                int status = 500;
                if (response instanceof HttpServletResponse) {
                    if (e instanceof ServletException) {
                        status = 500;
                    } else if (e instanceof IOException | e instanceof InterruptedException) {
                        status = 508;
                    } else if (e instanceof RejectedExecutionException) {
                        status = 503;
                    }
                    ((HttpServletResponse)response).setStatus(status);
                }
                System.out.printf("Exception thrown by Async handler: %d %s\n", status, e.getMessage());
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
                CoyoteAdapter.local.remove();
                threadParamsMapCache.remove(Thread.currentThread().getId());
                try {
                    this.asynContext.complete();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }

        private void setThreadParameters() {
            long threadid = Thread.currentThread().getId();
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ThreadParams threadParams = new ThreadParams(threadid);
            long cpuTime = threadMXBean.getCurrentThreadCpuTime();
            long userTime = threadMXBean.getCurrentThreadUserTime();
            long allMem = 0L;
            if (threadMXBean instanceof com.sun.management.ThreadMXBean) {
                allMem = ((com.sun.management.ThreadMXBean)threadMXBean).getThreadAllocatedBytes(threadid);
            }
            threadParams.setAllocatedMem(allMem);
            threadParams.setCPUTime(cpuTime);
            threadParams.setCPUUserTime(userTime);
            threadParams.setExecutionStarted(true);
            threadParamsMapCache.put(threadid, threadParams);
        }
    }

    private static class AsyncRequestThreadPool {
        static BlockingQueue<Runnable> queue = asyncQueueSize == 0 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(asyncQueueSize);
        static final ExecutorService INSTANCE = new ThreadPoolExecutor(asyncCoreThreads, asyncMaxThreads, asyncKeepAlive, TimeUnit.MILLISECONDS, queue, ASyncRequestThreadFactory.INSTANCE);

        private AsyncRequestThreadPool() {
        }
    }

    private static class ThreadParams {
        private long threadid;
        private long CPUTime;
        private long allocatedMem;
        private long CPUUserTime;
        private boolean executionStarted;

        public ThreadParams(long threadid) {
            this.threadid = threadid;
        }

        public long getCPUTime() {
            return this.CPUTime;
        }

        public long getAllocatedMem() {
            return this.allocatedMem;
        }

        public void setCPUTime(long cPUTime) {
            this.CPUTime = cPUTime;
        }

        public void setAllocatedMem(long allocatedMem) {
            this.allocatedMem = allocatedMem;
        }

        public long getCPUUserTime() {
            return this.CPUUserTime;
        }

        public void setCPUUserTime(long cPUUserTime) {
            this.CPUUserTime = cPUUserTime;
        }

        public boolean isExecutionStarted() {
            return this.executionStarted;
        }

        public void setExecutionStarted(boolean executionStarted) {
            this.executionStarted = executionStarted;
        }
    }

    private static class ASyncRequestThreadFactory
    implements ThreadFactory {
        public static ASyncRequestThreadFactory INSTANCE = new ASyncRequestThreadFactory();
        private AtomicLong threadCount = new AtomicLong();

        private ASyncRequestThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(asyncThreadGroup, r, BootstrapServlet.CF_ASYNC_THREAD + String.valueOf(this.threadCount.getAndIncrement()));
            thread.setDaemon(true);
            thread.setPriority(5);
            return thread;
        }
    }
}

