/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bootstrap;

import java.net.URL;
import java.net.URLClassLoader;

public class ChildFirstClassLoader
extends URLClassLoader {
    private String childPackage = null;
    private String childPackageResource = null;

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent, String childPackage) {
        super(urls, parent);
        this.setChildPackage(childPackage);
    }

    public void setChildPackage(String childPackage) {
        this.childPackage = childPackage;
        this.childPackageResource = childPackage.replace('.', '/');
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null && this.childPackage != null && !name.startsWith(this.childPackage)) {
            c = this.getParent() != null ? this.getParent().loadClass(name) : ChildFirstClassLoader.getSystemClassLoader().loadClass(name);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.childPackageResource != null && !name.startsWith(this.childPackageResource)) {
            url = this.getParent().getResource(name);
        }
        return url;
    }
}

