/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bootstrap;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.bootstrap.BootstrapClassLoader;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class ClassloaderHelper {
    public static final String thisVersion = "202500";
    Properties prop = null;
    ServletContext context = null;
    String classpath = null;
    private boolean initialized = false;
    private static ClassloaderHelper instance = new ClassloaderHelper();
    private static boolean isServerless = false;

    private ClassloaderHelper() {
    }

    private ServletContext getServletContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletContext context) {
        if (this.isInitialized()) {
            return;
        }
        ClassloaderHelper classloaderHelper = this;
        synchronized (classloaderHelper) {
            if (this.initialized) {
                return;
            }
            this.context = context;
            this.setClassloaderConfig();
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void testInit() throws ServletException {
        if (!this.isInitialized()) {
            throw new ServletException("ClassloaderHelper not initialized properly. Call ClassloaderHelper.init(ServletContext) before using this class");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet initServletClass(String servletClass, ServletConfig config) throws ServletException {
        this.testInit();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Servlet serv = (Servlet)this.getClassLoader().loadClass(servletClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            serv.init(config);
            Servlet servlet = serv;
            Thread.currentThread().setContextClassLoader(cl);
            return servlet;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log("failed to load: " + servletClass);
                throw new ServletException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter initFilterClass(String filterClass, FilterConfig config) throws ServletException {
        this.testInit();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Filter filt = (Filter)this.getClassLoader().loadClass(filterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            filt.init(config);
            Filter filter = filt;
            Thread.currentThread().setContextClassLoader(cl);
            return filter;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log("failed to load: " + filterClass);
                throw new ServletException(e);
            }
        }
    }

    public static ClassloaderHelper getInstance() {
        return instance;
    }

    private void setClassloaderConfig() {
        block5: {
            ClassLoader cl = this.getClass().getClassLoader();
            String serverinfo = this.getServletContext().getServerInfo();
            AppServerUtils.determineAppServerType(serverinfo);
            String appServerName = AppServerUtils.getAppServerTypeName();
            String propFileName = appServerName + ".properties";
            this.prop = new Properties();
            InputStream propsFileStream = null;
            try {
                propsFileStream = cl.getResourceAsStream(propFileName);
                if (propsFileStream != null) {
                    this.prop.load(propsFileStream);
                    propsFileStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log("Properties File Not Found!" + propFileName);
                if (propsFileStream == null) break block5;
                try {
                    propsFileStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public ClassLoader getClassLoader() throws ServletException {
        this.testInit();
        BootstrapClassLoader cl = BootstrapClassLoader.instance();
        if (cl != null) {
            return cl;
        }
        return this._getClassLoader();
    }

    public static String removeQuotes(String directory) {
        int beg = directory.indexOf("\"");
        int end = directory.lastIndexOf("\"");
        if (beg != -1 && end != -1) {
            directory = directory.substring(beg + 1, end);
        }
        return directory;
    }

    public URL[] getURLs(String standAloneClassPath) {
        ArrayList<URL> cpList = new ArrayList<URL>();
        if (standAloneClassPath != null) {
            StringTokenizer xt = new StringTokenizer(standAloneClassPath, ",");
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                tok = ClassloaderHelper.removeQuotes(tok);
                File sacp = new File(tok);
                cpList.addAll(ClassloaderHelper.getJarsInDirRecursively(sacp));
            }
        }
        URL[] urls = new URL[cpList.size()];
        for (int i = 0; i < urls.length; ++i) {
            URL url;
            urls[i] = url = (URL)cpList.get(i);
        }
        return urls;
    }

    private synchronized ClassLoader _getClassLoader() {
        BootstrapClassLoader _xl = BootstrapClassLoader.instance();
        if (_xl != null) {
            return _xl;
        }
        String updatesDirectory = null;
        String classpath = this.getServletContext().getInitParameter("cf.class.path");
        StringTokenizer st = new StringTokenizer(classpath, ",");
        ArrayList cpList = new ArrayList();
        String standAloneClassPath = System.getProperty("coldfusion.classPath");
        if (standAloneClassPath != null) {
            StringTokenizer xt = new StringTokenizer(standAloneClassPath, ",");
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                tok = ClassloaderHelper.removeQuotes(tok);
                File sacp = new File(tok);
                if (tok.endsWith("/updates")) {
                    updatesDirectory = tok;
                    ClassloaderHelper.addUpdatesToClassPath(sacp, cpList);
                    continue;
                }
                this.addToClassPath(sacp, cpList, tok);
            }
        } else {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                token = ClassloaderHelper.removeQuotes(token);
                String path = this.getServletContext().getRealPath(token);
                File file = new File(path);
                if (!file.exists()) {
                    file = new File(token);
                }
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (token.endsWith("/updates")) {
                    updatesDirectory = token;
                    ClassloaderHelper.addUpdatesToClassPath(file, cpList);
                    continue;
                }
                this.addToClassPath(file, cpList, token);
            }
        }
        String libpath = this.getServletContext().getInitParameter("cf.lib.path");
        String standAloneLibPath = System.getProperty("coldfusion.libPath");
        Vector<String> libPaths = new Vector<String>();
        Object iTextPath = null;
        if (standAloneLibPath != null) {
            xt = new StringTokenizer(standAloneLibPath, ",");
            iTextPath = ClassloaderHelper.addTrailingSlashIfNotExist(standAloneLibPath) + "itext";
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                tok = ClassloaderHelper.removeQuotes(tok);
                libPaths.add(tok);
            }
        } else if (libpath != null) {
            xt = new StringTokenizer(libpath, ",");
            while (xt.hasMoreTokens()) {
                libPaths.add(this.getRealLibPathFromServlet(xt.nextToken()));
            }
            iTextPath = this.getRealLibPathFromServlet(ClassloaderHelper.addTrailingSlashIfNotExist(libpath) + "itext");
        }
        URL[] classpathURLs = new URL[cpList.size()];
        for (int i = 0; i < classpathURLs.length; ++i) {
            URL url;
            classpathURLs[i] = url = (URL)cpList.get(i);
        }
        List<URL> iTextURLs = iTextPath != null ? ClassloaderHelper.getJarsInDirRecursively(new File((String)iTextPath)) : null;
        BootstrapClassLoader.setInstance(new BootstrapClassLoader(classpathURLs, this.getClass().getClassLoader(), this.prop, updatesDirectory, libPaths, iTextURLs));
        return BootstrapClassLoader.instance();
    }

    private String getRealLibPathFromServlet(String token) {
        token = ClassloaderHelper.removeQuotes(token);
        String path = this.getServletContext().getRealPath(token);
        File file = new File(path);
        if (!file.exists()) {
            file = new File(token);
        }
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }

    public static void addUpdatesToClassPath(File file, List cpList) {
        List fileCpList = ClassloaderHelper.getFilesInUpdates(file);
        if (fileCpList != null) {
            for (File aFile : fileCpList) {
                URL url = ClassloaderHelper.toURL(aFile);
                if (url == null) continue;
                cpList.add(url);
            }
        }
    }

    public static List getFilesInUpdates(File file) {
        if (isServerless) {
            return null;
        }
        if (file.isDirectory()) {
            ArrayList<Object> cpList = new ArrayList<Object>();
            File[] f = file.listFiles();
            TreeMap<Integer, File> chf = new TreeMap<Integer, File>();
            ArrayList<File> hf = new ArrayList<File>();
            ArrayList<File> extraJars = new ArrayList<File>();
            for (int i = 0; i < f.length; ++i) {
                String version;
                String fn = f[i].getName();
                if ((fn = fn.toLowerCase()).startsWith("chf")) {
                    if (fn.length() <= 7) {
                        System.err.println("Ignoring invalid file in updates directory: " + f[i].getName());
                        continue;
                    }
                    try {
                        version = fn.substring(3, 9);
                        if (!thisVersion.equals(version)) {
                            System.err.println("Ignoring invalid file in updates directory: " + f[i].getName());
                            continue;
                        }
                        int j = 7;
                        while (Character.isDigit(fn.charAt(j))) {
                            ++j;
                        }
                        String num = fn.substring(7, j);
                        Integer in = new Integer(Integer.parseInt(num));
                        chf.put(in, f[i]);
                    }
                    catch (Exception e) {
                        System.err.println("Ignoring invalid file in updates directory: " + f[i].getName());
                    }
                    continue;
                }
                if (fn.startsWith("hf")) {
                    if (fn.length() <= 13) {
                        System.err.println("Ignoring invalid file in updates directory: " + f[i].getName());
                        continue;
                    }
                    version = fn.substring(2, 8);
                    if (!thisVersion.equals(version)) {
                        System.err.println("Ignoring invalid file in updates directory: " + f[i].getName());
                        continue;
                    }
                    try {
                        String num = fn.substring(8, 13);
                        Integer.parseInt(num);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Ignoring invalid file in updates directory: " + f[i].getName());
                    }
                    hf.add(f[i]);
                    continue;
                }
                if (!fn.endsWith(".jar")) continue;
                extraJars.add(f[i]);
            }
            if (hf.size() > 0) {
                cpList.addAll(hf);
            }
            if (chf.size() > 0) {
                cpList.add(chf.get(chf.lastKey()));
            }
            if (extraJars.size() > 0) {
                cpList.addAll(extraJars);
            }
            return cpList;
        }
        System.err.println(file.getPath() + ": directory does not exist, hotfixes cannot be applied");
        return null;
    }

    public static List getFilePathsInUpdates(File updatesDir) {
        List fileCpList = ClassloaderHelper.getFilesInUpdates(updatesDir);
        ArrayList<String> filePathsCpList = new ArrayList<String>();
        if (fileCpList != null) {
            for (File aFile : fileCpList) {
                filePathsCpList.add(aFile.getAbsolutePath());
            }
        }
        return filePathsCpList;
    }

    private static URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void addToClassPath(File file, List cpList, String path) {
        if (file.exists()) {
            if (file.isDirectory()) {
                cpList.addAll(ClassloaderHelper.getJarsInDir(file));
            }
            try {
                cpList.add(file.toURL());
            }
            catch (MalformedURLException murl) {
                System.err.println(murl.getMessage() + ": url=" + murl);
            }
        }
    }

    private void log(String msg) {
        this.context.log(msg);
    }

    public static List<URL> getJarsInDirRecursively(File file) {
        ArrayList<URL> jars = new ArrayList<URL>();
        File[] list = file.listFiles();
        if (list == null) {
            return new ArrayList<URL>();
        }
        jars.addAll(ClassloaderHelper.getJarsInDir(file));
        for (File f : list) {
            if (!f.isDirectory()) continue;
            jars.addAll(ClassloaderHelper.getJarsInDirRecursively(f));
        }
        return jars;
    }

    public static List getJarsInDir(File file) {
        Vector<URL> list = new Vector<URL>();
        File[] libFiles = file.listFiles();
        for (int i = 0; i < libFiles.length; ++i) {
            URL url;
            String fileName = libFiles[i].toString();
            if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip") || (url = ClassloaderHelper.toURL(libFiles[i])) == null) continue;
            list.add(url);
        }
        return list;
    }

    public static String addTrailingSlashIfNotExist(String path) {
        if (path != null && ((String)path).length() > 0 && ((String)path).charAt(((String)path).length() - 1) != File.separatorChar) {
            path = (String)path + File.separator;
        }
        return path;
    }

    static {
        isServerless = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Boolean.getBoolean("coldfusion.lambdaenabled");
            }
        });
    }
}

