/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.bootstrap.BootstrapClassLoader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TemplateProxyWrapper
implements Externalizable {
    String cfcFullyQualifiedName = null;
    HashMap tempThisScopeMap = null;
    HashMap tempVarScopeMap = null;
    boolean persistent = false;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tempThisScopeMap = (HashMap)in.readObject();
        this.tempVarScopeMap = (HashMap)in.readObject();
        this.cfcFullyQualifiedName = (String)in.readObject();
        this.persistent = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tempThisScopeMap);
        out.writeObject(this.tempVarScopeMap);
        out.writeObject(this.cfcFullyQualifiedName);
        out.writeBoolean(this.persistent);
    }

    public Object readResolve() {
        BootstrapClassLoader bootStrapClassLoader = BootstrapClassLoader.instance();
        try {
            String className = this.persistent ? "coldfusion.orm.PersistentTemplateProxy" : "coldfusion.runtime.TemplateProxy";
            Class<?> templateProxyClass = Class.forName(className, true, bootStrapClassLoader);
            Class[] argumentClasses = new Class[]{HashMap.class, HashMap.class, String.class};
            Constructor<?> ct = templateProxyClass.getConstructor(argumentClasses);
            Object[] args = new Object[]{this.tempThisScopeMap, this.tempVarScopeMap, this.cfcFullyQualifiedName};
            Object obj = ct.newInstance(args);
            Method getCfcWrapperMapMethod = templateProxyClass.getMethod("getCfcWrapperMap", null);
            Map cfcWrapperMap = (Map)getCfcWrapperMapMethod.invoke(obj, null);
            cfcWrapperMap.put(this, obj);
            return obj;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void setCfcFullyQualifiedName(String cfcFullyQualifiedName) {
        this.cfcFullyQualifiedName = cfcFullyQualifiedName;
    }

    public void setTempThisScopeMap(HashMap tempThisScopeMap) {
        this.tempThisScopeMap = tempThisScopeMap;
    }

    public void setTempVarScopeMap(HashMap tempVarScopeMap) {
        this.tempVarScopeMap = tempVarScopeMap;
    }

    public HashMap getTempThisScopeMap() {
        return this.tempThisScopeMap;
    }

    public HashMap getTempVarScopeMap() {
        return this.tempVarScopeMap;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }
}

