/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.bootstrap.ClassloaderHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CLIInvoker {
    private static Properties prop;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("CommandLineInvoker must have at least one arg, which is the name of the class to invoke");
        }
        String classNameToInvoke = args[0];
        String[] invokeArgs = new String[args.length - 1];
        System.arraycopy(args, 1, invokeArgs, 0, args.length - 1);
        BootstrapClassLoader bootstrap = null;
        Vector<URL> classpath = new Vector<URL>();
        String standAloneClassPath = System.getProperty("coldfusion.classPath");
        if (standAloneClassPath != null) {
            StringTokenizer xt = new StringTokenizer(standAloneClassPath, ",");
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                File sacp = new File(tok = ClassloaderHelper.removeQuotes(tok));
                if (!sacp.exists()) continue;
                if (tok.endsWith("/updates")) {
                    ClassloaderHelper.addUpdatesToClassPath(sacp, classpath);
                    continue;
                }
                if (sacp.isDirectory()) {
                    classpath.addAll(ClassloaderHelper.getJarsInDir(sacp));
                }
                try {
                    classpath.add(sacp.toURL());
                }
                catch (MalformedURLException murl) {
                    System.err.println(murl.getMessage() + ": url=" + murl);
                }
            }
        }
        URL[] classpathURLs = new URL[classpath.size()];
        for (int i = 0; i < classpathURLs.length; ++i) {
            URL url;
            classpathURLs[i] = url = (URL)classpath.get(i);
        }
        String standAloneLibPath = System.getProperty("coldfusion.libPath");
        Vector<String> libPaths = new Vector<String>();
        String iTextPath = null;
        if (standAloneLibPath != null) {
            iTextPath = ClassloaderHelper.addTrailingSlashIfNotExist(standAloneLibPath) + "itext";
            StringTokenizer xt = new StringTokenizer(standAloneLibPath, ",");
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                tok = ClassloaderHelper.removeQuotes(tok);
                libPaths.add(tok);
            }
        }
        CLIInvoker.setClassloaderConfig();
        List<URL> iTextURLs = iTextPath != null ? ClassloaderHelper.getJarsInDirRecursively(new File(iTextPath)) : null;
        bootstrap = new BootstrapClassLoader(classpathURLs, CLIInvoker.class.getClassLoader(), prop, libPaths, iTextURLs);
        Thread.currentThread().setContextClassLoader(bootstrap);
        BootstrapClassLoader.setInstance(bootstrap);
        try {
            Class<?> compClz = bootstrap.loadClass("coldfusion.tools." + classNameToInvoke);
            Method mainMeth = compClz.getMethod("main", args.getClass());
            mainMeth.invoke(null, new Object[]{invokeArgs});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setClassloaderConfig() {
        block4: {
            ClassLoader cl = CLIInvoker.class.getClassLoader();
            String propFileName = "tomcat.properties";
            prop = new Properties();
            InputStream propsFileStream = null;
            try {
                propsFileStream = cl.getResourceAsStream(propFileName);
                prop.load(propsFileStream);
                propsFileStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (propsFileStream == null) break block4;
                try {
                    propsFileStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

