/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.bootstrap.ClassloaderHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLineInvoker {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("CommandLineInvoker must have at least one arg, which is the name of the class to invoke");
        }
        String classNameToInvoke = args[0];
        String[] invokeArgs = new String[args.length - 1];
        System.arraycopy(args, 1, invokeArgs, 0, args.length - 1);
        BootstrapClassLoader bootstrap = null;
        Vector<URL> classpath = new Vector<URL>();
        String standAloneClassPath = System.getProperty("coldfusion.classPath");
        if (standAloneClassPath != null) {
            StringTokenizer xt = new StringTokenizer(standAloneClassPath, ",");
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                tok = ClassloaderHelper.removeQuotes(tok);
                File sacp = new File(tok);
                if (tok.endsWith("/updates")) {
                    ClassloaderHelper.addUpdatesToClassPath(sacp, classpath);
                    continue;
                }
                if (sacp.isDirectory()) {
                    classpath.addAll(ClassloaderHelper.getJarsInDir(sacp));
                    continue;
                }
                classpath.add(sacp.toURL());
            }
        }
        URL[] classpathURLs = new URL[classpath.size()];
        for (int i = 0; i < classpathURLs.length; ++i) {
            URL url;
            classpathURLs[i] = url = (URL)classpath.get(i);
        }
        String standAloneLibPath = System.getProperty("coldfusion.libPath");
        Vector<String> libPaths = new Vector<String>();
        String iTextPath = null;
        if (standAloneLibPath != null) {
            iTextPath = ClassloaderHelper.addTrailingSlashIfNotExist(standAloneLibPath) + "itext";
            StringTokenizer xt = new StringTokenizer(standAloneLibPath, ",");
            while (xt.hasMoreTokens()) {
                String tok = xt.nextToken();
                tok = ClassloaderHelper.removeQuotes(tok);
                libPaths.add(tok);
            }
        }
        List<URL> iTextURLs = iTextPath != null ? ClassloaderHelper.getJarsInDirRecursively(new File(iTextPath)) : null;
        bootstrap = new BootstrapClassLoader(classpathURLs, CommandLineInvoker.class.getClassLoader(), new Properties(), libPaths, iTextURLs);
        Thread.currentThread().setContextClassLoader(bootstrap);
        try {
            Class<?> compClz = bootstrap.loadClass("coldfusion.tools." + classNameToInvoke);
            Method mainMeth = compClz.getMethod("main", args.getClass());
            mainMeth.invoke(null, new Object[]{invokeArgs});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

