/*
 * Decompiled with CFR 0.152.
 */
package coldfusion;

import coldfusion.ColdFusion;
import coldfusion.log.CFLogs;
import coldfusion.server.UpdateUtil;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;

public class Version {
    private static final String product_name = "ColdFusion Server";
    private static final String major = "2025";
    private static final String minor = "0";
    private static final String service_pack = "0";
    private static final String productVersionPrev = "2023";
    private static final String productVersion2Prev = "2021";
    private static final String productVersion3Prev = "2018";
    private static final String build = RB.getMessage(Version.class, "build", null, "coldfusion.buildnumber", null);
    private static final String build_date = RB.getString(ColdFusion.class, "coldfusion.builddate");
    private static final String VERSION_SEPERATOR = ",";
    private static String version_string = "2025,0,0," + build;
    private static final String baseVersion = RB.getString(Version.class, "coldfusion.baseversion");
    private static final String baseBuildNumber = RB.getString(Version.class, "coldfusion.version");
    private static final String copyrightYear = RB.getString(Version.class, "coldfusion.copyrightYear");

    public static String getProductName() {
        return product_name;
    }

    public static String getVersionString() {
        return version_string;
    }

    public static String getBuild() {
        return build;
    }

    public static String getBaseBuildNumber(String cfusioLibPath) {
        if (ServerlessUtil.isLambdaEnv()) {
            cfusioLibPath = "/var/task/lib";
        }
        String jarFilePath = cfusioLibPath + "/cfusion.jar";
        String buildNumber = "00000";
        try {
            File file = new File(jarFilePath);
            URI uri = file.toURI();
            URL url = uri.toURL();
            URLClassLoader ucl = new URLClassLoader(new URL[]{url});
            Class<?> versionClass = Class.forName("coldfusion.Version", true, ucl);
            Method getBuild = versionClass.getDeclaredMethod("getBuild", null);
            buildNumber = (String)getBuild.invoke(versionClass, null);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e.getMessage());
        }
        return buildNumber;
    }

    public static String getBuildDate() {
        return build_date;
    }

    public static String getMajor() {
        return major;
    }

    public static String getMinor() {
        return "0";
    }

    public static String getServicePack() {
        return "0";
    }

    public static String getBaseVersion() {
        return baseVersion;
    }

    public static String getBaseBuildNumber() {
        return baseBuildNumber;
    }

    public static String getProductVersionPrev() {
        return productVersionPrev;
    }

    public static String getProductVersion2Prev() {
        return productVersion2Prev;
    }

    public static String getProductversion3prev() {
        return productVersion3Prev;
    }

    public static void setProductVersion(String versionString) {
        version_string = versionString;
    }

    public static String getVersionString(String neoRoot) {
        String productVersion = Utils.joinStrings(VERSION_SEPERATOR, Version.getMajor(), Version.getMinor(), Version.getUpdateLevel(neoRoot), Version.getBuild());
        Version.setProductVersion(productVersion);
        return productVersion;
    }

    public static String getVersionStringWithDotSeparator() {
        return version_string.replaceAll(VERSION_SEPERATOR, ".");
    }

    public static String getUpdateLevel(String neoRoot) {
        if (neoRoot != null && !neoRoot.trim().equals("")) {
            return UpdateUtil.getUpdateLevel(neoRoot);
        }
        return "0";
    }

    public static String getUpdateLevel(String neoRoot, boolean reload) {
        if (neoRoot != null && !neoRoot.trim().equals("")) {
            return UpdateUtil.getUpdateLevel(neoRoot, reload);
        }
        return "0";
    }

    public static String getCopyrightYear() {
        return copyrightYear;
    }

    static {
        String v = "202500";
        if (!"202500".equals(v)) {
            System.err.println("ERROR: CFMX bootstrap version does not match cfusion.jar version");
        }
    }
}

