/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.appdeployment;

import coldfusion.appdeployment.AppDeploymentException;
import java.util.Objects;

public class AppDeploymentExceptions {
    private static AppDeploymentExceptions appDepExceptions = new AppDeploymentExceptions();

    public static void throwZipFileCreateException(String folderPath) throws ZipFileCreateException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new ZipFileCreateException(folderPath);
    }

    public static void throwMappingNotFoundException(String folderPath) throws MappingNotFoundException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new MappingNotFoundException(folderPath);
    }

    public static void throwCFIDEMappingExceptionException() throws CFIDEMappingException {
        throw appDepExceptions.new CFIDEMappingException();
    }

    public static void throwCFIDERemoveMappingException() throws CFIDERemoveMappingException {
        throw appDepExceptions.new CFIDERemoveMappingException();
    }

    public static void throwInstallTypeNotFoundException(String typeName) throws InstallTypeNotFoundException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new InstallTypeNotFoundException(typeName);
    }

    public static void throwDataSourceNotFoundException(String dsName) throws DataSourceNotFoundException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new DataSourceNotFoundException(dsName);
    }

    public static void throwPropertyNotFoundException(String propName) throws PropertyNotFoundException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new PropertyNotFoundException(propName);
    }

    public static void throwMissingInfoReqLibException() throws MissingInfoReqLibException {
        throw appDepExceptions.new MissingInfoReqLibException();
    }

    public static void throwMissingInfoInstallTypeException() throws MissingInfoInstallTypeException {
        throw appDepExceptions.new MissingInfoInstallTypeException();
    }

    public static void throwMissingInfoFileCopyException() throws MissingInfoFileCopyException {
        throw appDepExceptions.new MissingInfoFileCopyException();
    }

    public static void throwUninstallerInfoMissingException(String appName) throws UninstallerInfoMissingException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new UninstallerInfoMissingException(appName);
    }

    public static void throwInstallationCompleteException() throws InstallationCompleteException {
        throw appDepExceptions.new InstallationCompleteException();
    }

    public static void throwApplicationExistsException(String appName, String targetFolder) throws ApplicationExistsException {
        AppDeploymentExceptions appDeploymentExceptions = appDepExceptions;
        Objects.requireNonNull(appDeploymentExceptions);
        throw appDeploymentExceptions.new ApplicationExistsException(appName, targetFolder);
    }

    public static void throwMultipleDefaultInstallTypesException() throws MultipleDefaultInstallTypesException {
        throw appDepExceptions.new MultipleDefaultInstallTypesException();
    }

    public static void throwConfigFileNotFoundException() throws ConfigFileNotFoundException {
        throw appDepExceptions.new ConfigFileNotFoundException();
    }

    public class ZipFileCreateException
    extends AppDeploymentException {
        public String folderPath;

        public ZipFileCreateException(String folderPath) {
            this.folderPath = folderPath;
        }
    }

    public class MappingNotFoundException
    extends AppDeploymentException {
        public String mappingName;

        public MappingNotFoundException(String mappingName) {
            this.mappingName = mappingName;
        }
    }

    public class CFIDEMappingException
    extends AppDeploymentException {
    }

    public class CFIDERemoveMappingException
    extends AppDeploymentException {
    }

    public class InstallTypeNotFoundException
    extends AppDeploymentException {
        public String typeName;

        public InstallTypeNotFoundException(String typeName) {
            this.typeName = typeName;
        }
    }

    public class DataSourceNotFoundException
    extends AppDeploymentException {
        public String dsName;

        public DataSourceNotFoundException(String dsName) {
            this.dsName = dsName;
        }
    }

    public class PropertyNotFoundException
    extends AppDeploymentException {
        public String propName;

        public PropertyNotFoundException(String propName) {
            this.propName = propName;
        }
    }

    public class MissingInfoReqLibException
    extends AppDeploymentException {
    }

    public class MissingInfoInstallTypeException
    extends AppDeploymentException {
    }

    public class MissingInfoFileCopyException
    extends AppDeploymentException {
    }

    public class UninstallerInfoMissingException
    extends AppDeploymentException {
        public String appName;

        public UninstallerInfoMissingException(String appName) {
            this.appName = appName;
        }
    }

    public class InstallationCompleteException
    extends AppDeploymentException {
    }

    public class ApplicationExistsException
    extends AppDeploymentException {
        public String appName;
        public String targetFolder;

        public ApplicationExistsException(String appName, String targetFolder) {
            this.appName = appName;
            this.targetFolder = targetFolder;
        }
    }

    public class MultipleDefaultInstallTypesException
    extends AppDeploymentException {
    }

    public class ConfigFileNotFoundException
    extends AppDeploymentException {
    }
}

