/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.appdeployment;

import coldfusion.appdeployment.AppDeploymentExceptions;
import coldfusion.appdeployment.CFAppDeployer;
import coldfusion.appdeployment.ConfigInfo;
import coldfusion.appdeployment.DataSourceInfo;
import coldfusion.appdeployment.DataSourceInfoCollection;
import coldfusion.appdeployment.FileCopyInfo;
import coldfusion.appdeployment.InstallTypeInfo;
import coldfusion.appdeployment.LibraryInfo;
import coldfusion.appdeployment.MappingInfo;
import coldfusion.appdeployment.MappingsInfoCollection;
import coldfusion.appdeployment.PostInstallInfo;
import coldfusion.appdeployment.PreInstallInfo;
import coldfusion.appdeployment.PropertiesInfoCollection;
import coldfusion.appdeployment.PropertyInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigFileParser
extends DefaultHandler {
    File tmpUnzipFolder = null;
    public static final String configFileName = "config.xml";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final String DOM_DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    ConfigInfo configInfo = new ConfigInfo();
    CFAppDeployer appDeployer = null;

    public ConfigFileParser(File tmpUnzipfolder, CFAppDeployer appDeployer) {
        this.tmpUnzipFolder = tmpUnzipfolder;
        this.appDeployer = appDeployer;
    }

    public void parse() throws Exception {
        this.parse(configFileName);
    }

    public void parse(String configFileName) throws Exception {
        DOMParser parser = new DOMParser();
        FileReader reader = null;
        try {
            reader = new FileReader(this.tmpUnzipFolder.getAbsolutePath() + File.separator + configFileName);
        }
        catch (FileNotFoundException fnfe) {
            AppDeploymentExceptions.throwConfigFileNotFoundException();
        }
        InputSource inSource = new InputSource(reader);
        parser.parse(inSource);
        Document doc = parser.getDocument();
        this.processNode(doc);
        doc = null;
    }

    protected void printNode(Node node, int indent) {
        String nodeName = node.getNodeName();
        String nodeValue = node.getNodeValue();
        if (nodeValue != null && nodeValue.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println("Name = " + nodeName + ", Value = " + nodeValue + ", Type = " + node.getNodeType());
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.printNode(children.item(i), indent + 1);
        }
    }

    protected String getTextValue(Node node) {
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        if (firstChild.getNodeType() != 3) {
            return null;
        }
        return firstChild.getNodeValue();
    }

    protected void processPreInstallNode(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        PreInstallInfo preInstallInfo = new PreInstallInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            ArrayList libs;
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("license")) {
                preInstallInfo.setLicenseFilePath(this.getTextValue(child));
                continue;
            }
            if (nodeName.equalsIgnoreCase("help")) {
                preInstallInfo.setHelpFilePath(this.getTextValue(child));
                continue;
            }
            if (nodeName.equalsIgnoreCase("scripts")) {
                ArrayList scripts = this.processScriptsNode(child);
                if (scripts == null) continue;
                preInstallInfo.setScripts(scripts);
                continue;
            }
            if (nodeName.equalsIgnoreCase("serial_number")) {
                preInstallInfo.setSerialNumber(this.getTextValue(child));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("required_libraries") || (libs = this.processRequiredLibrariesNode(child)) == null) continue;
            preInstallInfo.setRequiredLibraires(libs);
        }
        this.configInfo.setPreInstallInfo(preInstallInfo);
    }

    protected void processPostInstallNode(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        PostInstallInfo postInstallInfo = new PostInstallInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            ArrayList scripts;
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("help")) {
                postInstallInfo.setHelpFilePath(this.getTextValue(child));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("scripts") || (scripts = this.processScriptsNode(child)) == null) continue;
            postInstallInfo.setScripts(scripts);
        }
        this.configInfo.setPostInstallInfo(postInstallInfo);
    }

    protected ArrayList processRequiredLibrariesNode(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        ArrayList<LibraryInfo> reqLibs = new ArrayList<LibraryInfo>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("library")) continue;
            NamedNodeMap attribMap = child.getAttributes();
            Node nameNode = attribMap.getNamedItem("name");
            String name = null;
            String url = null;
            if (nameNode != null) {
                name = nameNode.getNodeValue();
            }
            Node urlNode = attribMap.getNamedItem("path");
            url = urlNode.getNodeValue();
            if (name != null && url != null) {
                LibraryInfo libInfo = new LibraryInfo(name, url);
                reqLibs.add(libInfo);
                continue;
            }
            AppDeploymentExceptions.throwMissingInfoReqLibException();
        }
        if (reqLibs.size() == 0) {
            return null;
        }
        return reqLibs;
    }

    protected ArrayList processScriptsNode(Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<String> scripts = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("script")) continue;
            scripts.add(this.getTextValue(child));
        }
        if (scripts.size() == 0) {
            return null;
        }
        return scripts;
    }

    protected void processCFLibNode(Node cfLibNode) throws Exception {
        NodeList children = cfLibNode.getChildNodes();
        String lastSection = "appinfo";
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equalsIgnoreCase("name")) {
                this.configInfo.setAppName(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("version")) {
                this.configInfo.setVersionNum(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("author")) {
                this.configInfo.setAuthor(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("update_url")) {
                this.configInfo.setUpdateUrl(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("email")) {
                this.configInfo.setEmail(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("description")) {
                this.configInfo.setDescription(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("app_folder_name")) {
                this.configInfo.setAppFolderName(this.getTextValue(node));
                continue;
            }
            if (nodeName.equalsIgnoreCase("preinstall")) {
                this.processPreInstallNode(node);
                lastSection = "preinstall";
                continue;
            }
            if (nodeName.equalsIgnoreCase("mappings")) {
                this.processMappingsNode(node);
                lastSection = "mappings";
                continue;
            }
            if (nodeName.equalsIgnoreCase("datasources")) {
                this.processDataSourcesNode(node);
                lastSection = "datasources";
                continue;
            }
            if (nodeName.equalsIgnoreCase("properties")) {
                this.processPropertiesNode(node);
                lastSection = "properties";
                continue;
            }
            if (nodeName.equalsIgnoreCase("copy")) {
                this.processCopyNode(node, lastSection);
                continue;
            }
            if (nodeName.equalsIgnoreCase("postinstall")) {
                this.processPostInstallNode(node);
                lastSection = "postinstall";
                continue;
            }
            if (!nodeName.equalsIgnoreCase("install_types")) continue;
            this.processInstallTypesNode(node);
        }
    }

    private void processInstallTypesNode(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("install_type")) continue;
            this.processInstallTypeNode(child);
        }
        Map types = this.configInfo.getInstallTypes();
        boolean defaultTypeFound = false;
        for (String key : types.keySet()) {
            InstallTypeInfo typeInfo = (InstallTypeInfo)types.get(key);
            if (!typeInfo.isDefaultType()) continue;
            if (defaultTypeFound) {
                AppDeploymentExceptions.throwMultipleDefaultInstallTypesException();
            }
            defaultTypeFound = true;
        }
    }

    private void processInstallTypeNode(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        String installTypeName = null;
        String configPath = null;
        String description = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("name")) {
                installTypeName = this.getTextValue(child);
                continue;
            }
            if (nodeName.equalsIgnoreCase("config_file")) {
                configPath = this.getTextValue(child);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("description")) continue;
            description = this.getTextValue(child);
        }
        boolean isDefault = false;
        NamedNodeMap attribMap = node.getAttributes();
        Node defaultNode = attribMap.getNamedItem("default");
        if (defaultNode != null) {
            String objValue = defaultNode.getNodeValue();
            if (objValue != null) {
                if (!objValue.toString().equalsIgnoreCase("false")) {
                    isDefault = true;
                }
            } else {
                isDefault = true;
            }
        }
        if (installTypeName != null && configPath != null) {
            this.configInfo.addInstallType(installTypeName, configPath, description, isDefault);
        } else {
            AppDeploymentExceptions.throwMissingInfoInstallTypeException();
        }
    }

    private void processCopyNode(Node node, String lastSection) throws Exception {
        NodeList children = node.getChildNodes();
        Map fileCopyInfo = this.configInfo.getFileCopyInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            Node copyFolderFlagNode;
            Node urlNode;
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("file")) continue;
            NamedNodeMap attribMap = child.getAttributes();
            Node nameNode = attribMap.getNamedItem("source");
            String source = null;
            String destination = null;
            boolean createFolder = true;
            if (nameNode != null) {
                source = nameNode.getNodeValue();
            }
            if ((urlNode = attribMap.getNamedItem("destination")) != null) {
                destination = this.appDeployer.replaceSystemVariableValues(urlNode.getNodeValue());
            }
            if ((copyFolderFlagNode = attribMap.getNamedItem("createFolder")) != null) {
                String tmpStr = urlNode.getNodeValue();
                Boolean bObj = new Boolean(tmpStr);
                createFolder = bObj;
            }
            if (source != null) {
                FileCopyInfo copyInfo = new FileCopyInfo();
                copyInfo.setSource(source);
                copyInfo.setDestination(destination);
                copyInfo.setCreateFolder(createFolder);
                Object obj = fileCopyInfo.get(lastSection);
                if (obj == null) {
                    obj = new HashMap();
                    fileCopyInfo.put(lastSection, obj);
                }
                Map copyInfoMap = (Map)obj;
                copyInfoMap.put(source, copyInfo);
                continue;
            }
            AppDeploymentExceptions.throwMissingInfoFileCopyException();
        }
    }

    private void processPropertiesNode(Node node) {
        NodeList children = node.getChildNodes();
        PropertiesInfoCollection propCollection = this.configInfo.getProperties();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("property")) {
                PropertyInfo propInfo = this.processPropertyNode(child);
                propCollection.addPropertyInfo(propInfo);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("script")) continue;
            this.configInfo.setPropertiesScriptPath(this.getTextValue(child));
        }
    }

    private PropertyInfo processPropertyNode(Node node) {
        NodeList children = node.getChildNodes();
        PropertyInfo propInfo = new PropertyInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("name")) {
                propInfo.setName(this.getTextValue(child));
                continue;
            }
            if (nodeName.equalsIgnoreCase("value")) {
                propInfo.setValue(this.appDeployer.replaceSystemVariableValues(this.getTextValue(child)));
                continue;
            }
            if (nodeName.equalsIgnoreCase("help")) {
                propInfo.setHelpFilePath(this.getTextValue(child));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("default")) continue;
            propInfo.setDefaultValue(this.appDeployer.replaceSystemVariableValues(this.getTextValue(child)));
        }
        return propInfo;
    }

    private void processDataSourcesNode(Node node) {
        NodeList children = node.getChildNodes();
        DataSourceInfoCollection dsMappings = this.configInfo.getDatasources();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("datasource")) {
                DataSourceInfo dataSourceInfo = this.processDataSourceNode(child);
                dsMappings.addDataSourceInfo(dataSourceInfo);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("script")) continue;
            this.configInfo.setDatasourcesScriptPath(this.getTextValue(child));
        }
    }

    private DataSourceInfo processDataSourceNode(Node node) {
        NodeList children = node.getChildNodes();
        DataSourceInfo dsInfo = new DataSourceInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("name")) {
                dsInfo.setName(this.getTextValue(child));
                continue;
            }
            if (nodeName.equalsIgnoreCase("help")) {
                dsInfo.setHelpFilePath(this.getTextValue(child));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("default")) continue;
            dsInfo.setDefaultValue(this.getTextValue(child));
        }
        return dsInfo;
    }

    private void processMappingsNode(Node node) {
        NodeList children = node.getChildNodes();
        MappingsInfoCollection mappingCollection = this.configInfo.getMappings();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("mapping")) {
                MappingInfo mappingInfo = this.processMappingNode(child);
                mappingCollection.addMappingInfo(mappingInfo);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("script")) continue;
            this.configInfo.setMappingsScriptPath(this.getTextValue(child));
        }
    }

    private MappingInfo processMappingNode(Node node) {
        NodeList children = node.getChildNodes();
        MappingInfo mappingInfo = new MappingInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("name")) {
                mappingInfo.setName(this.getTextValue(child));
                continue;
            }
            if (nodeName.equalsIgnoreCase("path")) {
                mappingInfo.setPath(this.appDeployer.replaceSystemVariableValues(this.getTextValue(child)));
                continue;
            }
            if (nodeName.equalsIgnoreCase("help")) {
                mappingInfo.setHelpFilePath(this.getTextValue(child));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("default")) continue;
            mappingInfo.setDefaultPath(this.appDeployer.replaceSystemVariableValues(this.getTextValue(child)));
        }
        return mappingInfo;
    }

    protected void processNode(Node node) throws Exception {
        String nodeName = node.getNodeName();
        if (nodeName.equalsIgnoreCase("cflib")) {
            this.processCFLibNode(node);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.processNode(children.item(i));
        }
    }

    protected void parse_sax() throws Exception {
        XMLReader parser = null;
        FileReader reader = new FileReader(this.tmpUnzipFolder.getAbsolutePath() + File.separator + configFileName);
        InputSource inSource = new InputSource(reader);
        parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        parser.parse(inSource);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        System.out.println("Starting element - " + localName + " , QName - " + qName + ", URI = " + uri);
        for (int i = 0; i < attributes.getLength(); ++i) {
            System.out.println("\t" + attributes.getValue(i));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        System.out.println("Ending element - " + localName + " , QName - " + qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        System.out.println("\tData = " + data);
    }

    public ConfigInfo getConfigInfo() {
        return this.configInfo;
    }
}

