/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.archivedeploy;

import coldfusion.Version;
import coldfusion.archivedeploy.ArchiveDeployServiceImpl;
import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.cloud.VendorCredentialService;
import coldfusion.cloud.config.CloudConfigService;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.Logger;
import coldfusion.osgi.services.CronService;
import coldfusion.osgi.services.SamlService;
import coldfusion.osgi.to.ScheduleTagTO;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ClientScopeService;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Scope;
import coldfusion.runtime.Struct;
import coldfusion.server.ArchiveDeployService;
import coldfusion.server.ConfigList;
import coldfusion.server.ConfigListListener;
import coldfusion.server.ConfigMap;
import coldfusion.server.DataSourceService;
import coldfusion.server.DebuggingService;
import coldfusion.server.DocumentService;
import coldfusion.server.EventGatewayService;
import coldfusion.server.GraphingService;
import coldfusion.server.JaxRsService;
import coldfusion.server.LoggingService;
import coldfusion.server.MailSpoolService;
import coldfusion.server.MetricsService;
import coldfusion.server.MonitoringService;
import coldfusion.server.NoSQLService;
import coldfusion.server.PDFGService;
import coldfusion.server.RuntimeService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.SolrService;
import coldfusion.server.UpdateService;
import coldfusion.server.WatchService;
import coldfusion.server.WebSocketService;
import coldfusion.server.XmlRpcService;
import coldfusion.server.j2ee.CFMetricsService;
import coldfusion.util.ExtensionFilter;
import coldfusion.util.FastHashtable;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.StringEncoder;
import coldfusion.util.Utils;
import coldfusion.wddx.WddxDeserializationException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Archive {
    private static final String ALIAS_KEY = "ALIAS";
    private static final String CFMX = "cfmx";
    public static final String VERSION = "cfversion";
    public static final String SETTINGS = "basicSettings";
    public static final String SETTINGS_EVENTGATEWAY = "eventgatewayinstances";
    public static final String SETTINGS_EVENTGATEWAY_TYPES = "eventGatewayTypes";
    public static final String SETTINGS_EVENTGATEWAY_GLOBALS = "eventgatewaysettings";
    public static final String ARCHIVE_SETTINGS_EVENTGATEWAY_GLOBALS = "achiveEventGatewaySettings";
    public static final String GATEWAYINSTANCES = "gateways";
    public static final String SETTINGS_DEBUG = "debugging";
    public static final String SETTINGS_DEBUG_IPLIST = "iplist";
    public static final String SETTINGS_DEBUG_SETTINGS = "settings";
    public static final String SETTINGS_DEBUG_ENABLED = "enabled";
    public static final String SETTINGS_DEVELOPER_ENABLED = "developerenabled";
    public static final String SETTINGS_DEBUG_ROBUSTEXCEPTION = "robustexception";
    public static final String SETTINGS_LINE_DEBUG = "linedebuuger";
    public static final String SETTINGS_DEBUG_CFSTATENABLED = "cfstatenabled";
    public static final String SETTINGS_DEBUG_METRICSFREQ = "metricsfreq";
    public static final String SETTINGS_DEBUG_METRICSENALBED = "metricsenabled";
    public static final String SETTINGS_SERVERSETTINGS = "server_settings";
    public static final String SETTINGS_SERVERSETTINGS_ERRORS = "errors";
    public static final String SETTINGS_SERVERSETTINGS_WHITESPACE = "whitespace";
    public static final String SETTINGS_SERVERSETTINGS_REQUEST = "request";
    public static final String SETTINGS_SERVERSETTINGS_UUID = "uuidtoken";
    public static final String SETTINGS_SERVERSETTINGS_GLOBALSCRIPTPROTECT = "scriptprotect";
    public static final String SETTINGS_SERVERSETTINGS_MISC = "misc";
    public static final String SETTINGS_SERVERSETTINGS_REPORT = "report";
    public static final String SETTINGS_SERVERSETTINGS_THROTTLE = "throttle";
    public static final String SETTINGS_SERVERSETTINGS_CHARSET = "charsets";
    public static final String SETTINGS_SERVERSETTINGS_JRUN_ACTIVE = "jrunactive";
    public static final String SETTINGS_SERVERSETTINGS_JRUN_QUEUE = "jrunqueue";
    public static final String SETTINGS_SERVERSETTINGS_APIMANAGER = "apiManager";
    public static final String SETTINGS_SERVERSETTINGS_HTTPPOOL = "httpPool";
    public static final String SETTINGS_LOCKING = "locking";
    public static final String SETTINGS_LOGGING = "logging";
    public static final String SETTINGS_LOGGING_SETTINGS = "settings";
    public static final String SETTINGS_LOGGING_LOGCORBA = "logcorba";
    public static final String SETTINGS_LOGGING_LOGSLOW = "logslowrequests";
    public static final String SETTINGS_LOGGING_SLOWTIME = "slowrequesttimelimit";
    public static final String SETTINGS_LOGGING_SCHEDULEDTASKS = "logscheduledtasks";
    public static final String SETTINGS_MAIL = "mail";
    public static final String SETTINGS_JAVA = "java";
    public static final String SETTINGS_VARIABLES = "variables";
    public static final String SETTINGS_VARIABLES_MEMORY = "memory";
    public static final String SETTINGS_VARIABLES_SCS = "session_cookie_settings";
    public static final String SETTINGS_HTTPONLYSESSIONCOOKIE = "httponlySessionCookie";
    public static final String SETTINGS_SECURESESSIONCOOKIE = "secureSessionCookie";
    public static final String SETTINGS_SESSIONCOOKIETIMEOUT = "sessionCookieTimeout";
    public static final String SETTINGS_SESSIONSTORAGEHOST = "sessionStorageHost";
    public static final String SETTINGS_SESSIONSTORAGEPORT = "sessionStoragePort";
    public static final String SETTINGS_SESSIONSTORAGECLUSTER = "sessionStorageCluster";
    public static final String SETTINGS_SESSIONSTORAGEPASSWORD = "sessionStoragePassword";
    public static final String SETTINGS_SESSIONSTORAGEREUSECACHINGSERVER = "reuseCachingServer";
    public static final String SETTINGS_REDISCACHEHOST = "sessionStorageHost";
    public static final String SETTINGS_REDISCACHEPORT = "sessionStoragePort";
    public static final String SETTINGS_REDISCACHEPASSWORD = "sessionStoragePassword";
    public static final String SETTINGS_VARIABLES_CLIENT = "client";
    public static final String SETTINGS_VARIABLES_CLIENT_STORES = "clientstores";
    public static final String SETTINGS_SERVER_MONITOR = "monitoring";
    public static final String SETTINGS_SYSTEM_PROBE = "probe";
    public static final String SETTINGS_CACHING = "caching";
    public static final String SETTINGS_CACHING_MAXQUERYCOUNT = "maxquerycount";
    public static final String SETTINGS_CACHING_TEMPLATECACHESIZE = "templatecachesize";
    public static final String SETTINGS_CACHING_TRUSTEDCACHE = "trustedcache";
    public static final String SETTINGS_CACHING_SAVECLASSFILES = "saveclassfiles";
    public static final String SETTINGS_CACHING_CACHEREALPATH = "cacherealpath";
    public static final String SETTINGS_CACHING_INREQTEMPCACHEENABLD = "inReqTempCacheEnbld";
    public static final String SETTINGS_CACHING_COMPONENTCACHEENBLD = "comCacheEnbld";
    public static final String SETTINGS_CACHING_USE_INTERNAL_QUERYCACHE = "useinternalquerycache";
    public static final String SETTINGS_CACHING_ENGINE = "cachingEngine";
    public static final String SETTINGS_CACHING_JCS_DSN = "cachingJcsDsn";
    public static final String SETTINGS_CACHING_MEMCACHED_SERVER = "cachingMemcachedServer";
    public static final String SETTINGS_CACHING_MEMCACHED_MAXIDLE = "memcachedTimeToIdleSeconds";
    public static final String SETTINGS_CACHING_MEMCACHED_MAXTIME = "memcachedTimeToLiveSeconds";
    public static final String SETTINGS_CACHING_MEMCACHED_ETERNAL = "memcachedEternal";
    public static final String SETTINGS_CACHING_MEMCACHED_MAXOBJECTS = "memcachedMaxElementsInMemory";
    public static final String SETTINGS_CACHING_REDIS_MAXIDLE = "redisTimeToIdleSeconds";
    public static final String SETTINGS_CACHING_REDIS_MAXTIME = "redisTimeToLiveSeconds";
    public static final String SETTINGS_CACHING_REDIS_ETERNAL = "redisEternal";
    public static final String SETTINGS_CACHING_REDIS_MAXOBJECTS = "redisMaxElementsInMemory";
    public static final String SETTINGS_CACHING_JCS_MAXIDLE = "jcsTimeToIdleSeconds";
    public static final String SETTINGS_CACHING_JCS_MAXTIME = "jcsTimeToLiveSeconds";
    public static final String SETTINGS_CACHING_JCS_ETERNAL = "jcsEternal";
    public static final String SETTINGS_CACHING_JCS_MAXOBJECTS = "jcsMaxElementsInMemory";
    public static final String SETTINGS_CHARTING = "charting";
    public static final String SETTINGS_CUSTOM_TAG_PATHS = "customtags";
    public static final String SETTINGS_SECURITY = "basic_security";
    public static final String SETTINGS_WATCH = "watch";
    public static final String SETTINGS_UPDATES = "updates";
    public static final String UPDATES_DEFAULT_PACKAGES_URL = "defaultpackagesurl";
    public static final String UPDATES_PACKAGES_URL = "packagesurl";
    public static final String UPDATES_DEFAULT_URL = "defaulturl";
    public static final String UPDATES_URL = "url";
    public static final String SETTINGS_WEBSERVICE = "webservice_settings";
    public static final String WEBSERVICE_VERSION = "webservice_version";
    public static final String SETTINGS_PDFSERVICE = "pdfservice_settings";
    public static final String SETTINGS_WEBSOCKET = "websocket_settings";
    public static final String WEBSOCKET_SERVICE_ENABLED = "startWebSocketService";
    public static final String WEBSOCKET_PORT = "port";
    public static final String WEBSOCKET_SOCKETTIMEOUT = "sockettimeout";
    public static final String WEBSOCKET_MAXFRAMESIZE = "maxframesize";
    public static final String WEBSOCKET_SSL_ENABLED = "sslEnabled";
    public static final String WEBSOCKET_SSL_PORT = "sslport";
    public static final String WEBSOCKET_MULTICAST_PORT = "multicastPort";
    public static final String WEBSOCKET_CLUSTER_ENABLED = "clustered";
    public static final String WEBSOCKET_NORMAL_PORT_ENABLED = "startListenerOnNormalPort";
    public static final String WEBSOCKET_FLASHFALLBACK = "flashFallBack";
    public static final String WEBSOCKET_PROXY_PORT_ENABLED = "enableWebsocketOverProxyPort";
    public static final String MAPPINGS = "directoryMappings";
    public static final String CFX = "cfxs";
    public static final String FILES_EXCLUDE = "excludedFiles";
    public static final String FILES_INCLUDE = "includedFiles";
    public static final String SCHEDULED_TASKS = "tasks";
    public static final String ARCHIVE_VARIABLES = "archiveVariables";
    public static final String COLLECTIONS = "verityCollections";
    public static final String SOLR_COLLECTIONS = "solrCollections";
    public static final String SETTINGS_SOLR = "solrsettings";
    public static final String FONT_SETTINGS = "fontsettings";
    public static final String DATASOURCE = "datasources";
    public static final String WEBSERVICES = "webservices";
    public static final String RESTSERVICES = "restservices";
    public static final String PDFSERVICES = "pdfservices";
    public static final String PDF_HOSTNAME = "hostname";
    public static final String PDF_PORT = "port";
    public static final String PDF_PATH = "path";
    public static final String _DEF__RESTSERVICE = "_DEF__RESTSERVICE";
    public static final String RESTSERVICEMAPPINGS = "RESTSERVICEMAPPINGS";
    public static final String SETTINGS_FILE = "server_settings.xml";
    public static final String ARCHIVE_FILE = "archive_properties.xml";
    public static final String VERITY_COLLECTION_DIR = "car.verity.collectiondirectory";
    public static final String SOLR_COLLECTION_DIR = "car.solr.collectiondirectory";
    public static final String SOLR_HOME = "solrhome";
    public static final String SOLR_HOST = "solrhost";
    public static final String SOLR_PORT = "solrport";
    public static final String SOLR_USERNAME = "username";
    public static final String SOLR_WEBAPP = "solrwebapp";
    public static final String SOLR_HTTPS_PORT = "solrhttpsport";
    public static final String SOLR_BUFFER_SIZE = "solrbuffersize";
    public static final String SOLR_HTTPS_ENABLED = "httpsenabled";
    public static final String SOLR_LANG = "name";
    public static final String SOLR_LANGS = "languages";
    public static final String SOLR_LANG_SUFFIX = "suffix";
    public static final String PRE_RESTORE_LIST = "prerestore";
    public static final String POST_RESTORE_LIST = "postrestore";
    public static final String ARCHIVE_DESCRIPTION = "description";
    public static final String ARCHIVE_NAME = "name";
    private static final String ENABLE_NULL_SUPPORT = "enableNullSupport";
    public static final String SERVER_ROOT_DIR = "server_root_dir";
    public static final String CF_ROOTDIR = "cf.rootdir";
    public static final String IDP = "idps";
    public static final String SP = "sps";
    public static final String CLOUD_CREDENTIALS = "cloudcredentials";
    public static final String CLOUD_CONFIGURATIONS = "cloudconfigurations";
    public static final String NOSQL = "nosql";
    private static final String CORE_POOL_SIZE_AZURE_SERVICE_BUS = "corePoolSizeAzureServiceBus";
    private static final String MAX_POOL_SIZE_AZURE_SERVICE_BUS = "maxPoolSizeAzureServiceBus";
    private static final String KEEP_ALIVE_TIME_AZURE_SERVICE_BUS = "keepAliveTimeAzureServiceBus";
    private String currentVersion = "cfmx" + Version.getVersionString();
    private ConfigList m_BasicSettings = new ConfigList();
    private ConfigList m_Mappings = new ConfigList();
    private ConfigList m_Tasks = new ConfigList();
    private ConfigList m_Cfxs = new ConfigList();
    private ConfigList m_IncludedFiles = new ConfigList();
    private ConfigList m_ExcludedFiles = new ConfigList();
    private ConfigList m_Collections = new ConfigList();
    private ConfigList m_SolrCollections = new ConfigList();
    private ConfigList m_Datasources = new ConfigList();
    private ConfigList m_eventgateway = new ConfigList();
    private ConfigList m_eventgatewayTypes = new ConfigList();
    private ConfigMap eventGatewaySettings = new ConfigMap();
    private boolean archiveEventGatewaySettings = false;
    private String m_sPreRestore = "";
    private String m_sPostRestore = "";
    private ConfigList m_ServerSettings = new ConfigList();
    private String m_sDescription = "";
    private ConfigMap m_Variables = new ConfigMap();
    private ConfigMap m_Settings = new ConfigMap();
    private Vector m_ExpandedFileList = new Vector();
    private ConfigMap m_ArchiveMap = new ConfigMap();
    private File m_CarFile;
    private ConfigList m_webservices = new ConfigList();
    private ConfigList m_restservices = new ConfigList();
    private ConfigList m_pdfservices = new ConfigList();
    private ConfigList m_idps = new ConfigList();
    private ConfigList m_sps = new ConfigList();
    private ConfigList m_cloudcredentials = new ConfigList();
    private ConfigList m_cloudconfigurations = new ConfigList();
    private ConfigList m_nosql = new ConfigList();
    private boolean m_bLog = false;
    private Logger m_Logger;
    private String m_sName;
    private ArchiveDeployService m_Service;
    private String cfversion = "cfmx6";
    private String archiveSeed = null;
    private String oldAlgoValue = null;
    private int majorVersion = 0;
    private int minorVersion = 0;

    public Archive(String sName, ArchiveDeployService service) {
        this.init(sName, service);
    }

    private void init(String sName, ArchiveDeployService service) {
        this.m_sName = sName;
        this.m_Service = service;
        this.m_ArchiveMap.put("seed", (Object)((ArchiveDeployServiceImpl)service).getSeed());
        this.m_ArchiveMap.put("algorithm", (Object)"AES/CBC/PKCS5Padding");
        this.m_ArchiveMap.put(VERSION, (Object)this.currentVersion);
        this.m_ArchiveMap.put("name", (Object)this.m_sName);
        this.m_ArchiveMap.put(SETTINGS, (Object)this.m_BasicSettings);
        this.m_ArchiveMap.put(MAPPINGS, (Object)this.m_Mappings);
        this.m_ArchiveMap.put(SCHEDULED_TASKS, (Object)this.m_Tasks);
        this.m_ArchiveMap.put(CFX, (Object)this.m_Cfxs);
        this.m_ArchiveMap.put(FILES_INCLUDE, (Object)this.m_IncludedFiles);
        this.m_ArchiveMap.put(FILES_EXCLUDE, (Object)this.m_ExcludedFiles);
        this.m_ArchiveMap.put(COLLECTIONS, (Object)this.m_Collections);
        this.m_ArchiveMap.put(SOLR_COLLECTIONS, (Object)this.m_SolrCollections);
        this.m_ArchiveMap.put(DATASOURCE, (Object)this.m_Datasources);
        this.m_ArchiveMap.put(PRE_RESTORE_LIST, (Object)this.m_sPreRestore);
        this.m_ArchiveMap.put(POST_RESTORE_LIST, (Object)this.m_sPostRestore);
        this.m_ArchiveMap.put(ARCHIVE_DESCRIPTION, (Object)this.m_sDescription);
        this.m_ArchiveMap.put(ARCHIVE_VARIABLES, (Object)this.m_Variables);
        this.m_ArchiveMap.put(SETTINGS_EVENTGATEWAY, (Object)this.m_eventgateway);
        this.m_ArchiveMap.put(SETTINGS_EVENTGATEWAY_TYPES, (Object)this.m_eventgatewayTypes);
        this.m_ArchiveMap.put(ARCHIVE_SETTINGS_EVENTGATEWAY_GLOBALS, (Object)(this.archiveEventGatewaySettings ? Boolean.TRUE : Boolean.FALSE));
        this.m_ArchiveMap.put(WEBSERVICES, (Object)this.m_webservices);
        this.m_ArchiveMap.put(RESTSERVICES, (Object)this.m_restservices);
        this.m_ArchiveMap.put(PDFSERVICES, (Object)this.m_pdfservices);
        this.m_ArchiveMap.put(IDP, (Object)this.m_idps);
        this.m_ArchiveMap.put(SP, (Object)this.m_sps);
        this.m_ArchiveMap.put(CLOUD_CREDENTIALS, (Object)this.m_cloudcredentials);
        this.m_ArchiveMap.put(CLOUD_CONFIGURATIONS, (Object)this.m_cloudconfigurations);
        this.m_ArchiveMap.put(NOSQL, (Object)this.m_nosql);
    }

    public void addConfigMapListener(ServiceBase service) {
        this.m_ArchiveMap.init(service, this.m_sName);
        this.m_ArchiveMap.setConfigMapListener(service);
    }

    public void addConfigListListener(ConfigListListener listener) {
        this.m_BasicSettings.setListener(listener);
        this.m_Mappings.setListener(listener);
        this.m_Tasks.setListener(listener);
        this.m_Cfxs.setListener(listener);
        this.m_IncludedFiles.setListener(listener);
        this.m_ExcludedFiles.setListener(listener);
        this.m_Collections.setListener(listener);
        this.m_SolrCollections.setListener(listener);
        this.m_Datasources.setListener(listener);
        this.m_ServerSettings.setListener(listener);
        this.m_eventgateway.setListener(listener);
        this.m_eventgatewayTypes.setListener(listener);
        this.m_webservices.setListener(listener);
        this.m_restservices.setListener(listener);
        this.m_pdfservices.setListener(listener);
        this.m_idps.setListener(listener);
        this.m_sps.setListener(listener);
        this.m_cloudcredentials.setListener(listener);
        this.m_cloudconfigurations.setListener(listener);
        this.m_nosql.setListener(listener);
    }

    public Archive(String sName, Map map, ArchiveDeployService service) {
        this.init(sName, service);
        this.update(map);
    }

    public Archive(File carFile, ArchiveDeployService service) {
        this.init("", service);
        this.m_CarFile = carFile;
        if (carFile.exists()) {
            ZipInputStream zin;
            try {
                zin = new ZipInputStream(new FileInputStream(carFile));
            }
            catch (IOException ex) {
                throw new InvalidArchiveFileException(carFile.getAbsolutePath(), "read");
            }
            Object result = null;
            try {
                ZipEntry entry = zin.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(ARCHIVE_FILE)) {
                        result = ((ServiceBase)((Object)this.m_Service)).deserialize(zin);
                        break;
                    }
                    entry = zin.getNextEntry();
                }
                if (result instanceof Map) {
                    this.update((Map)result);
                }
            }
            catch (WddxDeserializationException ex) {
                ex.printStackTrace();
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
            }
            catch (SAXException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void update(Map map) {
        if (map.containsKey(VERSION)) {
            this.cfversion = (String)map.get(VERSION);
            if (this.cfversion != null) {
                this.majorVersion = this.getMajorVersion(this.cfversion);
                this.minorVersion = this.getMinorVersion(this.cfversion);
            } else {
                this.majorVersion = 0;
                this.minorVersion = 0;
            }
        }
        if (map.containsKey("seed")) {
            this.archiveSeed = (String)map.get("seed");
        }
        if (map.containsKey("algorithm")) {
            this.oldAlgoValue = (String)map.get("algorithm");
        }
        if (map.containsKey(SETTINGS)) {
            this.m_BasicSettings.clear();
            this.m_BasicSettings.addAll((Collection)map.get(SETTINGS));
        }
        if (map.containsKey(MAPPINGS)) {
            this.m_Mappings.clear();
            this.m_Mappings.addAll((Collection)map.get(MAPPINGS));
        }
        if (map.containsKey(SCHEDULED_TASKS)) {
            this.m_Tasks.clear();
            this.m_Tasks.addAll((Collection)map.get(SCHEDULED_TASKS));
        }
        if (map.containsKey(CFX)) {
            this.m_Cfxs.clear();
            this.m_Cfxs.addAll((Collection)map.get(CFX));
        }
        if (map.containsKey(FILES_INCLUDE)) {
            this.m_IncludedFiles.clear();
            this.m_IncludedFiles.addAll((Collection)map.get(FILES_INCLUDE));
        }
        if (map.containsKey(FILES_EXCLUDE)) {
            this.m_ExcludedFiles.clear();
            this.m_ExcludedFiles.addAll((Collection)map.get(FILES_EXCLUDE));
        }
        if (map.containsKey(COLLECTIONS)) {
            this.m_Collections.clear();
            this.m_Collections.addAll((Collection)map.get(COLLECTIONS));
        }
        if (map.containsKey(SOLR_COLLECTIONS)) {
            this.m_SolrCollections.clear();
            this.m_SolrCollections.addAll((Collection)map.get(SOLR_COLLECTIONS));
        }
        if (map.containsKey(ARCHIVE_VARIABLES)) {
            this.m_Variables.clear();
            this.m_Variables.putAll((Map)map.get(ARCHIVE_VARIABLES));
        }
        if (map.containsKey(DATASOURCE)) {
            this.m_Datasources.clear();
            this.m_Datasources.addAll((Collection)map.get(DATASOURCE));
        }
        if (map.containsKey(PRE_RESTORE_LIST)) {
            this.setPreRestore((String)map.get(PRE_RESTORE_LIST));
        }
        if (map.containsKey(POST_RESTORE_LIST)) {
            this.setPostRestore((String)map.get(POST_RESTORE_LIST));
        }
        if (map.containsKey(ARCHIVE_DESCRIPTION)) {
            this.setDescription((String)map.get(ARCHIVE_DESCRIPTION));
        }
        if (map.containsKey("name")) {
            this.setName((String)map.get("name"));
        }
        if (map.containsKey(SETTINGS_EVENTGATEWAY)) {
            this.m_eventgateway.clear();
            this.m_eventgateway.addAll((Collection)map.get(SETTINGS_EVENTGATEWAY));
        }
        if (map.containsKey(SETTINGS_EVENTGATEWAY_TYPES)) {
            this.m_eventgatewayTypes.clear();
            this.m_eventgatewayTypes.addAll((Collection)map.get(SETTINGS_EVENTGATEWAY_TYPES));
        }
        if ("cfmx7".equalsIgnoreCase(this.cfversion) && map.containsKey(GATEWAYINSTANCES)) {
            this.m_eventgateway.clear();
            this.m_eventgateway.addAll((Collection)map.get(GATEWAYINSTANCES));
        }
        if (map.containsKey(SETTINGS_EVENTGATEWAY_GLOBALS)) {
            this.eventGatewaySettings.clear();
            this.eventGatewaySettings.putAll((Map)map.get(SETTINGS_EVENTGATEWAY_GLOBALS));
        }
        if (map.containsKey(WEBSERVICES)) {
            this.m_webservices.clear();
            this.m_webservices.addAll((Collection)map.get(WEBSERVICES));
        }
        if (map.containsKey(RESTSERVICES)) {
            this.m_restservices.clear();
            this.m_restservices.addAll((Collection)map.get(RESTSERVICES));
        }
        if (map.containsKey(PDFSERVICES)) {
            this.m_pdfservices.clear();
            this.m_pdfservices.addAll((Collection)map.get(PDFSERVICES));
        }
        if (map.containsKey(IDP)) {
            this.m_idps.clear();
            this.m_idps.addAll((Collection)map.get(IDP));
        }
        if (map.containsKey(SP)) {
            this.m_sps.clear();
            this.m_sps.addAll((Collection)map.get(SP));
        }
        if (map.containsKey(CLOUD_CREDENTIALS)) {
            this.m_cloudcredentials.clear();
            this.m_cloudcredentials.addAll((Collection)map.get(CLOUD_CREDENTIALS));
        }
        if (map.containsKey(CLOUD_CONFIGURATIONS)) {
            this.m_cloudconfigurations.clear();
            this.m_cloudconfigurations.addAll((Collection)map.get(CLOUD_CONFIGURATIONS));
        }
        if (map.containsKey(NOSQL)) {
            this.m_nosql.clear();
            this.m_nosql.addAll((Collection)map.get(NOSQL));
        }
        if (map.containsKey(ARCHIVE_SETTINGS_EVENTGATEWAY_GLOBALS)) {
            try {
                this.archiveEventGatewaySettings = (Boolean)map.get(ARCHIVE_SETTINGS_EVENTGATEWAY_GLOBALS);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public ConfigList getBasicSettings() {
        return this.m_BasicSettings;
    }

    public ConfigList getDirectoryMappings() {
        return this.m_Mappings;
    }

    public ConfigList getTasks() {
        return this.m_Tasks;
    }

    public ConfigList getCfxs() {
        return this.m_Cfxs;
    }

    public ConfigList getIncludedFiles() {
        return this.m_IncludedFiles;
    }

    public ConfigList getExcludedFiles() {
        return this.m_ExcludedFiles;
    }

    public ConfigMap getArchiveVariables() {
        return this.m_Variables;
    }

    public ConfigList getVerityCollections() {
        return this.m_Collections;
    }

    public ConfigList getSolrCollections() {
        return this.m_SolrCollections;
    }

    public ConfigList getDatasources() {
        return this.m_Datasources;
    }

    public String getPreRestore() {
        return this.m_sPreRestore;
    }

    public String getPostRestore() {
        return this.m_sPostRestore;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public ConfigList getEventGateways() {
        return this.m_eventgateway;
    }

    public ConfigList getWebServices() {
        return this.m_webservices;
    }

    public ConfigList getRestServices() {
        return this.m_restservices;
    }

    public ConfigList getPDFServices() {
        return this.m_pdfservices;
    }

    public ConfigList getIdps() {
        return this.m_idps;
    }

    public ConfigList getSps() {
        return this.m_sps;
    }

    public ConfigList getCloudCredentials() {
        return this.m_cloudcredentials;
    }

    public ConfigList getCloudConfigurations() {
        return this.m_cloudconfigurations;
    }

    public ConfigList getNoSqlSettings() {
        return this.m_nosql;
    }

    public ConfigList getEventGatewayTypes() {
        return this.m_eventgatewayTypes;
    }

    public ConfigMap getEventGatewaySettings() {
        return this.eventGatewaySettings;
    }

    public void setDescription(String sDesc) {
        this.m_sDescription = sDesc;
        this.m_ArchiveMap.put(ARCHIVE_DESCRIPTION, (Object)this.m_sDescription);
    }

    public void setPreRestore(String preRestore) {
        this.m_sPreRestore = preRestore;
        this.m_ArchiveMap.put(PRE_RESTORE_LIST, (Object)this.m_sPreRestore);
    }

    public void setPostRestore(String postRestore) {
        this.m_sPostRestore = postRestore;
        this.m_ArchiveMap.put(POST_RESTORE_LIST, (Object)this.m_sPostRestore);
    }

    public void setName(String name) {
        this.m_sName = name;
        this.m_ArchiveMap.put("name", (Object)this.m_sName);
    }

    public String getName() {
        return this.m_sName;
    }

    public synchronized void createArchive(String archiveFile, boolean bLog) throws ServiceException {
        File workingDir;
        this.setLogging(bLog, "archive");
        File carFile = new File(archiveFile);
        if (!carFile.exists()) {
            try {
                if (!carFile.createNewFile()) {
                    this.logError("Unable to create archive file: " + archiveFile);
                    throw new InvalidArchiveFileException(archiveFile, "create");
                }
            }
            catch (IOException ex) {
                this.logError("Unable to create archive file: " + archiveFile);
                this.logError(ex);
                throw new InvalidArchiveFileException(archiveFile, "create");
            }
        }
        if (carFile.isDirectory()) {
            this.logError("Unable to write to archive file: " + archiveFile + " The file is a directory");
            throw new InvalidArchiveFileException(archiveFile, "write");
        }
        if (!carFile.canWrite()) {
            this.logError("Unable to write to archive file: " + archiveFile);
            throw new InvalidArchiveFileException(archiveFile, "write");
        }
        this.logInfo("Beginning archiving");
        this.m_ExpandedFileList.clear();
        this.m_ArchiveMap.put("seed", (Object)((ArchiveDeployServiceImpl)this.m_Service).getSeed());
        this.m_ArchiveMap.put("algorithm", (Object)"AES/CBC/PKCS5Padding");
        Object verStr = this.m_ArchiveMap.get(VERSION);
        if (verStr != null) {
            String verSt = verStr.toString();
            this.majorVersion = this.getMajorVersion(verSt);
            this.majorVersion = this.getMinorVersion(verSt);
        } else {
            this.majorVersion = 0;
            this.minorVersion = 0;
        }
        if (this.m_Service.getWorkingDirectory() != null && this.m_Service.getWorkingDirectory().trim().length() > 0) {
            RuntimeService rntmSvc = ServiceFactory.getRuntimeService();
            String sRootDir = rntmSvc.getRootDir();
            this.m_Variables.put(SERVER_ROOT_DIR, (Object)sRootDir);
            this.addBasicSettings();
            this.addDirectoryMappings();
            this.addScheduledTasks();
            this.addCFXs();
            this.addFontSettings();
            this.addSolrCollections();
            this.addDatasources();
            this.addEventGateways();
            this.addEventGatewayTypes();
            this.addWebServices();
            this.addRestServices();
            this.addPDFServices();
            this.addSamlIdpSettings();
            this.addSamlSpSettings();
            this.addCloudCredentialSettings();
            this.addCloudConfigurationSettings();
            this.addNoSqlSettings();
            if (this.archiveEventGatewaySettings) {
                this.addEventGatewaySettings();
            }
            if (!(workingDir = new File(this.m_Service.getWorkingDirectory())).exists() && !workingDir.mkdir()) {
                throw new ArchiveDeployServiceImpl.InvalidWorkingDirException(this.m_Service.getWorkingDirectory());
            }
        } else {
            throw new ArchiveDeployServiceImpl.InvalidWorkingDirException(this.m_Service.getWorkingDirectory());
        }
        String sWorkingDir = workingDir.getAbsolutePath();
        this.m_Variables.put("WorkingDir", (Object)sWorkingDir);
        this.addFiles();
        File settingsFile = new File(sWorkingDir + File.separatorChar + SETTINGS_FILE);
        ((ServiceBase)((Object)this.m_Service)).serialize(this.m_Settings, settingsFile);
        File propsFile = new File(sWorkingDir + File.separatorChar + ARCHIVE_FILE);
        ((ServiceBase)((Object)this.m_Service)).serialize(this.m_ArchiveMap, propsFile);
        this.m_ExpandedFileList.add(settingsFile);
        this.m_ExpandedFileList.add(propsFile);
        this.createCarFile(carFile);
        settingsFile.delete();
        propsFile.delete();
        this.logInfo("Archive complete");
        this.m_bLog = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deploy(boolean bLog) {
        ZipInputStream zin;
        CentralConfigClientUtil.carMigrationStarted = true;
        this.setLogging(bLog, "deploy");
        boolean error = false;
        try {
            zin = new ZipInputStream(new FileInputStream(this.m_CarFile));
        }
        catch (IOException ex) {
            this.logError("Unable to read carFile");
            this.logError(ex);
            error = true;
            throw new InvalidArchiveFileException(this.m_CarFile.getAbsolutePath(), "read");
        }
        RuntimeService rntmSvc = ServiceFactory.getRuntimeService();
        String sRootDir = rntmSvc.getRootDir();
        this.m_Variables.put(SERVER_ROOT_DIR, (Object)sRootDir);
        this.m_Variables.put(CF_ROOTDIR, (Object)sRootDir);
        HashMap<String, String> fileMappings = new HashMap<String, String>();
        File workingDir = new File(this.m_Service.getWorkingDirectory());
        if (!workingDir.exists() && !workingDir.mkdir()) {
            throw new ArchiveDeployServiceImpl.InvalidWorkingDirException(this.m_Service.getWorkingDirectory());
        }
        String sWorkingDir = workingDir.getAbsolutePath();
        this.m_Variables.put("WorkingDir", (Object)sWorkingDir);
        try {
            Map prop;
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                try {
                    String sFile = entry.getName();
                    if (!this.cfversion.startsWith("cfmx6") && !this.cfversion.startsWith("cfmx7") || !sFile.endsWith("jvm.config")) {
                        String sRealFileName = this.restoreFilePath(sFile);
                        fileMappings.put(entry.getName(), sRealFileName);
                        this.logInfo("Restoring entry '" + entry.getName() + "' to file '" + sRealFileName + "'");
                        this.writeZipEntryToFile(zin, new File(sRealFileName));
                    }
                }
                catch (InvalidVariableNameException ex) {
                    error = true;
                    this.logError("Unable to restore entry '" + entry.getName() + "' the variable does not exist");
                }
                entry = zin.getNextEntry();
            }
            File propFile = new File(this.m_Service.getWorkingDirectory() + File.separatorChar + ARCHIVE_FILE);
            Object props = ((ServiceBase)((Object)this.m_Service)).deserialize(propFile);
            if (props != null && props instanceof Map && (prop = (Map)props).containsKey(VERSION)) {
                this.cfversion = prop.get(VERSION).toString();
            }
            this.majorVersion = this.getMajorVersion(this.cfversion);
            this.minorVersion = this.getMinorVersion(this.cfversion);
            File settingsFile = new File(this.m_Service.getWorkingDirectory() + File.separatorChar + SETTINGS_FILE);
            Object result = ((ServiceBase)((Object)this.m_Service)).deserialize(settingsFile);
            if (result != null && result instanceof Map) {
                Map settings = (Map)result;
                if (settings.containsKey(SETTINGS)) {
                    try {
                        this.setBasicSettings((Map)settings.get(SETTINGS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating settings:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(FONT_SETTINGS)) {
                    try {
                        this.setFontSettings((Map)settings.get(FONT_SETTINGS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating settings:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(MAPPINGS)) {
                    try {
                        this.setDirectoryMappings((Map)settings.get(MAPPINGS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating directory mappings:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(SCHEDULED_TASKS)) {
                    try {
                        this.setScheduledTasks((ConfigMap)settings.get(SCHEDULED_TASKS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating scheduled tasks:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(CFX)) {
                    try {
                        this.setCFXs((Map)settings.get(CFX));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating CFX's:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(SOLR_COLLECTIONS)) {
                    try {
                        this.setSolrCollections((Map)settings.get(SOLR_COLLECTIONS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating solr collections:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(DATASOURCE)) {
                    try {
                        this.setDatasources((Map)settings.get(DATASOURCE), fileMappings);
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating datasources:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(WEBSERVICES)) {
                    try {
                        this.setWebServices((List)settings.get(WEBSERVICES));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating Web Services");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(RESTSERVICES)) {
                    try {
                        this.setRestServices((Map)settings.get(RESTSERVICES));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating Rest Services");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(PDFSERVICES)) {
                    try {
                        this.setPDFServices((Map)settings.get(PDFSERVICES));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating PDF Services");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(IDP)) {
                    try {
                        this.setSamlIdpSettings((Map)settings.get(IDP));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating SAML Identity Provider Settings");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(SP)) {
                    try {
                        this.setSamlSpSettings((Map)settings.get(SP));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating SAML Service Provider Settings");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(CLOUD_CREDENTIALS)) {
                    try {
                        this.setCloudCredentialSettings((Map)settings.get(CLOUD_CREDENTIALS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating cloud credential settings");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(CLOUD_CONFIGURATIONS)) {
                    try {
                        this.setCloudConfigurationSettings((Map)settings.get(CLOUD_CONFIGURATIONS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating cloud configuration settings");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(NOSQL)) {
                    try {
                        this.setNoSqlSettings((Map)settings.get(NOSQL));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating NoSQL Settings");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(SETTINGS_EVENTGATEWAY)) {
                    try {
                        this.setEventGateways((Map)settings.get(SETTINGS_EVENTGATEWAY), fileMappings);
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating gateway instances:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(SETTINGS_EVENTGATEWAY_TYPES)) {
                    try {
                        this.setEventGatewayTypes((Map)settings.get(SETTINGS_EVENTGATEWAY_TYPES));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating gateway Types:");
                        this.logError(ex);
                    }
                }
                if (settings.containsKey(SETTINGS_EVENTGATEWAY_GLOBALS)) {
                    try {
                        this.setEventGatewaySetting((Map)settings.get(SETTINGS_EVENTGATEWAY_GLOBALS));
                    }
                    catch (Exception ex) {
                        error = true;
                        this.logError("Error occurred while updating gateway Global Settings:");
                        this.logError(ex);
                    }
                }
            } else {
                this.logError("Unable to read settings from archive.  Settings will not be updated");
                error = false;
                return error;
            }
        }
        catch (IOException ex) {
            this.logError(ex);
            error = true;
            return error;
        }
        finally {
            this.logInfo("Deploy complete");
            this.m_bLog = true;
            CentralConfigClientUtil.carMigrationStarted = false;
            return error;
        }
    }

    private void setBasicSettings(Map settings) {
        Map map;
        block162: {
            RuntimeService runtimeService;
            block161: {
                boolean _isStandalone;
                try {
                    Class.forName("com.adobe.coldfusion.launcher.Launcher");
                    _isStandalone = true;
                }
                catch (ClassNotFoundException cnfe) {
                    _isStandalone = false;
                }
                if (settings.get(SETTINGS_DEBUG) != null) {
                    try {
                        this.logInfo("Restoring Debugging Settings");
                        Map debug = (Map)settings.get(SETTINGS_DEBUG);
                        DebuggingService debugService = ServiceFactory.getDebuggingService(true);
                        MetricsService metricsService = ServiceFactory.getMetricsService(true);
                        if (debugService != null) {
                            Iterator it = debug.keySet().iterator();
                            block54: while (it.hasNext()) {
                                String key;
                                switch (key = (String)it.next()) {
                                    case "iplist": {
                                        Map ipValue = (Map)debug.get(key);
                                        ipValue.remove("developer_enabled");
                                        debugService.setIplist(ipValue);
                                        continue block54;
                                    }
                                    case "linedebuuger": {
                                        ConfigMap lineDebuggingSettings = (ConfigMap)debug.get(key);
                                        debugService.setDebuggingSettings(lineDebuggingSettings);
                                        continue block54;
                                    }
                                    case "enabled": {
                                        debugService.setEnabled((Boolean)debug.get(key));
                                        continue block54;
                                    }
                                    case "robustexception": {
                                        debugService.setRobustEnabled((Boolean)debug.get(key));
                                        continue block54;
                                    }
                                    case "developerenabled": {
                                        debugService.setDeveloperEnabled((Boolean)debug.get(key));
                                        continue block54;
                                    }
                                }
                                if (!_isStandalone) continue;
                                metricsService.setCfstatEnabled((Boolean)debug.get(SETTINGS_DEBUG_CFSTATENABLED));
                                metricsService.setMetricsEnabled((Boolean)debug.get(SETTINGS_DEBUG_METRICSENALBED));
                                metricsService.setMetricsFrequency(((Double)debug.get(SETTINGS_DEBUG_METRICSFREQ)).intValue());
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logError("Error occurred while updating debugging settings");
                        this.logError(ex);
                    }
                }
                if (settings.get(SETTINGS_SERVERSETTINGS) != null) {
                    try {
                        this.logInfo("Restoring Server Settings");
                        Map serverSettings = (Map)settings.get(SETTINGS_SERVERSETTINGS);
                        RuntimeService runtimeService2 = ServiceFactory.getRuntimeService();
                        ClientScopeService clientSvc = ServiceFactory.getClientScopeService();
                        if (runtimeService2 == null || clientSvc == null) break block161;
                        Map errorSettings = runtimeService2.getErrors();
                        errorSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_ERRORS));
                        runtimeService2.setWhitespace(serverSettings.get(SETTINGS_SERVERSETTINGS_WHITESPACE).toString());
                        Map requestSettings = runtimeService2.getRequestSettings();
                        requestSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_REQUEST));
                        Boolean uuid = (Boolean)serverSettings.get(SETTINGS_SERVERSETTINGS_UUID);
                        Map clientSettings = clientSvc.getSettings();
                        clientSettings.put(SETTINGS_SERVERSETTINGS_UUID, uuid);
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_GLOBALSCRIPTPROTECT)) {
                            runtimeService2.setScriptProtect(serverSettings.get(SETTINGS_SERVERSETTINGS_GLOBALSCRIPTPROTECT).toString());
                        }
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_MISC)) {
                            Map miscSettings = runtimeService2.getMiscSettings();
                            Map archiveMiscSettings = (Map)serverSettings.get(SETTINGS_SERVERSETTINGS_MISC);
                            if (this.cfversion.startsWith("cfmx2021")) {
                                this.replaceKey(archiveMiscSettings, CORE_POOL_SIZE_AZURE_SERVICE_BUS, "corePoolSizeCloudServices");
                                this.replaceKey(archiveMiscSettings, MAX_POOL_SIZE_AZURE_SERVICE_BUS, "maxPoolSizeCloudServices");
                                this.replaceKey(archiveMiscSettings, KEEP_ALIVE_TIME_AZURE_SERVICE_BUS, "keepAliveTimeCloudServices");
                            }
                            miscSettings.putAll(archiveMiscSettings);
                            Boolean enableNullSupport = Boolean.valueOf(miscSettings.get(ENABLE_NULL_SUPPORT).toString());
                            runtimeService2.setEnableNullSupport(enableNullSupport);
                        }
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_REPORT)) {
                            Map reportSettings = runtimeService2.getReportSettings();
                            reportSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_REPORT));
                        }
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_THROTTLE)) {
                            Map throttleSettings = runtimeService2.getRequestThrottleSettings();
                            throttleSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_THROTTLE));
                        }
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_CHARSET)) {
                            Map charsetSettings = runtimeService2.getCharsetSettings();
                            charsetSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_CHARSET));
                        }
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_APIMANAGER)) {
                            Map apiManagerSettings = runtimeService2.getApiManagerSettings();
                            apiManagerSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_APIMANAGER));
                        }
                        if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_HTTPPOOL)) {
                            ConfigMap httpPoolSettings = ((RuntimeServiceImpl)runtimeService2).getHttpPoolingSettings();
                            httpPoolSettings.putAll((Map)serverSettings.get(SETTINGS_SERVERSETTINGS_HTTPPOOL));
                        }
                        try {
                            if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_JRUN_ACTIVE)) {
                                int maxHandlers = ((Number)serverSettings.get(SETTINGS_SERVERSETTINGS_JRUN_ACTIVE)).intValue();
                                runtimeService2.setActiveHandlers(maxHandlers);
                            }
                            if (serverSettings.containsKey(SETTINGS_SERVERSETTINGS_JRUN_QUEUE)) {
                                int maxRequests = ((Number)serverSettings.get(SETTINGS_SERVERSETTINGS_JRUN_QUEUE)).intValue();
                                runtimeService2.setMaxQueued(maxRequests);
                            }
                        }
                        catch (UnsupportedOperationException maxRequests) {}
                    }
                    catch (Exception ex) {
                        this.logError("Error occurred while updating server settings");
                        this.logError(ex);
                    }
                }
            }
            if (settings.get(SETTINGS_LOCKING) != null) {
                try {
                    this.logInfo("Restoring Locking Settings");
                    runtimeService = ServiceFactory.getRuntimeService();
                    if (runtimeService != null) {
                        Map lockSettings = runtimeService.getLocking();
                        lockSettings.putAll((Map)settings.get(SETTINGS_LOCKING));
                    } else {
                        this.logError("Unable to update locking settings.");
                    }
                }
                catch (Exception ex) {
                    this.logError("Error occurred while updating locking settings");
                    this.logError(ex);
                }
            }
            if (settings.get(SETTINGS_LOGGING) != null) {
                try {
                    this.logInfo("Restoring Logging Settings");
                    LoggingService logService = ServiceFactory.getLoggingService();
                    RuntimeService rntmSvc = ServiceFactory.getRuntimeService();
                    CronService cronSvc = ServiceFactory.getCronService(true);
                    if (logService != null && rntmSvc != null && cronSvc != null) {
                        Map logSettings = (Map)settings.get(SETTINGS_LOGGING);
                        Map basiclogsettings = (Map)logSettings.get("settings");
                        basiclogsettings.remove("logDirectory");
                        logService.setSettings(basiclogsettings);
                        Map requestSettings = rntmSvc.getRequestSettings();
                        requestSettings.put("LogSlowRequests", logSettings.get(SETTINGS_LOGGING_LOGSLOW));
                        requestSettings.put("SlowRequestTimeLimit", logSettings.get(SETTINGS_LOGGING_SLOWTIME));
                        Map corbaSettings = rntmSvc.getCorba();
                        corbaSettings.put(SETTINGS_LOGGING, logSettings.get(SETTINGS_LOGGING_LOGCORBA));
                        cronSvc.setLogFlag((Boolean)logSettings.get(SETTINGS_LOGGING_SCHEDULEDTASKS));
                    } else {
                        this.logError("Unable to update logging settings.");
                    }
                }
                catch (Exception ex) {
                    this.logError("Error occurred while updating logging settings");
                    this.logError(ex);
                }
            }
            if (settings.get(SETTINGS_MAIL) != null) {
                try {
                    this.logInfo("Restoring Mail Settings");
                    MailSpoolService mailService = ServiceFactory.getMailSpoolService(true);
                    if (mailService != null) {
                        mailService.setSettingsForArchive((Map)settings.get(SETTINGS_MAIL), this.archiveSeed, this.oldAlgoValue, this.majorVersion, this.minorVersion);
                    } else {
                        this.logError("Unable to update mail settings.");
                    }
                }
                catch (Exception ex) {
                    this.logError("Error occurred while updating mail settings");
                    this.logError(ex);
                }
            }
            if (settings.get(SETTINGS_VARIABLES) != null) {
                try {
                    this.logInfo("Restoring Variables");
                    runtimeService = ServiceFactory.getRuntimeService();
                    ClientScopeService clientSvc = ServiceFactory.getClientScopeService();
                    if (runtimeService != null && clientSvc != null) {
                        Map variables = runtimeService.getVariables();
                        variables.putAll((Map)((Map)settings.get(SETTINGS_VARIABLES)).get(SETTINGS_VARIABLES_MEMORY));
                        Map clientvariables = clientSvc.getSettings();
                        clientvariables.putAll((Map)((Map)settings.get(SETTINGS_VARIABLES)).get(SETTINGS_VARIABLES_CLIENT));
                        Map svcmap = (Map)((Map)settings.get(SETTINGS_VARIABLES)).get(SETTINGS_VARIABLES_SCS);
                        if (svcmap != null) {
                            runtimeService.setHttpOnlySessionCookie((Boolean)svcmap.get(SETTINGS_HTTPONLYSESSIONCOOKIE));
                            runtimeService.setSecureSessionCookie((Boolean)svcmap.get(SETTINGS_SECURESESSIONCOOKIE));
                            int sct = (int)((Double)svcmap.get(SETTINGS_SESSIONCOOKIETIMEOUT)).doubleValue();
                            runtimeService.setSessionCookieTimeout(sct);
                            if (svcmap.containsKey("sessionStorageHost")) {
                                ((RuntimeServiceImpl)runtimeService).setSessionStorageHost((String)svcmap.get("sessionStorageHost"));
                            }
                            if (svcmap.containsKey("sessionStoragePort")) {
                                ((RuntimeServiceImpl)runtimeService).setSessionStoragePort(Cast._int(svcmap.get("sessionStoragePort")));
                            }
                            if (svcmap.containsKey("sessionStoragePassword")) {
                                ((RuntimeServiceImpl)runtimeService).setSessionStoragePassword(PasswordUtils.decryptPassword((String)svcmap.get("sessionStoragePassword"), this.archiveSeed));
                            }
                            if (svcmap.containsKey(SETTINGS_SESSIONSTORAGEREUSECACHINGSERVER)) {
                                ((RuntimeServiceImpl)runtimeService).setReuseRedisCachingForSessionStorage(Cast._boolean(svcmap.get(SETTINGS_SESSIONSTORAGEREUSECACHINGSERVER)));
                            }
                        }
                        Map clientStores = clientSvc.getClientstores();
                        Map clientstoresFromCAR = (Map)((Map)settings.get(SETTINGS_VARIABLES)).get(SETTINGS_VARIABLES_CLIENT_STORES);
                        if (clientstoresFromCAR != null) {
                            clientStores.putAll(clientstoresFromCAR);
                        }
                    } else {
                        this.logError("Unable to update variable settings");
                    }
                }
                catch (Exception ex) {
                    this.logError("Error occurred while updating variable settings");
                    this.logError(ex);
                }
            }
            if (settings.get(SETTINGS_CACHING) != null) {
                try {
                    this.logInfo("Restoring Caching Settings");
                    Map caching = (Map)settings.get(SETTINGS_CACHING);
                    DataSourceService dsSvc = ServiceFactory.getDataSourceService(true);
                    RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
                    if (runtimeSvc == null || dsSvc == null) break block162;
                    dsSvc.setMaxQueryCount((Number)caching.get(SETTINGS_CACHING_MAXQUERYCOUNT));
                    runtimeSvc.setTemplateCacheSize(((Number)caching.get(SETTINGS_CACHING_TEMPLATECACHESIZE)).intValue());
                    runtimeSvc.setTrustedCache((Boolean)caching.get(SETTINGS_CACHING_TRUSTEDCACHE));
                    if (caching.containsKey(SETTINGS_CACHING_CACHEREALPATH)) {
                        int n = ServiceFactory.getLicenseService().getServerType();
                        ServiceFactory.getLicenseService();
                        if (n == 1) {
                            runtimeSvc.setCachePaths((Boolean)caching.get(SETTINGS_CACHING_CACHEREALPATH));
                        }
                    }
                    if (caching.containsKey(SETTINGS_CACHING_SAVECLASSFILES)) {
                        runtimeSvc.setSaveClassFiles((Boolean)caching.get(SETTINGS_CACHING_SAVECLASSFILES));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_INREQTEMPCACHEENABLD)) {
                        runtimeSvc.setInRequestTemplateCacheEnabled((Boolean)caching.get(SETTINGS_CACHING_INREQTEMPCACHEENABLD));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_COMPONENTCACHEENBLD)) {
                        runtimeSvc.setComponentCache((Boolean)caching.get(SETTINGS_CACHING_COMPONENTCACHEENBLD));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_USE_INTERNAL_QUERYCACHE)) {
                        runtimeSvc.setInternalCacheForQueryEnabled((Boolean)caching.get(SETTINGS_CACHING_USE_INTERNAL_QUERYCACHE));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_ENGINE)) {
                        ((RuntimeServiceImpl)runtimeSvc).setServerCacheType(Cast._int(caching.get(SETTINGS_CACHING_ENGINE)));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_JCS_DSN)) {
                        try {
                            ((RuntimeServiceImpl)runtimeSvc).setJCSClusterDsnName((String)caching.get(SETTINGS_CACHING_JCS_DSN), false);
                        }
                        catch (Exception ex) {
                            this.logError("Error occurred while updating JCS DSN name caching settings");
                            this.logError(ex);
                        }
                    }
                    if (caching.containsKey(SETTINGS_CACHING_MEMCACHED_SERVER)) {
                        ((RuntimeServiceImpl)runtimeSvc).setMemcachedServer((String)caching.get(SETTINGS_CACHING_MEMCACHED_SERVER));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_MEMCACHED_MAXIDLE)) {
                        ((RuntimeServiceImpl)runtimeSvc).setMemcachedServerMaxIdle(((Double)caching.get(SETTINGS_CACHING_MEMCACHED_MAXIDLE)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_MEMCACHED_MAXTIME)) {
                        ((RuntimeServiceImpl)runtimeSvc).setMemcachedServerMaxLife(((Double)caching.get(SETTINGS_CACHING_MEMCACHED_MAXTIME)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_MEMCACHED_MAXOBJECTS)) {
                        ((RuntimeServiceImpl)runtimeSvc).setMemcachedServerMaxObjects(((Double)caching.get(SETTINGS_CACHING_MEMCACHED_MAXOBJECTS)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_MEMCACHED_ETERNAL)) {
                        ((RuntimeServiceImpl)runtimeSvc).setMemcachedServerEternal((String)caching.get(SETTINGS_CACHING_MEMCACHED_ETERNAL));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_REDIS_MAXIDLE)) {
                        ((RuntimeServiceImpl)runtimeSvc).setredisServerMaxIdle(((Double)caching.get(SETTINGS_CACHING_REDIS_MAXIDLE)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_REDIS_MAXTIME)) {
                        ((RuntimeServiceImpl)runtimeSvc).setredisServerMaxLife(((Double)caching.get(SETTINGS_CACHING_REDIS_MAXTIME)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_REDIS_MAXOBJECTS)) {
                        ((RuntimeServiceImpl)runtimeSvc).setredisServerMaxObjects(((Double)caching.get(SETTINGS_CACHING_REDIS_MAXOBJECTS)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_REDIS_ETERNAL)) {
                        ((RuntimeServiceImpl)runtimeSvc).setRedisServerEternal((String)caching.get(SETTINGS_CACHING_REDIS_ETERNAL));
                    }
                    if (caching.containsKey(SETTINGS_CACHING_JCS_MAXIDLE)) {
                        ((RuntimeServiceImpl)runtimeSvc).setJCSServerMaxIdle(((Double)caching.get(SETTINGS_CACHING_JCS_MAXIDLE)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_JCS_MAXTIME)) {
                        ((RuntimeServiceImpl)runtimeSvc).setJCSServerMaxLife(((Double)caching.get(SETTINGS_CACHING_JCS_MAXTIME)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_JCS_MAXOBJECTS)) {
                        ((RuntimeServiceImpl)runtimeSvc).setJCSServerMaxObjects(((Double)caching.get(SETTINGS_CACHING_JCS_MAXOBJECTS)).longValue());
                    }
                    if (caching.containsKey(SETTINGS_CACHING_JCS_ETERNAL)) {
                        ((RuntimeServiceImpl)runtimeSvc).setJCSServerEternal((String)caching.get(SETTINGS_CACHING_JCS_ETERNAL));
                    }
                    if (caching.containsKey("sessionStorageHost")) {
                        ((RuntimeServiceImpl)runtimeSvc).setRedisCacheStorageHost((String)caching.get("sessionStorageHost"));
                    }
                    if (caching.containsKey("sessionStoragePort")) {
                        ((RuntimeServiceImpl)runtimeSvc).setRedisCacheStoragePort(((Double)caching.get("sessionStoragePort")).intValue());
                    }
                    if (caching.containsKey("sessionStoragePassword")) {
                        ((RuntimeServiceImpl)runtimeSvc).setRedisCacheStoragePassword(PasswordUtils.decryptPassword((String)caching.get("sessionStoragePassword"), this.archiveSeed));
                    }
                    if (caching.containsKey(SETTINGS_SESSIONSTORAGECLUSTER)) {
                        ((RuntimeServiceImpl)runtimeSvc).setSessionStorageCluster(Cast._boolean(caching.get(SETTINGS_SESSIONSTORAGECLUSTER)));
                    }
                }
                catch (Exception ex) {
                    this.logError("Error occurred while updating caching settings");
                    this.logError(ex);
                }
            }
        }
        if (settings.get(SETTINGS_CHARTING) != null) {
            try {
                this.logInfo("Restoring Charting Settings");
                GraphingService graphSvc = ServiceFactory.getNewGraphingService(true);
                if (graphSvc != null) {
                    Map graphSettings = graphSvc.getSettings();
                    graphSettings.putAll((Map)settings.get(SETTINGS_CHARTING));
                }
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating charting settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_CUSTOM_TAG_PATHS) != null) {
            try {
                this.logInfo("Restoring Custom Tag Paths");
                RuntimeService rntmSvc = ServiceFactory.getRuntimeService();
                if (rntmSvc != null) {
                    Map customtagPathSettings = rntmSvc.getCustomtags();
                    HashSet customtagPathValues = new HashSet(customtagPathSettings.values());
                    HashSet<String> canonicalCustomtagPaths = new HashSet<String>();
                    for (String customTagPath : customtagPathValues) {
                        File f;
                        if (customTagPath == null || customTagPath.length() <= 0 || (f = new File(customTagPath)) == null || !f.exists()) continue;
                        canonicalCustomtagPaths.add(f.getCanonicalPath());
                    }
                    Map customTagSettingsFromCar = (Map)settings.get(SETTINGS_CUSTOM_TAG_PATHS);
                    if (customTagSettingsFromCar != null) {
                        Set keys = customTagSettingsFromCar.keySet();
                        for (String key : keys) {
                            String canPath;
                            File f;
                            String customPath = (String)customTagSettingsFromCar.get(key);
                            if (customPath == null || customPath.length() <= 0 || (f = new File(customPath)) == null || !f.exists() || (canPath = f.getCanonicalPath()) == null || canonicalCustomtagPaths.contains(canPath)) continue;
                            customtagPathSettings.put(key, customPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating Custom Tag Path settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_SECURITY) != null) {
            try {
                this.logInfo("Restoring Security Settings");
                SecurityService secService = ServiceFactory.getSecurityService();
                if (secService != null) {
                    HashMap secsettingMap = new HashMap();
                    secsettingMap.putAll((Map)settings.get(SETTINGS_SECURITY));
                    secsettingMap.remove("sbs.security.enabled");
                    if (secsettingMap.containsKey("admin.security.enabled")) {
                        secService.setAdminSecurityEnabled((Boolean)secsettingMap.get("admin.security.enabled"));
                    }
                    if (secsettingMap.containsKey("rds.security.enabled")) {
                        if (secsettingMap.get("rds.security.enabled") instanceof Boolean) {
                            secService.setRdsSecurityEnabled((Boolean)secsettingMap.get("rds.security.enabled"));
                        } else {
                            Boolean b = "true".equalsIgnoreCase((String)secsettingMap.get("rds.security.enabled")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            secService.setRdsSecurityEnabled(b);
                        }
                    }
                    if (secsettingMap.containsKey("rds.security.usesinglerdspassword")) {
                        secService.setUseSingleRdsPassword((Boolean)secsettingMap.get("rds.security.usesinglerdspassword"));
                    }
                    if (secsettingMap.containsKey("admin.userid.required")) {
                        secService.setAdminUserIdRequired((Boolean)secsettingMap.get("admin.userid.required"));
                    }
                    if (secsettingMap.containsKey("allowedIPList")) {
                        secService.setAllowedIPList((String)secsettingMap.get("allowedIPList"));
                    }
                    if (secsettingMap.containsKey("allowedAdminIPList")) {
                        secService.setAllowedAdminIPList((String)secsettingMap.get("allowedAdminIPList"));
                    }
                    if (secsettingMap.containsKey("CrossSiteScriptPatterns")) {
                        secService.setCrossSiteScriptPatterns((ConfigMap)secsettingMap.get("CrossSiteScriptPatterns"));
                    }
                    if (secsettingMap.containsKey("AuthorizedUsers")) {
                        secService.setAuthorizedUsers((FastHashtable)secsettingMap.get("AuthorizedUsers"));
                    }
                    if (secsettingMap.containsKey("contexts")) {
                        secService.loadSandboxes((ConfigMap)secsettingMap.get("contexts"));
                    }
                    if (secsettingMap.containsKey("allowconcurrentadminlogin")) {
                        secService.setAllowConcurrentAdminLogin((Boolean)secsettingMap.get("allowconcurrentadminlogin"));
                    }
                } else {
                    this.logError("Unable to update security settings.");
                }
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating security settings");
                this.logError(ex);
            }
        }
        if (!settings.containsKey(SETTINGS_SERVER_MONITOR) || FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.server_monitoring_and_api)) {
            // empty if block
        }
        if (settings.containsKey(SETTINGS_SYSTEM_PROBE)) {
            try {
                this.logInfo("Restoring System Probes settings");
                RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
                Scope server = runtimeSvc.getServerScope();
                Map probes = (Map)server.get("coldfusion.probes");
                if (probes == null) {
                    probes = new ConfigMap();
                    server.put("coldfusion.probes", probes);
                }
                Map probeconfig = (Map)probes.get("config");
                Map probesMap = (Map)probes.get("probes");
                Map archivedConfig = (Map)((Map)settings.get(SETTINGS_SYSTEM_PROBE)).get("config");
                Map archivedProbes = (Map)((Map)settings.get(SETTINGS_SYSTEM_PROBE)).get("probes");
                if (probeconfig != null) {
                    probeconfig.putAll(archivedConfig);
                } else {
                    probes.put("config", archivedConfig);
                }
                if (probeconfig != null) {
                    probesMap.putAll(archivedProbes);
                } else {
                    probes.put("probes", archivedProbes);
                }
                String probefilepath = runtimeSvc.getLibDir() + File.separator + "neo-probe.xml";
                ((ArchiveDeployServiceImpl)this.m_Service).serialize(probes, new File(probefilepath));
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating System Probe Settings:");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_WATCH) != null) {
            try {
                this.logInfo("Restoring Watch Settings");
                WatchService watchService = ServiceFactory.getWatchService();
                if (watchService != null) {
                    watchService.setSettings((Map)settings.get(SETTINGS_WATCH));
                } else {
                    this.logError("Unable to update Watcher settings.");
                }
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating Watcher settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_UPDATES) != null) {
            try {
                this.logInfo("Restoring Update Settings");
                Map settingsMap = (Map)settings.get(SETTINGS_UPDATES);
                UpdateService.getInstance().saveSettings(settingsMap, true);
            }
            catch (Exception ex) {
                this.logError("Error occurred while saving update settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_WEBSOCKET) != null) {
            try {
                this.logInfo("Restoring Websocket Settings");
                WebSocketService wss = ServiceFactory.getWebsocketService(true);
                map = (Map)settings.get(SETTINGS_WEBSOCKET);
                if (map.containsKey("port")) {
                    wss.setPort(((Double)map.get("port")).intValue());
                }
                if (map.containsKey(WEBSOCKET_SOCKETTIMEOUT)) {
                    wss.setSocketTimeOut(((Double)map.get(WEBSOCKET_SOCKETTIMEOUT)).intValue());
                }
                if (map.containsKey(WEBSOCKET_MAXFRAMESIZE)) {
                    wss.setMaxFrameSize(((Double)map.get(WEBSOCKET_MAXFRAMESIZE)).intValue());
                }
                if (map.containsKey(WEBSOCKET_SERVICE_ENABLED)) {
                    wss.setWebSocketServiceEnabled((Boolean)map.get(WEBSOCKET_SERVICE_ENABLED));
                }
                if (map.containsKey(WEBSOCKET_SSL_ENABLED)) {
                    wss.setSSLEnabled((Boolean)map.get(WEBSOCKET_SSL_ENABLED));
                }
                if (map.containsKey(WEBSOCKET_NORMAL_PORT_ENABLED)) {
                    wss.setNormalPortListenerEnabled((Boolean)map.get(WEBSOCKET_NORMAL_PORT_ENABLED));
                }
                if (map.containsKey(WEBSOCKET_CLUSTER_ENABLED)) {
                    wss.setClusterEnabled((Boolean)map.get(WEBSOCKET_CLUSTER_ENABLED));
                }
                if (map.containsKey(WEBSOCKET_SSL_PORT)) {
                    wss.setSSLPort(((Double)map.get(WEBSOCKET_SSL_PORT)).intValue());
                }
                if (map.containsKey(WEBSOCKET_MULTICAST_PORT)) {
                    wss.setMulticastPort(((Double)map.get(WEBSOCKET_MULTICAST_PORT)).intValue());
                }
                if (map.containsKey(WEBSOCKET_FLASHFALLBACK)) {
                    wss.setFlashFallBackEnabled((Boolean)map.get(WEBSOCKET_FLASHFALLBACK));
                }
                if (map.containsKey(WEBSOCKET_PROXY_PORT_ENABLED)) {
                    wss.setProxyEnabled((Boolean)map.get(WEBSOCKET_PROXY_PORT_ENABLED));
                }
            }
            catch (Exception ex) {
                this.logError("Error occurred while saving websocket settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_PDFSERVICE) != null) {
            try {
                this.logInfo("Restoring PDF Service Settings");
                RuntimeService rs = ServiceFactory.getRuntimeService();
                map = (Map)settings.get(SETTINGS_PDFSERVICE);
            }
            catch (Exception ex) {
                this.logError("Error occurred while saving PDF Service settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_WEBSERVICE) != null) {
            try {
                this.logInfo("Restoring Web Services Settings");
                XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
                map = (Map)settings.get(SETTINGS_WEBSERVICE);
                if (map.containsKey(WEBSERVICE_VERSION)) {
                    xmlRpcService.setWSEngineVersion(map.get(WEBSERVICE_VERSION).toString());
                }
            }
            catch (Exception ex) {
                this.logError("Error occurred while saving Web Services settings");
                this.logError(ex);
            }
        }
        if (settings.get(SETTINGS_SOLR) != null) {
            try {
                this.setSolrSettings((Map)settings.get(SETTINGS_SOLR));
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating settings:");
                this.logError(ex);
            }
        }
    }

    private void addFiles() {
        int i;
        Vector includedFiles = new Vector();
        Vector<File> excludedFiles = new Vector<File>();
        for (i = 0; i < this.m_ExcludedFiles.size(); ++i) {
            File temp = new File((String)this.m_ExcludedFiles.get(i));
            excludedFiles.add(temp);
        }
        for (i = 0; i < this.m_IncludedFiles.size(); ++i) {
            File tempFile;
            String sFile = (String)this.m_IncludedFiles.get(i);
            if (sFile.toLowerCase().indexOf("{cf.rootdir}") != -1) {
                String newFile = CFPage.ReplaceNoCase(sFile, "{cf.rootdir}", ServiceFactory.getRuntimeService().getRootDir());
                tempFile = new File(newFile);
                this.m_Variables.put(sFile, (Object)newFile);
            } else {
                tempFile = new File(sFile);
                if (sFile.indexOf(42) != -1) {
                    File parent = tempFile.getParentFile();
                    sFile = parent.getAbsolutePath();
                }
                this.m_Variables.put(sFile, (Object)sFile);
            }
            this.addFile(tempFile, excludedFiles, includedFiles);
        }
        this.m_ExpandedFileList.addAll(includedFiles);
    }

    private void addFile(File file, Vector excludes, Vector includedFiles) {
        boolean bExcluded = false;
        if (excludes != null) {
            for (int e = 0; e < excludes.size(); ++e) {
                File excludeFile = (File)excludes.elementAt(e);
                if (excludeFile.compareTo(file) != 0) continue;
                bExcluded = true;
                break;
            }
        }
        if (!bExcluded) {
            ExtensionFilter filter = null;
            String path = file.getAbsolutePath();
            if (path.indexOf(42) != -1) {
                String fileName = file.getName();
                file = file.getParentFile();
                filter = new ExtensionFilter(fileName);
            }
            includedFiles.add(file);
            if (file.isDirectory()) {
                this.expandDirectory(file, excludes, includedFiles, filter);
            }
        }
    }

    private void expandDirectory(File dir, Vector excludes, Vector includeFiles, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i], excludes, includeFiles);
        }
    }

    private void addBasicSettings() {
        this.logInfo("Archiving basic settings");
        ConfigMap map = new ConfigMap();
        for (int i = 0; i < this.m_BasicSettings.size(); ++i) {
            ConfigMap result;
            RuntimeService rntmSvc;
            RuntimeService rntmSvc2;
            RuntimeService runtimeService;
            String item = (String)this.m_BasicSettings.get(i);
            if (item.equalsIgnoreCase(SETTINGS_DEBUG)) {
                this.logInfo("Archiving debugging settings");
                DebuggingService debugService = ServiceFactory.getDebuggingService();
                MetricsService metricsService = ServiceFactory.getMetricsService();
                if (debugService != null && metricsService != null) {
                    Map debugSettings = debugService.getSettings();
                    Map debugIPList = debugService.getIplist();
                    Map lineDebugger = debugService.getLineDebugSettings();
                    boolean debugEnabled = debugService.isEnabled();
                    ConfigMap debug = new ConfigMap();
                    if (!(metricsService instanceof CFMetricsService)) {
                        boolean cfStatEnabled = metricsService.getCfstatEnabled();
                        Hashtable cfperfmon = metricsService.getPerfmonMetrics();
                        int metricsFreq = metricsService.getMetricsFrequency();
                        boolean metricsEnabled = metricsService.getMetricsEnabled();
                        debug.put(SETTINGS_DEBUG_CFSTATENABLED, (Object)cfStatEnabled);
                        debug.put(SETTINGS_DEBUG_METRICSENALBED, (Object)metricsEnabled);
                        debug.put(SETTINGS_DEBUG_METRICSFREQ, (Object)metricsFreq);
                    }
                    boolean developerEnabled = debugService.isDeveloperEnabled();
                    debug.put(SETTINGS, (Object)debugSettings);
                    if (lineDebugger != null) {
                        debug.put(SETTINGS_LINE_DEBUG, (Object)lineDebugger);
                    }
                    debug.put(SETTINGS_DEBUG_IPLIST, (Object)debugIPList);
                    debug.put(SETTINGS_DEBUG_ENABLED, (Object)debugEnabled);
                    debug.put(SETTINGS_DEBUG_ROBUSTEXCEPTION, (Object)debugService.isRobustEnabled());
                    debug.put(SETTINGS_DEVELOPER_ENABLED, (Object)developerEnabled);
                    map.put(SETTINGS_DEBUG, (Object)debug);
                    continue;
                }
                this.logError("Unable to obtain debugging settings, debugging settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_SERVERSETTINGS)) {
                this.logInfo("Archiving server settings");
                runtimeService = ServiceFactory.getRuntimeService();
                ClientScopeService clientScopeService = ServiceFactory.getClientScopeService();
                if (runtimeService != null) {
                    Map errorSettings = runtimeService.getErrors();
                    Boolean whitespace = runtimeService.getWhitespace();
                    Map requestSettings = runtimeService.getRequestSettings();
                    Boolean uuid = (Boolean)clientScopeService.getSettings().get(SETTINGS_SERVERSETTINGS_UUID);
                    String scriptProtect = runtimeService.getScriptProtect();
                    Map miscSettings = runtimeService.getMiscSettings();
                    Map throttleSettings = runtimeService.getRequestThrottleSettings();
                    Map reportSettings = runtimeService.getReportSettings();
                    Map charsetSettings = runtimeService.getCharsetSettings();
                    Map apiManagerSettings = runtimeService.getApiManagerSettings();
                    ConfigMap httpPoolSettings = ((RuntimeServiceImpl)runtimeService).getHttpPoolingSettings();
                    ConfigMap serverSettings = new ConfigMap();
                    serverSettings.put(SETTINGS_SERVERSETTINGS_ERRORS, (Object)errorSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_WHITESPACE, (Object)whitespace);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_REQUEST, (Object)requestSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_UUID, (Object)uuid);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_GLOBALSCRIPTPROTECT, (Object)scriptProtect);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_MISC, (Object)miscSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_REPORT, (Object)reportSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_THROTTLE, (Object)throttleSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_CHARSET, (Object)charsetSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_APIMANAGER, (Object)apiManagerSettings);
                    serverSettings.put(SETTINGS_SERVERSETTINGS_HTTPPOOL, (Object)httpPoolSettings);
                    try {
                        int active = runtimeService.getActiveHandlers();
                        int queue = runtimeService.getMaxQueued();
                        serverSettings.put(SETTINGS_SERVERSETTINGS_JRUN_ACTIVE, (Object)new Integer(active));
                        serverSettings.put(SETTINGS_SERVERSETTINGS_JRUN_QUEUE, (Object)new Integer(queue));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    map.put(SETTINGS_SERVERSETTINGS, (Object)serverSettings);
                    continue;
                }
                this.logError("Unable to obtain server settings, server settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_LOCKING)) {
                this.logInfo("Archiving locking settings");
                runtimeService = ServiceFactory.getRuntimeService();
                if (runtimeService != null) {
                    Map lockSettings = runtimeService.getLocking();
                    ConfigMap locking = new ConfigMap();
                    locking.putAll(lockSettings);
                    map.put(SETTINGS_LOCKING, (Object)locking);
                    continue;
                }
                this.logError("Unable to obtain locking settings, locking settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_LOGGING)) {
                this.logInfo("Archiving logging settings");
                LoggingService logService = ServiceFactory.getLoggingService();
                rntmSvc2 = ServiceFactory.getRuntimeService();
                CronService cronSvc = ServiceFactory.getCronService();
                if (logService != null && rntmSvc2 != null && cronSvc != null) {
                    Map logSettings = logService.getSettings();
                    ConfigMap logging = new ConfigMap();
                    logging.put("settings", (Object)logSettings);
                    logging.put(SETTINGS_LOGGING_LOGSLOW, rntmSvc2.getRequestSettings().get("LogSlowRequests"));
                    logging.put(SETTINGS_LOGGING_SLOWTIME, rntmSvc2.getRequestSettings().get("SlowRequestTimeLimit"));
                    logging.put(SETTINGS_LOGGING_LOGCORBA, rntmSvc2.getCorba().get(SETTINGS_LOGGING));
                    logging.put(SETTINGS_LOGGING_SCHEDULEDTASKS, (Object)cronSvc.getLogFlag());
                    map.put(SETTINGS_LOGGING, (Object)logging);
                    continue;
                }
                this.logError("Unable to obtain logging settings, logging settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_MAIL)) {
                this.logInfo("Archiving mail settings");
                MailSpoolService mailService = ServiceFactory.getMailSpoolService();
                if (mailService != null) {
                    Map mailSettings = mailService.getSettings();
                    map.put(SETTINGS_MAIL, (Object)mailSettings);
                    continue;
                }
                this.logError("Unable to obtain mail settings, mail settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_VARIABLES)) {
                this.logInfo("Archiving variable settings");
                runtimeService = ServiceFactory.getRuntimeService();
                ClientScopeService clientSvc = ServiceFactory.getClientScopeService();
                if (runtimeService != null && clientSvc != null) {
                    ConfigMap memMap = new ConfigMap();
                    Map memvariables = runtimeService.getVariables();
                    memMap.put(SETTINGS_VARIABLES_MEMORY, (Object)memvariables);
                    ConfigMap sessionCS = new ConfigMap();
                    sessionCS.put(SETTINGS_HTTPONLYSESSIONCOOKIE, runtimeService.isHttpOnlySessionCookie());
                    sessionCS.put(SETTINGS_SECURESESSIONCOOKIE, runtimeService.isSecureSessionCookie());
                    sessionCS.put(SETTINGS_SESSIONCOOKIETIMEOUT, Double.valueOf(runtimeService.getSessionCookieTimeout()));
                    sessionCS.put("sessionStorageHost", ((RuntimeServiceImpl)runtimeService).getSessionStorageHost());
                    sessionCS.put("sessionStoragePort", ((RuntimeServiceImpl)runtimeService).getSessionStoragePort());
                    sessionCS.put("sessionStoragePassword", ((RuntimeServiceImpl)runtimeService).getSessionStoragePassword());
                    sessionCS.put(SETTINGS_SESSIONSTORAGEREUSECACHINGSERVER, ((RuntimeServiceImpl)runtimeService).getReuseRedisCachingForSessionStorage());
                    memMap.put(SETTINGS_VARIABLES_SCS, (Object)sessionCS);
                    Map clientVariables = clientSvc.getSettings();
                    memMap.put(SETTINGS_VARIABLES_CLIENT, (Object)clientVariables);
                    Map clientStores = clientSvc.getClientstores();
                    memMap.put(SETTINGS_VARIABLES_CLIENT_STORES, (Object)clientStores);
                    map.put(SETTINGS_VARIABLES, (Object)memMap);
                    continue;
                }
                this.logError("Unable to obtain variable settings, variable settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_CACHING)) {
                this.logInfo("Archiving caching settings");
                runtimeService = ServiceFactory.getRuntimeService();
                DataSourceService dsSvc = ServiceFactory.getDataSourceService();
                if (runtimeService != null && dsSvc != null) {
                    ConfigMap cacheSettings = new ConfigMap();
                    cacheSettings.put(SETTINGS_CACHING_MAXQUERYCOUNT, (Object)dsSvc.getMaxQueryCount());
                    cacheSettings.put(SETTINGS_CACHING_TEMPLATECACHESIZE, (Object)new Integer(runtimeService.getTemplateCacheSize()));
                    cacheSettings.put(SETTINGS_CACHING_TRUSTEDCACHE, (Object)runtimeService.isTrustedCache());
                    cacheSettings.put(SETTINGS_CACHING_SAVECLASSFILES, (Object)runtimeService.getSaveClassFiles());
                    cacheSettings.put(SETTINGS_CACHING_USE_INTERNAL_QUERYCACHE, (Object)runtimeService.isInternalCacheForQueryEnabled());
                    cacheSettings.put(SETTINGS_CACHING_INREQTEMPCACHEENABLD, (Object)runtimeService.isInRequestTemplateCacheEnabled());
                    cacheSettings.put(SETTINGS_CACHING_COMPONENTCACHEENBLD, (Object)runtimeService.isComponentCache());
                    int n = ServiceFactory.getLicenseService().getServerType();
                    ServiceFactory.getLicenseService();
                    if (n == 1) {
                        cacheSettings.put(SETTINGS_CACHING_CACHEREALPATH, (Object)runtimeService.isCachePaths());
                    }
                    cacheSettings.put(SETTINGS_CACHING_ENGINE, (Object)((RuntimeServiceImpl)runtimeService).getServerCacheType());
                    cacheSettings.put(SETTINGS_CACHING_MEMCACHED_SERVER, (Object)((RuntimeServiceImpl)runtimeService).getMemcachedServer());
                    try {
                        cacheSettings.put(SETTINGS_CACHING_MEMCACHED_MAXIDLE, (Object)((RuntimeServiceImpl)runtimeService).getMemcachedServerMaxIdle());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_MEMCACHED_MAXTIME, (Object)((RuntimeServiceImpl)runtimeService).getMemcachedServerMaxLife());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_MEMCACHED_ETERNAL, (Object)((RuntimeServiceImpl)runtimeService).getMemcachedServerEternal());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_MEMCACHED_MAXOBJECTS, (Object)((RuntimeServiceImpl)runtimeService).getMemcachedServerMaxObjects());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_REDIS_MAXIDLE, (Object)((RuntimeServiceImpl)runtimeService).getredisServerMaxIdle());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_REDIS_MAXTIME, (Object)((RuntimeServiceImpl)runtimeService).getredisServerMaxLife());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_REDIS_ETERNAL, (Object)((RuntimeServiceImpl)runtimeService).getRedisServerEternal());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_REDIS_MAXOBJECTS, (Object)((RuntimeServiceImpl)runtimeService).getredisServerMaxObjects());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_JCS_MAXIDLE, (Object)((RuntimeServiceImpl)runtimeService).getJCSServerMaxIdle());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_JCS_MAXTIME, (Object)((RuntimeServiceImpl)runtimeService).getJCSServerMaxLife());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_JCS_ETERNAL, (Object)((RuntimeServiceImpl)runtimeService).getJCSServerEternal());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    try {
                        cacheSettings.put(SETTINGS_CACHING_JCS_MAXOBJECTS, (Object)((RuntimeServiceImpl)runtimeService).getJCSServerMaxObjects());
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                    }
                    cacheSettings.put(SETTINGS_CACHING_JCS_DSN, (Object)((RuntimeServiceImpl)runtimeService).getJCSClusterDsnName());
                    cacheSettings.put("sessionStorageHost", (Object)((RuntimeServiceImpl)runtimeService).getRedisCacheStorageHost());
                    cacheSettings.put("sessionStoragePort", (Object)((RuntimeServiceImpl)runtimeService).getRedisCacheStoragePort());
                    cacheSettings.put("sessionStoragePassword", (Object)((RuntimeServiceImpl)runtimeService).getRedisCacheStoragePassword());
                    cacheSettings.put(SETTINGS_SESSIONSTORAGECLUSTER, (Object)((RuntimeServiceImpl)runtimeService).getSessionStorageIsCluster());
                    map.put(SETTINGS_CACHING, (Object)cacheSettings);
                    continue;
                }
                this.logError("Unable to obtain caching settings, caching settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_CHARTING)) {
                this.logInfo("Archiving charting settings");
                GraphingService graphSvc = ServiceFactory.getNewGraphingService();
                if (graphSvc != null) {
                    Map graphSettings = graphSvc.getSettings();
                    map.put(SETTINGS_CHARTING, (Object)graphSettings);
                    continue;
                }
                this.logError("Unable to obtain charting settings, charting settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_JAVA)) {
                this.logInfo("Archiving java settings");
                rntmSvc = ServiceFactory.getRuntimeService();
                if (rntmSvc != null) {
                    String sRootDir = rntmSvc.getRootDir();
                    File jvmFile = new File(sRootDir + "/bin/jvm.config");
                    this.m_ExpandedFileList.add(jvmFile);
                    continue;
                }
                this.logError("Unable to obtain java settings, java settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_CUSTOM_TAG_PATHS)) {
                this.logInfo("Archiving custom tag paths");
                rntmSvc = ServiceFactory.getRuntimeService();
                if (rntmSvc != null) {
                    Map customTagSettings = rntmSvc.getCustomtags();
                    map.put(SETTINGS_CUSTOM_TAG_PATHS, (Object)customTagSettings);
                    continue;
                }
                this.logError("Unable to obtain custom tag paths, custom tag paths not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_SECURITY)) {
                this.logInfo("Archiving security settings");
                SecurityService secSvc = ServiceFactory.getSecurityService();
                rntmSvc2 = ServiceFactory.getRuntimeService();
                if (rntmSvc2 != null) {
                    String sRootDir = rntmSvc2.getRootDir();
                    File customRoles = new File(sRootDir + "/lib/customroles.properties");
                    File customRoleNames = new File(sRootDir + "/lib/customrolenames.properties");
                    if (customRoles.exists() && customRoles.isFile()) {
                        this.m_ExpandedFileList.add(customRoles);
                    }
                    if (customRoleNames.exists() && customRoleNames.isFile()) {
                        this.m_ExpandedFileList.add(customRoleNames);
                    }
                }
                if (secSvc != null) {
                    Map secSettings = secSvc.getSettings();
                    map.put(SETTINGS_SECURITY, (Object)secSettings);
                    continue;
                }
                this.logError("Unable to obtain security settings, security settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_WATCH)) {
                this.logInfo("Archiving Watcher settings");
                WatchService watchSvc = ServiceFactory.getWatchService();
                if (watchSvc != null) {
                    Map watchSettings = watchSvc.getSettings();
                    map.put(SETTINGS_WATCH, (Object)watchSettings);
                    continue;
                }
                this.logError("Unable to obtain Watcher settings, Watcher settings not archived");
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_SERVER_MONITOR) && FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.server_monitoring_and_api)) {
                this.logInfo("Archiving Server Monitor settings");
                MonitoringService monitorSvc = ServiceFactory.getMonitoringService();
                try {
                    if (monitorSvc != null) continue;
                    this.logError("Unable to obtain Server Monitor settings, Server Monitor settings not archived");
                }
                catch (Exception ex) {
                    this.logError("Unable to archive Server Monitor Settings ");
                    this.logError(ex);
                }
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_SYSTEM_PROBE)) {
                try {
                    this.logInfo("Archiving System Probes settings");
                    RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
                    String probefilepath = runtimeSvc.getLibDir() + File.separator + "neo-probe.xml";
                    if (this.m_Service != null) {
                        Map systemprobes = (Map)((ArchiveDeployServiceImpl)this.m_Service).deserialize(new File(probefilepath));
                        map.put(SETTINGS_SYSTEM_PROBE, (Object)systemprobes);
                        continue;
                    }
                    this.logError("Unable to obtain System Probes settings, Server Monitor settings not archived");
                }
                catch (Exception ex) {
                    this.logError("Unable to archive System Probes Settings ");
                    this.logError(ex);
                }
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_UPDATES)) {
                try {
                    this.logInfo("Archiving update settings");
                    Map updateSettings = UpdateService.getInstance().getSettings();
                    if (updateSettings.containsKey(UPDATES_DEFAULT_PACKAGES_URL)) {
                        updateSettings.remove(UPDATES_DEFAULT_PACKAGES_URL);
                    }
                    if (updateSettings.containsKey(UPDATES_PACKAGES_URL)) {
                        updateSettings.remove(UPDATES_PACKAGES_URL);
                    }
                    if (updateSettings.containsKey(UPDATES_DEFAULT_URL)) {
                        updateSettings.remove(UPDATES_DEFAULT_URL);
                    }
                    if (updateSettings.containsKey(UPDATES_URL)) {
                        updateSettings.remove(UPDATES_URL);
                    }
                    if (updateSettings == null) continue;
                    map.put(SETTINGS_UPDATES, (Object)updateSettings);
                }
                catch (Exception ex) {
                    this.logError("Unable to archive update settings");
                    this.logError(ex);
                }
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_WEBSOCKET)) {
                try {
                    this.logInfo("Archiving Websocket Settings");
                    WebSocketService wss = ServiceFactory.getWebsocketService();
                    result = new ConfigMap();
                    result.put("port", (Object)wss.getPort());
                    result.put(WEBSOCKET_SOCKETTIMEOUT, (Object)wss.getSocketTimeOut());
                    result.put(WEBSOCKET_MAXFRAMESIZE, (Object)wss.getMaxFrameSize());
                    result.put(WEBSOCKET_SERVICE_ENABLED, (Object)wss.isWebSocketServiceEnabled());
                    result.put(WEBSOCKET_SSL_ENABLED, (Object)wss.isSSLEnabled());
                    result.put(WEBSOCKET_CLUSTER_ENABLED, (Object)wss.isClusterEnabled());
                    result.put(WEBSOCKET_NORMAL_PORT_ENABLED, (Object)wss.isNormalPortListenerEnabled());
                    result.put(WEBSOCKET_SSL_PORT, (Object)wss.getSSLPort());
                    result.put(WEBSOCKET_MULTICAST_PORT, (Object)wss.getMulticastPort());
                    result.put(WEBSOCKET_FLASHFALLBACK, (Object)wss.isFlashFallBackEnabled());
                    result.put(WEBSOCKET_PROXY_PORT_ENABLED, (Object)wss.isProxyEnabled());
                    map.put(SETTINGS_WEBSOCKET, (Object)result);
                }
                catch (Exception ex) {
                    this.logError("Unable to archive websocket settings");
                    this.logError(ex);
                }
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_PDFSERVICE)) {
                try {
                    this.logInfo("Archiving PDF Service Settings");
                    RuntimeService rs = ServiceFactory.getRuntimeService();
                    result = new ConfigMap();
                    map.put(SETTINGS_PDFSERVICE, (Object)result);
                }
                catch (Exception ex) {
                    this.logError("Unable to archive PDF Service settings");
                    this.logError(ex);
                }
                continue;
            }
            if (item.equalsIgnoreCase(SETTINGS_WEBSERVICE)) {
                try {
                    this.logInfo("Archiving Web Services Settings");
                    XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
                    result = new ConfigMap();
                    result.put(WEBSERVICE_VERSION, (Object)xmlRpcService.getWSEngineVersion());
                    map.put(SETTINGS_WEBSERVICE, (Object)result);
                }
                catch (Exception ex) {
                    this.logError("Unable to archive Web Services settings");
                    this.logError(ex);
                }
                continue;
            }
            if (!item.equalsIgnoreCase(SETTINGS_SOLR)) continue;
            try {
                this.logInfo("Archiving new Solr Settings");
                map.put(SETTINGS_SOLR, (Object)this.addSolrSettings());
                continue;
            }
            catch (Exception ex) {
                this.logError("Unable to archive Solr Server settings");
                this.logError(ex);
            }
        }
        this.m_Settings.put(SETTINGS, (Object)map);
    }

    private void createCarFile(File carFile) {
        FileOutputStream outstream;
        try {
            outstream = new FileOutputStream(carFile);
        }
        catch (IOException ioe) {
            this.logError("Unable to open file " + carFile.getAbsolutePath() + " for writing");
            this.logError(ioe);
            throw new InvalidArchiveFileException(carFile.getAbsolutePath(), "write");
        }
        ZipOutputStream zout = new ZipOutputStream(outstream);
        ZipEntry entry = null;
        for (int i = 0; i < this.m_ExpandedFileList.size(); ++i) {
            File file = (File)this.m_ExpandedFileList.get(i);
            if (file.exists() && !file.isDirectory()) {
                String path = this.translateFilePath(file);
                if (path != null) {
                    entry = new ZipEntry(path);
                }
                this.writeFileToZipEntry(zout, entry, file);
                this.logInfo("Archived file: " + file.getAbsolutePath());
                continue;
            }
            if (file.exists()) continue;
            this.logWarning("Unable to archive file: " + file.getAbsolutePath() + " The file does not exist");
        }
        try {
            zout.close();
        }
        catch (IOException ex) {
            throw new RuntimeWrapper(ex);
        }
    }

    private String translateFilePath(File file) {
        Object sPath = Utils.getCanonicalPath(file);
        Set varSet = this.m_Variables.entrySet();
        Object current = null;
        Iterator it = varSet.iterator();
        if (it.hasNext()) {
            current = it.next();
        }
        while (current != null) {
            Map.Entry entry = current;
            String path = (String)entry.getValue();
            File temp = new File(path);
            if (temp.exists()) {
                if (temp.isDirectory()) {
                    if (temp.compareTo(file) == 0) {
                        sPath = "{" + entry.getKey() + "}";
                        break;
                    }
                    String sTempPath = Utils.getCanonicalPath(temp);
                    if (((String)sPath).startsWith(sTempPath)) {
                        sPath = "{" + entry.getKey() + "}" + ((String)sPath).substring(sTempPath.length());
                        break;
                    }
                } else if (temp.compareTo(file) == 0) {
                    sPath = "{" + entry.getKey() + "}";
                    break;
                }
            }
            if (it.hasNext()) {
                current = it.next();
                continue;
            }
            current = null;
        }
        return sPath;
    }

    private String restoreFilePath(String sFile) throws InvalidVariableNameException {
        int varEnd;
        if (((String)sFile).endsWith(ARCHIVE_FILE)) {
            return (String)this.m_Variables.get("WorkingDir") + File.separator + ARCHIVE_FILE;
        }
        if (((String)sFile).endsWith(SETTINGS_FILE)) {
            return (String)this.m_Variables.get("WorkingDir") + File.separator + SETTINGS_FILE;
        }
        int varStart = ((String)sFile).indexOf(123);
        if (((String)sFile).startsWith("{") && ((String)sFile).endsWith("}") && ((String)sFile).indexOf(CF_ROOTDIR) != -1) {
            sFile = ((String)sFile).substring(1, ((String)sFile).length() - 1);
        }
        if (varStart != -1 && (varEnd = ((String)sFile).indexOf(125, varStart)) != -1) {
            String varName = ((String)sFile).substring(varStart + 1, varEnd);
            if (this.m_Variables.containsKey(varName)) {
                String sPath = (String)this.m_Variables.get(varName);
                String restOfPath = ((String)sFile).substring(varEnd + 1);
                sFile = sPath + restOfPath;
            } else {
                this.logError("Variable '" + varName + "' does not exist.");
                throw new InvalidVariableNameException(varName);
            }
        }
        if (File.separator.equals("/")) {
            sFile = ((String)sFile).replace('\\', '/');
        } else if (File.separator.equals("\\")) {
            sFile = ((String)sFile).replace('/', '\\');
        }
        return sFile;
    }

    private void writeFileToZipEntry(ZipOutputStream zout, ZipEntry entry, File file) {
        try {
            int n;
            FileInputStream fin = new FileInputStream(file);
            zout.putNextEntry(entry);
            byte[] buf = new byte[4096];
            while ((n = fin.read(buf, 0, buf.length)) != -1) {
                zout.write(buf, 0, n);
            }
            fin.close();
            zout.closeEntry();
        }
        catch (FileNotFoundException ex) {
            this.logWarning("Unable to open file " + file.getAbsolutePath() + ".  The file could not be found");
            this.logWarning(ex);
        }
        catch (IOException ex1) {
            this.logWarning("Unable to archive file " + file.getAbsolutePath() + ".  The file could not be found");
            this.logWarning(ex1);
        }
    }

    private void writeZipEntryToFile(ZipInputStream zin, File file) {
        try {
            int n;
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ex) {
                    File temp = new File(file.getParent());
                    temp.mkdirs();
                    file.createNewFile();
                }
            }
            FileOutputStream fout = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((n = zin.read(buf, 0, buf.length)) != -1) {
                fout.write(buf, 0, n);
            }
            fout.close();
            zin.closeEntry();
        }
        catch (FileNotFoundException ex) {
            this.logError("Unable to open file " + file.getAbsolutePath());
            this.logError(ex);
        }
        catch (IOException ex1) {
            this.logError("Unable to restore file " + file.getAbsolutePath());
            this.logError(ex1);
        }
    }

    private void addDirectoryMappings() {
        this.logInfo("Archiving directory mappings");
        ConfigMap result = new ConfigMap();
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        Map dirMappings = runtime.getMappings();
        for (int i = 0; i < this.m_Mappings.size(); ++i) {
            String item = (String)this.m_Mappings.get(i);
            if ("/CFIDE".equalsIgnoreCase(item)) continue;
            Object temp = dirMappings.get(item);
            if (temp != null) {
                result.put(item, temp);
                continue;
            }
            this.logError("Unable to obtain directory mapping '" + item + "'.  This mapping was not archived");
        }
        this.m_Settings.put(MAPPINGS, (Object)result);
    }

    private void setDirectoryMappings(Map dirMappings) {
        this.logInfo("Restoring Directory Mappings");
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        Map mappings = runtime.getMappings();
        dirMappings.remove("/CFIDE");
        dirMappings.remove("/cfide");
        mappings.putAll(dirMappings);
    }

    private void addScheduledTasks() {
        ConfigMap result = new ConfigMap();
        CronService cron = ServiceFactory.getCronService();
        if (null == cron) {
            return;
        }
        this.logInfo("Archiving scheduled tasks");
        for (int i = 0; i < this.m_Tasks.size(); ++i) {
            ScheduleTagTO temp = null;
            Object item = "";
            Object obj = this.m_Tasks.get(i);
            if (obj instanceof String) {
                item = (String)obj;
                if (((String)item).contains(":")) {
                    String[] m = ((String)item).split(":");
                    if (m.length == 3) {
                        task = m[0];
                        group = m[1];
                        mode = m[2];
                        temp = cron.findTask(task, group, mode);
                    } else {
                        temp = null;
                    }
                } else {
                    temp = cron.findTask((String)item);
                }
            } else {
                Struct s = (Struct)obj;
                task = (String)s.get("task");
                group = (String)s.get("group");
                mode = (String)s.get("mode");
                temp = cron.findTask(task, group, mode);
                item = task + group + mode;
            }
            if (temp != null) {
                result.put(item, (Object)temp);
                continue;
            }
            this.logError("Unable to obtain scheduled task '" + (String)item + "'.  This task was not archived");
        }
        this.m_Settings.put(SCHEDULED_TASKS, (Object)result);
    }

    private void setScheduledTasks(ConfigMap tasks) {
        Enumeration enu = tasks.elements();
        ArrayList<ScheduleTagTO> tasksTO = new ArrayList<ScheduleTagTO>();
        while (enu.hasMoreElements()) {
            Object o = enu.nextElement();
            ScheduleTagTO tsk = null;
            if (o instanceof ScheduleTagTO) {
                tsk = (ScheduleTagTO)o;
            } else {
                String proxyport;
                String proxypassword;
                String proxyuser;
                String proxyserver;
                String username;
                Map map = (Map)o;
                tsk = new ScheduleTagTO();
                String task2 = (String)map.get("task");
                tsk.setTask(task2);
                String url = (String)map.get(UPDATES_URL);
                tsk.setUrl(url);
                String file = (String)map.get("file");
                tsk.setFile(file);
                String path = (String)map.get(PDF_PATH);
                tsk.setPath(path);
                boolean publish = Cast._boolean(map.get("publish"));
                tsk.setPublish(publish);
                tsk.setStartdate(Cast._Date(map.get("start_date")));
                String str = (String)map.get("end_date");
                if (str != null) {
                    tsk.setEnddate(Cast._Date(map.get("end_date")));
                }
                tsk.setStarttime(Cast._Date(map.get("start_time")));
                str = (String)map.get("end_time");
                if (str != null) {
                    tsk.setEndtime(Cast._Date(map.get("end_time")));
                }
                String interval = (String)map.get("interval");
                tsk.setInterval(interval);
                String password = (String)map.get("password");
                if (password != null) {
                    tsk.setPassword(password);
                }
                if ((username = (String)map.get(SOLR_USERNAME)) != null) {
                    tsk.setUsername(username);
                }
                if ((proxyserver = (String)map.get("proxy_server")) != null) {
                    tsk.setProxyserver(proxyserver);
                }
                if ((proxyuser = (String)map.get("proxy_user")) != null) {
                    tsk.setProxyuser(proxyuser);
                }
                if ((proxypassword = (String)map.get("proxy_password")) != null) {
                    tsk.setProxypassword(proxypassword);
                }
                boolean resolveUrl = Cast._boolean(map.get("resolveurl"));
                tsk.setResolveUrl(resolveUrl);
                boolean chained = false;
                if (map.get("chained") != null) {
                    chained = Cast._boolean(map.get("chained"));
                }
                tsk.setChained(chained);
                boolean clustered = false;
                if (map.get(WEBSOCKET_CLUSTER_ENABLED) != null) {
                    clustered = Cast._boolean(map.get(WEBSOCKET_CLUSTER_ENABLED));
                }
                tsk.setClustered(clustered);
                boolean overwrite = null == map.get("overwrite") ? true : Cast._boolean(map.get("overwrite"));
                tsk.setOverwrite(overwrite);
                String port = (String)map.get("http_port");
                if (port != null) {
                    tsk.setPort(port);
                }
                if ((proxyport = (String)map.get("http_proxy_port")) != null) {
                    tsk.setProxyport(proxyport);
                }
                try {
                    str = (String)map.get("last_run");
                    if (str != null) {
                        tsk.setLastfire((Date)map.get("last_run"));
                    }
                    if ((str = (String)map.get("lastfire")) != null) {
                        tsk.setLastfire((Date)map.get("last_run"));
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                String group = (String)map.get("group");
                if (group != null) {
                    tsk.setGroup(group);
                }
                String misfire = "";
                if (map.get("misfire") != null) {
                    misfire = (String)map.get("misfire");
                }
                tsk.setMisfire(misfire);
                tsk.setOnexception((String)map.get("onexception"));
                tsk.setChianedtasks((String)map.get("oncomplete"));
                if (map.get("repeat") != null) {
                    tsk.setRepeat((String)map.get("repeat"));
                }
                tsk.setCrontime((String)map.get("crontime"));
                tsk.setRetrycount((String)map.get("retrycount"));
                tsk.setEventhandler((String)map.get("eventhandler"));
                tsk.setEventhandlerrp((String)map.get("eventhandlerrp"));
                tsk.setPriority((String)map.get("priority"));
                tsk.setExclude((String)map.get("exclude"));
                tsk.setMode((String)map.get("mode"));
                if (map.get("appname") != null) {
                    tsk.setAppname((String)map.get("appname"));
                } else if (tsk.getMode().equalsIgnoreCase("application")) {
                    tsk.setAppname("");
                }
            }
            tasksTO.add(tsk);
        }
        CronService cron = ServiceFactory.getCronService();
        this.logInfo("Restoring Scheduled Tasks");
        if (null != cron) {
            try {
                cron.updateTasksForArchive(tasksTO, this.archiveSeed, this.oldAlgoValue, this.majorVersion, this.minorVersion);
            }
            catch (Exception ex) {
                this.logError("Unable to restore scheduled tasks.  The cron service was not found");
            }
        }
    }

    private void addCFXs() {
        this.logInfo("Archiving CFX Settings");
        ConfigMap result = new ConfigMap();
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        Map cfxs = runtime.getCfxtags();
        for (int i = 0; i < this.m_Cfxs.size(); ++i) {
            String item = (String)this.m_Cfxs.get(i);
            Object temp = cfxs.get(item);
            if (temp != null) {
                result.put(item, temp);
                continue;
            }
            this.logError("Unable to obtain CFX '" + item + "'.  This CFX was not archived");
        }
        this.m_Settings.put(CFX, (Object)result);
    }

    private void setCFXs(Map cfxSettings) {
        this.logInfo("Restoring CFXs");
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        Map cfxs = runtime.getCfxtags();
        cfxs.putAll(cfxSettings);
    }

    private void addSolrCollections() {
        SolrService solr;
        ConfigMap result = new ConfigMap();
        try {
            solr = ServiceFactory.getSolrService();
        }
        catch (ApplicationException se) {
            this.logError("Solr service is currently disabled, archiving for solr collections skipped");
            return;
        }
        if (solr == null) {
            return;
        }
        if (this.m_SolrCollections.size() > 0) {
            this.logInfo("Archiving solr collections");
            ConfigMap vars = this.m_Variables;
            vars.put(SOLR_COLLECTION_DIR, solr.getSolrHome());
        }
        for (int i = 0; i < this.m_SolrCollections.size(); ++i) {
            String collectionName = (String)this.m_SolrCollections.get(i);
            Map info = null;
            try {
                info = solr.getCollectionInfo(collectionName);
            }
            catch (Exception ae) {
                this.logError("Solr service is currently disabled, archiving for solr collections skipped");
                return;
            }
            if (info != null) {
                ConfigMap tempCollection = new ConfigMap();
                tempCollection.put("NAME", (Object)collectionName);
                String path = (String)info.get("PATH");
                this.m_IncludedFiles.add(path);
                this.m_ExcludedFiles.add(path + File.separator + "core.properties");
                File collectionPath = new File(path);
                tempCollection.put("PATH", (Object)this.translateFilePath(collectionPath));
                String language = (String)info.get("LANGUAGE");
                tempCollection.put("LANGUAGE", (Object)language);
                result.put(collectionName, (Object)tempCollection);
                continue;
            }
            this.logError("Unable to obtain Solr collection '" + collectionName + "'.  This collection was not archived");
        }
        this.m_Settings.put(SOLR_COLLECTIONS, (Object)result);
    }

    private Map addSolrSettings() {
        SolrService solr;
        ConfigMap solrSettingMap = new ConfigMap();
        ArrayList<ConfigMap> langs = new ArrayList<ConfigMap>();
        try {
            solr = ServiceFactory.getSolrService();
        }
        catch (ApplicationException se) {
            this.logError("Solr service is currently disabled, archiving for solr settings skipped");
            return null;
        }
        if (null == solr) {
            return null;
        }
        this.logInfo("Archiving Solr Admin settings");
        String solrHome = solr.getSolrHome();
        String solrHost = solr.getSolrHost();
        int solrPort = solr.getSolrPort();
        int solrHttpsPort = solr.getSolrhttpsport();
        String solrHttpsEnabled = solr.getHttpsenabled();
        int solrBufferSize = solr.getSolrBufferSize();
        String solrWebApp = solr.getSolrWebapp();
        String solrUsername = solr.getUsername();
        Vector<Map> solrLangs = solr.getLanguages();
        Enumeration<Map> en = solrLangs.elements();
        while (en.hasMoreElements()) {
            Map m = en.nextElement();
            ConfigMap langMap = new ConfigMap();
            langMap.put("name", m.get("name"));
            langMap.put(SOLR_LANG_SUFFIX, m.get(SOLR_LANG_SUFFIX));
            langs.add(langMap);
        }
        if (this.m_SolrCollections.size() == 0) {
            solrSettingMap.put(SOLR_HOME, (Object)solrHome);
            solrSettingMap.put(SOLR_HOST, (Object)solrHost);
            solrSettingMap.put(SOLR_PORT, (Object)solrPort);
            solrSettingMap.put(SOLR_HTTPS_PORT, (Object)solrHttpsPort);
        }
        solrSettingMap.put(SOLR_HTTPS_ENABLED, (Object)solrHttpsEnabled);
        solrSettingMap.put(SOLR_BUFFER_SIZE, (Object)solrBufferSize);
        solrSettingMap.put(SOLR_WEBAPP, (Object)solrWebApp);
        solrSettingMap.put(SOLR_USERNAME, (Object)solrUsername);
        solrSettingMap.put(SOLR_LANGS, (Object)langs);
        return solrSettingMap;
    }

    private void setSolrSettings(Map solrsettings) {
        SolrService solr;
        try {
            this.logInfo("Restoring Solr Settings");
            solr = ServiceFactory.getSolrService(true);
        }
        catch (ApplicationException se) {
            this.logError("Solr service disabled, solr settings restore skipped");
            return;
        }
        if (solrsettings.get(SOLR_HOST) != null) {
            solr.setSolrHost((String)solrsettings.get(SOLR_HOST));
            solr.setSolrPort(((Double)solrsettings.get(SOLR_PORT)).intValue());
            solr.setSolrhttpsport(((Double)solrsettings.get(SOLR_HTTPS_PORT)).intValue());
            solr.setSolrHome((String)solrsettings.get(SOLR_HOME));
        }
        solr.setHttpsEnabled((String)solrsettings.get(SOLR_HTTPS_ENABLED));
        solr.setSolrWebapp((String)solrsettings.get(SOLR_WEBAPP));
        solr.setUsername((String)solrsettings.get(SOLR_USERNAME));
        solr.setSolrBufferSize(((Double)solrsettings.get(SOLR_BUFFER_SIZE)).intValue());
        Vector langs = new Vector();
        langs = (Vector)solrsettings.get(SOLR_LANGS);
        Enumeration en = langs.elements();
        while (en.hasMoreElements()) {
            Map m = (Map)en.nextElement();
            solr.setLanguage((String)m.get("name") + "," + (String)m.get(SOLR_LANG_SUFFIX));
        }
    }

    private void setFontSettings(Map fontsettings) {
        DocumentService fontService;
        try {
            this.logInfo("Restoring Font Settings");
            fontService = ServiceFactory.getDocumentService();
        }
        catch (ApplicationException se) {
            this.logError("Document service disabled, Font settings restore skipped");
            return;
        }
        for (Object font : fontsettings.keySet()) {
            if (!new File(font.toString()).exists()) continue;
            fontService.registerFontFile(font.toString());
        }
    }

    private void addFontSettings() {
        DocumentService fontService;
        this.logInfo("Archiving Font settings");
        ConfigMap FontSettingMap = new ConfigMap();
        try {
            fontService = ServiceFactory.getDocumentService();
        }
        catch (ApplicationException se) {
            this.logError("Document service is currently disabled, archiving for Font settings skipped");
            return;
        }
        if (fontService != null) {
            Map fonts = fontService.getUserConfigMap();
            for (Object key : fonts.keySet()) {
                FontSettingMap.put(key.toString(), (Object)key.toString());
            }
            this.m_Settings.put(FONT_SETTINGS, (Object)FontSettingMap);
        }
    }

    private void setSolrCollections(Map collections) {
        SolrService solr;
        this.logInfo("Restoring Solr Collections");
        try {
            solr = ServiceFactory.getSolrService(true);
        }
        catch (ApplicationException se) {
            this.logError("Solr service disabled, solr collections restore skipped");
            return;
        }
        ConfigMap vars = this.m_Variables;
        vars.put(SOLR_COLLECTION_DIR, solr.getSolrHome());
        for (Map.Entry entry : collections.entrySet()) {
            String collectionName = (String)entry.getKey();
            Map info = (Map)entry.getValue();
            if (!info.containsKey(PDF_PATH)) continue;
            String path = (String)info.get(PDF_PATH);
            try {
                path = this.restoreFilePath(path);
            }
            catch (InvalidVariableNameException ex) {
                this.logError("Unable to resolve variable, collection can not be restored");
                this.logError(ex);
            }
            try {
                solr.registerCollection(collectionName, path);
            }
            catch (Exception e) {
                this.logError("Unable to register solr collection '" + collectionName + "'.  This collection was not restored. Error: " + e);
                this.logError(e);
            }
        }
    }

    private void addDatasources() {
        DataSourceService ds = ServiceFactory.getDataSourceService();
        if (null == ds) {
            return;
        }
        this.logInfo("Archiving datasource settings");
        ConfigMap result = new ConfigMap();
        Map datasources = ds.getDatasources();
        for (int i = 0; i < this.m_Datasources.size(); ++i) {
            String item = (String)this.m_Datasources.get(i);
            if (item.equalsIgnoreCase("cfartgallery") || item.equalsIgnoreCase("cfbookclub") || item.equalsIgnoreCase("cfcodeexplorer") || item.equalsIgnoreCase("cfdocexamples") || item.equalsIgnoreCase("cfartgallery_pb") || item.equalsIgnoreCase("cfbookclub_pb")) continue;
            Object temp = datasources.get(item);
            if (temp != null) {
                result.put(item, temp);
                continue;
            }
            this.logError("Unable to obtain settings for datasource '" + item + "'.  The datasource was not archived");
        }
        this.m_Settings.put(DATASOURCE, (Object)result);
    }

    private void setDatasources(Map dsSettings, Map fileSettings) {
        this.logInfo("Restoring Datasources");
        DataSourceService ds = ServiceFactory.getDataSourceService();
        Map datasources = ds.getDatasources();
        Iterator itr = dsSettings.keySet().iterator();
        while (itr.hasNext()) {
            String dsnName = itr.next().toString();
            Map dsn = (Map)dsSettings.get(dsnName);
            try {
                String dbFile;
                String driver = dsn.get("DRIVER").toString();
                String url = dsn.get(UPDATES_URL).toString();
                String currentPort = "20008";
                int maxpooledStatementsValue = 100;
                if (url.indexOf("20006") != -1) {
                    url = CFPage.Replace(url, "20006", "20008", "all");
                    dsn.put(UPDATES_URL, url);
                    ((Map)dsn.get("urlmap")).put("port", currentPort);
                    ((Map)((Map)dsn.get("urlmap")).get("connectionprops")).put("port", currentPort);
                }
                if (dsn.containsKey("validationQuery") && !dsn.get("validationQuery").toString().trim().equals("")) {
                    dsn.put("validateConnection", true);
                } else {
                    dsn.put("validateConnection", false);
                }
                if (driver.equalsIgnoreCase("DB2") || driver.equalsIgnoreCase("Informix") || driver.equalsIgnoreCase("MSSQLServer") || driver.equalsIgnoreCase("Oracle") || driver.equalsIgnoreCase("MySQL_DD")) {
                    int value;
                    String connPropsMaxPooledStmts;
                    Object connPropsMaxPooledStmtsObj;
                    int value2;
                    String urlMapMaxPooledStmts;
                    Object urlMapMaxPooledStmtsObj = ((Map)dsn.get("urlmap")).get("maxpooledstatements");
                    if (urlMapMaxPooledStmtsObj != null && (urlMapMaxPooledStmts = urlMapMaxPooledStmtsObj.toString()).length() > 0 && (value2 = Double.valueOf(urlMapMaxPooledStmts).intValue()) > maxpooledStatementsValue) {
                        ((Map)dsn.get("urlmap")).put("maxpooledstatements", maxpooledStatementsValue);
                    }
                    if ((connPropsMaxPooledStmtsObj = ((Map)((Map)dsn.get("urlmap")).get("connectionprops")).get("maxpooledstatements")) != null && (connPropsMaxPooledStmts = connPropsMaxPooledStmtsObj.toString()).length() > 0 && (value = Double.valueOf(connPropsMaxPooledStmts).intValue()) > maxpooledStatementsValue) {
                        ((Map)((Map)dsn.get("urlmap")).get("connectionprops")).put("maxpooledstatements", maxpooledStatementsValue);
                    }
                }
                if (fileSettings.containsKey("{" + (dbFile = ((ConfigMap)dsn.get("urlmap")).get("databaseFile").toString()) + "}")) {
                    ((ConfigMap)dsn.get("urlmap")).put("databaseFile", fileSettings.get("{" + dbFile + "}"));
                }
                dsn = ds.reEncryptPasswordForMigration(dsn, this.archiveSeed, this.oldAlgoValue, this.majorVersion, this.minorVersion);
                if (("cfartgallery".equalsIgnoreCase(dsnName) || "cfdocexamples".equalsIgnoreCase(dsnName) || "cfcodeexplorer".equalsIgnoreCase(dsnName) || "cfbookclub".equalsIgnoreCase(dsnName)) && ("cfartgallery_pb".equalsIgnoreCase(dsnName) || "cfbookclub_pb".equalsIgnoreCase(dsnName))) continue;
                datasources.put(dsnName, dsn);
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating datasources:" + dsnName);
                this.logError(ex);
            }
        }
        this.logWarning("Value for Max Pooled Statements is set to 100 for following drivers - DB2, Informix, Oracle, Microsoft SQL Server, MySQL_DD (DataDirect).");
    }

    private void addEventGatewaySettings() {
        EventGatewayService eventService = ServiceFactory.getEventProcessorService();
        if (null == eventService) {
            return;
        }
        this.logInfo("Archiving Event Gateway Settings");
        ConfigMap result = new ConfigMap();
        try {
            Map globals = eventService.getGlobals();
            for (Map.Entry entry : globals.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("JIGID")) continue;
                result.put(key, entry.getValue());
            }
        }
        catch (Exception ex) {
            this.logError("Error occurred Archiving Event Gateway Settings");
            this.logError(ex);
        }
        this.m_Settings.put(SETTINGS_EVENTGATEWAY_GLOBALS, (Object)result);
    }

    private void addEventGatewayTypes() {
        this.logInfo("Archiving Event Gateway Types");
        ConfigMap result = new ConfigMap();
        EventGatewayService eventService = ServiceFactory.getEventProcessorService();
        for (int i = 0; i < this.m_eventgatewayTypes.size(); ++i) {
            String type = (String)this.m_eventgatewayTypes.get(i);
            Map temp = eventService.getGatewayTypeInfo(type);
            if (temp != null) {
                result.put(type, (Object)temp);
                continue;
            }
            this.logError("Unable to obtain settings for gateway Type'" + type + "'.  The gateway Type was not archived");
        }
        this.m_Settings.put(SETTINGS_EVENTGATEWAY_TYPES, (Object)result);
    }

    private void addEventGateways() {
        this.logInfo("Archiving Event Gateway Instances");
        ConfigMap result = new ConfigMap();
        EventGatewayService eventService = ServiceFactory.getEventProcessorService();
        for (int i = 0; i < this.m_eventgateway.size(); ++i) {
            String item = (String)this.m_eventgateway.get(i);
            Map temp = eventService.getGatewayInfo(item);
            if (temp != null) {
                Vector paths = (Vector)temp.get("CFCPATHS");
                for (int x = 0; x < paths.size(); ++x) {
                    if (this.m_IncludedFiles.contains(paths.get(x))) continue;
                    this.m_IncludedFiles.add(paths.get(x));
                }
                String config = (String)temp.get("CONFIGURATIONPATH");
                if (config.length() > 0 && !this.m_IncludedFiles.contains(config)) {
                    this.m_IncludedFiles.add(config);
                }
                result.put(item, (Object)temp);
                continue;
            }
            this.logError("Unable to obtain settings for gateway '" + item + "'.  The gateway was not archived");
        }
        this.m_Settings.put(SETTINGS_EVENTGATEWAY, (Object)result);
    }

    private void addWebServices() {
        try {
            XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
            if (xmlRpcService == null) {
                return;
            }
            this.logInfo("Archiving web Services");
            ConfigList result = new ConfigList();
            Map mappings = xmlRpcService.getMappings();
            ConfigMap newMappings = new ConfigMap();
            Map usernames = xmlRpcService.getUsernames();
            ConfigMap newusernames = new ConfigMap();
            Map passwords = xmlRpcService.getPasswords();
            ConfigMap newpasswords = new ConfigMap();
            Map proxypasswords = xmlRpcService.getProxypasswords();
            ConfigMap newproxypasswords = new ConfigMap();
            Map proxyusersnames = xmlRpcService.getProxyusernames();
            ConfigMap newproxyusernames = new ConfigMap();
            Map proxyservers = xmlRpcService.getProxyservers();
            ConfigMap newproxyservers = new ConfigMap();
            Map proxyports = xmlRpcService.getProxyports();
            ConfigMap newproxyports = new ConfigMap();
            Map timeouts = xmlRpcService.getTimeouts();
            ConfigMap newtimeouts = new ConfigMap();
            for (int i = 0; i < this.m_webservices.size(); ++i) {
                String item = (String)this.m_webservices.get(i);
                String webservice = null;
                if (mappings != null) {
                    webservice = (String)mappings.get(item);
                }
                if (webservice != null && !item.equalsIgnoreCase(webservice)) {
                    newMappings.put(item, webservice);
                    newusernames.put(item, usernames.get(item) == null ? "" : usernames.get(item));
                    newpasswords.put(item, passwords.get(item) == null ? "" : passwords.get(item));
                    newproxypasswords.put(item, proxypasswords.get(item) == null ? "" : proxypasswords.get(item));
                    newproxyusernames.put(item, proxyusersnames.get(item) == null ? "" : proxyusersnames.get(item));
                    newproxyservers.put(item, proxyservers.get(item) == null ? "" : proxyservers.get(item));
                    newproxyports.put(item, proxyports.get(item) == null ? "" : proxyports.get(item));
                    newtimeouts.put(item, timeouts.get(item) == null ? "" : timeouts.get(item));
                    continue;
                }
                this.logError("Unable to obtain settings for web service '" + item + "'.  The web service was not archived");
            }
            result.add(newMappings);
            result.add(newusernames);
            result.add(newpasswords);
            result.add(newproxypasswords);
            result.add(newproxyusernames);
            result.add(newproxyservers);
            result.add(newproxyports);
            result.add(newtimeouts);
            this.m_Settings.put(WEBSERVICES, (Object)result);
        }
        catch (Exception ex) {
            this.logError("Error occurred while archiving web Services");
            this.logError(ex);
        }
    }

    private void addRestServices() {
        try {
            this.logInfo("Archiving Rest Services");
            JaxRsService jrs = ServiceFactory.getJaxRsService();
            ConfigMap registeredRestMap = jrs.getMappings();
            ConfigMap archiveRestMap = new ConfigMap();
            for (int i = 0; i < this.m_restservices.size(); ++i) {
                String apppath = (String)this.m_restservices.get(i);
                Object mapping = registeredRestMap.get(apppath);
                if (apppath != null && mapping != null) {
                    archiveRestMap.put(apppath, (Object)((Vector)mapping));
                    continue;
                }
                this.logError("Unable to archive restservice for the path" + apppath);
            }
            ConfigMap resultrest = new ConfigMap();
            String defapp = jrs.getDefaultApp();
            if (defapp != null && defapp != "") {
                resultrest.put(_DEF__RESTSERVICE, (Object)defapp);
            } else {
                resultrest.put(_DEF__RESTSERVICE, (Object)"");
            }
            resultrest.put(RESTSERVICEMAPPINGS, (Object)archiveRestMap);
            this.m_Settings.put(RESTSERVICES, (Object)resultrest);
        }
        catch (Exception ex) {
            this.logError("Error occurred while archiving rest Services");
            this.logError(ex);
        }
    }

    private void setRestServices(Map rest) {
        try {
            this.logInfo("Restoring Rest Services");
            JaxRsService jrx = ServiceFactory.getJaxRsService();
            String defapp = "";
            if (rest.containsKey(_DEF__RESTSERVICE)) {
                defapp = (String)rest.get(_DEF__RESTSERVICE);
            }
            ConfigMap restservice = (ConfigMap)rest.get(RESTSERVICEMAPPINGS);
            for (String apppath : restservice.keySet()) {
                Object mapping = restservice.get(apppath);
                String restserviceName = null;
                String hostName = null;
                boolean defApp = false;
                if (mapping instanceof String) {
                    restserviceName = mapping.toString();
                } else if (mapping instanceof Vector) {
                    Vector mappingVector = (Vector)mapping;
                    restserviceName = mappingVector.get(0).toString();
                    hostName = mappingVector.get(1).toString();
                } else {
                    this.logError("Error while updating restservice" + apppath);
                    return;
                }
                if (apppath.equals(defapp)) {
                    defApp = true;
                }
                jrx.registerApplication(apppath, restserviceName, hostName, defApp, true);
            }
        }
        catch (Exception ex) {
            this.logError("Error while updating Rest Services");
            this.logError(ex);
        }
    }

    private void addPDFServices() {
        try {
            DocumentService ds = ServiceFactory.getDocumentService();
            if (ds == null) {
                return;
            }
            PDFGService pdfgService = ServiceFactory.getPDFGService();
            if (pdfgService == null) {
                return;
            }
            this.logInfo("Archiving PDF Services");
            ConfigMap result = new ConfigMap();
            ConfigMap pdfServices = pdfgService.getAllServiceManagers();
            String path = ds.getOfficeLocation();
            String host = ds.getOpenOfficeRemoteHost();
            String port = ds.getOpenOfficeRemotePort();
            if (host != null) {
                result.put(PDF_HOSTNAME, (Object)host);
            }
            if (port != null) {
                result.put("port", (Object)port);
            }
            if (path != null) {
                result.put(PDF_PATH, (Object)path);
            }
            for (int i = 0; i < this.m_pdfservices.size(); ++i) {
                String item = (String)this.m_pdfservices.get(i);
                Object temp = pdfServices.get(item);
                if (temp != null) {
                    result.put(item, temp);
                    continue;
                }
                this.logError("Unable to obtain settings for PDF Service '" + item + "'.  The PDF Service was not archived");
            }
            this.m_Settings.put(PDFSERVICES, (Object)result);
        }
        catch (Exception ex) {
            this.logError("Error occurred while archiving PDF Services");
            this.logError(ex);
        }
    }

    private void addSamlIdpSettings() {
        try {
            this.logInfo("Archiving SAML Identity Provider Settings");
            ConfigMap result = new ConfigMap();
            SamlService ss = ServiceFactory.getSamlService();
            Map m_allIdps = ss.getAllIdpConfig();
            for (int i = 0; i < this.m_idps.size(); ++i) {
                String idpName = (String)this.m_idps.get(i);
                Object idpObj = m_allIdps.get(idpName);
                if (idpObj != null) {
                    result.put(idpName, idpObj);
                    continue;
                }
                this.logError("Unable to obtain settings for Identity Provider alias '" + idpName + "'. The Identity Provider configuration was not archived");
            }
            this.m_Settings.put(IDP, (Object)result);
        }
        catch (Exception e) {
            this.logError("Error occurred while archiving SAML Identity Provider Settings");
            this.logError(e);
        }
    }

    private void addSamlSpSettings() {
        try {
            this.logInfo("Archiving SAML Service Provider Settings");
            ConfigMap result = new ConfigMap();
            SamlService ss = ServiceFactory.getSamlService();
            Map m_allSps = ss.getAllSpConfig();
            for (int i = 0; i < this.m_sps.size(); ++i) {
                String spName = (String)this.m_sps.get(i);
                Object idpObj = m_allSps.get(spName);
                if (idpObj != null) {
                    result.put(spName, idpObj);
                    continue;
                }
                this.logError("Unable to obtain settings for Service Provider alias '" + spName + "'. The Service Provider configuration was not archived");
            }
            this.m_Settings.put(SP, (Object)result);
        }
        catch (Exception e) {
            this.logError("Error occurred while archiving SAML Service Provider Settings");
            this.logError(e);
        }
    }

    private void addCloudCredentialSettings() {
        try {
            this.logInfo("Archiving Cloud Credential Settings");
            ConfigMap result = new ConfigMap();
            VendorCredentialService ss = ServiceFactory.getVendorCredentialService();
            List<Struct> m_allCreds = ss.getAllCredentialsData();
            for (Struct credObj : m_allCreds) {
                String credAlias = (String)credObj.get(ALIAS_KEY);
                if (credObj != null) {
                    result.put(credAlias, (Object)credObj);
                    continue;
                }
                this.logError("Unable to obtain settings for Cloud  Credetial alias '" + credAlias + "'. The Cloud Credential was not archived");
            }
            this.m_Settings.put(CLOUD_CREDENTIALS, (Object)result);
        }
        catch (Exception e) {
            this.logError("Error occurred while archiving Cloud Credential Settings");
            this.logError(e);
        }
    }

    private void addCloudConfigurationSettings() {
        try {
            this.logInfo("Archiving Cloud Configuration Settings");
            ConfigMap result = new ConfigMap();
            CloudConfigService ss = ServiceFactory.getCloudConfigService();
            List<Struct> m_allConfigs = ss.getAllConfigData();
            for (Struct configObj : m_allConfigs) {
                String configAlias = (String)configObj.get(ALIAS_KEY);
                if (configObj != null) {
                    result.put(configAlias, (Object)configObj);
                    continue;
                }
                this.logError("Unable to obtain settings for Cloud Configuration alias '" + configAlias + "'. The Cloud Configuration was not archived");
            }
            this.m_Settings.put(CLOUD_CONFIGURATIONS, (Object)result);
        }
        catch (Exception e) {
            this.logError("Error occurred while archiving Cloud Configuration Settings");
            this.logError(e);
        }
    }

    private void addNoSqlSettings() {
        try {
            this.logInfo("Archiving NoSQL Settings");
            ConfigMap result = new ConfigMap();
            NoSQLService noSqlService = ServiceFactory.getNoSQLService();
            Map<?, ?> all_datasources = noSqlService.getDatasources();
            for (int i = 0; i < this.m_nosql.size(); ++i) {
                String dsnName = (String)this.m_nosql.get(i);
                Object dsObj = all_datasources.get(dsnName);
                if (dsObj != null) {
                    result.put(dsnName, dsObj);
                    continue;
                }
                this.logError("Unable to obtain settings for NoSQL datasource '" + dsnName + "'. The NoSQL configuration was not archived");
            }
            this.m_Settings.put(NOSQL, (Object)result);
        }
        catch (Exception e) {
            this.logError("Error occurred while archiving NoSQL Settings");
            this.logError(e);
        }
    }

    private void setPDFServices(Map pdfServices) {
        try {
            this.logInfo("Restoring PDF Services");
            DocumentService documentService = ServiceFactory.getDocumentService(true);
            PDFGService pdfgService = ServiceFactory.getPDFGService();
            if (pdfServices.containsKey(PDF_PATH)) {
                documentService.setOfficeLocation(Cast._String(pdfServices.get(PDF_PATH)));
                pdfServices.remove(PDF_PATH);
            }
            if (pdfServices.containsKey(PDF_HOSTNAME) && pdfServices.containsKey("port")) {
                documentService.setOpenOfficeRemoteConfig(Cast._String(pdfServices.get(PDF_HOSTNAME)), Cast._String(pdfServices.get("port")));
                pdfServices.remove(PDF_HOSTNAME);
                pdfServices.remove("port");
            }
            for (String name : pdfServices.keySet()) {
                Map pdfServiceManager = (Map)pdfServices.get(name);
                pdfgService.addServiceManager(name, Cast._String(pdfServiceManager.get(PDF_HOSTNAME)), Cast._int(pdfServiceManager.get("port")), Cast._int(pdfServiceManager.get("weight")), Cast._boolean(pdfServiceManager.get("isHttps")), Cast._String(pdfServiceManager.get("engine")));
            }
        }
        catch (Exception ex) {
            this.logError("Error while updating PDF Services");
            this.logError(ex);
        }
    }

    private void setSamlIdpSettings(Map idpSettings) {
        this.logInfo("Restoring SAML Identity Provider Settings");
        SamlService samlService = ServiceFactory.getSamlService();
        for (String alias : idpSettings.keySet()) {
            try {
                Object idpObj = idpSettings.get(alias);
                samlService.addIdpMetadata(alias, idpObj);
            }
            catch (Exception e) {
                this.logError("Error occurred while updating Identity Provider:" + alias);
                this.logError(e);
                e.printStackTrace();
            }
        }
    }

    private void setSamlSpSettings(Map spSettings) {
        this.logInfo("Restoring SAML Service Provider Settings");
        SamlService samlService = ServiceFactory.getSamlService();
        for (String alias : spSettings.keySet()) {
            try {
                Object spObj = spSettings.get(alias);
                samlService.addSpMetadata(alias, spObj);
            }
            catch (Exception e) {
                this.logError("Error occurred while updating Identity Provider:" + alias);
                this.logError(e);
                e.printStackTrace();
            }
        }
    }

    private void setCloudCredentialSettings(Map cloudCredentialSettings) {
        this.logInfo("Restoring Cloud Credential Settings");
        VendorCredentialService credentialService = ServiceFactory.getVendorCredentialService();
        for (String alias : cloudCredentialSettings.keySet()) {
            try {
                Struct credObj = (Struct)cloudCredentialSettings.get(alias);
                credentialService.addCredentialsData(credObj);
            }
            catch (Exception e) {
                this.logError("Error occurred while updating Cloud Credential: " + alias);
                this.logError(e);
                e.printStackTrace();
            }
        }
    }

    private void setCloudConfigurationSettings(Map cloudConfigurationSettings) {
        this.logInfo("Restoring SAML Service Provider Settings");
        CloudConfigService configService = ServiceFactory.getCloudConfigService();
        for (String alias : cloudConfigurationSettings.keySet()) {
            try {
                Struct configObj = (Struct)cloudConfigurationSettings.get(alias);
                configService.addConfigData(configObj);
            }
            catch (Exception e) {
                this.logError("Error occurred while updating Cloud Configuration:" + alias);
                this.logError(e);
                e.printStackTrace();
            }
        }
    }

    private void setNoSqlSettings(Map noSqlSettings) {
        this.logInfo("Restoring NoSQL Settings");
        NoSQLService noSqlService = ServiceFactory.getNoSQLService();
        for (String alias : noSqlSettings.keySet()) {
            try {
                Object dsObj = noSqlSettings.get(alias);
                noSqlService.setDataSource((Map)dsObj);
            }
            catch (Exception e) {
                this.logError("Error occurred while updating NoSql Datasource:" + alias);
                this.logError(e);
                e.printStackTrace();
            }
        }
    }

    private void setEventGateways(Map gateways, Map fileMappings) {
        this.logInfo("Restoring Event Gateway Instances");
        EventGatewayService eventService = ServiceFactory.getEventProcessorService();
        Iterator itr = gateways.keySet().iterator();
        while (itr.hasNext()) {
            String name = itr.next().toString();
            try {
                Map gw = (Map)gateways.get(name);
                Vector paths = (Vector)gw.get("CFCPATHS");
                Object[] newPaths = new String[paths.size()];
                paths.copyInto(newPaths);
                String configPath = (String)gw.get("CONFIGURATIONPATH");
                for (int i = 0; i < newPaths.length; ++i) {
                    String p = "{" + (String)newPaths[i] + "}";
                    if (!fileMappings.containsKey(p)) continue;
                    newPaths[i] = fileMappings.get(p).toString();
                }
                if (fileMappings.containsKey("{" + configPath + "}")) {
                    configPath = fileMappings.get("{" + configPath + "}").toString();
                }
                eventService.registerGateway((String)gw.get("GATEWAYID"), (String)gw.get("TYPE"), configPath, (String[])newPaths, (String)gw.get("MODE"));
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating gateway:" + name);
                this.logError(ex);
                ex.printStackTrace();
            }
        }
    }

    private void setEventGatewayTypes(Map gateways) {
        this.logInfo("Restoring Event Gateway Types");
        EventGatewayService eventService = ServiceFactory.getEventProcessorService();
        Iterator itr = gateways.keySet().iterator();
        while (itr.hasNext()) {
            String name = itr.next().toString();
            try {
                if (eventService.getGatewayTypeInfo(name) != null) continue;
                Map gw = (Map)gateways.get(name);
                eventService.registerGatewayType((String)gw.get("TYPE"), (String)gw.get("DESCRIPTION"), (String)gw.get("CLASS"), ((Number)gw.get("STARTTIMEOUT")).intValue(), (Boolean)gw.get("KILLONTIMEOUT"));
            }
            catch (Exception ex) {
                this.logError("Error occurred while updating gateway Type " + name);
                this.logError(ex);
                ex.printStackTrace();
            }
        }
    }

    private void setWebServices(List webservices) {
        this.logInfo("Restoring Web Services");
        final XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
        Map mappings = xmlRpcService.getMappings();
        mappings.putAll((Map)webservices.get(0));
        Map usernames = xmlRpcService.getUsernames();
        usernames.putAll((Map)webservices.get(1));
        Map passwordsFromCAR = (Map)webservices.get(2);
        xmlRpcService.reEncryptPasswordForArchive(passwordsFromCAR, this.archiveSeed, this.oldAlgoValue, this.majorVersion, this.minorVersion);
        Map passwords = xmlRpcService.getPasswords();
        passwords.putAll(passwordsFromCAR);
        if (webservices.size() > 3) {
            Map proxypasswords = xmlRpcService.getProxypasswords();
            proxypasswords.putAll((Map)webservices.get(3));
            Map proxyusernames = xmlRpcService.getProxyusernames();
            proxyusernames.putAll((Map)webservices.get(4));
            Map proxyservers = xmlRpcService.getProxyservers();
            proxyservers.putAll((Map)webservices.get(5));
            Map proxyports = xmlRpcService.getProxyports();
            proxyports.putAll((Map)webservices.get(6));
            if (webservices.size() > 7) {
                Map timeouts = xmlRpcService.getTimeouts();
                timeouts.putAll((Map)webservices.get(7));
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    xmlRpcService.store();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceRuntimeException(pex.getException());
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    private void setEventGatewaySetting(Map gatewaySetting) {
        this.logInfo("Restoring Event Gateway Global Settings");
        EventGatewayService eventService = ServiceFactory.getEventProcessorService();
        Map settings = eventService.getGlobals();
        settings.putAll(gatewaySetting);
    }

    private void setLogging(boolean bLog, String action) {
        if (bLog) {
            this.m_bLog = bLog;
            String logFileName = "car_" + action + "_" + StringEncoder.encode(this.m_sName);
            LoggingService logSvc = ServiceFactory.getLoggingService();
            this.m_Logger = logSvc.getArchiveLog(logFileName);
        }
    }

    private void logError(String message) {
        if (this.m_bLog) {
            this.m_Logger.error(message);
        }
    }

    private void logError(Exception ex) {
        if (this.m_bLog) {
            this.m_Logger.error(ex);
        }
    }

    private void logWarning(String message) {
        if (this.m_bLog) {
            this.m_Logger.warn(message);
        }
    }

    private void logWarning(Exception ex) {
        if (this.m_bLog) {
            this.m_Logger.warn(ex);
        }
    }

    private void logInfo(String message) {
        if (this.m_bLog) {
            this.m_Logger.info(message);
        }
    }

    public void setArchiveEventGatewaySettings(boolean archiveEventGatewaySettings) {
        this.archiveEventGatewaySettings = archiveEventGatewaySettings;
    }

    private String addAlertCFC(Map alertSettings, String alertType) {
        String alertcfc;
        String alertCFC = "alert_processing_cfc";
        Map alert = (Map)alertSettings.get(alertType);
        if (alert != null && (alertcfc = (String)alert.get("alert_processing_cfc")) != null && !"".equalsIgnoreCase(alertcfc.trim())) {
            if (!this.m_IncludedFiles.contains(alertcfc)) {
                this.m_IncludedFiles.add(alertcfc);
            }
            return alertcfc;
        }
        return null;
    }

    public boolean isArchiveEventGatewaySettings() {
        return this.archiveEventGatewaySettings;
    }

    private int getMajorVersion(String versionStr) throws NumberFormatException {
        if (versionStr == null) {
            return 0;
        }
        String subStr = "";
        if (versionStr.contains(",")) {
            String[] versions = versionStr.split(",", 4);
            if (versions != null) {
                if (versions[0].startsWith(CFMX)) {
                    String[] strings = versions[0].split(CFMX, 2);
                    if (strings != null && strings.length > 0) {
                        subStr = strings[1];
                    }
                } else {
                    subStr = versions[0];
                }
                try {
                    return Integer.parseInt(subStr);
                }
                catch (NumberFormatException ne) {
                    this.m_Logger.error(ne);
                }
            }
        } else if (versionStr.startsWith(CFMX)) {
            String majorVer = versionStr.substring(CFMX.length());
            return Integer.parseInt(majorVer);
        }
        return 0;
    }

    private int getMinorVersion(String versionStr) throws NumberFormatException {
        String[] versions;
        if (versionStr == null) {
            return 0;
        }
        if (versionStr.contains(",") && (versions = versionStr.split(",", 4)) != null) {
            try {
                return Integer.parseInt(versions[1]);
            }
            catch (NumberFormatException ne) {
                this.m_Logger.error(ne);
            }
        }
        return 0;
    }

    private void replaceKey(Map map, Object oldKey, Object newKey) {
        if (map.containsKey(oldKey)) {
            map.put(newKey, map.remove(oldKey));
        }
    }

    public static class InvalidArchiveFileException
    extends ApplicationException {
        private String file;
        private String verb;

        public InvalidArchiveFileException(String file, String verb) {
            this.file = file;
            this.verb = verb;
        }

        public String getFile() {
            return this.file;
        }

        public String getVerb() {
            return this.verb;
        }
    }

    public static final class InvalidVariableNameException
    extends ApplicationException {
        private String m_sVarName;

        InvalidVariableNameException(String varName) {
            this.m_sVarName = varName;
        }

        public String getVarName() {
            return this.m_sVarName;
        }
    }
}

