/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.archivedeploy;

import coldfusion.archivedeploy.Archive;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ArchiveDeployService;
import coldfusion.server.ConfigList;
import coldfusion.server.ConfigListListener;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.util.PasswordUtils;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.regex.Pattern;

public class ArchiveDeployServiceImpl
extends ServiceBase
implements ArchiveDeployService,
Observer,
ConfigListListener {
    private static final String ARCHIVE_KEY = "archives";
    private static final String LOG_ARCHIVE_KEY = "log_archive";
    private static final String LOG_DEPLOY_KEY = "log_deploy";
    static String rootDir = null;
    private boolean isStarted = false;
    private String seed;
    private File file;
    private ConfigMap m_Archives = new ConfigMap();
    private String m_sWorkingDir;
    private boolean m_bLogArchive;
    private boolean m_bLogDeploy;

    public ArchiveDeployServiceImpl(File file, String rootDir) {
        this.file = file;
        ArchiveDeployServiceImpl.rootDir = rootDir;
        this.setEnableWatch(true);
        this.setWatchFile(file);
    }

    @Override
    public String getWorkingDirectory() {
        if (this.m_sWorkingDir != null) {
            return this.m_sWorkingDir;
        }
        return "";
    }

    @Override
    public void listModified(ConfigList list) {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void setWorkingDirectory(String dir) {
        if (dir.trim().length() > 0) {
            File workingDir = new File(dir);
            if (!workingDir.isDirectory()) {
                throw new InvalidWorkingDirException(dir);
            }
        } else {
            throw new InvalidWorkingDirException(dir);
        }
        this.m_sWorkingDir = dir;
    }

    @Override
    public Map getArchives() {
        return this.m_Archives;
    }

    @Override
    public Map getSettings() {
        return null;
    }

    @Override
    public Map getArchive(String name) {
        return (ConfigMap)this.m_Archives.get(name);
    }

    public boolean getLogArchive() {
        return this.m_bLogArchive;
    }

    public void setLogArchive(boolean bLog) {
        this.m_bLogArchive = bLog;
    }

    public boolean getLogDeploy() {
        return this.m_bLogDeploy;
    }

    public void setLogDeploy(Boolean bLog) {
        this.m_bLogDeploy = bLog;
    }

    @Override
    public Archive createArchive(String name) {
        Archive arc = new Archive(name, (ArchiveDeployService)this);
        arc.addConfigMapListener(this);
        arc.addConfigListListener(this);
        this.m_Archives.put(name, (Object)arc);
        return arc;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        PasswordUtils.getInstance().addObserver(this);
        this.isStarted = true;
    }

    @Override
    public void load() throws ServiceException {
        try {
            Map m = (Map)this.deserialize(this.file);
            ConfigMap tempArchives = (ConfigMap)m.get(ARCHIVE_KEY);
            if (this.isStarted) {
                this.m_Archives = new ConfigMap();
            }
            Set arcSet = tempArchives.entrySet();
            Iterator it = arcSet.iterator();
            Archive arc = null;
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                arc = new Archive((String)entry.getKey(), (Map)entry.getValue(), this);
                arc.addConfigMapListener(this);
                arc.addConfigListListener(this);
                this.m_Archives.put((String)entry.getKey(), (Object)arc);
            }
            this.m_Archives.init(this, ARCHIVE_KEY);
            this.m_Archives.setConfigMapListener(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        ConfigMap m = new ConfigMap();
        m.put(ARCHIVE_KEY, (Object)this.m_Archives);
        m.put(LOG_ARCHIVE_KEY, (Object)new Boolean(this.m_bLogArchive));
        m.put(LOG_DEPLOY_KEY, (Object)new Boolean(this.m_bLogDeploy));
        this.serialize(m, this.file);
    }

    private boolean isValidArchiveFileName(String fileName) {
        return Pattern.matches("(.+)[.]car$", fileName);
    }

    @Override
    public synchronized void archive(String name, String archiveFile) throws ServiceException {
        Object result = this.m_Archives.get(name);
        if (result == null || !(result instanceof Archive)) {
            throw new InvalidArchiveNameException(name);
        }
        Archive archive = (Archive)result;
        if (!this.isValidArchiveFileName(archiveFile)) {
            throw new Archive.InvalidArchiveFileException(archiveFile, "create");
        }
        archive.createArchive(archiveFile, this.m_bLogArchive);
    }

    @Override
    public synchronized boolean deploy(Archive arc) {
        return arc.deploy(this.m_bLogDeploy);
    }

    @Override
    public Archive retrieveArchive(String carFileName) {
        if (!this.isValidArchiveFileName(carFileName)) {
            throw new Archive.InvalidArchiveFileException(carFileName, "deploy");
        }
        File carFile = new File(carFileName);
        return new Archive(carFile, (ArchiveDeployService)this);
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
        }
    }

    String getSeed() {
        return this.seed;
    }

    public static class InvalidWorkingDirException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String dir;

        public InvalidWorkingDirException(String dir) {
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }
    }

    public static class InvalidArchiveNameException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String name;

        public InvalidArchiveNameException(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

