/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.bytecode;

import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CFBigInteger;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.util.WeakKeyCache;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

public class JavaAssembler {
    private ClassGen cg;
    private ConstantPoolGen cp;
    private InstructionFactory factory;
    private Map methodGens;
    private Map fieldGens;
    private MethodState ms;
    protected static final Object compileLock = new Object();
    private InstructionList clinitIl;
    private InstructionList initIl;
    public static final Class voidClass = Void.TYPE;
    public static final Class doubleClass = Double.TYPE;
    public static final Class longClass = Long.TYPE;
    public static final Class BooleanClass = Boolean.class;
    public static final Class booleanClass = Boolean.TYPE;
    public static final Class byteClass = Byte.TYPE;
    public static final Class shortClass = Short.TYPE;
    public static final Class charClass = Character.TYPE;
    public static final Class intClass = Integer.TYPE;
    public static final Class floatClass = Float.TYPE;
    public static final Class ClassClass = Class.class;
    public static final Class StringClass = String.class;
    public static final Class BigDecimalClass = BigDecimal.class;
    public static final Class CFBigDecimalClass = CFBigDecimal.class;
    public static final Class CFBigIntegerClass = CFBigInteger.class;
    public static final Class CFIntegerClass = CFInteger.class;
    public static final Class CFLongClass = CFLong.class;
    public static final Class CFDoubleClass = CFDouble.class;
    public static final Class ThrowableClass = Throwable.class;
    public static final Class CFBooleanClass = CFBoolean.class;
    public static final String SOURCE_MOD_TIME_ATTR = "com.macromedia.SourceModTime";
    static final Constructor newCFBigInteger = JavaAssembler.getConstructor(CFBigIntegerClass, new Class[]{StringClass});
    static final Constructor newCFInteger = JavaAssembler.getConstructor(CFIntegerClass, new Class[]{intClass, StringClass});
    static final Constructor newCFLong = JavaAssembler.getConstructor(CFLongClass, new Class[]{longClass, StringClass});
    static final Constructor newCFDouble = JavaAssembler.getConstructor(CFDoubleClass, new Class[]{doubleClass, StringClass});
    static final Constructor newCFBigDecimal = JavaAssembler.getConstructor(CFBigDecimalClass, new Class[]{StringClass});
    private ITable iTable = new ITable();
    private static final HashMap fieldTypeMap = new HashMap();
    private static final LabelInstruction LABEL;
    private static final WeakKeyCache typeCache;
    public static final Method classForName;

    public void startClass(String className, Class superClass, Class[] interfaces, String sourceFilename) {
        this.startClass(className, superClass, interfaces, sourceFilename, 17);
    }

    public void startClass(String className, String superClass, String[] interfaces, String sourceFilename, int modifiers) {
        this.cg = new ClassGen(className, superClass, sourceFilename, modifiers | 0x20, null);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.cg.addInterface(interfaces[i]);
            }
        }
        this.cp = this.cg.getConstantPool();
        this.factory = new InstructionFactory(this.cg);
        this.methodGens = new HashMap();
        this.fieldGens = new HashMap();
        this.clinitIl = new InstructionList();
        MethodGen clinitMg = new MethodGen(2048, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", this.cg.getClassName(), this.clinitIl, this.cp);
        this.initMethod(clinitMg);
        this.initIl = new InstructionList();
        this.initIl.append((Instruction)InstructionConstants.THIS);
        this.initIl.append((Instruction)new INVOKESPECIAL(this.cp.addMethodref(superClass, "<init>", "()V")));
        MethodGen initMg = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "<init>", className, this.initIl, this.cp);
        this.initMethod(initMg);
    }

    public void startClass(String className, Class superClass, Class[] interfaces, String sourceFilename, int modifiers) {
        String[] names = new String[interfaces.length];
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            names[i] = interfaces[i].getName();
        }
        this.startClass(className, superClass.getName(), names, sourceFilename, modifiers);
    }

    public void setSourceModified(long modTime) {
        int attrNameIndex = this.cp.addUtf8(SOURCE_MOD_TIME_ATTR);
        int modTimeIndex = this.cp.addLong(modTime);
        byte[] indexVals = new byte[]{(byte)(modTimeIndex >> 8), (byte)(modTimeIndex & 0xFF)};
        ConstantPool tempcp = this.cp.getConstantPool();
        Unknown sourceMod = new Unknown(attrNameIndex, indexVals.length, indexVals, tempcp);
        this.cg.addAttribute((Attribute)sourceMod);
    }

    public Object startMethod(String methodName, Class[] argTypes, String[] argNames, Class returnType, int modifiers) {
        return this.startMethod(methodName, argTypes, argNames, returnType, modifiers, new Class[0]);
    }

    public Object startMethod(String methodName, String[] argTypes, String[] argNames, String returnType, int modifiers, String[] exceptionTypes) {
        return this.startMethod(methodName, argTypes, argNames, returnType, modifiers, exceptionTypes, methodName);
    }

    public Object startMethod(String methodName, String[] argTypes, String[] argNames, String returnType, int modifiers, String[] exceptionTypes, String methodKey) {
        MethodGen methodGen = new MethodGen(modifiers, this.getType(returnType), this.getTypes(argTypes), argNames, methodName, this.cg.getClassName(), new InstructionList(), this.cp);
        for (int i = 0; exceptionTypes != null && i < exceptionTypes.length; ++i) {
            methodGen.addException(exceptionTypes[i]);
        }
        this.initMethod(methodGen, methodKey);
        return methodGen;
    }

    public Object startMethod(String methodName, Class[] argTypes, String[] argNames, Class returnType, int modifiers, Class[] exceptionTypes) {
        return this.startMethod(methodName, argTypes, argNames, returnType, modifiers, exceptionTypes, methodName);
    }

    public Object startMethod(String methodName, Class[] argTypes, String[] argNames, Class returnType, int modifiers, Class[] exceptionTypes, String methodKey) {
        String[] argTypeNames = new String[argTypes.length];
        int len = argTypes.length;
        for (int i = 0; i < len; ++i) {
            argTypeNames[i] = argTypes[i].getName();
        }
        String[] exTypeNames = new String[exceptionTypes.length];
        len = exTypeNames.length;
        for (int i = 0; i < len; ++i) {
            exTypeNames[i] = exceptionTypes[i].getName();
        }
        return this.startMethod(methodName, argTypeNames, argNames, returnType.getName(), modifiers, exTypeNames, methodKey);
    }

    public Object findMethod(String methodName) {
        return ((MethodState)this.methodGens.get((Object)methodName)).mg;
    }

    public void implementMethod(Method method, String[] argNames) {
        this.implementMethod(method, argNames, true);
    }

    public void implementMethod(Method method, String[] argNames, boolean makeFinal) {
        this.implementMethod(method, argNames, makeFinal, false);
    }

    public void implementMethod(Method method, String[] argNames, boolean makeFinal, boolean synchronizedFlag) {
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class[] argTypes = method.getParameterTypes();
        if (argTypes.length != argNames.length) {
            throw new IllegalArgumentException("argument name / type mismatch");
        }
        InstructionList il = new InstructionList();
        int flags = method.getModifiers() & 0xFFFFFBFF;
        if (makeFinal) {
            flags |= 0x10;
        }
        if (synchronizedFlag) {
            flags |= 0x20;
        }
        MethodGen mg = new MethodGen(flags, this.getType(returnType), this.getTypes(argTypes), argNames, methodName, this.cg.getClassName(), il, this.cp);
        this.initMethod(mg);
        this.setMethod(mg.getName());
    }

    private void initMethod(MethodGen mg) {
        this.initMethod(mg, mg.getName());
    }

    private void initMethod(MethodGen mg, String methodKey) {
        HashMap<String, LocalVariableGen> locals = new HashMap<String, LocalVariableGen>();
        LocalVariableGen[] lvs = mg.getLocalVariables();
        for (int i = 0; i < lvs.length; ++i) {
            LocalVariableGen local = lvs[i];
            locals.put(local.getName(), local);
        }
        MethodState ms = new MethodState(mg, locals);
        this.methodGens.put(methodKey, ms);
    }

    public String setMethod(String name) {
        String oldMethod = this.ms != null ? this.ms.mg.getName() : null;
        this.ms = (MethodState)this.methodGens.get(name);
        return oldMethod;
    }

    public Object findLocal(String name) {
        return this.ms.locals.get(name);
    }

    public Object createLocal(Class type) {
        return this.createLocal(type, "t" + this.ms.mg.getMaxLocals());
    }

    public Object createLocal(Class ctype, String name) {
        Type type = this.getType(ctype);
        LocalVariableGen local = this.ms.mg.addLocalVariable(name, type, null, null);
        this.ms.locals.put(name, local);
        return local;
    }

    public Object createField(Class type, String name, int modifiers) {
        if (name == null) {
            name = "t" + this.fieldGens.size();
        }
        FieldGen fg = new FieldGen(modifiers, this.getType(type), (String)name, this.cp);
        this.fieldGens.put(name, fg);
        this.cg.addField(fg.getField());
        return fg;
    }

    public Object findField(String name) {
        return this.fieldGens.get(name);
    }

    public byte[] getBytes() throws IOException {
        this.initIl.append((Instruction)InstructionConstants.RETURN);
        this.clinitIl.append((Instruction)InstructionConstants.RETURN);
        Iterator it = this.methodGens.values().iterator();
        while (it.hasNext()) {
            try {
                MethodState ms = (MethodState)it.next();
                ms.mg.setMaxStack();
                this.cg.addMethod(ms.mg.getMethod());
            }
            catch (ClassCastException ms) {}
        }
        byte[] bytes = this.cg.getJavaClass().getBytes();
        return bytes;
    }

    public Object vreturn() {
        return this.ms.il.append((Instruction)InstructionConstants.RETURN);
    }

    public Object areturn() {
        return this.ms.il.append((Instruction)InstructionConstants.ARETURN);
    }

    public Object ireturn() {
        return this.ms.il.append((Instruction)InstructionConstants.IRETURN);
    }

    public Object mreturn(Class type) {
        return this.ms.il.append((Instruction)InstructionFactory.createReturn((Type)this.getType(type)));
    }

    public Object mreturn(String type) {
        return this.ms.il.append((Instruction)InstructionFactory.createReturn((Type)this.getType(type)));
    }

    public Object invoke(Method method) {
        return this.ms.il.append(this.iTable.invoke(method));
    }

    public Object invokespecial(String className, String methodName) {
        String signature = Type.getMethodSignature((Type)Type.VOID, (Type[])new Type[0]);
        int index = this.cp.addMethodref(className, methodName, signature);
        INVOKESPECIAL i = new INVOKESPECIAL(index);
        return this.ms.il.append((Instruction)i);
    }

    public Object invokespecial(Method method) {
        return this.ms.il.append((Instruction)this.factory.createInvoke(method.getDeclaringClass().getName(), method.getName(), this.getType(method.getReturnType()), this.getTypes(method.getParameterTypes()), (short)183));
    }

    public Object invokeVoid(Method method) {
        Object label = this.invoke(method);
        this.cast(method.getReturnType(), voidClass);
        return label;
    }

    public Object invokespecial(Object method) {
        if (method instanceof Constructor) {
            return this.invokespecial((Constructor)method);
        }
        if (method instanceof Method) {
            return this.invokespecial((Method)method);
        }
        MethodGen methodGen = (MethodGen)method;
        return this.ms.il.append((Instruction)this.factory.createInvoke(methodGen.getClassName(), methodGen.getName(), methodGen.getReturnType(), methodGen.getArgumentTypes(), (short)183));
    }

    public Object newinstance(String className) {
        InstructionHandle label = this.ms.il.append((Instruction)this.factory.createNew(new ObjectType(className)));
        this.ms.il.append((Instruction)InstructionConstants.DUP);
        return label;
    }

    public Object newinstance(Class c) {
        InstructionHandle label = this.ms.il.append(this.iTable.newinstance(c));
        this.ms.il.append((Instruction)InstructionConstants.DUP);
        return label;
    }

    public Object startCatch(Object tryStart, Object tryEnd, Class exType) {
        Object exVar = this.createLocal(exType == null ? ThrowableClass : exType);
        this.ms.mg.addExceptionHandler((InstructionHandle)tryStart, (InstructionHandle)tryEnd, (InstructionHandle)this.store(exVar), (ObjectType)this.getType(exType));
        return exVar;
    }

    public void addExceptionHandlers(Object startObj, Object endObj, Class exType, Object exVarLbl, Object jumpGoto) {
        InstructionList il = this.ms.mg.getInstructionList();
        boolean isBroken = false;
        boolean startCheck = false;
        InstructionHandle tempStore = null;
        Iterator i = il.iterator();
        while (i.hasNext()) {
            InstructionHandle ih = (InstructionHandle)i.next();
            if (!isBroken) {
                tempStore = (InstructionHandle)startObj;
            }
            if (!startCheck && ih == startObj) {
                startCheck = true;
            }
            if (ih == endObj) {
                if (tempStore == endObj) break;
                if (((InstructionHandle)endObj).getInstruction() instanceof GOTO) {
                    ih = ih.getPrev();
                }
                this.ms.mg.addExceptionHandler(tempStore, ih, (InstructionHandle)exVarLbl, (ObjectType)this.getType(exType));
                break;
            }
            if (!startCheck || !i.hasNext() || ih.getNext() == null || !(ih.getNext().getInstruction() instanceof ReturnInstruction) && !(ih.getInstruction() instanceof GOTO)) continue;
            InstructionHandle tempHolder = null;
            tempHolder = ih.getNext().getInstruction() instanceof ReturnInstruction ? ih.getPrev() : ih;
            if (ih.getInstruction() instanceof GOTO) {
                boolean breakForGoto = false;
                InstructionHandle gotoTarget = ((BranchInstruction)ih.getInstruction()).getTarget();
                InstructionTargeter[] t = ((InstructionHandle)jumpGoto).getTargeters();
                for (int ind = 0; t != null && ind < t.length; ++ind) {
                    if (!t[ind].containsTarget(gotoTarget)) continue;
                    breakForGoto = true;
                }
                if (!breakForGoto) continue;
                tempHolder = ih.getPrev();
            } else if (tempHolder.getInstruction() instanceof JsrInstruction) {
                tempHolder = tempHolder.getPrev();
            }
            this.ms.mg.addExceptionHandler(tempStore, tempHolder, (InstructionHandle)exVarLbl, (ObjectType)this.getType(exType));
            isBroken = true;
            if (ih.getNext().getInstruction() instanceof ReturnInstruction) {
                tempStore = (InstructionHandle)i.next();
                if (!i.hasNext()) break;
                tempStore = (InstructionHandle)i.next();
                while (tempStore.getInstruction() instanceof LabelInstruction && i.hasNext()) {
                    tempStore = (InstructionHandle)i.next();
                }
            } else {
                tempStore = (InstructionHandle)i.next();
                while (tempStore.getInstruction() instanceof LabelInstruction && i.hasNext()) {
                    tempStore = (InstructionHandle)i.next();
                }
            }
            if (tempStore != endObj) continue;
            break;
        }
    }

    public Object invokespecial(Constructor ctor) {
        return this.ms.il.append(this.iTable.invoke(ctor));
    }

    public Object dup(Class type) {
        if (this.is2(type)) {
            return this.ms.il.append((Instruction)InstructionConstants.DUP2);
        }
        return this.ms.il.append((Instruction)InstructionConstants.DUP);
    }

    public Object dup() {
        return this.ms.il.append((Instruction)InstructionConstants.DUP);
    }

    public Object dup2() {
        return this.ms.il.append((Instruction)InstructionConstants.DUP2);
    }

    private boolean is2(Class type) {
        return type == doubleClass || type == longClass;
    }

    public Object aconst(Object value) {
        if (value instanceof Class) {
            return this.cconst((Class)value);
        }
        if (value instanceof String || value == null) {
            return this.ms.il.append(this.iTable.push((String)value));
        }
        if (value instanceof Double) {
            return this.dconst((Double)value);
        }
        if (value instanceof Long) {
            return this.ms.il.append(this.iTable.push((Long)value));
        }
        if (value instanceof Float) {
            return this.ms.il.append(this.iTable.push(((Float)value).floatValue()));
        }
        if (value instanceof CFInteger) {
            Object label = this.newinstance(CFIntegerClass);
            this.aconst(((CFInteger)value).intValue());
            this.aconst(((CFInteger)value).toString());
            this.invokespecial(newCFInteger);
            return label;
        }
        if (value instanceof CFLong) {
            Object label = this.newinstance(CFLongClass);
            this.aconst(((CFLong)value).longValue());
            this.aconst(((CFLong)value).toString());
            this.invokespecial(newCFLong);
            return label;
        }
        if (value instanceof CFBigInteger) {
            Object label = this.newinstance(CFBigIntegerClass);
            this.aconst(((CFBigInteger)value).toString());
            this.invokespecial(newCFBigInteger);
            return label;
        }
        if (value instanceof CFDouble) {
            Object label = this.newinstance(CFDoubleClass);
            this.aconst(((CFDouble)value).doubleValue());
            this.aconst(((CFDouble)value).toString());
            this.invokespecial(newCFDouble);
            return label;
        }
        if (value instanceof CFBigDecimal) {
            Object label = this.newinstance(CFBigDecimalClass);
            this.aconst(((CFBigDecimal)value).toString());
            this.invokespecial(newCFBigDecimal);
            return label;
        }
        if (value instanceof Number) {
            return this.iconst(((Number)value).intValue());
        }
        if (value instanceof Boolean) {
            return this.zconst((Boolean)value);
        }
        if (value instanceof CFBoolean) {
            String fName = ((CFBoolean)value).value ? "t" : "f";
            return this.getstatic(JavaAssembler.getStaticField(CFBooleanClass, fName + "_" + ((CFBoolean)value).image));
        }
        if (value instanceof Character) {
            return this.ms.il.append(this.iTable.push(((Character)value).charValue()));
        }
        if (value instanceof LocalVariableGen) {
            return this.load(value);
        }
        throw new UnsupportedOperationException("cannot push a " + value);
    }

    private Object cconst(Class value) {
        if (value.isPrimitive()) {
            Field field = (Field)fieldTypeMap.get(value);
            return this.ms.il.append((Instruction)this.factory.createGetStatic(field.getDeclaringClass().getName(), field.getName(), this.getType(ClassClass)));
        }
        String name = "class$" + value.getName().replace('.', '$');
        org.apache.bcel.classfile.Field field = this.cg.containsField(name);
        if (field == null) {
            FieldGen fg = new FieldGen(24, this.getType(ClassClass), name, this.cp);
            field = fg.getField();
            this.cg.addField(field);
            this.clinitIl.append((CompoundInstruction)new PUSH(this.cp, value.getName()));
            this.clinitIl.append((Instruction)this.factory.createInvoke(ClassClass.getName(), "forName", this.getType(ClassClass), this.getTypes(new Class[]{StringClass}), (short)184));
            this.clinitIl.append((Instruction)this.factory.createPutStatic(this.cg.getClassName(), fg.getName(), fg.getType()));
        }
        return this.ms.il.append((Instruction)this.factory.createGetStatic(this.cg.getClassName(), name, this.getType(ClassClass)));
    }

    public Object iconst(int value) {
        return this.ms.il.append(this.iTable.push(value));
    }

    public Object dconst(double value) {
        return this.ms.il.append(this.iTable.push(value));
    }

    public Object zconst(boolean value) {
        Instruction i = value ? InstructionConstants.ICONST_1 : InstructionConstants.ICONST_0;
        return this.ms.il.append(i);
    }

    public Object nullconst() {
        return this.ms.il.append(InstructionConstants.ACONST_NULL);
    }

    public Object pop(Class type) {
        if (this.is2(type)) {
            return this.ms.il.append((Instruction)InstructionConstants.POP2);
        }
        return this.ms.il.append((Instruction)InstructionConstants.POP);
    }

    public Object getstatic(Object var) {
        if (var instanceof Field) {
            Field f = (Field)var;
            return this.ms.il.append((Instruction)this.factory.createGetStatic(f.getDeclaringClass().getName(), f.getName(), this.getType(f.getType())));
        }
        if (var instanceof FieldGen) {
            FieldGen f = (FieldGen)var;
            return this.ms.il.append((Instruction)this.factory.createGetStatic(this.cg.getClassName(), f.getName(), f.getType()));
        }
        throw new UnsupportedOperationException("can't load a " + (var == null ? null : var.getClass()));
    }

    public Object load(Object var) {
        if (var instanceof LocalVariableGen) {
            LocalVariableGen local = (LocalVariableGen)var;
            return this.ms.il.append((Instruction)InstructionFactory.createLoad((Type)local.getType(), (int)local.getIndex()));
        }
        throw new UnsupportedOperationException("can't load a " + (var == null ? null : var.getClass()));
    }

    public Object loadInstruction(Instruction instr) {
        return this.ms.il.append(instr);
    }

    public Object getstatic(String className, String fieldName, Class type) {
        return this.ms.il.append((Instruction)this.factory.createGetStatic(className, fieldName, this.getType(type)));
    }

    public Object getfield(String fieldName, Class type) {
        return this.ms.il.append((Instruction)this.factory.createGetField(this.cg.getClassName(), fieldName, this.getType(type)));
    }

    public Object getfield(Object var) {
        if (var instanceof Field) {
            return this.ms.il.append(this.iTable.getfield((Field)var));
        }
        if (var instanceof FieldGen) {
            return this.ms.il.append(this.iTable.getfield((FieldGen)var));
        }
        throw new UnsupportedOperationException("can't load a " + (var == null ? null : var.getClass()));
    }

    public Object store(Object var) {
        if (var instanceof LocalVariableGen) {
            LocalVariableGen local = (LocalVariableGen)var;
            return this.ms.il.append((Instruction)InstructionFactory.createStore((Type)local.getType(), (int)local.getIndex()));
        }
        if (var == null) {
            throw new UnsupportedOperationException("null var passed to store()");
        }
        throw new UnsupportedOperationException("cant store a " + var.getClass());
    }

    public Object putfield(Object var) {
        if (var instanceof Field) {
            Field f = (Field)var;
            return this.ms.il.append((Instruction)this.factory.createPutField(f.getDeclaringClass().getName(), f.getName(), this.getType(f.getType())));
        }
        if (var instanceof FieldGen) {
            FieldGen f = (FieldGen)var;
            return this.ms.il.append((Instruction)this.factory.createPutField(this.cg.getClassName(), f.getName(), f.getType()));
        }
        if (var == null) {
            throw new UnsupportedOperationException("null var passed to putfield()");
        }
        throw new UnsupportedOperationException("cant use putfield with a " + var.getClass());
    }

    public Object putstatic(Object var) {
        if (var instanceof Field) {
            Field f = (Field)var;
            return this.ms.il.append((Instruction)this.factory.createPutStatic(f.getDeclaringClass().getName(), f.getName(), this.getType(f.getType())));
        }
        if (var instanceof FieldGen) {
            FieldGen f = (FieldGen)var;
            return this.ms.il.append((Instruction)this.factory.createPutStatic(this.cg.getClassName(), f.getName(), f.getType()));
        }
        if (var == null) {
            throw new UnsupportedOperationException("null var passed to putstatic()");
        }
        throw new UnsupportedOperationException("cant use putstatic with a " + var.getClass());
    }

    public Object xor(Class type) {
        if (this.is2(type)) {
            return this.ms.il.append((Instruction)InstructionConstants.LXOR);
        }
        return this.ms.il.append((Instruction)InstructionConstants.IXOR);
    }

    public Object ixor1() {
        InstructionHandle label = this.ms.il.append(InstructionConstants.ICONST_1);
        this.ms.il.append((Instruction)InstructionConstants.IXOR);
        return label;
    }

    public Object ior() {
        return this.ms.il.append((Instruction)InstructionConstants.IOR);
    }

    public Object iand1() {
        InstructionHandle label = this.ms.il.append(InstructionConstants.ICONST_1);
        this.ms.il.append((Instruction)InstructionConstants.IAND);
        return label;
    }

    public Object iushr(int nbits) {
        Object label = this.iconst(nbits);
        this.ms.il.append((Instruction)InstructionConstants.IUSHR);
        return label;
    }

    public Object dcmpl0() {
        InstructionHandle label = this.ms.il.append(InstructionConstants.DCONST_0);
        this.ms.il.append(InstructionConstants.DCMPL);
        return label;
    }

    public Object dcmpl() {
        return this.ms.il.append(InstructionConstants.DCMPL);
    }

    public Object dcmpg() {
        return this.ms.il.append(InstructionConstants.DCMPG);
    }

    public Object dcmpg0() {
        InstructionHandle label = this.ms.il.append(InstructionConstants.DCONST_0);
        this.ms.il.append(InstructionConstants.DCMPG);
        return label;
    }

    public Object fcmpl0() {
        InstructionHandle label = this.ms.il.append(InstructionConstants.FCONST_0);
        this.ms.il.append(InstructionConstants.FCMPL);
        return label;
    }

    public void cast(String className) {
        if ("java.lang.Object".equals(className)) {
            return;
        }
        this.ms.il.append(this.factory.createCast(this.getType("java.lang.Object"), this.getType(className)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cast(Class from, Class to) {
        if (from.equals(to)) {
            return;
        }
        if (from.isPrimitive() && to.isPrimitive()) {
            if (to == booleanClass) {
                if (from == doubleClass) {
                    this.dcmpl0();
                    this.iand1();
                    return;
                } else if (from == floatClass) {
                    this.fcmpl0();
                    this.iand1();
                    return;
                } else if (from == longClass) {
                    this.ms.il.append((Instruction)InstructionConstants.L2F);
                    this.fcmpl0();
                    this.iand1();
                    return;
                } else {
                    this.ms.il.append((Instruction)InstructionConstants.I2F);
                    this.fcmpl0();
                    this.iand1();
                }
                return;
            } else {
                this.ms.il.append(this.factory.createCast(this.getType(from), this.getType(to)));
            }
            return;
        } else {
            if (from.isPrimitive() || to.isPrimitive()) throw new UnsupportedOperationException("cannot convert " + from.getName() + " to " + to.getName());
            if (to.isAssignableFrom(from)) return;
            if (!from.isAssignableFrom(to)) throw new UnsupportedOperationException("cannot convert " + from.getName() + " to " + to.getName());
            this.ms.il.append(this.factory.createCast(this.getType(from), this.getType(to)));
        }
    }

    public void setTarget(Object label, Object target) {
        InstructionHandle ih = (InstructionHandle)label;
        Instruction ins = ih.getInstruction();
        if (!(ins instanceof BranchInstruction)) {
            ins = ih.getNext().getInstruction();
        }
        ((BranchInstruction)ins).setTarget((InstructionHandle)target);
    }

    public Object ifne(Object target) {
        IFNE i = new IFNE((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ificmpne(int value, Object target) {
        if (value != 0) {
            Object label = this.iconst(value);
            IF_ICMPNE i = new IF_ICMPNE((InstructionHandle)target);
            this.ms.il.append((BranchInstruction)i);
            return label;
        }
        return this.ifne(target);
    }

    public Object ifacmpne(Object value, Object target) {
        Object label = this.aconst(value);
        IF_ACMPNE i = new IF_ACMPNE((InstructionHandle)target);
        this.ms.il.append((BranchInstruction)i);
        return label;
    }

    public Object ifeq(Object target) {
        IFEQ i = new IFEQ((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object instanceOf(Class className) {
        int index = this.cp.addClass(className.getName());
        return this.ms.il.append((Instruction)new INSTANCEOF(index));
    }

    public Object iflt(Object target) {
        IFLT i = new IFLT((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ifle(Object target) {
        IFLE i = new IFLE((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ifgt(Object target) {
        IFGT i = new IFGT((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ifge(Object target) {
        IFGE i = new IFGE((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ificmpeq(int value, Object target) {
        if (value != 0) {
            Object label = this.iconst(value);
            IF_ICMPEQ i = new IF_ICMPEQ((InstructionHandle)target);
            this.ms.il.append((BranchInstruction)i);
            return label;
        }
        return this.ifeq(target);
    }

    public Object ificmplt(Object target) {
        IF_ICMPLT i = new IF_ICMPLT((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ifacmpeq(Object value, Object target) {
        this.aconst(value);
        IF_ACMPEQ i = new IF_ACMPEQ((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ifnull(Object target) {
        return this.ms.il.append((BranchInstruction)new IFNULL((InstructionHandle)target));
    }

    public Object ifnonNull(Object target) {
        return this.ms.il.append((BranchInstruction)new IFNONNULL((InstructionHandle)target));
    }

    public Object jmp(Object target) {
        GOTO i = new GOTO((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object jsr(Object target) {
        JSR i = new JSR((InstructionHandle)target);
        return this.ms.il.append((BranchInstruction)i);
    }

    public Object ret(Object retAddrVar) {
        LocalVariableGen local = (LocalVariableGen)retAddrVar;
        RET i = new RET(local.getIndex());
        return this.ms.il.append((Instruction)i);
    }

    public Object tableswitch() {
        return this.label();
    }

    public void setSwitchTargets(Object label, int[] values, Object[] targets, Object defaultTarget) {
        InstructionHandle switchHandle = (InstructionHandle)label;
        InstructionHandle endHandle = (InstructionHandle)defaultTarget;
        InstructionHandle[] targetHandles = new InstructionHandle[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            targetHandles[i] = (InstructionHandle)targets[i];
        }
        Object i = targetHandles.length == 0 ? new LOOKUPSWITCH(values, targetHandles, endHandle) : new TABLESWITCH(values, targetHandles, endHandle);
        this.ms.il.append(switchHandle, (BranchInstruction)i);
    }

    public Object label() {
        return this.ms.il.append((Instruction)LABEL);
    }

    public Object athrow() {
        return this.ms.il.append(InstructionConstants.ATHROW);
    }

    public Object add(Class type) {
        if (type == doubleClass) {
            return this.ms.il.append((Instruction)InstructionConstants.DADD);
        }
        if (type == floatClass) {
            return this.ms.il.append((Instruction)InstructionConstants.FADD);
        }
        if (type == longClass) {
            return this.ms.il.append((Instruction)InstructionConstants.LADD);
        }
        return this.ms.il.append((Instruction)InstructionConstants.IADD);
    }

    public Object dadd() {
        return this.ms.il.append((Instruction)InstructionConstants.DADD);
    }

    public Object sub(Class type) {
        if (type == doubleClass) {
            return this.ms.il.append((Instruction)InstructionConstants.DSUB);
        }
        if (type == floatClass) {
            return this.ms.il.append((Instruction)InstructionConstants.FSUB);
        }
        if (type == longClass) {
            return this.ms.il.append((Instruction)InstructionConstants.LSUB);
        }
        return this.ms.il.append((Instruction)InstructionConstants.ISUB);
    }

    public Object mul(Class type) {
        if (type == doubleClass) {
            return this.ms.il.append((Instruction)InstructionConstants.DMUL);
        }
        if (type == floatClass) {
            return this.ms.il.append((Instruction)InstructionConstants.FMUL);
        }
        if (type == longClass) {
            return this.ms.il.append((Instruction)InstructionConstants.LMUL);
        }
        return this.ms.il.append((Instruction)InstructionConstants.IMUL);
    }

    public Object neg(Class type) {
        if (type == doubleClass) {
            return this.ms.il.append((Instruction)InstructionConstants.DNEG);
        }
        if (type == floatClass) {
            return this.ms.il.append((Instruction)InstructionConstants.FNEG);
        }
        if (type == longClass) {
            return this.ms.il.append((Instruction)InstructionConstants.LNEG);
        }
        return this.ms.il.append((Instruction)InstructionConstants.INEG);
    }

    public Object ineg() {
        return this.ms.il.append((Instruction)InstructionConstants.INEG);
    }

    public Object newarray(Class componentType, int length) {
        Object label = this.iconst(length);
        if (componentType.isPrimitive()) {
            NEWARRAY i = new NEWARRAY((BasicType)this.getType(componentType));
            this.ms.il.append((Instruction)i);
        } else {
            ANEWARRAY i = new ANEWARRAY(this.cp.addClass((ObjectType)this.getType(componentType)));
            this.ms.il.append((Instruction)i);
        }
        return label;
    }

    public Object aastore() {
        return this.ms.il.append((Instruction)InstructionConstants.AASTORE);
    }

    private Type getType(Class c) {
        if (c == null) {
            return null;
        }
        return (Type)typeCache.get(c);
    }

    private Type getType(String c) {
        if (c == null) {
            return null;
        }
        return (Type)typeCache.get(c);
    }

    private Type[] getTypes(Class[] c) {
        Type[] types = new Type[c.length];
        for (int i = 0; i < c.length; ++i) {
            types[i] = this.getType(c[i]);
        }
        return types;
    }

    private Type[] getTypes(String[] c) {
        Type[] types = new Type[c.length];
        for (int i = 0; i < c.length; ++i) {
            types[i] = this.getType(c[i]);
        }
        return types;
    }

    public static Constructor getConstructor(Class c, Class[] argTypes) {
        try {
            return c.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public static Method getStaticMethod(Class c, String name, Class[] argTypes) {
        try {
            Method m = c.getMethod(name, argTypes);
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException("expected " + m + " to be static");
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public static Method getInstanceMethod(Class c, String name, Class[] argTypes) {
        try {
            Method m = c.getMethod(name, argTypes);
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException("did not expect " + m + " to be static");
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(c.getName() + "." + name + "()");
        }
    }

    public static Method getDeclaredMethod(Class c, String name, Class[] argTypes) {
        try {
            Method m = c.getDeclaredMethod(name, argTypes);
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException("did not expect " + m + " to be static");
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(c.getName() + "." + name + "()");
        }
    }

    public static Field getDeclaredField(Class c, String name) {
        try {
            Field f = c.getDeclaredField(name);
            if (Modifier.isStatic(f.getModifiers())) {
                throw new IllegalStateException("did not expect " + f + " to be static");
            }
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
    }

    public static Field getInstanceField(Class c, String name) {
        try {
            Field f = c.getField(name);
            if (Modifier.isStatic(f.getModifiers())) {
                throw new IllegalStateException("did not expect " + f + " to be static");
            }
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
    }

    public static Field getStaticField(Class c, String name) {
        try {
            Field f = c.getField(name);
            if (!Modifier.isStatic(f.getModifiers())) {
                throw new IllegalStateException("expected " + f + " to be static");
            }
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
    }

    public void addLineNumber(Object label, int line) {
        if (label == null) {
            throw new NullPointerException();
        }
        if (line > 0) {
            this.ms.mg.addLineNumber((InstructionHandle)label, line);
        }
    }

    static {
        try {
            fieldTypeMap.put(voidClass, Void.class.getField("TYPE"));
            fieldTypeMap.put(booleanClass, Boolean.class.getField("TYPE"));
            fieldTypeMap.put(byteClass, Byte.class.getField("TYPE"));
            fieldTypeMap.put(shortClass, Short.class.getField("TYPE"));
            fieldTypeMap.put(charClass, Character.class.getField("TYPE"));
            fieldTypeMap.put(intClass, Integer.class.getField("TYPE"));
            fieldTypeMap.put(longClass, Long.class.getField("TYPE"));
            fieldTypeMap.put(floatClass, Float.class.getField("TYPE"));
            fieldTypeMap.put(doubleClass, Double.class.getField("TYPE"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        LABEL = new LabelInstruction();
        typeCache = new WeakKeyCache(){

            @Override
            protected Object fetch(Object key) {
                return this.convert(key);
            }

            private Type convert(Object type) {
                int index;
                if (type == voidClass || "void".equals(type)) {
                    return Type.VOID;
                }
                if (type == byteClass || "byte".equals(type)) {
                    return Type.BYTE;
                }
                if (type == shortClass || "short".equals(type)) {
                    return Type.SHORT;
                }
                if (type == intClass || "int".equals(type)) {
                    return Type.INT;
                }
                if (type == longClass || "long".equals(type)) {
                    return Type.LONG;
                }
                if (type == charClass || "char".equals(type)) {
                    return Type.CHAR;
                }
                if (type == floatClass || "float".equals(type)) {
                    return Type.FLOAT;
                }
                if (type == doubleClass || "double".equals(type)) {
                    return Type.DOUBLE;
                }
                if (type == booleanClass || "boolean".equals(type)) {
                    return Type.BOOLEAN;
                }
                if (type instanceof Class && ((Class)type).isArray()) {
                    return new ArrayType(this.convert(((Class)type).getComponentType()), 1);
                }
                if (type instanceof String && (index = ((String)type).indexOf("[]")) != -1) {
                    return new ArrayType(this.convert(((String)type).substring(0, index)), 1);
                }
                return new ObjectType(type instanceof Class ? ((Class)type).getName() : (String)type);
            }
        };
        classForName = JavaAssembler.getStaticMethod(ClassClass, "forName", new Class[]{StringClass});
    }

    private class ITable
    extends HashMap {
        private ITable() {
        }

        Instruction newinstance(Class c) {
            Instruction ins = (Instruction)this.get(c);
            if (ins == null) {
                ins = JavaAssembler.this.factory.createNew((ObjectType)JavaAssembler.this.getType(c));
                this.put(c, ins);
            }
            return ins;
        }

        Instruction invoke(Constructor ctor) {
            Instruction ins = (Instruction)this.get(ctor);
            if (ins == null) {
                Class[] paramTypes = ctor.getParameterTypes();
                Class declaringClass = ctor.getDeclaringClass();
                ins = JavaAssembler.this.factory.createInvoke(declaringClass.getName(), "<init>", (Type)Type.VOID, JavaAssembler.this.getTypes(paramTypes), (short)183);
                this.put(ctor, ins);
            }
            return ins;
        }

        Instruction invoke(Method method) {
            InvokeInstruction ins = (InvokeInstruction)this.get(method);
            if (ins == null) {
                Class<?> declaringClass = method.getDeclaringClass();
                ins = Modifier.isStatic(method.getModifiers()) ? JavaAssembler.this.factory.createInvoke(declaringClass.getName(), method.getName(), JavaAssembler.this.getType(method.getReturnType()), JavaAssembler.this.getTypes(method.getParameterTypes()), (short)184) : (Modifier.isPrivate(method.getModifiers()) ? JavaAssembler.this.factory.createInvoke(declaringClass.getName(), method.getName(), JavaAssembler.this.getType(method.getReturnType()), JavaAssembler.this.getTypes(method.getParameterTypes()), (short)183) : (declaringClass.isInterface() ? JavaAssembler.this.factory.createInvoke(declaringClass.getName(), method.getName(), JavaAssembler.this.getType(method.getReturnType()), JavaAssembler.this.getTypes(method.getParameterTypes()), (short)185) : JavaAssembler.this.factory.createInvoke(declaringClass.getName(), method.getName(), JavaAssembler.this.getType(method.getReturnType()), JavaAssembler.this.getTypes(method.getParameterTypes()), (short)182)));
                this.put(method, ins);
            }
            return ins;
        }

        Instruction getfield(Field f) {
            Instruction ins = (Instruction)this.get(f);
            if (ins == null) {
                ins = JavaAssembler.this.factory.createGetField(f.getDeclaringClass().getName(), f.getName(), JavaAssembler.this.getType(f.getType()));
                this.put(f, ins);
            }
            return ins;
        }

        Instruction getfield(FieldGen fg) {
            Instruction ins = (Instruction)this.get(fg);
            if (ins == null) {
                ins = JavaAssembler.this.factory.createGetField(JavaAssembler.this.cg.getClassName(), fg.getName(), fg.getType());
                this.put(fg, ins);
            }
            return ins;
        }

        Instruction push(int v) {
            switch (v) {
                case -1: {
                    return InstructionConstants.ICONST_M1;
                }
                case 0: {
                    return InstructionConstants.ICONST_0;
                }
                case 1: {
                    return InstructionConstants.ICONST_1;
                }
                case 2: {
                    return InstructionConstants.ICONST_2;
                }
                case 3: {
                    return InstructionConstants.ICONST_3;
                }
                case 4: {
                    return InstructionConstants.ICONST_4;
                }
                case 5: {
                    return InstructionConstants.ICONST_5;
                }
            }
            Integer value = new Integer(v);
            Object ins = (Instruction)this.get(value);
            if (ins == null) {
                ins = v >= -128 && v <= 127 ? new BIPUSH((byte)v) : (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE ? new SIPUSH((short)v) : new LDC(JavaAssembler.this.cp.addInteger(v)));
                this.put(value, ins);
            }
            return ins;
        }

        Instruction push(double v) {
            if (v == 0.0) {
                return InstructionConstants.DCONST_0;
            }
            if (v == 1.0) {
                return InstructionConstants.DCONST_1;
            }
            Double value = new Double(v);
            Instruction ins = (Instruction)this.get(value);
            if (ins == null) {
                ins = new LDC2_W(JavaAssembler.this.cp.addDouble(v));
                this.put(value, ins);
            }
            return ins;
        }

        Instruction push(long v) {
            if (v == 0L) {
                return InstructionConstants.LCONST_0;
            }
            if (v == 1L) {
                return InstructionConstants.LCONST_1;
            }
            Long value = new Long(v);
            Instruction ins = (Instruction)this.get(value);
            if (ins == null) {
                ins = new LDC2_W(JavaAssembler.this.cp.addLong(v));
                this.put(value, ins);
            }
            return ins;
        }

        Instruction push(float v) {
            if (v == 0.0f) {
                return InstructionConstants.FCONST_0;
            }
            if (v == 1.0f) {
                return InstructionConstants.FCONST_1;
            }
            Float value = new Float(v);
            Instruction ins = (Instruction)this.get(value);
            if (ins == null) {
                ins = new LDC2_W(JavaAssembler.this.cp.addFloat(v));
                this.put(value, ins);
            }
            return ins;
        }

        Instruction push(String value) {
            if (value == null) {
                return InstructionConstants.ACONST_NULL;
            }
            Instruction ins = (Instruction)this.get(value);
            if (ins == null) {
                ins = new LDC(JavaAssembler.this.cp.addString(value));
            }
            return ins;
        }
    }

    private class MethodState {
        MethodGen mg;
        Map locals;
        InstructionList il;

        public MethodState(MethodGen mg, Map locals) {
            this.mg = mg;
            this.locals = locals;
            this.il = mg.getInstructionList();
        }
    }

    private static class LabelInstruction
    extends Instruction {
        LabelInstruction() {
            super((short)0, (short)0);
        }

        public void accept(Visitor v) {
        }

        public void dump(DataOutputStream out) throws IOException {
        }

        public int consumeStack(ConstantPoolGen cpg) {
            return 0;
        }

        public int produceStack(ConstantPoolGen cpg) {
            return 0;
        }

        public String toString(boolean verbose) {
            return "Label";
        }

        public Instruction copy() {
            return this;
        }
    }
}

