/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.centralconfig.client;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.centralconfig.client.CentralConfigRefreshServlet;
import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class CFConfigFilesWatcher
implements Runnable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            WatchKey key;
            WatchService watchService = FileSystems.getDefault().newWatchService();
            String lib = ServiceFactory.getRuntimeService().getLibDir();
            Path path = Paths.get(lib + File.separator, new String[0]);
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            while ((key = watchService.take()) != null) {
                try {
                    block9: for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed = (Path)event.context();
                        String filePath = changed.toFile().getAbsolutePath();
                        for (String cfsettingfile : CentralConfigClientUtil.cfSettingsFiles) {
                            if (!filePath.endsWith(cfsettingfile)) continue;
                            if (!this.isAllowed(cfsettingfile)) continue block9;
                            File file = new File(lib + File.separator + changed);
                            if (this.fileModifiedByCFAndNotCFSetup(file)) continue;
                            Thread.sleep(100L);
                            Path filepath = Paths.get(file.getAbsolutePath(), new String[0]);
                            String data = Files.readAllLines(filepath).get(0);
                            if (this.fileModifiedByCFAndNotCFSetup(file)) continue;
                            CentralConfigClientUtil.pushToCCS(file.getName(), data, (Object)("cfsetup_" + cfsettingfile), null, null);
                            CentralConfigRefreshServlet.reloadModule(cfsettingfile, "", false);
                            continue block9;
                        }
                    }
                }
                catch (Throwable e) {
                    CFLogs.SERVER_LOG.error(e);
                }
                finally {
                    key.reset();
                }
            }
        }
        catch (InterruptedException watchService) {
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private boolean isAllowed(String cfsettingfile) {
        return !cfsettingfile.equals("neo_updates.xml") && !cfsettingfile.equals("license.properties");
    }

    private boolean fileModifiedByCFAndNotCFSetup(File file) {
        String lastModified = "" + file.lastModified();
        return lastModified.endsWith("0000");
    }
}

