/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.centralconfig.client;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.log.CFLogs;
import coldfusion.rest.utils.RESTPathUpdate;
import coldfusion.runtime.ServletConfigWrapper;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.UpdateService;
import com.restfb.json.JsonObject;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class CentralConfigRefreshServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (!this.validateRequest(request)) {
                this.sendError(response);
                return;
            }
            this.initPort(request.getServerPort());
            this.initContext(request);
            if (!CentralConfigClientUtil.isCCSAvailaible()) {
                return;
            }
            if (!this.validateHost(request)) {
                this.sendError(response);
                return;
            }
            if (this.sameServer(request)) {
                return;
            }
            this.doButtonAction(request);
            this.doNeoAction(request);
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
    }

    private boolean sameServer(HttpServletRequest request) {
        int serverId = Integer.parseInt(request.getParameter("serverid"));
        return serverId == ServiceBase.serverId;
    }

    private void doNeoAction(HttpServletRequest request) throws Exception {
        if (!CentralConfigClientUtil.getCurrentVersion().equals("-1")) {
            return;
        }
        String module = request.getParameter("module");
        String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        if (module != null) {
            CentralConfigRefreshServlet.reloadModule(module, body, false);
        }
    }

    private void doButtonAction(HttpServletRequest request) {
        String action = request.getParameter("action");
        if (action != null) {
            if (action.equals("clearcomponentcache")) {
                ServiceFactory.getRuntimeService().clearComponentCache(false);
            } else if (action.equals("clearfoldercache")) {
                String param = request.getParameter("param1");
                ServiceFactory.getRuntimeService().clearTemplateFolderFromCache(param, false);
            } else if (action.equals("cleartrustedcache")) {
                ServiceFactory.getRuntimeService().clearTrustedCache(false);
            } else if (action.equals("clearquerycache")) {
                ServiceFactory.getDataSourceService().purgeQueryCache(false);
            } else if (action.equals("updaterestpath")) {
                String param = request.getParameter("param1");
                String webxml = request.getServletContext().getRealPath("/WEB-INF") + File.separator + "web.xml";
                RESTPathUpdate.updateWebXml(webxml, param, false);
            }
        }
    }

    private void initPort(int port) {
        CentralConfigClientUtil.initHostport(port);
    }

    private void initHostname(HttpServletRequest request) {
        String hostname = request.getParameter("hostname");
        CentralConfigClientUtil.initHostname(hostname);
    }

    private boolean validateHost(HttpServletRequest request) {
        String hostName = request.getRemoteHost();
        InetAddress requestServer = null;
        try {
            requestServer = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        if (requestServer.isLoopbackAddress() || requestServer.isAnyLocalAddress() || requestServer.isSiteLocalAddress()) {
            return true;
        }
        if (hostName.equalsIgnoreCase(CentralConfigClientUtil.getHostName())) {
            return true;
        }
        CFLogs.SERVER_LOG.error("Hostname from request is : " + hostName + " and hostname fetched from CCS is : " + CentralConfigClientUtil.getHostName() + ". CCS server name is  : " + CentralConfigClientUtil.getServer());
        CFLogs.SERVER_LOG.error(new UnknownHostException());
        return false;
    }

    private boolean validateRequest(HttpServletRequest request) {
        String secretKey = request.getParameter("secretkey");
        return secretKey != null && secretKey.equals(CentralConfigClientUtil.getSecretKey());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (!this.validateRequest(request)) {
                this.sendError(response);
                return;
            }
            this.initPort(request.getServerPort());
            this.initContext(request);
            if (!this.validateHost(request)) {
                this.sendError(response);
                return;
            }
            String action = request.getParameter("action");
            if (null != action) {
                if (action.equals("metadata")) {
                    JsonObject jobj = new JsonObject();
                    jobj.put("currentversion", (Object)CentralConfigClientUtil.getLoadVersionFrom());
                    jobj.put("enabled", CentralConfigClientUtil.isEnabled());
                    jobj.put("environment", (Object)CentralConfigClientUtil.getEnv());
                    jobj.put("clustername", (Object)CentralConfigClientUtil.getClusterName());
                    response.getWriter().print(jobj);
                    return;
                }
                if (action.equals("disable")) {
                    CentralConfigClientUtil.setEnabled("false");
                    return;
                }
                if (action.equals("enable")) {
                    CentralConfigClientUtil.setEnabled("true");
                    return;
                }
                if (action.equals("delete")) {
                    CentralConfigClientUtil.setEnabled("false");
                    return;
                }
                if (action.equals("add")) {
                    if (!this.validateRequest(request)) {
                        this.sendError(response);
                        return;
                    }
                    this.initHostname(request);
                    this.initCCSDetails(request);
                    CentralConfigClientUtil.setEnabled("true");
                    return;
                }
                if (action.equals("reloadall")) {
                    CentralConfigRefreshServlet.reloadAllModules();
                    return;
                }
                if (action.equals("disable")) {
                    CentralConfigClientUtil.setEnabled("false");
                    return;
                }
                if (action.equals("enable")) {
                    CentralConfigClientUtil.setEnabled("true");
                    return;
                }
                if (action.equals("delete")) {
                    CentralConfigClientUtil.setEnabled("false");
                    return;
                }
                if (action.equals("reloadall")) {
                    CentralConfigRefreshServlet.reloadAllModules();
                    return;
                }
                if (action.equals("vaidatekey")) {
                    if (!this.validateRequest(request)) {
                        this.sendError(response);
                        return;
                    }
                } else if (action.equals("ccsup")) {
                    CentralConfigClientUtil.setCCSServerStatus(true);
                } else if (action.equals("ccsdown")) {
                    CentralConfigClientUtil.setCCSServerStatus(false);
                } else if (action.equals("restart")) {
                    CentralConfigClientUtil.restartServer();
                }
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
    }

    private void initContext(HttpServletRequest request) {
        String[] uriSplit;
        if (request.getRequestURI() != null && (uriSplit = request.getRequestURI().split("/")).length > 2) {
            String context = uriSplit[1];
            CentralConfigClientUtil.initContext(context);
        }
    }

    private void sendError(HttpServletResponse response) {
        JsonObject jobj = new JsonObject();
        jobj.put("error", (Object)"invalidkey");
        try {
            response.getWriter().print(jobj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initCCSDetails(HttpServletRequest request) {
        String server = request.getParameter("server");
        String port = request.getParameter("port");
        String protocol = request.getParameter("protocol");
        CentralConfigClientUtil.setServer(server);
        CentralConfigClientUtil.setPort(port);
        if (!protocol.isEmpty()) {
            CentralConfigClientUtil.setCcsServerProtocol(protocol);
        }
    }

    public static void reloadAllModules() {
        CentralConfigRefreshServlet.reloadModule("", "", true);
    }

    public static void reloadModule(String module, String body, boolean reloadAll) {
        HashSet<Service> services = new HashSet<Service>();
        if (module.equals("neo-solr.xml") || reloadAll) {
            services.add(ServiceFactory.getSolrService());
        }
        if (module.equals("neo-graphing.xml") || reloadAll) {
            services.add(ServiceFactory.getNewGraphingService());
        }
        if (module.equals("neo-logging.xml") || reloadAll) {
            services.add(ServiceFactory.getLoggingService());
        }
        if (module.equals("neo-runtime.xml") || reloadAll) {
            services.add(ServiceFactory.getRuntimeService());
        }
        if (module.equals("neo-watch.xml") || reloadAll) {
            services.add(ServiceFactory.getRuntimeService());
            services.add(ServiceFactory.getWatchService());
        }
        if (module.equals("neo-clientstore.xml") || reloadAll) {
            services.add(ServiceFactory.getClientScopeService());
        }
        if (module.equals("neo-event.xml") || reloadAll) {
            services.add(ServiceFactory.getEventProcessorService());
        }
        if (module.equals("neo-mail.xml") || reloadAll) {
            services.add(ServiceFactory.getMailSpoolService());
        }
        if (module.equals("neo-metric.xml") || reloadAll) {
            services.add(ServiceFactory.getMetricsService());
        }
        if (module.equals("neo-jaxrs.xml") || reloadAll) {
            services.add(ServiceFactory.getJaxRsService());
        }
        if (module.equals("neo-websocket.xml") || reloadAll) {
            services.add(ServiceFactory.getWebsocketService());
        }
        if (module.equals("neo-document.xml") || reloadAll) {
            services.add(ServiceFactory.getDocumentService());
            services.add((Service)((Object)ServiceFactory.getPDFGService()));
        }
        if (module.equals("neo-datasource.xml") || module.equals("neo-drivers.xml") || reloadAll) {
            services.add(ServiceFactory.getDataSourceService());
        }
        if (module.equals("neo-solr.xml") || reloadAll) {
            services.add(ServiceFactory.getSolrService());
        }
        if (module.equals("neo-nosql-datasource.xml")) {
            services.add(ServiceFactory.getNoSQLService());
        }
        if (module.equals("neo-xmlrpc.xml") || reloadAll) {
            services.add(ServiceFactory.getXmlRpcService());
        }
        if (module.equals("neo-cloud-config.xml") || reloadAll) {
            services.add(ServiceFactory.getCloudConfigService());
        }
        if (module.equals("neo-cloudcredential.xml") || reloadAll) {
            services.add(ServiceFactory.getVendorCredentialService());
        }
        if (module.equals("neo-debug.xml") || reloadAll) {
            services.add(ServiceFactory.getDebuggingService());
        }
        if (module.equals("neo-monitoring.xml") || reloadAll) {
            services.add(ServiceFactory.getMonitoringService());
        }
        if (module.equals("neo-archivedeploy.xml") || reloadAll) {
            services.add(ServiceFactory.getArchiveDeployService());
        }
        if (module.equals("neo-security.xml") || reloadAll) {
            services.add(ServiceFactory.getSecurityService());
        }
        if (module.equals("neo-saml.xml") || reloadAll) {
            services.add((Service)((Object)ServiceFactory.getSamlService(false)));
        }
        if (module.equals("license.properties") || reloadAll) {
            services.add(ServiceFactory.getLicenseService());
        }
        if (module.equals("neo_updates.xml") || reloadAll) {
            CentralConfigRefreshServlet.updateUpdateService();
        }
        if (module.equals("neo-graphql-config.xml") || module.equals("graphql_serviceconfig.pom") || reloadAll) {
            services.add(ServiceFactory.getGraphQLConfigService(false));
        }
        if (module.equals("jvm.config")) {
            CentralConfigRefreshServlet.saveJvmConfig(body);
        }
        for (Service service : services) {
            if (null == service) continue;
            try {
                service.stop();
            }
            catch (Throwable t) {
                CFLogs.SERVER_LOG.error(t);
            }
            try {
                service.start();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    private static void updateUpdateService() {
        UpdateService instance = UpdateService.getInstance();
        Map settings = instance.getSettings();
        instance.init(settings);
        instance.store(false);
    }

    public static void saveJvmConfig(final String body) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CentralConfigRefreshServlet._saveJvmConfig(body);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _saveJvmConfig(String body) {
        OutputStreamWriter fw = null;
        String jvmFile = ServiceFactory.getRuntimeService().getLibDir() + File.separator + ".." + File.separator + "bin" + File.separator + "jvm.config";
        try {
            FileReader reader = new FileReader(jvmFile);
            Properties p = new Properties();
            p.load(reader);
            StringReader sr = new StringReader(body);
            Properties finalProps = new Properties();
            finalProps.load(sr);
            finalProps.put("java.home", p.get("java.home"));
            fw = new FileWriter(jvmFile);
            finalProps.store(fw, "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init((ServletConfig)new ServletConfigWrapper(config));
    }
}

