/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.centralconfig.client.discovery;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CFToCCSMulticastSender {
    private static InetAddress multicastGroup;
    private static MulticastSocket mcSocket;
    public static String multiCastGroupIp;
    public static int multiCastPort;
    public static String CF_CCS_UPMESSAGE;
    private static boolean multicastStarted;

    public static boolean startMulticastService() {
        if (multicastStarted) {
            return true;
        }
        try {
            multicastGroup = InetAddress.getByName(multiCastGroupIp);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        try {
            mcSocket = new MulticastSocket(multiCastPort);
            mcSocket.joinGroup(multicastGroup);
            multicastStarted = true;
            int port = 0;
            try {
                port = CFToCCSMulticastSender.getPort();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            if (FusionContext.getCurrent() != null && FusionContext.getCurrent().getRequest() != null) {
                port = FusionContext.getCurrent().getRequest().getServerPort();
            }
            int finalPort = port;
            ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
            Runnable task2 = () -> CFToCCSMulticastSender.broadcastNodeUpMessage(finalPort);
            ScheduledFuture<?> scheduledFuture = ses.scheduleAtFixedRate(task2, 5L, 10L, TimeUnit.SECONDS);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        return multicastStarted;
    }

    public void stopMulticastService() {
        try {
            mcSocket.leaveGroup(multicastGroup);
            multicastGroup = null;
            mcSocket.close();
            multicastStarted = false;
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastNodeUpMessage(int port) {
        Object data = "";
        try {
            data = InetAddress.getLocalHost().getHostName().trim();
        }
        catch (UnknownHostException e1) {
            CFLogs.SERVER_LOG.error(e1);
        }
        data = (String)data + ":" + port + ":" + CentralConfigClientUtil.getSecretKey();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            bout.write(CF_CCS_UPMESSAGE.getBytes());
        }
        catch (IOException e1) {
            CFLogs.SERVER_LOG.error(e1);
        }
        DatagramPacket dp = null;
        try {
            bout.write(((String)data).getBytes());
            bout.flush();
            dp = new DatagramPacket(bout.toByteArray(), bout.size(), multicastGroup, multiCastPort);
            bout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            mcSocket.send(dp);
        }
        catch (Exception exception) {
        }
        finally {
            dp = null;
        }
    }

    private static int getPort() throws ParserConfigurationException, SAXException, IOException {
        String port = CentralConfigClientUtil.getHostport();
        if (port != null && port.length() > 0) {
            return Integer.parseInt(port);
        }
        String serverXml = System.getProperty("coldfusion.home") + "/runtime/conf/server.xml";
        File fXmlFile = new File(serverXml);
        if (!fXmlFile.exists()) {
            return 0;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList connectorLists = doc.getElementsByTagName("Connector");
        for (int item = 0; item < connectorLists.getLength(); ++item) {
            Node nNode = connectorLists.item(item);
            Element eElement = (Element)nNode;
            port = eElement.getAttribute("port");
            if (port == null || port.equals("")) continue;
            int iPort = Integer.parseInt(port);
            return iPort;
        }
        return 0;
    }

    public MulticastSocket getMcSocket() {
        return mcSocket;
    }

    static {
        multiCastGroupIp = "229.0.0.4";
        multiCastPort = 46865;
        CF_CCS_UPMESSAGE = "CF_CCS_UP";
        multicastStarted = false;
    }
}

