/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.centralconfig.server;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.centralconfig.server.CCSClientNode;
import coldfusion.log.CFLogs;
import coldfusion.server.CFService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class CentralConfigServerManager {
    private static Set<CCSClientNode> allNodes;
    private static Set<CCSClientNode> dicoveredNodes;
    public static String libFolder;
    public static String logLevel;
    public static int nodesHealthCheckInterval;
    public static String environments;
    private static int ccsPort;
    private static String ccsProtocol;

    private static void init() {
        CentralConfigServerManager.initCCSPort();
    }

    public static String getLib() {
        Object lib = "";
        if (ServiceFactory.isRuntimeServiceInitialized()) {
            lib = ServiceFactory.getRuntimeService().getLibDir();
        }
        if (!new File((String)lib).exists()) {
            String home = System.getenv().get("CFUSION_HOME");
            if (null == home) {
                home = System.getProperty("CFUSION_HOME");
            }
            lib = null == home ? ".." + File.separator + "lib" : home + File.separator + "lib";
        }
        return lib;
    }

    private static void initCCSPort() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CentralConfigServerManager._initCCSPort();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _initCCSPort() {
        String lib = CentralConfigServerManager.getLib();
        String configFile = lib + File.separator + "ccs" + File.separator + "server.properties";
        Properties _props = new Properties();
        FilterInputStream ds = null;
        try {
            ds = new DataInputStream(new FileInputStream(configFile));
            _props.load(ds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (Boolean.parseBoolean((String)_props.get("enablehttpsport"))) {
            ccsProtocol = "https";
            ccsPort = Integer.parseInt((String)_props.get("httpsport"));
        } else {
            ccsProtocol = "http";
            ccsPort = Integer.parseInt((String)_props.get("port"));
        }
        if (_props.containsKey("loglevel")) {
            logLevel = (String)_props.get("loglevel");
        }
        if (_props.containsKey("environments")) {
            environments = (String)_props.get("environments");
        }
        if (_props.containsKey("nodeshealthcheckinterval")) {
            nodesHealthCheckInterval = Integer.parseInt((String)_props.get("nodeshealthcheckinterval"));
        }
    }

    private static void initServerConfig() {
        allNodes = new HashSet<CCSClientNode>();
        File file = CentralConfigServerManager.getCCSNodesConfigFile();
        if (null == file) {
            return;
        }
        String ccsinfo = file.getAbsolutePath();
        try {
            String nodesStr = new String(Files.readAllBytes(Paths.get(ccsinfo, new String[0])));
            if (nodesStr != null && nodesStr.length() > 0) {
                JsonArray nodesstr = new JsonArray(nodesStr);
                for (int i = 0; i < nodesstr.length(); ++i) {
                    JsonObject jobj = nodesstr.getJsonObject(i);
                    String sk = jobj.getString("ccssecretkey");
                    String server = jobj.getString("server");
                    String portStr = jobj.getString("port");
                    String jee = "";
                    if (jobj.has("jeecontext")) {
                        jee = jobj.getString("jeecontext");
                    }
                    boolean sslEnabled = false;
                    if (jobj.has("sslenabled")) {
                        sslEnabled = jobj.getBoolean("sslenabled");
                    }
                    int port = 0;
                    if (portStr.length() > 0) {
                        port = Integer.parseInt(portStr);
                    }
                    CCSClientNode node = new CCSClientNode();
                    node.setPort(port);
                    node.setSecretKey(sk);
                    node.setServer(server);
                    node.setJeeContext(jee);
                    node.setSslEnabled(sslEnabled);
                    allNodes.add(node);
                }
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    public static void addNode(String ip, String port, String jee, String secretKey, boolean sslEnabled) {
        CentralConfigServerManager.initServerConfig();
        CCSClientNode node = new CCSClientNode();
        node.setServer(ip);
        if (port.length() > 0) {
            node.setPort(Integer.parseInt(port));
        }
        node.setSecretKey(secretKey);
        node.setJeeContext(jee);
        node.setSslEnabled(sslEnabled);
        if (allNodes.contains(node)) {
            throw new NodeAlreadyExistsException();
        }
        allNodes.add(node);
        String response = CentralConfigServerManager.callNode(ip, jee, port, "vaidatekey", sslEnabled);
        boolean notValid = false;
        String error = "";
        if (response.length() > 0) {
            if (response.equals("unknownhost")) {
                notValid = true;
                error = "unknownhost";
            } else if (response.toLowerCase().contains("bad request")) {
                notValid = true;
                error = response;
            } else {
                JsonObject jobj = new JsonObject(response);
                notValid = jobj.get("error").equals("invalidkey");
                error = "invalidkey";
            }
        }
        if (notValid) {
            allNodes.remove(node);
            throw new AddNodeException(error);
        }
        CentralConfigServerManager.saveNodes();
        CentralConfigServerManager.callNode(ip, jee, port, "add", sslEnabled);
        CentralConfigServerManager.callNode(ip, jee, port, "reloadall", sslEnabled);
        CCSClientNode dnode = new CCSClientNode();
        dnode.setServer(ip);
        if (port != null && port.length() > 0) {
            dnode.setPort(Integer.parseInt(port));
        }
        dnode.setJeeContext(jee);
        ip = CentralConfigServerManager.getIPPort(ip, port, jee);
        dicoveredNodes.remove(dnode);
    }

    public static void addDiscoveredNode(String newnode) {
        CentralConfigServerManager.initServerConfig();
        boolean already = false;
        String[] split = newnode.split(":");
        CCSClientNode node = new CCSClientNode();
        node.setServer(split[0]);
        node.setPort(Integer.parseInt(split[1]));
        node.setSecretKey(split[2]);
        for (CCSClientNode inode : allNodes) {
            if (!inode.equals(node)) continue;
            already = true;
            break;
        }
        if (!already) {
            dicoveredNodes.add(node);
        }
    }

    public static CCSClientNode[] getDiscoveredNodes() {
        return dicoveredNodes.toArray(new CCSClientNode[dicoveredNodes.size()]);
    }

    private static String getIPPort(String ip, String port, String jee) {
        if (jee == null) {
            jee = "";
        }
        if (((String)ip).contains(":")) {
            if (((String)ip).contains("]")) {
                int idx = ((String)ip).indexOf("]");
                if (((String)ip).length() > idx) {
                    String sub = ((String)ip).substring(idx + 1, ((String)ip).length() - 1);
                    try {
                        Integer.getInteger(sub);
                        ip = (String)ip + "/" + jee;
                    }
                    catch (Throwable t) {
                        if (port != null && port.length() > 0) {
                            ip = (String)ip + ":" + port;
                        }
                    }
                }
            } else {
                ip = (String)ip + "/" + jee;
            }
        } else {
            ip = port != null && port.length() > 0 && !((String)ip).equals(port) ? (String)ip + ":" + port + "/" + jee : (String)ip + "/" + jee;
        }
        if (((String)ip).endsWith("/")) {
            ip = ((String)ip).substring(0, ((String)ip).length() - 1);
        }
        return ip;
    }

    public static Set<String> getNodesIPPort() {
        CentralConfigServerManager.initServerConfig();
        CCSClientNode[] allnodes = CentralConfigServerManager.getNodes(true);
        HashSet<String> nodes = new HashSet<String>();
        for (CCSClientNode node : allnodes) {
            nodes.add(node.getServerWithPortCluster());
        }
        return nodes;
    }

    public static Set<String> getNodesIPAndPort() {
        CentralConfigServerManager.initServerConfig();
        CCSClientNode[] allnodes = CentralConfigServerManager.getNodes(true);
        HashSet<String> nodes = new HashSet<String>();
        for (CCSClientNode node : allnodes) {
            nodes.add(node.getServerWithPort());
        }
        return nodes;
    }

    public static CCSClientNode getClientNode(String node) {
        CCSClientNode[] allnodes;
        CentralConfigServerManager.initServerConfig();
        for (CCSClientNode clientNode : allnodes = CentralConfigServerManager.getNodes(true)) {
            String clientNodeIpAndPort = clientNode.getServerWithPort();
            if (!clientNodeIpAndPort.equals(node)) continue;
            return clientNode;
        }
        return null;
    }

    public static CCSClientNode[] getNodes() {
        return CentralConfigServerManager.getNodes(true);
    }

    public static CCSClientNode[] getNodes(boolean checkStatus) {
        CentralConfigServerManager.initServerConfig();
        HashSet<CCSClientNode> clientNodes = new HashSet<CCSClientNode>();
        for (CCSClientNode node : allNodes) {
            String clientNodeProtocol;
            CCSClientNode clientNode = new CCSClientNode();
            String string = clientNodeProtocol = node.isSslEnabled() ? "https://" : "http://";
            if (checkStatus) {
                String url = clientNodeProtocol + node.getServerWithPort() + "/centralconfigservlet?action=metadata&secretkey=" + node.getSecretKey();
                HttpGet get = new HttpGet(url);
                String content = "";
                JsonObject jobj = null;
                try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
                     CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                    content = EntityUtils.toString((HttpEntity)response.getEntity());
                    jobj = new JsonObject(content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (content.length() > 0) {
                    if (jobj.has("error")) {
                        boolean notValid = jobj.get("error").equals("invalidkey");
                        if (notValid) {
                            clientNode.setKeyValid(false);
                        }
                    } else {
                        clientNode.setCurrentVersion(Integer.parseInt(jobj.getString("currentversion")));
                        clientNode.setCCSEnabled(Boolean.parseBoolean(jobj.getString("enabled")));
                        clientNode.setEnvironment(jobj.getString("environment"));
                        clientNode.setCluster(jobj.getString("clustername"));
                    }
                } else {
                    clientNode.setRunning(false);
                }
            }
            clientNode.setServer(node.getServer());
            clientNode.setPort(node.getPort());
            clientNode.setSecretKey(node.getSecretKey());
            clientNode.setJeeContext(node.getJeeContext());
            clientNode.setSslEnabled(node.isSslEnabled());
            clientNodes.add(clientNode);
        }
        return clientNodes.toArray(new CCSClientNode[clientNodes.size()]);
    }

    private static void saveNodes() {
        JsonArray jary = new JsonArray();
        for (CCSClientNode node : allNodes) {
            JsonObject jobj = new JsonObject();
            jobj.put("server", (Object)node.getServer());
            jobj.put("port", node.getPort());
            jobj.put("jeecontext", (Object)node.getJeeContext());
            jobj.put("ccssecretkey", (Object)node.getSecretKey());
            jobj.put("sslenabled", node.isSslEnabled());
            jary.put((Object)jobj);
        }
        CentralConfigServerManager.saveContent(CentralConfigServerManager.getCCSNodesConfigFile().getAbsolutePath(), jary.toString());
    }

    public static void deleteNode(String ip, String port, String jee, boolean sslEnabled) {
        CentralConfigServerManager.initServerConfig();
        CentralConfigServerManager.callNode(ip, jee, port, "delete", sslEnabled);
        CCSClientNode node = new CCSClientNode();
        node.setServer(ip);
        if (port.length() > 0) {
            node.setPort(Integer.parseInt(port));
        }
        if (null != jee) {
            node.setJeeContext(jee);
        }
        allNodes.remove(node);
        CentralConfigServerManager.saveNodes();
    }

    public static void disableNode(String ip, String port, String jee, boolean sslEnabled) {
        CentralConfigServerManager.callNode(ip, jee, port, "disable", sslEnabled);
    }

    public static void enableNode(String ip, String port, String jee, boolean sslEnabled) {
        CentralConfigServerManager.callNode(ip, jee, port, "enable", sslEnabled);
    }

    public static void restartNode(String ip, String port, String jee, boolean sslEnabled) {
        CentralConfigServerManager.callNode(ip, jee, port, "restart", sslEnabled);
    }

    public static String getSecretKeyForNode(String ip, int port, String jee) {
        String server = CentralConfigServerManager.getIPPort(ip, "" + port, jee);
        for (CCSClientNode node : allNodes) {
            String svr = CentralConfigServerManager.getIPPort(node.getServer(), "" + node.getPort(), node.getJeeContext());
            if (!server.equals(svr)) continue;
            return node.getSecretKey();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String callNode(String ip, String jee, String port, String action, boolean sslEnabled) {
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (port == null || port.length() == 0) {
            port = "0";
        }
        String sk = CentralConfigServerManager.getSecretKeyForNode(ip, Integer.parseInt(port), jee);
        String address = CentralConfigServerManager.getIPPort(ip, port, jee);
        String clientNodeProtocol = sslEnabled ? "https://" : "http://";
        String url = clientNodeProtocol + address + "/centralconfigservlet?action=" + action + "&secretkey=" + sk + "&hostname=" + ip + "&server=" + localhost + "&port=" + ccsPort + "&protocol=" + ccsProtocol;
        HttpGet get = new HttpGet(url);
        String content = "";
        Object jobj = null;
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();){
            String string;
            block17: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
                try {
                    string = content = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (Exception e) {
            System.out.println(address + " is not accessible");
            return "unknownhost";
        }
    }

    private static File _getCCSNodesConfigFile() {
        File file = CFService.getFile("ccs" + File.separator + "nodes.properties");
        if (libFolder != null) {
            file = new File(libFolder + File.separator + "ccs" + File.separator + "nodes.properties");
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static File getCCSNodesConfigFile() {
        File file = null;
        try {
            file = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return CentralConfigServerManager._getCCSNodesConfigFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static boolean isCCSServer() {
        File file = CFService.getFile("ccs" + File.separator + "status");
        return file.exists();
    }

    private static void saveContent(final String path, final String content) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CentralConfigServerManager._saveContent(path, content);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _saveContent(String path, String content) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(path);
            fw.write(content);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        dicoveredNodes = new HashSet<CCSClientNode>();
        logLevel = "error";
        nodesHealthCheckInterval = 5;
        environments = "";
        CentralConfigServerManager.init();
    }

    public static class NodeAlreadyExistsException
    extends CacheException {
    }

    public static class AddNodeException
    extends CacheException {
        public String exc = null;

        public AddNodeException(String exc) {
            this.exc = exc;
        }
    }
}

