/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cfc;

import coldfusion.cfc.CFCProxyFilter;
import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.filter.ApplicationFilter;
import coldfusion.filter.ClientScopePersistenceFilter;
import coldfusion.filter.DatasourceFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.GlobalsFilter;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.tools.CompilerContext;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.CFCServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;

public class CFCProxy {
    private String filePath;
    protected TemplateProxy template;
    private Servlet cfcServlet;
    private boolean autoflush = true;
    private boolean executeApplication = true;
    private boolean directInvoke = false;
    private boolean isSchedulerEvent = false;
    private static ThreadLocal inInvoke = new ThreadLocal();
    private boolean isServerlessCall = false;
    public CfJspPage page;
    public static final boolean RECUR_RESOLVE_INCLUDES = Boolean.getBoolean("coldfusion.application.recur_resolve.include");

    public CFCProxy(String str) throws Throwable {
        this(str, null);
    }

    public CFCProxy(String str, boolean directInvoke) throws Throwable {
        this(str, null, directInvoke);
    }

    public CFCProxy(String str, Map initialThis) throws Throwable {
        this(str, initialThis, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFCProxy(String str, Map initialThis, boolean directInvoke) throws Throwable {
        this.directInvoke = directInvoke;
        boolean isFile = false;
        if (str != null && (str.indexOf("\\") >= 0 || str.indexOf("/") >= 0)) {
            isFile = true;
            this.filePath = str;
        }
        if (!isFile) {
            FusionContext fusionContext = FusionContext.getCurrent();
            this.filePath = str;
            this.template = (TemplateProxy)ComponentProxyFactory.getProxy(str, fusionContext.pageContext, null, null);
            if (initialThis != null) {
                this.template.putAll(initialThis);
            }
        } else {
            this.cfcServlet = CFCServlet.getCFCServlet();
            if (this.cfcServlet == null && !ServiceFactory.getRuntimeService().isCommandLineCompile() && !ServerlessUtil.isLambdaEnv()) {
                throw new RuntimeException("CFCServlet must be initialized");
            }
            FusionContextData data = null;
            try {
                data = this.createContextData(null, null, null);
                FusionContext.setCurrent(data.context);
                if (data.oldContext == null) {
                    data.context.SymTab_initForRequest(true);
                } else {
                    data.context.pageContext = data.oldContext.pageContext;
                    if (RECUR_RESOLVE_INCLUDES) {
                        data.context.pageContext.setFusionContext(data.context);
                    }
                    data.context.hiddenScope = data.oldContext.hiddenScope;
                }
                File cfc = new File(this.filePath);
                this.template = TemplateProxyFactory.resolveFile(data.context.pageContext, cfc, initialThis);
                this.convertCFCValues(this.template);
            }
            finally {
                if (data != null) {
                    data.resetContext();
                    FusionContext.setCurrent(data.oldContext);
                    if (data.oldContext != null && data.context != null) {
                        if (RECUR_RESOLVE_INCLUDES) {
                            data.context.pageContext.setFusionContext(data.oldContext);
                        }
                        if (data.oldContext.getCfSettingTimeout() == 0L && data.context.getCfSettingTimeout() != 0L) {
                            data.oldContext.setCfSettingTimeout(data.context.getCfSettingTimeout());
                        }
                    }
                }
            }
        }
        this.page = this.template.page;
    }

    private void convertCFCValues(TemplateProxy template) {
        Object appTimeout;
        Object sessionTimeout = template.getCanonicalKey("SESSIONTIMEOUT");
        if (sessionTimeout instanceof Double) {
            int timeout = (int)(Cast._double(sessionTimeout) * 24.0 * 60.0 * 60.0);
            template.putCanonicalKey("SESSIONTIMEOUT", new Integer(timeout));
        }
        if ((appTimeout = template.getCanonicalKey("APPLICATIONTIMEOUT")) instanceof Double) {
            int timeout = (int)(Cast._double(appTimeout) * 24.0 * 60.0 * 60.0);
            template.putCanonicalKey("APPLICATIONTIMEOUT", new Integer(timeout));
        }
    }

    protected String getApplicationName() {
        FusionContext context = FusionContext.getCurrent();
        if (context != null) {
            return context.getApplicationName();
        }
        return "";
    }

    public void setThisScope(Map map) {
        HashMap toSet = map instanceof LocalScope ? ((LocalScope)((Object)map)).getBacking() : (!(map instanceof HashMap) ? new HashMap(map) : map);
        this.template.replaceBacking(toSet);
    }

    public Map getThisScope() {
        return this.template.clone();
    }

    public UDFMethod getMethod(String methodStr) {
        return this.template.resolveMethod(methodStr, false);
    }

    public final Object invoke(String method, Object[] args) throws Throwable {
        if (this.directInvoke) {
            return this.doInvoke(method, args);
        }
        return this.doInvoke(method, args, null, null, null);
    }

    public final Object invoke(String method, Object[] args, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (this.directInvoke) {
            return this.doInvoke(method, args);
        }
        return this.doInvoke(method, args, request, response, null);
    }

    public static boolean inInvoke() {
        Boolean bool = (Boolean)inInvoke.get();
        return bool != null && bool != false;
    }

    public final Object invoke(String method, Object[] args, HttpServletRequest request, HttpServletResponse response, OutputStream out) throws Throwable {
        if (this.directInvoke) {
            return this.doInvoke(method, args);
        }
        return this.doInvoke(method, args, request, response, out);
    }

    public final Object invoke(String method, Object[] args, HttpServletRequest request, HttpServletResponse response, OutputStream out, Object o) throws Throwable {
        if (this.directInvoke) {
            return this.doInvoke(method, args);
        }
        return this.doInvoke(method, args, request, response, out);
    }

    private Object doInvoke(String method, Object[] args) throws Throwable {
        FusionContext fusionContext = FusionContext.getCurrent();
        return this.template.invoke(method, args, (PageContext)fusionContext.pageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInvoke(String method, Object[] args, HttpServletRequest request, HttpServletResponse response, OutputStream out) throws Throwable {
        FusionContextData data = null;
        try {
            inInvoke.set(Boolean.TRUE);
            data = this.createContextData(request, response, out);
            FusionContext.setCurrent(data.context);
            FusionFilter filterChain = this.getComponentFilterChain(method, args);
            filterChain.invoke(data.context);
            if (this.autoflush) {
                this.flush();
            }
        }
        finally {
            inInvoke.set(null);
            if (data != null) {
                data.resetContext();
                FusionContext.setCurrent(data.oldContext);
            }
        }
        Object retValue = null;
        if (data.context != null) {
            retValue = data.context.returnValue;
        }
        return retValue;
    }

    public void flush() throws IOException {
        this.template.page.pageContext.getCFOutput().getWriter().flush();
    }

    public void setAutoFlush(boolean flush) {
        this.autoflush = flush;
    }

    public void setSchedulerEvent(boolean isSchedulerEvent) {
        this.isSchedulerEvent = isSchedulerEvent;
    }

    public void setApplicationExecution(boolean doApp) {
        this.executeApplication = doApp;
    }

    public void setServerlessCall(boolean isServerlessCall) {
        this.isServerlessCall = isServerlessCall;
    }

    public FusionContext createContext(HttpServletRequest req, HttpServletResponse resp, OutputStream os) throws Throwable {
        FusionContextData data = this.createContextData(req, resp, os);
        return data.context;
    }

    private FusionContextData createContextData(HttpServletRequest req, HttpServletResponse resp, OutputStream os) throws Throwable {
        HttpServletRequest oldReq = null;
        HttpServletResponse oldResp = null;
        Servlet oldServlet = null;
        byte[] bufferedReqContent = null;
        String secureUsername = null;
        String securePassword = null;
        boolean useMappings = false;
        FusionContext context = FusionContext.getCurrent();
        if (context != null) {
            oldReq = context.getRequest();
            oldResp = context.getResponse();
            oldServlet = context.servlet;
            useMappings = context.getUseMappings();
            if (req == null) {
                req = oldReq;
            }
            if (resp == null) {
                resp = oldResp;
            }
            secureUsername = context.getSecureUsername();
            securePassword = context.getSecurePassword();
            if (req == oldReq && context.isBufferedRequestContent()) {
                bufferedReqContent = context.getRequestContent();
            }
        }
        if (req == null) {
            req = new DummyHttpServletRequest(this.filePath);
        }
        if (os != null || resp == null) {
            resp = new DummyHttpServletResponse(os);
        }
        FusionContext newContext = new FusionContext();
        if (secureUsername != null) {
            newContext.setSecureCredentials(secureUsername, securePassword);
        }
        newContext.setUseMappings(useMappings);
        if (ServiceFactory.getRuntimeService().isCommandLineCompile() || ServerlessUtil.isLambdaEnv()) {
            CompilerContext application = new CompilerContext();
            CodeSource src = application.getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                URL url = src.getLocation();
                application.setWebInf(new File(url.getPath()).getParent() + File.separatorChar + ".." + File.separatorChar + "wwwroot" + File.separatorChar + "WEB-INF");
            }
            Thread.currentThread().setContextClassLoader(application.getClass().getClassLoader());
            application.setInitParameter("cftags", "/WEB-INF/cftags");
            Utils.parseWebXml(application);
            newContext.setServletObjects(application, (ServletRequest)req, (ServletResponse)resp);
        } else {
            newContext.setServletObjects(this.cfcServlet, (ServletRequest)req, bufferedReqContent, (ServletResponse)resp);
        }
        newContext.setPagePath(this.filePath);
        newContext.setApplicationName(this.getApplicationName());
        if (this.isSchedulerEvent) {
            newContext.setSchedulerEvent(true);
        }
        if (this.isServerlessCall) {
            newContext.setApplicationPath(context.getApplicationPath());
            newContext.setApplicationFile(context.getApplicationFile());
        }
        return new FusionContextData(newContext, context, oldServlet, oldReq, oldResp);
    }

    protected FusionFilter getComponentFilterChain(String method, Object[] args) throws Throwable {
        FusionFilter filter = new CFCProxyFilter(method, args, this.template);
        if (this.executeApplication) {
            filter = new ApplicationFilter(filter);
        }
        filter = new ClientScopePersistenceFilter(filter);
        boolean needsFormScope = false;
        filter = new GlobalsFilter(filter, false);
        filter = new DatasourceFilter(filter);
        return filter;
    }

    private static class FusionContextData {
        private FusionContext oldContext;
        private FusionContext context;
        private Servlet servlet;
        private HttpServletRequest request;
        private HttpServletResponse response;

        public FusionContextData(FusionContext context, FusionContext oldContext, Servlet servlet, HttpServletRequest request, HttpServletResponse response) {
            this.context = context;
            this.oldContext = oldContext;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
        }

        public FusionContext getOldContext() {
            return this.oldContext;
        }

        public FusionContext getContext() {
            return this.context;
        }

        public void resetContext() {
            if (this.oldContext != null) {
                this.oldContext.setServletObjects(this.servlet, (ServletRequest)this.request, (ServletResponse)this.response);
            }
        }
    }
}

