/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.CloudVendorFactory;
import coldfusion.cloud.CloudVendorName;
import coldfusion.cloud.VendorCredential;
import coldfusion.cloud.VendorServiceFactory;
import coldfusion.cloud.config.AbstractCloudConfig;
import coldfusion.cloud.exception.InvalidVendorOrServiceException;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.util.RB;
import java.util.Objects;

public enum CloudServiceAgent {
    INSTANCE;

    CloudVendorFactory cloudVendorFactory = new CloudVendorFactory();

    public CloudService getCloudService(VendorCredential vendorCredential, AbstractCloudConfig serviceConfig) throws InvalidVendorOrServiceException {
        if (Objects.isNull(vendorCredential)) {
            throw new ValidationException(RB.getString(CloudServiceAgent.class, "incorrectCredentialAlias"));
        }
        if (Objects.isNull(serviceConfig)) {
            throw new ValidationException(RB.getString(CloudServiceAgent.class, "incorrectConfigAlias"));
        }
        CloudVendorName cloudVendorName = vendorCredential.vendorName();
        CloudServiceName cloudServiceName = serviceConfig.serviceName();
        if (vendorCredential.vendorName() != null && serviceConfig.serviceName() != null) {
            if (cloudServiceName.isValidVendor(cloudVendorName)) {
                VendorServiceFactory cloudServiceFactory = CloudVendorFactory.getCloudServiceFactory(cloudVendorName);
                return cloudServiceFactory.getCloudServiceProducer(cloudServiceName).orElseThrow(() -> new InvalidVendorOrServiceException("Service " + cloudServiceName.name() + " is not registered with vendor " + cloudVendorName.name())).getServiceHandle(vendorCredential, serviceConfig);
            }
            throw new InvalidVendorOrServiceException("Service " + serviceConfig.serviceName().name() + " is invalid for vendor " + vendorCredential.vendorName().name());
        }
        throw new InvalidVendorOrServiceException("vendorName = " + vendorCredential.vendorName() + " and serviceName = " + serviceConfig.serviceName() + " both should be not null");
    }
}

