/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.VendorServiceFactory;
import coldfusion.server.ServiceFactory;
import java.util.Optional;

public class AWSServiceFactory
extends VendorServiceFactory {
    @Override
    public Optional<CloudServiceProducer> getCloudServiceProducer(CloudServiceName serviceName) {
        CloudServiceProducer producer = (CloudServiceProducer)serviceProducerMap.get((Object)serviceName);
        if (producer == null) {
            if (CloudServiceName.SQS.equals((Object)serviceName)) {
                producer = ServiceFactory.getSqsService().getSQSProducer();
            } else if (CloudServiceName.S3.equals((Object)serviceName)) {
                producer = ServiceFactory.getS3Service().getServiceProducer();
            } else if (CloudServiceName.SNS.equals((Object)serviceName)) {
                producer = ServiceFactory.getSnsService().getSNSProducer();
            } else if (CloudServiceName.DYNAMODB.equals((Object)serviceName)) {
                producer = ServiceFactory.getDynamoDBService().getDynamoDBProducer();
            } else if (CloudServiceName.LAMBDA.equals((Object)serviceName)) {
                producer = ServiceFactory.getLambdaService(true).getLambdaProducer();
            }
            serviceProducerMap.put(serviceName, producer);
        }
        return Optional.ofNullable(producer);
    }
}

