/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.config;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.VendorCredentialService;
import coldfusion.cloud.config.AbstractCloudConfig;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.Struct;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import coldfusion.util.StructUtil;
import coldfusion.util.Utils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.stream.Collectors;

public class CloudConfigService
extends ServiceBase
implements Observer,
StructUtil {
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private File cloudConfigFile;
    private ConfigMap configSetting;
    private static final String CLOUD_SERVICE_CONFIG_LIST_KEY = "CLOUDSERVICECONFIG";
    private static final String ALIAS_KEY = "ALIAS";

    public CloudConfigService(File cloudConfigFile) {
        this.cloudConfigFile = cloudConfigFile;
    }

    public void addConfigData(Object o) {
        ConfigMap c = (ConfigMap)o;
        Struct s = new Struct();
        s.putAll((Map)c);
        this.addConfigData(s);
    }

    public void addConfigData(Struct struct) {
        if (!struct.containsKey("serviceName")) {
            throw new RuntimeException("serviceName field not present");
        }
        Struct structCopy = null;
        try {
            structCopy = (Struct)struct.duplicate();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to make a copy of Struct!");
        }
        AbstractCloudConfig cloudConfig = this.transformToCloudConfig(structCopy);
        if (this.configSetting.containsKey(cloudConfig.getConfigAlias())) {
            throw new ValidationException(cloudConfig.getConfigAlias() + " alias already exists.");
        }
        this.configSetting.put(cloudConfig.getConfigAlias(), (Object)structCopy);
        try {
            this.store(cloudConfig.getConfigAlias(), structCopy, null);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public List<Struct> getAllConfigData() {
        Collection cloudConfigs = this.configSetting.values();
        return cloudConfigs.stream().filter(Objects::nonNull).map(map -> {
            Struct struct = new Struct();
            struct.putAll((Map)map);
            return struct;
        }).collect(Collectors.toList());
    }

    public void deleteConfigData(String alias) throws ServiceException {
        if (!this.configSetting.containsKey(alias)) {
            throw new ConfigDoesNotExistException(alias);
        }
        Object copy = this.configSetting.get(alias);
        this.configSetting.remove(alias);
        this.store(alias, null, copy);
    }

    public Struct getConfigData(String alias) {
        Map map = (Map)this.configSetting.get(alias);
        if (map == null) {
            throw new ConfigDoesNotExistException(alias);
        }
        Struct struct = new Struct();
        struct.putAll(map);
        return struct;
    }

    public AbstractCloudConfig getConfig(String alias) {
        if (Objects.nonNull(alias) && this.configSetting.containsKey(alias)) {
            return this.transformToCloudConfig(this.getConfigData(alias));
        }
        throw new ValidationException(RB.getString(CloudConfigService.class, "invalidCloudConfigAlias"));
    }

    public void modifyConfigData(String oldAlias, Struct struct) throws ServiceException {
        if (Objects.isNull(oldAlias)) {
            throw new ValidationException("oldAlias is null.");
        }
        if (Objects.isNull(struct)) {
            throw new ValidationException("config struct is null");
        }
        if (!this.configSetting.containsKey(oldAlias)) {
            throw new ConfigDoesNotExistException(oldAlias);
        }
        if (struct.containsKey("alias")) {
            throw new ValidationException("Alias cannot be modified once created. Please create configuration with a new alias");
        }
        Struct oldStruct = this.getConfigData(oldAlias);
        Struct oldStructCopy = new Struct();
        oldStructCopy.putAll((Map)((Struct)oldStruct.deepClone(true)));
        this.replaceOldValues(oldStruct, struct);
        AbstractCloudConfig cloudConfig = this.transformToCloudConfig(oldStruct);
        cloudConfig.setConfigAlias(oldAlias);
        this.configSetting.put(cloudConfig.getConfigAlias(), (Object)oldStruct.caseHandledKeySet().stream().collect(Collectors.toMap(key -> key, oldStruct::get)));
        this.store(cloudConfig.getConfigAlias(), struct, oldStructCopy);
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.cloudConfigFile = Utils.getCanonicalFile(this.cloudConfigFile);
            this.configSetting = (ConfigMap)this.deserialize(this.cloudConfigFile);
            if (this.configSetting == null) {
                this.configSetting = new ConfigMap(this, "cloudConfig");
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("cloudConfig.formats", "coldfusion.server.MapFormatter");
            this.rb.put("cloudConfig.value", "");
        }
        return this.rb;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        this.serialize(this.configSetting, this.cloudConfigFile, broadcast, key, value, oldValue);
    }

    @Override
    public void store() {
        this.serialize(this.configSetting, this.cloudConfigFile);
    }

    public AbstractCloudConfig fromApplicationScope(String alias) {
        if (alias.trim().isEmpty()) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "emptyServiceConfigAlias"));
        }
        Struct struct = null;
        ApplicationScope appScope = (ApplicationScope)FusionContext.getApplicationScope();
        if (appScope == null) {
            return null;
        }
        List cloudServiceConfig = (List)appScope.getApplicationSettingsMap().get(CLOUD_SERVICE_CONFIG_LIST_KEY);
        struct = this.getStructFromList(cloudServiceConfig, ALIAS_KEY, alias);
        if (struct != null) {
            return this.transformToCloudConfig(struct);
        }
        return null;
    }

    public AbstractCloudConfig transformToCloudConfig(Struct struct) {
        CloudServiceName serviceName;
        if (struct.isEmpty()) {
            throw new ValidationException(RB.getString(CloudConfigService.class, "emptyCloudConfigStruct"));
        }
        String serName = (String)struct.get("serviceName");
        if (serName == null) {
            throw new ValidationException(RB.getString(CloudConfigService.class, "serviceNameAbsentInStruct"));
        }
        serName = serName.toUpperCase();
        struct.put("serviceName", (Object)serName);
        try {
            serviceName = CloudServiceName.valueOf(FieldTypecastUtil.INSTANCE.getStringProperty(serName).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException(RB.getString(CloudConfigService.class, "invalidServiceName", (Object)(serName != null && serName.length() > 0 ? serName : "empty")));
        }
        try {
            switch (serviceName) {
                case S3: {
                    return ServiceFactory.getS3Service().getServiceConfig(struct);
                }
                case SNS: {
                    return ServiceFactory.getSnsService().getSNSServiceConfig(struct);
                }
                case SQS: {
                    return ServiceFactory.getSqsService().getSQSServiceConfig(struct);
                }
                case DYNAMODB: {
                    return ServiceFactory.getDynamoDBService().getDynamoDBConfig(struct);
                }
                case LAMBDA: {
                    return ServiceFactory.getLambdaService(true).getLambdaServiceConfig(struct);
                }
                case SERVICE_BUS: {
                    return ServiceFactory.getServiceBusService().getServiceBusConfig(struct);
                }
                case AZURE_BLOB: {
                    return ServiceFactory.getAzureBlobService().getServiceConfig(struct);
                }
                case PUBSUB: {
                    return ServiceFactory.getPubSubService(true).getPubSubConfig(struct);
                }
                case STORAGE: {
                    return ServiceFactory.getStorageService(true).getStorageConfig(struct);
                }
                case FIRESTORE: {
                    return ServiceFactory.getFirestoreService().getFirestoreConfig(struct);
                }
            }
            throw new ValidationException(serviceName.name() + " : is not configured with CloudConfigService");
        }
        catch (IllegalArgumentException ex) {
            String expMsg = ex.getMessage();
            if (expMsg.contains("maxNumberOfRetries")) {
                expMsg = expMsg.replace("maxNumberOfRetries", "numRetries");
            }
            throw new ValidationException(expMsg);
        }
    }

    public void replaceOldValues(Map oldMap, Map newMap) {
        for (Map.Entry entry : newMap.entrySet()) {
            String newKey = (String)entry.getKey();
            if (oldMap.containsKey(newKey)) {
                Object oldVal = oldMap.get(newKey);
                if (!(oldVal instanceof Map)) {
                    oldMap.replace(newKey, entry.getValue());
                    continue;
                }
                this.replaceOldValues((Map)oldVal, (Map)entry.getValue());
                continue;
            }
            oldMap.put(newKey, entry.getValue());
        }
    }

    public class ConfigDoesNotExistException
    extends ApplicationException {
        public String configAlias;

        public ConfigDoesNotExistException(String configAlias) {
            this.configAlias = configAlias;
        }
    }
}

