/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.validator;

import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.util.RB;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum GCPLabelValidator implements Validator
{
    INSTANCE;

    private static final Pattern keyRegex;
    private static final Pattern valueRegex;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private BiConsumer<String, String> action = new LabelsMapConsumer();
    private Map<String, String> labelsMap;

    public boolean validate(Object obj) {
        try {
            if (obj == null) {
                return true;
            }
            this.labelsMap = this.cast.getGCPLabelsMapProperty(obj, "labels");
            this.labelsMap.forEach(this.action);
            return true;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException(RB.getString(GCPLabelValidator.class, "STRUCT_VALIDATION_ERROR"), ex);
        }
    }

    static {
        keyRegex = Pattern.compile("^[a-z][-_a-z0-9]{0,62}$");
        valueRegex = Pattern.compile("^[-_a-z0-9]{0,63}$");
    }

    private class LabelsMapConsumer
    implements BiConsumer<String, String> {
        private LabelsMapConsumer() {
        }

        @Override
        public void accept(String key, String value) {
            Matcher keyMatcher = keyRegex.matcher(key);
            Matcher valueMatcher = valueRegex.matcher(value);
            if (!keyMatcher.find()) {
                if (key != null && key.trim().length() == 0) {
                    throw new FieldValidationFailedException(RB.getString(GCPLabelValidator.class, "LABEL_EMPTY_KEY_VALIDATION_ERROR", (Object)key));
                }
                throw new FieldValidationFailedException(RB.getString(GCPLabelValidator.class, "LABEL_KEY_VALIDATION_ERROR", (Object)key));
            }
            if (!valueMatcher.find()) {
                throw new FieldValidationFailedException(RB.getString(GCPLabelValidator.class, "LABEL_VALUE_VALIDATION_ERROR", (Object)value));
            }
        }
    }
}

