/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum GCPResourceNameValidator implements Validator
{
    TOPIC("topicName"),
    DEADLETTERTOPIC("deadLetterTopic"),
    SUBSCRIPTION("subscriptionName"),
    SNAPSHOT("snapshotName"),
    SCHEMA("schemaName");

    private String fieldName;
    private static final Pattern regex;
    private String resourceId;

    private GCPResourceNameValidator(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean validate(Object obj) {
        try {
            if (obj == null) {
                return true;
            }
            this.resourceId = Cast._String(obj).trim().toLowerCase();
            Matcher matcher = regex.matcher(this.resourceId);
            boolean result = matcher.find();
            if (!result) {
                throw new FieldValidationFailedException(RB.getString(GCPResourceNameValidator.class, "RESOURCE_NAME_VALIDATION_ERROR", (Object)this.fieldName, (Object)this.resourceId));
            }
            return result;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException(RB.getString(GCPResourceNameValidator.class, "RESOURCE_NAME_VALIDATION_ERROR", (Object)this.fieldName, (Object)this.resourceId), ex);
        }
    }

    static {
        regex = Pattern.compile("^(projects\\/\\b(?!.*google|.*ssl)\\b[a-z][-a-z0-9]{4,28}[a-z0-9]{1}\\/(topics|subscriptions|snapshots|schemas)\\/)?\\b(?!goog)\\b[A-Za-z][-_.~+%A-Za-z0-9]{2,254}$");
    }
}

