/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Closure;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum FieldTypecastUtil {
    INSTANCE;


    public final String getStringProperty(Object val) {
        try {
            return Cast._String(val);
        }
        catch (RuntimeException ex) {
            throw new FieldValidationFailedException("Casting exception while casting " + val + " to String", ex);
        }
    }

    public final int getIntegerProperty(Object val) {
        return Cast._int(val);
    }

    public final Map getMapProperty(Object val) {
        return Cast._Map(val);
    }

    public final Map getMapProperty(Object val, String fieldName) {
        if (val instanceof String) {
            throw new FieldValidationFailedException(RB.getString(CloudService.class, "STRUCT_VALIDATION_ERROR", (Object)fieldName));
        }
        return Cast._Map(val);
    }

    public final Map<String, Object> getStringObjectMapProperty(Object val) {
        try {
            return (Map)val;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : struct of attributes", ex);
        }
    }

    public final Map<String, String> getStringStringMapFromStringObjectMapProperty(Object val) {
        try {
            return ((Map)val).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Cast._String(e.getValue())));
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : struct of attributes is expected.", ex);
        }
    }

    public final Map<String, String> getGCPLabelsMapProperty(Object val, String fieldName) {
        try {
            return ((Map)val).entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> Cast._String(e.getValue()).toLowerCase()));
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException(RB.getString(CloudService.class, "STRUCT_VALIDATION_ERROR", (Object)fieldName), ex);
        }
    }

    public List<String> getStringListProperty(Object val) {
        return Cast._List(val);
    }

    public List getListProperty(Object val) {
        return Cast._List(val);
    }

    public Integer[] getIntegerArrayProperty(Object val) {
        try {
            List list = Cast._List(val);
            Integer[] temp = new Integer[list.size()];
            return list.toArray(temp);
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : Array Of Integer values expected", ex);
        }
    }

    public String[] getStringArrayProperty(Object val) {
        try {
            List list = Cast._List(val);
            String[] temp = new String[list.size()];
            return list.toArray(temp);
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : Array Of String values expected", ex);
        }
    }

    public Set<String> getStringSetProperty(Object val) {
        try {
            return new HashSet<String>(Cast._List(val));
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : Set Of String values expected", ex);
        }
    }

    public Map<String, String> getStringStringMapProperty(Object val) {
        try {
            return (Map)val;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : struct of attributes", ex);
        }
    }

    public final Boolean getBooleanProperty(Object val) {
        return Cast._boolean(val);
    }

    public final Date getDateProperty(Object val) {
        return this.getDateProperty(val, null);
    }

    public final Date getDateProperty(Object val, String fieldName) {
        String input;
        if (val != null && val instanceof String && (input = (String)val).trim().length() == 0) {
            if (fieldName != null) {
                throw new ValidationException(RB.getString(CloudService.class, "invalidDateExceptionWithFieldName", (Object)fieldName));
            }
            throw new ValidationException(RB.getString(CloudService.class, "invalidDateException"));
        }
        return Cast._Date(val);
    }

    public final Instant getInstantProperty(Object val) {
        Date date = Cast._Date(val);
        if (date == null) {
            throw new ValidationException(RB.getString(CloudService.class, "invalidDateException"));
        }
        return date.toInstant();
    }

    public final Instant getUtcInstantProperty(Object val) {
        Date date = Cast._Date(val);
        if (date == null) {
            throw new ValidationException(RB.getString(CloudService.class, "invalidDateException"));
        }
        return DateUtils.convertDate("local2utc", date).toInstant();
    }

    public final Long getLongProperty(Object value) {
        return Cast._long(value);
    }

    public final Long getLongDateProperty(Date value, String fieldName) {
        if (value == null) {
            throw new ValidationException(RB.getString(CloudService.class, "INVALID_VALIDATION_ERROR", (Object)fieldName));
        }
        return Cast._Long(value);
    }

    public final Double getDoubleProperty(Object value) {
        return Cast._double(value);
    }

    public Duration getDurationProperty(Object val) {
        return this.getDurationProperty(val, null);
    }

    public Duration getDurationProperty(Object val, String fieldName) {
        try {
            String stringDuration = Cast._String(val);
            if (!Pattern.matches("[1-9]+[0-9]*[mMdhsn]", stringDuration)) {
                if (val instanceof String && val != null && ((String)val).trim().length() == 0) {
                    val = "Empty string";
                }
                if (fieldName == null) {
                    throw new RuntimeException("Attribute Value : " + val + ", " + RB.getString(CloudService.class, "invalidDurationValue"));
                }
                throw new RuntimeException(RB.getString(CloudService.class, "invalidDurationValueWithAttributeNameError", (Object)fieldName, val));
            }
            int length = stringDuration.length();
            String unit = stringDuration.substring(length - 1);
            long response = 1L;
            response = Long.parseLong(stringDuration.substring(0, length - 1));
            switch (unit) {
                case "m": {
                    return Duration.ofMillis(response);
                }
                case "M": {
                    return Duration.ofMinutes(response);
                }
                case "d": {
                    return Duration.ofDays(response);
                }
                case "h": {
                    return Duration.ofHours(response);
                }
                case "s": {
                    return Duration.ofSeconds(response);
                }
                case "n": {
                    return Duration.ofNanos(response);
                }
            }
            return null;
        }
        catch (RuntimeException ex) {
            throw new ValidationException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new FieldValidationFailedException("Incorrect syntax : struct of attributes", ex);
        }
    }

    public static String toDurationString(long seconds) {
        long minutes = 0L;
        long hours = 0L;
        long days = 0L;
        if (seconds % 60L > 0L) {
            return seconds + "s";
        }
        if (seconds % 60L == 0L && (minutes = seconds / 60L) % 60L > 0L) {
            return minutes + "M";
        }
        if (minutes % 60L == 0L && (hours = minutes / 60L) % 24L > 0L) {
            return hours + "h";
        }
        if (hours % 24L == 0L && (days = hours / 24L) % 365L >= 0L) {
            return days + "d";
        }
        return seconds + "s";
    }

    public Closure getClosureProperty(Object val) {
        return (Closure)Cast._cast(val, Closure.class);
    }

    public Instant getMidNightInstant(Object value) {
        Date date = this.getDateProperty(value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return calendar.toInstant();
    }
}

