/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.XMLizerUtils;
import coldfusion.runtime.provider.SerializerProxyWrapper;
import coldfusion.runtime.xml.SerializationException;

public class SerializationUtil {
    public static String Serialize(Object object, String type, boolean useCustomSerializer) throws SerializationException {
        RequestMonitorEventProcessor.onFunctionStart("serialize");
        String result = null;
        if (null != type && type.trim().equalsIgnoreCase("XML")) {
            result = XMLizerUtils.serializeXML(object, useCustomSerializer);
        } else if (null != type && type.trim().equalsIgnoreCase("JSON")) {
            boolean isSecure = false;
            FusionContext fc = FusionContext.getCurrent();
            if (fc != null && fc.isSecureJSON()) {
                isSecure = true;
            }
            result = JSONUtils.serializeJSON(object, false, isSecure, useCustomSerializer);
        } else if (useCustomSerializer) {
            SerializerProxyWrapper serializerProxy = JSONUtils.getSerializerProxy();
            if (null != serializerProxy) {
                boolean canSerialize = false;
                try {
                    canSerialize = serializerProxy.canSerialize(type);
                    if (canSerialize) {
                        result = serializerProxy.serialize(object, type);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!canSerialize) {
                    throw new CFPage.TypeNotSupportedException(type);
                }
            }
        } else {
            throw new CFPage.TypeNotSupportedException(type);
        }
        RequestMonitorEventProcessor.onFunctionEnd("serialize");
        return result;
    }

    public static Object Deserialize(String string, String type, boolean useCustomSerializer) throws SerializationException {
        RequestMonitorEventProcessor.onFunctionStart("deserialize");
        Object result = null;
        if (null != type && type.trim().equalsIgnoreCase("XML")) {
            result = XMLizerUtils.deserializeXML(Object.class, string, useCustomSerializer);
        } else if (null != type && type.trim().equalsIgnoreCase("JSON")) {
            result = JSONUtils.deserializeJSON(string, false, useCustomSerializer);
        } else if (useCustomSerializer) {
            SerializerProxyWrapper serializerProxy = JSONUtils.getSerializerProxy();
            if (null != serializerProxy) {
                boolean canDeserialize = false;
                try {
                    canDeserialize = serializerProxy.canDeSerialize(type);
                    if (canDeserialize) {
                        result = serializerProxy.deserialize(string, type, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!canDeserialize) {
                    throw new CFPage.TypeNotSupportedException(type);
                }
            }
        } else {
            throw new CFPage.TypeNotSupportedException(type);
        }
        RequestMonitorEventProcessor.onFunctionEnd("deserialize");
        return result;
    }
}

