/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Struct;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;

public enum ValidatorFiller {
    INSTANCE;


    public <T> void fillObject(T filler, Map map, ConsumerMap<T> consumerMap) {
        this.fillObject(filler, map, consumerMap, false);
    }

    public <T> void fillObject(T filler, Map map, ConsumerMap<T> consumerMap, boolean skipUnknown) {
        if (Objects.isNull(map)) {
            return;
        }
        if (!skipUnknown) {
            Set inputKeys = map.keySet();
            StringJoiner unknownKeys = null;
            boolean greaterThanOne = false;
            for (String inputKey : inputKeys) {
                if (consumerMap.get(inputKey) != null) continue;
                if (unknownKeys == null) {
                    unknownKeys = new StringJoiner(", ");
                } else {
                    greaterThanOne = true;
                }
                unknownKeys.add(inputKey);
            }
            if (unknownKeys != null) {
                throw new FieldValidationFailedException((greaterThanOne ? "Unknown Fields : " : "Unknown Field : ") + unknownKeys.toString());
            }
        }
        consumerMap.entrySet().forEach(entry -> {
            ConsumerValidator consumerValidator = (ConsumerValidator)entry.getValue();
            Object value = map.get(entry.getKey());
            if (consumerValidator != null) {
                BiConsumer biConsumer;
                List<Validator> validators = consumerValidator.getValidators();
                if (validators != null) {
                    validators.forEach(validator -> {
                        if (!validator.validate(value)) {
                            if (validator instanceof NotNullValidator) {
                                throw new FieldValidationFailedException("Field " + entry.getKey() + " is mandatory and must have a non-null value.");
                            }
                            if (value != null && value instanceof String && ((String)value).trim().isEmpty()) {
                                throw new FieldValidationFailedException("Validation failed for " + entry.getKey() + " attribute. Empty string is not allowed.");
                            }
                            throw new FieldValidationFailedException("Validation failed for key " + entry.getKey() + " which has value passed as " + value);
                        }
                    });
                }
                if ((biConsumer = consumerValidator.getBiConsumer()) != null && (map instanceof Struct && ((Struct)map).keyExists(entry.getKey()) || map.containsKey(entry.getKey()))) {
                    biConsumer.accept(filler, value);
                }
            }
        });
    }
}

