/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class GenericEnumValidator<T extends Enum>
implements Validator {
    private static Set<String> unwantedValues = new HashSet<String>(Arrays.asList("UNRECOGNIZED", "ENCODING_UNSPECIFIED", "SCHEMA_VIEW_UNSPECIFIED", "TYPE_UNSPECIFIED"));
    private Class<T> enumType;
    private Set<String> allowedValues;
    private String fieldName;

    public GenericEnumValidator(Class<T> enumType, String fieldName) {
        this.enumType = enumType;
        this.allowedValues = this.getAllValues();
        this.fieldName = fieldName;
    }

    private Set<String> getAllValues() {
        Set collect = null;
        if (this.enumType != null && this.enumType.isEnum()) {
            collect = EnumSet.allOf(this.enumType).stream().filter(name -> this.filterUnWantedValues(name)).map(name -> name.toString().toUpperCase()).collect(Collectors.toSet());
        }
        return collect;
    }

    public boolean validate(Object obj) {
        try {
            if (obj == null) {
                return true;
            }
            String value = Cast._String(obj);
            if (this.allowedValues.contains(value = value.trim().toUpperCase())) {
                return true;
            }
            if (value.length() == 0) {
                throw new FieldValidationFailedException(RB.getString(GenericEnumValidator.class, "ENUM_EMPTY_VALUE_VALIDATION_ERROR", (Object)value, (Object)this.fieldName, this.allowedValues));
            }
            throw new FieldValidationFailedException(RB.getString(GenericEnumValidator.class, "ENUM_VALUE_VALIDATION_ERROR", (Object)value, (Object)this.fieldName, this.allowedValues));
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect type for field name: " + this.fieldName, ex);
        }
    }

    private boolean filterUnWantedValues(Object value) {
        String sValue = null;
        return value == null || !unwantedValues.contains(sValue = value.toString().toUpperCase());
    }
}

