/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtoolkit;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.ArrayStructInitializer;
import coldfusion.compiler.ExprAssembler;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.ImplicitInitializerTransformer;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import coldfusion.runtime.CFVariableLexer;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class ASTDestructring
extends ExprNode {
    private static final String CF_DREF_INITIALIZER_DEFAULT_LOCAL = "__cf_dref_initdef_local";
    protected List<AssignmentElement> assignmentElements = new ArrayList<AssignmentElement>();
    private boolean hasRestOp;
    protected ExprNode restOpKeyName;
    private boolean isFinal;
    private boolean isStatic;
    private boolean isLocal;
    private boolean isFunctionParam;

    ASTDestructring(int id) {
        super(id);
    }

    public void setIsFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setIsStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isFunctionParam() {
        return this.isFunctionParam;
    }

    public void setFunctionParam(boolean isFunctionParam) {
        this.isFunctionParam = isFunctionParam;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isHasRestOp() {
        return this.hasRestOp;
    }

    public void setHasRestOp(boolean hasRestOp) {
        this.hasRestOp = hasRestOp;
    }

    public ExprNode getRestOpKeyName() {
        return this.restOpKeyName;
    }

    public void setRestOpKeyName(ExprNode restOpKeyName) {
        this.restOpKeyName = restOpKeyName;
    }

    public void addElement(AssignmentElement property) {
        if (this.assignmentElements == null) {
            this.assignmentElements = new LinkedList<AssignmentElement>();
        }
        this.assignmentElements.add(property);
    }

    public List<AssignmentElement> getElements() {
        return this.assignmentElements;
    }

    public abstract Class<?> getLocalVariableClass();

    public abstract String getCodeGenVariablePrefix();

    public Object handle(ExprNode rvalNode, ExprAssembler assembler) {
        return this.handle(rvalNode, assembler, this.isFinal, 0, -1, this.isLocal ? Boolean.TRUE : (this.isStatic ? Boolean.FALSE : null));
    }

    protected Object handle(ExprNode rvalNode, ExprAssembler assembler, boolean isFinal, int depth, int index, Boolean isLocalOrStatic) {
        String varName = this.getDerefVariableName(this.getCodeGenVariablePrefix(), depth, index);
        Object localVar = assembler.findLocal(varName);
        if (localVar == null) {
            localVar = assembler.createLocal(this.getLocalVariableClass(), varName);
        }
        if (rvalNode != null) {
            assembler.assembleExpr(rvalNode);
        }
        assembler.invoke(this.getRHSMethod());
        assembler.store(localVar);
        return this.handle(assembler, localVar, isFinal, depth, isLocalOrStatic);
    }

    protected abstract Object handle(ExprAssembler var1, Object var2, boolean var3, int var4, Boolean var5);

    protected String getDerefVariableName(String prefix, int depth, int index) {
        if (depth > 0) {
            prefix = (String)prefix + depth;
        }
        if (index > -1) {
            prefix = (String)prefix + index;
        }
        return prefix;
    }

    public abstract Method getRHSMethod();

    protected void handleKey(ExprNode keyExpr, ExprAssembler assembler) {
        this.handleKey(keyExpr, assembler, String.class);
    }

    protected void handleKey(ExprNode keyExpr, ExprAssembler assembler, Class<?> cls) {
        String fullVarName;
        if (keyExpr instanceof ASTsimpleVariableReference && (fullVarName = this.getFullVariableName((ASTsimpleVariableReference)keyExpr)) != null) {
            assembler.aconst(this.validateVariable(fullVarName, keyExpr));
        } else if (keyExpr instanceof ASTstructureReference && ((ASTstructureReference)keyExpr).getStem() instanceof ASTsimpleVariableReference) {
            String[] keys = ((ASTstructureReference)keyExpr).getStructureKeys();
            StringBuilder newKey = new StringBuilder();
            for (int i = keys.length - 1; i > -1; --i) {
                newKey.insert(0, "." + keys[i]);
            }
            newKey.insert(0, ((ASTstructureReference)keyExpr).getStem().getStartToken().image);
            assembler.aconst(newKey.toString());
        } else if (keyExpr instanceof ASTarrayReference && ((ASTarrayReference)keyExpr).getStem() instanceof ASTsimpleVariableReference) {
            ASTarrayReference arrayRef = (ASTarrayReference)keyExpr;
            assembler.aconst(((ASTsimpleVariableReference)arrayRef.getStem()).getCodegenVariableName().toUpperCase());
            assembler.newarray(ExprAssembler.ObjectClass, arrayRef.indices.toArray());
            arrayRef.setIsLHS();
        } else if (cls != null) {
            assembler.cast(keyExpr, cls);
        } else {
            assembler.assembleExpr(keyExpr);
        }
    }

    protected Node preTransformRoot(NeoTranslationContext tc) {
        if (this.isLocal && this.getFunctionDef() == null) {
            throw new ASTvariableDefinition.InvalidDestructuringVarDefinition(this.getStartToken());
        }
        return this.preTransform(tc, this.isLocal);
    }

    protected Node preTransform(NeoTranslationContext tc, boolean isLocal) {
        for (AssignmentElement element : this.assignmentElements) {
            this.preTransformDefault(tc, element);
            if (element.value instanceof ASTDestructring) {
                ((ASTDestructring)element.value).preTransform(tc, isLocal);
            } else if (isLocal) {
                this.registerLocalVar(element.value);
            }
            this.preTransform(tc, element, isLocal);
        }
        if (isLocal) {
            this.registerLocalVar(this.restOpKeyName);
        }
        return this;
    }

    protected void preTransform(NeoTranslationContext tc, AssignmentElement element, boolean isLocal) {
    }

    protected void registerLocalVar(ExprNode node) {
        if (node != null && node instanceof ASTsimpleVariableReference && this.getFullVariableName((ASTsimpleVariableReference)node) != null) {
            ASTvariableDefinition varDef = new ASTvariableDefinition(6);
            ASTsimpleVariableReference ref = (ASTsimpleVariableReference)node;
            varDef.setVariableName(ref.getStartToken());
            varDef.jjtSetParent(ref.jjtGetParent());
            varDef.register();
        }
    }

    private void insertCast(ASTcfscriptStatement cfscriptStatement, Class type) {
        for (Node parent : cfscriptStatement.children) {
            Node rvalNode = parent.getNamedAttribute("RVAL");
            if (!(rvalNode instanceof ExprNode)) continue;
            if (rvalNode == null) {
                rvalNode = new ASTliteral(null, parent);
            }
            rvalNode = ASTtoolkit.cast(rvalNode, type);
            parent.setNamedAttribute("RVAL", rvalNode);
        }
    }

    protected void preTransformDefault(NeoTranslationContext tc, AssignmentElement element) {
        Node n = element.defaultValue;
        if (n instanceof ArrayStructInitializer) {
            String varName = "___IMPLICITARRYSTRUCTVAR" + tc.getImplicitArrayStructCount();
            Token varNameTok = Token.newToken(0);
            varNameTok.image = varName;
            ASTcfscriptStatement statement = new ASTcfscriptStatement(3);
            statement.insertedNode = true;
            statement.implicitArrayStructVarName = varName;
            statement.parser = n.parser;
            statement.setStatementType(3);
            statement.setStartToken(n.getStartToken());
            ASTsimpleVariableReference implictVar = new ASTsimpleVariableReference(varNameTok);
            implictVar.setImplicitVariable(true);
            implictVar.parser = n.parser;
            statement.setNamedAttribute("LVAL", implictVar);
            statement.setNamedAttribute("RVAL", n);
            statement.jjtSetParent(this.jjtGetParent());
            ImplicitInitializerTransformer.pretransformInitializer(statement);
            this.insertCast(statement, Object.class);
            statement.id = 4;
            element.defaultValueInitializerStmt = statement;
            element.defaultValue = implictVar;
            this.optimize(implictVar);
        }
    }

    protected void optimize() {
        for (AssignmentElement element : this.assignmentElements) {
            this.optimize(element.value);
            if (element.defaultValue instanceof ExprNode) {
                this.optimize((ExprNode)element.defaultValue);
            }
            this.optimize(element);
        }
        this.optimize(this.restOpKeyName);
    }

    protected void optimize(AssignmentElement n) {
    }

    protected void optimize(ExprNode n) {
        if (n != null) {
            if (n instanceof ASTDestructring) {
                ((ASTDestructring)n).optimize();
            } else {
                switch (n.id) {
                    case 10001: {
                        this.optimize((ASTruntimeCall)n);
                        break;
                    }
                    case 10002: {
                        ASTsimpleVariableReference varRef = (ASTsimpleVariableReference)n;
                        if (!(n.jjtGetParent() instanceof ASTDestructring)) break;
                        ASTDestructring parent = (ASTDestructring)n.jjtGetParent();
                        varRef.declareVariable(varRef.getCodegenVariableName(), parent.isFinal);
                    }
                }
            }
        }
    }

    protected void optimize(ASTruntimeCall call) {
        if (!call.isBuiltin()) {
            VariableReference stem = call.getStem();
            if (stem instanceof ASTsimpleVariableReference) {
                this.optimize((ASTsimpleVariableReference)stem);
            }
        } else {
            call.setMethod();
        }
    }

    protected void optimize(ASTsimpleVariableReference varRef) {
        varRef.declareVariable(varRef.getCodegenVariableName(), false);
    }

    protected String validateVariable(String image, Node n) {
        if (image.length() == 0 || Character.isDigit(image.charAt(0)) || image.charAt(0) == '.' || !CFVariableLexer.isValidVariableName(image)) {
            throw ParseException.wrap(new CFTypeValidatorFactory.InvalidVariableNameException(image), n);
        }
        return image;
    }

    protected static Object getInitializerDefaultLocal(ExprAssembler assembler) {
        return ASTDestructring.getInitializerLocal(assembler, CF_DREF_INITIALIZER_DEFAULT_LOCAL);
    }

    protected static Object getInitializerLocal(ExprAssembler assembler, String name) {
        Object localVar = assembler.findLocal(name);
        if (localVar == null) {
            return assembler.createLocal(Object.class, name);
        }
        return localVar;
    }

    protected void handleInitializerDefaultValue(ExprAssembler assembler, AssignmentElement element) {
        if (element.defaultValue instanceof ASTcfscriptStatement) {
            ASTcfscriptStatement stmt = (ASTcfscriptStatement)element.defaultValue;
            assembler.assignStatement((ExprNode)stmt.getNamedAttribute("LVAL"), stmt.getNamedAttribute("RVAL"));
        }
    }

    protected String getFullVariableName(ASTsimpleVariableReference varRef) {
        StringBuilder fullVarName = new StringBuilder(varRef.getStartToken().image);
        while (varRef.getStem() instanceof ASTsimpleVariableReference) {
            varRef = (ASTsimpleVariableReference)varRef.getStem();
            fullVarName.insert(0, varRef.getStartToken().image + ".");
        }
        if (varRef.getStem() == null) {
            return fullVarName.toString();
        }
        return null;
    }

    protected void handleScopeVariable(ExprNode keyExpr, ExprAssembler assembler) {
        if (keyExpr != null) {
            String fullVarName;
            if (keyExpr instanceof ASTsimpleVariableReference && (fullVarName = this.getFullVariableName((ASTsimpleVariableReference)keyExpr)) != null) {
                this.validateVariable(fullVarName, keyExpr);
                assembler.newarray(ExprAssembler.ObjectClass, fullVarName.split("\\."));
            } else if (keyExpr instanceof ASTstructureReference && ((ASTstructureReference)keyExpr).getStem() instanceof ASTsimpleVariableReference) {
                String[] keys = ((ASTstructureReference)keyExpr).getStructureKeys();
                Object[] newKeys = new String[keys.length + 1];
                newKeys[0] = ((ASTstructureReference)keyExpr).getStem().getStartToken().image;
                int j = 1;
                for (int i = keys.length - 1; i > -1; --i) {
                    newKeys[j++] = keys[i];
                }
                assembler.newarray(ExprAssembler.ObjectClass, newKeys);
            } else {
                assembler.newarray(ExprAssembler.ObjectClass, new Object[]{keyExpr});
            }
        } else {
            assembler.aconst(null);
        }
    }

    public static class AssignmentElement {
        public ExprNode value;
        public Node defaultValue;
        public ASTcfscriptStatement defaultValueInitializerStmt;

        public AssignmentElement(ExprNode value, Node defaultValue) {
            this.value = value;
            this.defaultValue = defaultValue;
        }
    }
}

