/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ExprAssembler;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.StmtAssembler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ASTObjectDestructuring
extends ASTDestructring {
    static final Method setDref = JavaAssembler.getInstanceMethod(ExprAssembler.CfJspPageClass, "_setDref_Struct", new Class[]{JavaAssembler.StringClass, ExprAssembler.MapClass, ExprAssembler.ObjectClass, JavaAssembler.booleanClass});
    static final Method setDref_Default = JavaAssembler.getInstanceMethod(ExprAssembler.CfJspPageClass, "_setDref_Struct", new Class[]{JavaAssembler.StringClass, ExprAssembler.MapClass, ExprAssembler.ObjectClass, JavaAssembler.booleanClass, ExprAssembler.ObjectClass});
    static final Method structsetDref = JavaAssembler.getInstanceMethod(ExprAssembler.CfJspPageClass, "_structSetAtDRef", new Class[]{ExprAssembler.ObjectClass, ExprAssembler.ObjectArrayClass, ExprAssembler.MapClass, ExprAssembler.ObjectClass, JavaAssembler.booleanClass});
    static final Method structsetDref_Default = JavaAssembler.getInstanceMethod(ExprAssembler.CfJspPageClass, "_structSetAtDRef_Default", new Class[]{ExprAssembler.ObjectClass, ExprAssembler.ObjectArrayClass, ExprAssembler.MapClass, ExprAssembler.ObjectClass, JavaAssembler.booleanClass, ExprAssembler.ObjectClass});
    static final Method dRefMapGet = JavaAssembler.getStaticMethod(ExprAssembler.CfJspPageClass, "_dref_map_get", new Class[]{ExprAssembler.MapClass, ExprAssembler.ObjectClass, JavaAssembler.booleanClass});
    static final Method dRefMapGet_Default = JavaAssembler.getStaticMethod(ExprAssembler.CfJspPageClass, "_dref_map_get", new Class[]{ExprAssembler.MapClass, ExprAssembler.ObjectClass, JavaAssembler.booleanClass, ExprAssembler.ObjectClass});
    static final Method dRefMapRest = JavaAssembler.getStaticMethod(ExprAssembler.CfJspPageClass, "_dref_map_rest", new Class[]{ExprAssembler.MapClass, List.class});
    static final Method castMap = JavaAssembler.getStaticMethod(ExprAssembler.CastClass, "_Map", new Class[]{ExprAssembler.ObjectClass});
    static final Constructor newArrayList = JavaAssembler.getConstructor(ArrayList.class, new Class[]{JavaAssembler.intClass});
    static final Method arrayListAdd = JavaAssembler.getInstanceMethod(List.class, "add", new Class[]{ExprAssembler.ObjectClass});

    ASTObjectDestructuring(int id) {
        super(id);
    }

    @Override
    public Class<?> getLocalVariableClass() {
        return Map.class;
    }

    @Override
    public String getCodeGenVariablePrefix() {
        return "__cf_internal_sdref_";
    }

    @Override
    protected Object handle(ExprAssembler assembler, Object localVarRef, boolean isFinal, int depth, Boolean isLocalOrStatic) {
        ObjectAssignmentProperty property;
        Object restKeys = null;
        if (this.isHasRestOp()) {
            String varName = this.getDerefVariableName(this.getCodeGenVariablePrefix() + "__restkeys", depth, -1);
            restKeys = assembler.findLocal(varName);
            if (restKeys == null) {
                restKeys = assembler.createLocal(ArrayList.class, varName);
            }
            assembler.newinstance(ArrayList.class);
            assembler.iconst(4);
            assembler.invokespecial(newArrayList);
            assembler.store(restKeys);
        }
        Object label = null;
        int index = 0;
        for (ASTDestructring.AssignmentElement element : this.assignmentElements) {
            property = (ObjectAssignmentProperty)element;
            if (element.defaultValueInitializerStmt != null) {
                ((StmtAssembler)assembler).assembleStatement(element.defaultValueInitializerStmt);
            }
            if (element.value == null) {
                label = isLocalOrStatic != null ? this.handleScopeDeclaration(assembler, property, isFinal, localVarRef, isLocalOrStatic) : this.handleVariableDeclaration(assembler, property, isFinal, localVarRef);
            } else {
                ASTDestructring innerDerefNode = (ASTDestructring)element.value;
                assembler.load(localVarRef);
                this.handleKey(property.key, assembler, null);
                assembler.aconst(innerDerefNode instanceof ASTObjectDestructuring);
                if (element.defaultValue != null) {
                    assembler.cast((ExprNode)element.defaultValue, ExprAssembler.ObjectClass);
                    assembler.invoke(dRefMapGet_Default);
                } else {
                    assembler.invoke(dRefMapGet);
                }
                innerDerefNode.handle(null, assembler, isFinal, depth + 1, index, isLocalOrStatic);
            }
            ++index;
        }
        if (this.isHasRestOp()) {
            for (ASTDestructring.AssignmentElement element : this.assignmentElements) {
                property = (ObjectAssignmentProperty)element;
                assembler.load(restKeys);
                this.handleKey(property.key, assembler, null);
                assembler.invoke(arrayListAdd);
                assembler.pop(JavaAssembler.booleanClass);
            }
            label = isLocalOrStatic != null ? this.handleScopeRestDeclaration(assembler, isFinal, localVarRef, restKeys, isLocalOrStatic) : this.handleRestVariableDeclaration(assembler, isFinal, localVarRef, restKeys);
        }
        return label;
    }

    protected Object handleVariableDeclaration(ExprAssembler assembler, ObjectAssignmentProperty property, boolean isFinal, Object localVarRef) {
        Object label = assembler.load(assembler.pageVar);
        if (property.label != null) {
            this.handleKey(property.label, assembler);
        } else {
            assembler.aconst(null);
        }
        assembler.load(localVarRef);
        this.handleKey(property.key, assembler, null);
        assembler.aconst(isFinal);
        if (property.defaultValue != null) {
            assembler.cast((ExprNode)property.defaultValue, ExprAssembler.ObjectClass);
            assembler.invoke(setDref_Default);
        } else {
            assembler.invoke(setDref);
        }
        return label;
    }

    protected Object handleRestVariableDeclaration(ExprAssembler assembler, boolean isFinal, Object localVarRef, Object restKeys) {
        Object label = assembler.load(assembler.pageVar);
        this.handleKey(this.restOpKeyName, assembler);
        assembler.load(localVarRef);
        assembler.load(restKeys);
        assembler.invoke(dRefMapRest);
        assembler.invoke(isFinal ? ExprAssembler.set_Final : ExprAssembler.set);
        return label;
    }

    protected Object handleScopeDeclaration(ExprAssembler assembler, ObjectAssignmentProperty property, boolean isFinal, Object localVarRef, boolean isLocalOrStatic) {
        Object label = assembler.load(assembler.pageVar);
        if (isLocalOrStatic) {
            assembler.load(assembler.findLocal("__localScope"));
        } else {
            assembler.getstatic(assembler.findField(assembler.getStaticScopeVarName()));
        }
        this.handleScopeVariable(property.label, assembler);
        assembler.load(localVarRef);
        this.handleKey(property.key, assembler, null);
        assembler.aconst(isFinal);
        if (property.defaultValue != null) {
            assembler.cast((ExprNode)property.defaultValue, ExprAssembler.ObjectClass);
            assembler.invoke(structsetDref_Default);
        } else {
            assembler.invoke(structsetDref);
        }
        return label;
    }

    protected Object handleScopeRestDeclaration(ExprAssembler assembler, boolean isFinal, Object localVarRef, Object restKeys, boolean isLocalOrStatic) {
        Object label = assembler.load(assembler.pageVar);
        if (isLocalOrStatic) {
            assembler.load(assembler.findLocal("__localScope"));
        } else {
            assembler.getstatic(assembler.findField(assembler.getStaticScopeVarName()));
        }
        this.handleScopeVariable(this.restOpKeyName, assembler);
        assembler.load(localVarRef);
        assembler.load(restKeys);
        assembler.invoke(dRefMapRest);
        assembler.invoke(isFinal ? ExprAssembler.structSetObjectFinal : ExprAssembler.structSetObject);
        return label;
    }

    @Override
    public Method getRHSMethod() {
        return castMap;
    }

    @Override
    protected void optimize(ASTDestructring.AssignmentElement element) {
        ObjectAssignmentProperty property = (ObjectAssignmentProperty)element;
        this.optimize(property.key);
        this.optimize(property.label);
    }

    @Override
    protected void preTransform(NeoTranslationContext tc, ASTDestructring.AssignmentElement element, boolean isLocal) {
        ObjectAssignmentProperty property = (ObjectAssignmentProperty)element;
        if (property.value == null && isLocal) {
            this.registerLocalVar(property.label != null ? property.label : property.key);
        }
    }

    public static class ObjectAssignmentProperty
    extends ASTDestructring.AssignmentElement {
        public ExprNode key;
        public ExprNode label;

        public ObjectAssignmentProperty(ExprNode value, ExprNode defaultValue, ExprNode key, ExprNode label) {
            super(value, defaultValue);
            this.key = key;
            this.label = label;
        }
    }
}

