/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.IndexedVariable;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import java.util.Vector;

public final class ASTarrayReference
extends VariableReference
implements IndexedVariable {
    protected Vector indices;
    protected Vector safeHooks;
    private boolean usedInLHS = false;
    private boolean afterSpread;
    private Object rvalIndex;

    public Object getRvalIndex() {
        return this.rvalIndex;
    }

    public void setRvalIndex(Object rvalIndex) {
        this.rvalIndex = rvalIndex;
    }

    ASTarrayReference(VariableReference stem) {
        super(10000);
        this.setStem(stem);
        stem.isLeafReference = false;
        stem.jjtSetParent(this);
    }

    ASTarrayReference(VariableReference stem, ExprNode index) {
        this(stem);
        this.addIndex(index);
    }

    ASTarrayReference(VariableReference stem, ExprNode index, CFMLParserBase parser) {
        this(stem, index);
        this.setParser(parser);
    }

    public void setIsLHS() {
        this.usedInLHS = true;
    }

    public boolean isUsedInLHS() {
        return this.usedInLHS;
    }

    public void setAfterSpread(boolean spreadOperation) {
        this.afterSpread = spreadOperation;
    }

    public boolean isAfterSpread() {
        return this.afterSpread;
    }

    public void addIndex(ExprNode nextIndex) {
        if (this.indices == null) {
            this.indices = new Vector();
        }
        if (this.safeHooks == null) {
            this.safeHooks = new Vector();
        }
        this.indices.add(nextIndex);
        if (this.getStem() != null && this.getStem() instanceof ASTsimpleVariableReference && ((ASTsimpleVariableReference)this.getStem()).isSafePreHook()) {
            this.safeHooks.add(new Boolean(nextIndex.hasSafeHook()).toString());
        }
        this.setNamedAttribute("INDEX" + (this.indices.size() - 1), nextIndex);
        nextIndex.jjtSetParent(this);
        this.setType(Object.class);
    }

    @Override
    public void setNamedAttribute(String key, Node value) {
        if (key.startsWith("INDEX")) {
            int i = Integer.parseInt(key.substring(5));
            this.indices.set(i, value);
        }
        super.setNamedAttribute(key, value);
    }

    @Override
    public Node getNamedAttribute(String key) {
        if (key.startsWith("INDEX")) {
            int i = Integer.parseInt(key.substring(5));
            return (Node)this.indices.get(i);
        }
        return super.getNamedAttribute(key);
    }

    @Override
    public ExprNode getIndex(int i) {
        return (ExprNode)this.indices.elementAt(i);
    }

    public ExprNode removeIndex() {
        return (ExprNode)this.indices.remove(this.indices.size() - 1);
    }

    @Override
    void setParser(CFMLParserBase parser) {
        super.setParser(parser);
        int count = this.indices.size();
        for (int i = 0; i < count; ++i) {
            this.getIndex(i).setParser(parser);
        }
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        cfml.visit(this);
        this.getStem().accept(cfml);
    }

    public boolean isFinal() {
        String finalYesNo;
        ASTliteral finalMarker;
        boolean isFinal = false;
        if (this.getNamedAttribute("IS_FINAL_VARIABLE") != null && (finalMarker = (ASTliteral)this.getNamedAttribute("IS_FINAL_VARIABLE")) != null && finalMarker.tokens != null && finalMarker.tokens.size() > 0 && "TRUE".equals(finalYesNo = (String)finalMarker.tokens.get(0))) {
            isFinal = true;
        }
        return isFinal;
    }

    public boolean hasAssignment() {
        Node node = this.jjtGetParent();
        while (node != null) {
            if (node instanceof ASTcfscriptStatement) {
                Token assignmentOp = ((ASTcfscriptStatement)node).assignmentOpToken;
                return assignmentOp != null && assignmentOp.image.equals("=");
            }
            if (node instanceof ASTstart || node instanceof ASTfunctionDefinition) {
                return false;
            }
            node = node.jjtGetParent();
        }
        return false;
    }

    public void checkForFinalArgumentOverride() {
        String stemName;
        ASTsimpleVariableReference varRef;
        ASTfunctionDefinition functionDef = this.getFunctionDef();
        if (functionDef != null && this.hasAssignment() && this.getStem() != null && this.getStem() instanceof ASTsimpleVariableReference && (varRef = (ASTsimpleVariableReference)this.getStem()) != null && (stemName = varRef.getCodegenVariableName()) != null && stemName.equalsIgnoreCase("ARGUMENTS")) {
            Vector indices = this.indices;
            ASTparameterDefinition paramDef = functionDef.getParameterdefinition();
            if (paramDef != null && indices != null && indices.size() > 0) {
                for (int index = 0; index < indices.size(); ++index) {
                    String val;
                    ASTliteral literal;
                    if (!(indices.get(index) instanceof ASTliteral) || (literal = (ASTliteral)indices.get(index)) == null || literal.tokens == null || literal.tokens.size() <= 0 || !(literal.tokens.get(0) instanceof String) || !paramDef.hasFinalParameter(val = (String)literal.tokens.get(0))) continue;
                    throw new ASTsimpleVariableReference.FunctionFinalParamMutationException(val, functionDef.functionName.image);
                }
            }
        }
    }
}

