/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.InterfaceParseExceptions;
import coldfusion.compiler.NonConstantExpressionException;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.tagext.validation.AttributeValueNotFromListException;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import coldfusion.tagext.validation.RequiredAttributesException;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import java.util.HashSet;
import java.util.Iterator;

public class ASTcffunction
extends ASTfunctionDefinition {
    public static final String PRIVATE = "PRIVATE";
    public static final String PUBLIC = "PUBLIC";
    public static final String PACKAGE = "PACKAGE";
    public static final String REMOTE = "REMOTE";
    FastHashtable attrMap;
    boolean output;

    ASTcffunction(int id) {
        super(id);
    }

    final void setAttrList(String cfClosureName, ASTexprlist e) {
        Token anonymousClosureToken = Token.newToken(0);
        this.attrMap = new FastHashtable();
        e.populateMap(this.attrMap);
        anonymousClosureToken.image = "_CF_ANONYMOUSCLOSURE_" + closureCount++;
        this.anonymousClosure = true;
        this.closure = true;
        this.setAttrList(anonymousClosureToken, e);
    }

    final void setAttrList(Token cffunctionToken, ASTexprlist e) {
        String tagName = "CFFUNCTION";
        if (this.calledName != null) {
            tagName = this.calledName;
        }
        this.attrList = e;
        e.jjtSetParent(this);
        this.attrMap = new FastHashtable();
        e.populateMap(this.attrMap);
        HashSet keys = new HashSet(this.attrMap.keySet());
        ExprNode node = (ExprNode)this.attrMap.get("name");
        if (node != null) {
            super.setName(ASTcffunction.extractToken(node, cffunctionToken, "name"));
            keys.remove("name");
        } else if (this.attrMap.get("anonymousClosure") != null) {
            super.setNameForClosure(cffunctionToken);
        } else {
            throw new RequiredAttributesException(tagName, "name");
        }
        String attrName = "";
        try {
            Token t;
            String value;
            String value2;
            attrName = "output";
            node = (ExprNode)this.attrMap.get(attrName);
            if (node != null) {
                String outputValue = node instanceof ASToperator && ((ASToperator)node).id == 215 ? EvaluateEngine._String(node) : ASTcffunction.extractToken((ExprNode)node, (Token)cffunctionToken, (String)attrName).image;
                this.output = Cast._boolean(outputValue);
                if (this.output) {
                    this.parser.pushBodyTag(cffunctionToken);
                }
                keys.remove(attrName);
            }
            if ((node = (ExprNode)this.attrMap.get(attrName = "access")) != null) {
                value2 = EvaluateEngine._String(node);
                if (!"".equals(value2)) {
                    String accessValue = Cast._String(ASTcffunction.extractToken((ExprNode)node, (Token)cffunctionToken, (String)attrName).image).toUpperCase();
                    if (!(accessValue.equals(PRIVATE) || accessValue.equals(PACKAGE) || accessValue.equals(PUBLIC) || accessValue.equals(REMOTE))) {
                        throw new AttributeValueNotFromListException(tagName, attrName, accessValue, "private, package, public, remote");
                    }
                    if (this.parser.isInterface() && !accessValue.equals(PUBLIC)) {
                        InterfaceParseExceptions.throwInvalidInterfaceMethodAccess(accessValue);
                    }
                }
                keys.remove(attrName);
            }
            if ((node = (ExprNode)this.attrMap.get(attrName = "roles")) != null) {
                if (this.parser.isInterface()) {
                    InterfaceParseExceptions.throwInterfaceRolesAttibException();
                }
                if (!"".equals(value2 = EvaluateEngine._String(node))) {
                    Token t2 = ASTcffunction.extractToken(node, cffunctionToken, attrName);
                    if (t2 == null) {
                        throw new IllegalAttributeValueException(tagName, attrName, "");
                    }
                    Cast._String(t2.image);
                }
                keys.remove(attrName);
            }
            attrName = "returnType";
            String returnType = null;
            node = (ExprNode)this.attrMap.get(attrName);
            if (node != null) {
                value = EvaluateEngine._String(node);
                if (!"".equals(value)) {
                    t = ASTcffunction.extractToken(node, cffunctionToken, attrName);
                    if (t == null) {
                        throw new IllegalAttributeValueException(tagName, attrName, "");
                    }
                    returnType = Cast._String(t.image).trim().toUpperCase();
                }
                keys.remove(attrName);
            }
            if ((node = (ExprNode)this.attrMap.get(attrName = "returnFormat")) != null) {
                value = EvaluateEngine._String(node);
                if (!"".equals(value)) {
                    String returnFormatValue = Cast._String(ASTcffunction.extractToken((ExprNode)node, (Token)cffunctionToken, (String)attrName).image).toUpperCase();
                    if (!(returnFormatValue.equals("WDDX") || returnFormatValue.equals("JSON") || returnFormatValue.equals("PLAIN"))) {
                        throw new AttributeValueNotFromListException(tagName, attrName, returnFormatValue, "wddx, json, plain");
                    }
                    if (!(!returnFormatValue.equals("PLAIN") || returnType == null || returnType.equals("ANY") || returnType.equals("BOOLEAN") || returnType.equals("DATE") || returnType.equals("GUID") || returnType.equals("NUMERIC") || returnType.equals("STRING") || returnType.equals("UUID") || returnType.equals("VARIABLENAME") || returnType.equals("XML"))) {
                        throw new IllegalAttributeValueException(tagName, attrName, RB.getString(ASTcffunction.class, "ASTcffunction.invalidReturnFormatType"));
                    }
                }
                keys.remove(attrName);
            }
            if ((node = (ExprNode)this.attrMap.get(attrName = "securejson")) != null) {
                value = EvaluateEngine._String(node);
                if (!"".equals(value)) {
                    t = ASTcffunction.extractToken(node, cffunctionToken, attrName);
                    if (t == null) {
                        throw new IllegalAttributeValueException(tagName, attrName, "");
                    }
                    try {
                        Cast._boolean(t.image);
                    }
                    catch (Exception ex) {
                        throw new AttributeValueNotFromListException(tagName, attrName, value, "yes, no, true, false");
                    }
                }
                keys.remove(attrName);
            }
            if ((node = (ExprNode)this.attrMap.get(attrName = "verifyclient")) != null) {
                value = EvaluateEngine._String(node);
                if (!"".equals(value)) {
                    t = ASTcffunction.extractToken(node, cffunctionToken, attrName);
                    if (t == null) {
                        throw new IllegalAttributeValueException(tagName, attrName, "");
                    }
                    try {
                        Cast._boolean(t.image);
                    }
                    catch (Exception ex) {
                        throw new AttributeValueNotFromListException(tagName, attrName, value, "yes, no, true, false");
                    }
                }
                keys.remove(attrName);
            }
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                attrName = it.next().toString();
                Object attrVal = this.attrMap.get(attrName);
                if (attrVal == null || !(attrVal instanceof ExprNode)) continue;
                node = (ExprNode)attrVal;
                EvaluateEngine._String(node);
            }
        }
        catch (ExpressionException ex) {
            throw new IllegalAttributeValueException(tagName, attrName, ex.getMessage());
        }
        catch (NonConstantExpressionException nce) {
            throw nce;
        }
        catch (ParseException ex) {
            Object detail = ex.getDetail();
            if (ex instanceof InterfaceParseExceptions.InterfaceExceptionType) {
                String message = ex.getMessage();
                detail = message + " " + (String)detail;
            }
            throw new IllegalAttributeValueException(tagName, attrName, (String)detail);
        }
    }

    @Override
    void jjtClose() {
        if (this.output) {
            this.parser.popBodyTag();
        }
        super.jjtClose();
    }
}

