/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.ParseException;

public final class ASTcfimport
extends ASTcftag {
    private String namespace;
    private String taglib;
    private String webservice;
    private boolean checkLic = false;

    ASTcfimport(int id) {
        super(id);
    }

    boolean shouldCheckLic() {
        return this.checkLic;
    }

    void doImport() throws ParseException {
        ExprNode taglibNode = this.getAttrNode("TAGLIB");
        ExprNode namespaceNode = this.getAttrNode("PREFIX");
        ExprNode importPathNode = this.getAttrNode("PATH");
        if (importPathNode != null && (taglibNode != null || namespaceNode != null)) {
            throw new InvalidAttributeCombination();
        }
        if (importPathNode != null) {
            this.getTranslationContext().registerImportPath(EvaluateEngine._String(importPathNode));
        }
        if (taglibNode != null) {
            this.taglib = EvaluateEngine._String(taglibNode);
        }
        if (namespaceNode != null) {
            this.namespace = EvaluateEngine._String(namespaceNode);
            if (this.namespace.length() > 0 && !this.namespace.endsWith(":") && !this.namespace.endsWith("_")) {
                this.namespace = this.namespace + ":";
            }
        } else {
            this.namespace = "";
        }
        if (this.taglib != null) {
            try {
                if (!this.getTranslationContext().registerTaglib(this.namespace, this.taglib)) {
                    this.checkLic = true;
                }
            }
            catch (Exception e) {
                throw new TaglibLookupException(this.taglib, e);
            }
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        cfml.visit(this);
    }

    public static class InvalidAttributeCombination
    extends AbstractParseException {
    }

    public static class TaglibLookupException
    extends AbstractParseException {
        public String taglib;

        public TaglibLookupException(String taglib, Throwable rootCause) {
            super(rootCause);
            this.taglib = taglib;
        }

        public String getCauseString() {
            return this.getRootCause().getMessage();
        }
    }
}

