/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.NamedAttributeNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.Token;
import java.util.Enumeration;

public final class ASTcfscriptStatement
extends StatementNode
implements NamedAttributeNode {
    static final int STATEMENT_LIST = 1;
    static final int IF = 2;
    static final int ASSIGNMENT = 3;
    static final int EXPRESSION = 4;
    static final int FOR = 5;
    static final int WHILE = 6;
    static final int DO = 7;
    static final int CONTINUE = 9;
    static final int STRUCT_LOOP = 10;
    static final int ARRAY_STRUCT_IMPLICIT_INITIALIZER = 11;
    int stmtType;
    static final int DIV_ASSIGNMENT = 12;
    static final int PLUS_ASSIGNMENT = 13;
    static final int MINUS_ASSIGNMENT = 15;
    static final int MOD_ASSIGNMENT = 16;
    static final int MULT_ASSIGNMENT = 17;
    static final int CONCAT_ASSIGNMENT = 18;
    static final int BREAK = 19;
    static final int STATIC_BLOCK = 20;
    Token assignmentOpToken;
    int stmtSubType;
    String implicitArrayStructVarName;
    private String validationLval;
    private boolean assignTransformed = false;
    private String label;
    private boolean isStringLiteralInvocation = false;

    public boolean isStringLiteralInvocation() {
        return this.isStringLiteralInvocation;
    }

    public void setStringLiteralInvocation(boolean stringLiteralInvocation) {
        this.isStringLiteralInvocation = stringLiteralInvocation;
    }

    void setStatementType(int type) {
        this.stmtType = type;
    }

    int getStatementType() {
        return this.stmtType;
    }

    ASTcfscriptStatement(int id) {
        super(id);
    }

    ASTcfscriptStatement(int id, int type) {
        this(id);
        this.setStatementType(type);
    }

    ExprNode getExpression(String key) {
        return (ExprNode)this.getNamedAttribute(key);
    }

    Node getNode(String key) {
        return this.getNamedAttribute(key);
    }

    StatementNode getStatement(String key) {
        return (StatementNode)this.getNamedAttribute(key);
    }

    public String getValidatableName() {
        return this.validationLval;
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        if (this.stmtType == 3) {
            ExprNode lval = this.getExpression("LVAL");
            if (lval instanceof ASTstructureReference) {
                this.validationLval = ((ASTstructureReference)lval).validatableName();
                cfml.visit(this);
            } else if (lval instanceof ASTsimpleVariableReference) {
                this.validationLval = ((ASTsimpleVariableReference)lval).getVariableName();
                cfml.visit(this);
            }
        }
        Enumeration keys = this.getAttrNames();
        while (keys.hasMoreElements()) {
            String name = keys.nextElement().toString();
            Node value = this.getNamedAttribute(name);
            value.accept(cfml);
        }
        this.walkChildren(cfml);
    }

    public String toString() {
        return super.toString() + " type " + this.stmtType;
    }

    int getStmtSubType() {
        return this.stmtSubType;
    }

    void setStmtSubType(Token t) {
        this.assignmentOpToken = t;
        String op = t.image;
        int opType = t.kind;
        switch (t.kind) {
            case 130: {
                this.stmtSubType = 17;
                break;
            }
            case 131: {
                this.stmtSubType = 12;
                break;
            }
            case 132: {
                this.stmtSubType = 13;
                break;
            }
            case 133: {
                this.stmtSubType = 15;
                break;
            }
            case 135: {
                this.stmtSubType = 16;
                break;
            }
            case 134: {
                this.stmtSubType = 18;
                break;
            }
        }
    }

    private int getAssignOp() {
        switch (this.stmtSubType) {
            case 17: {
                return 204;
            }
            case 12: {
                return 205;
            }
            case 13: {
                return 200;
            }
            case 15: {
                return 201;
            }
            case 16: {
                return 203;
            }
            case 18: {
                return 202;
            }
        }
        throw new RuntimeException();
    }

    void preTransformAssignment(Class operandClass) {
        if (this.assignTransformed) {
            return;
        }
        if (this.stmtSubType != 0) {
            int opType = this.getAssignOp();
            ASToperator op = new ASToperator(opType);
            op.jjtAddChild(this.getExpression("LVAL"), 0);
            op.jjtAddChild(this.getExpression("RVAL"), 1);
            if (opType == 203) {
                op.setOperator(this.assignmentOpToken, opType, JavaAssembler.intClass);
            } else if (opType == 202) {
                op.setOperator(this.assignmentOpToken, opType, JavaAssembler.StringClass);
            } else {
                op.setOperator(this.assignmentOpToken, opType, operandClass);
            }
            this.setNamedAttribute("RVAL", op);
            op.setStartToken(this.assignmentOpToken);
            this.assignTransformed = true;
        }
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

