/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.MethodArgumentMismatchException;
import coldfusion.compiler.MethodNotFoundException;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.RunAsyncNamedParameterValidationException;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import coldfusion.compiler.cfml40TreeConstants;
import coldfusion.runtime.CFComponent;
import coldfusion.runtime.CFPage;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ASTruntimeCall
extends VariableReference
implements cfml40TreeConstants {
    public static final String ARRAYPUSH = "ArrayPush";
    public static final String ARRAYUNSHIFT = "ArrayUnshift";
    public static final String PRECISIONEVALUATE = "PrecisionEvaluate";
    public static final String EVALUATE = "Evaluate";
    public static final String ARRAYPUSH_VARIADIC = "arrayPushVariadic";
    public static final String ARRAYUNSHIFT_VARIADIC = "arrayUnshiftVariadic";
    public static final String PRECISION_EVALUATE_VARIADIC = "precisionEvaluateVariadic";
    public static final String EVALUATE_VARIADIC = "evaluateVariadic";
    public static final String CREATEOBJECTINTERNAL = "_createobject";
    public static final String CREATEOBJECT = "createobject";
    public static final String ISNULL = "isNull";
    private boolean isSafePreHook = false;
    private boolean isSafePostHook = false;
    ASTfuncparams arguments;
    private boolean isSimpleReference = false;
    private boolean newOperator = false;
    private ExprNode newArgumentCfc;
    private boolean isNamedParameterFunctionCall = false;
    private ExprNode funcName;
    private boolean isAssociativeArrayNotation = false;
    private boolean isImplicitInitializerNode = false;
    String[] parameterShadow;
    Token nameToken;

    public ExprNode getFuncName() {
        return this.funcName;
    }

    public void setFuncName(ExprNode funcName) {
        this.funcName = funcName;
    }

    public boolean isAssociativeArrayNotation() {
        return this.isAssociativeArrayNotation;
    }

    public void setAssociativeArrayNotation(boolean associativeArrayNotation) {
        this.isAssociativeArrayNotation = associativeArrayNotation;
    }

    public void setImplicitInitializerNode(boolean implicitInitializerNode) {
        this.isImplicitInitializerNode = implicitInitializerNode;
    }

    ASTruntimeCall(String functionName, Token startToken) {
        super(10001);
        this.isLeafReference = false;
        this.synthesizeFunctionName(startToken, functionName);
    }

    ASTruntimeCall(ExprNode funcName) {
        super(10001);
        this.funcName = funcName;
        this.isAssociativeArrayNotation = true;
    }

    ASTruntimeCall(Node parent, String functionName, Node[] args) {
        super(10001);
        this.setSimpleReference(true);
        this.jjtSetParent(parent);
        this.setParser(parent.parser);
        this.synthesizeFunctionName(parent.getStartToken(), functionName);
        ASTfuncparams newArgs = new ASTfuncparams(28);
        for (int i = args.length - 1; i >= 0; --i) {
            newArgs.jjtAddChild(args[i], i);
        }
        this.setArguments(newArgs);
        this.setMethod();
    }

    ASTruntimeCall(Node parent, Method method, Node[] args) {
        super(10001);
        this.setSimpleReference(true);
        this.jjtSetParent(parent);
        this.setParser(parent.parser);
        this.synthesizeFunctionName(parent.getStartToken(), method.getName());
        ASTfuncparams newArgs = new ASTfuncparams(28);
        for (int i = args.length - 1; i >= 0; --i) {
            newArgs.jjtAddChild(args[i], i);
        }
        this.setArguments(newArgs);
        this.arguments.setMethod(method);
        this.arguments.setVariadic(false);
        this.setType(this.arguments.getType());
    }

    public boolean isSafePreHook() {
        return this.isSafePreHook;
    }

    public void setSafePreHook(boolean isSafePreHook) {
        this.isSafePreHook = isSafePreHook;
    }

    public boolean isSafePostHook() {
        return this.isSafePostHook;
    }

    public void setSafePostHook(boolean isSafePostHook) {
        this.isSafePostHook = isSafePostHook;
    }

    private void synthesizeFunctionName(Token templateToken, String functionName) {
        this.nameToken = Token.copyToken(templateToken);
        this.nameToken.image = functionName;
    }

    public void setArguments(ASTfuncparams args) {
        this.setNamedAttribute("arguments", args);
        this.arguments = args;
        if (this.getNameToken() != null) {
            this.arguments.setFunctionName(this.getNameToken().image);
        }
    }

    public ASTfuncparams getArguments() {
        return this.arguments;
    }

    void sanitizeRunAsyncForNamedParamCall(Map<String, Node> functionArgsMap) {
        int count = functionArgsMap.size();
        if (count > 0) {
            if (count >= 3) {
                throw new MethodArgumentMismatchException(this.getNameToken().image, 2, count);
            }
            for (String paramName : functionArgsMap.keySet()) {
                if (!paramName.equalsIgnoreCase("errorHandler")) continue;
                throw new RunAsyncNamedParameterValidationException(this.getNameToken().image, paramName);
            }
            Boolean hasErrorHandler = this.checkForCustomErrorMethodInAsyncChain();
            ASTliteral hasCustomErrorhandlerLiteral = new ASTliteral(hasErrorHandler);
            functionArgsMap.put("errorhandler", hasCustomErrorhandlerLiteral);
            int paramCount = this.arguments.getParamCount();
            this.arguments.jjtAddChild(hasCustomErrorhandlerLiteral, paramCount);
        }
    }

    void handleSpecialsForNamedParamCall(Map<String, Node> functionArgsMap) {
        Token nameToken = this.getNameToken();
        if (nameToken != null && nameToken.image.equalsIgnoreCase("RunAsync")) {
            this.sanitizeRunAsyncForNamedParamCall(functionArgsMap);
        }
    }

    Method findAndSetApproximateMethod(Map<String, Node> functionArgsMap, Class clazz) throws ParseException {
        boolean paramNameValidation;
        this.handleSpecialsForNamedParamCall(functionArgsMap);
        Method method = null;
        Method[] cfPageMethods = clazz.getMethods();
        TreeMap<CallSite, Method> treeMap = new TreeMap<CallSite, Method>();
        Token nameToken = this.getNameToken();
        int count = this.arguments.getParamCount();
        boolean bl = paramNameValidation = count != 4 || !nameToken.image.equalsIgnoreCase("listsort");
        if (nameToken.image.equalsIgnoreCase("queryexecute") && count > 1 && this.arguments.children[count - 1] instanceof ASTliteral) {
            functionArgsMap.put("queryname", this.arguments.children[count - 1]);
        }
        for (Method methodIter : cfPageMethods) {
            if (!methodIter.getName().equalsIgnoreCase(this.getFunctionName())) continue;
            treeMap.put((CallSite)((Object)(methodIter.getParameterCount() + methodIter.getName())), methodIter);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            Method methodId = (Method)entry.getValue();
            int numFuncArgs = functionArgsMap.size();
            if (paramNameValidation) {
                List<Parameter> paramList = Arrays.asList(methodId.getParameters());
                ArrayList<String> paramNameList = new ArrayList<String>();
                for (Parameter parameter : paramList) {
                    paramNameList.add(parameter.getName().toLowerCase());
                }
                int paramFound = 0;
                for (String paramName : functionArgsMap.keySet()) {
                    if (!paramNameList.contains(paramName)) break;
                    ++paramFound;
                }
                if (paramFound != numFuncArgs) continue;
                method = methodId;
                break;
            }
            if (methodId.getParameters().length != count) continue;
            method = methodId;
            Node callback = functionArgsMap.get("callback");
            if (callback == null) break;
            functionArgsMap.remove("callback");
            Node delimiter = functionArgsMap.get("delimiter");
            functionArgsMap.remove("delimiter");
            Node includeemptyfields = functionArgsMap.get("includeemptyfields");
            functionArgsMap.remove("includeemptyfields");
            functionArgsMap.put("sorttype", callback);
            functionArgsMap.put("sortorder", delimiter);
            functionArgsMap.put("delimiter", includeemptyfields);
            break;
        }
        if (method == null) {
            method = this.getMethod(this.getBaseClass());
        }
        this.arguments.setMethod(method);
        this.arguments.setVariadic(false);
        this.setType(this.arguments.getType());
        return method;
    }

    void setMethod() throws ParseException {
        Boolean hasCustomErrorHandler = this.checkForCustomErrorMethodInAsyncChain();
        if (this.isVariadic()) {
            this.arguments.setMethod(this.getVariadicMethod());
            this.arguments.setVariadic(true);
        } else {
            Method method = null;
            method = this.arguments.getIsTyped() != null && this.arguments.getIsTyped() != false ? this.getMethod(this.getBaseClass(), true) : (hasCustomErrorHandler != null ? this.getAsyncMethod(this.getBaseClass(), hasCustomErrorHandler) : this.getMethod(this.getBaseClass()));
            if (method.getName().equalsIgnoreCase("queryexecute") && this.arguments.children.length != method.getParameterCount()) {
                int i;
                Node endNode = this.arguments.children[this.arguments.children.length - 1];
                for (i = this.arguments.children.length - 1; i < method.getParameterCount() - 1; ++i) {
                    this.arguments.jjtAddChild(new ASTliteral(null), i);
                }
                this.arguments.jjtAddChild(endNode, i);
            }
            this.arguments.setMethod(method);
            this.arguments.setVariadic(false);
        }
        this.setType(this.arguments.getType());
    }

    private void validateRunAsyncParams() {
        Node[] nodes = this.arguments.children;
        int childCount = nodes.length;
        if (nodes != null && childCount >= 3) {
            throw new MethodArgumentMismatchException(this.getNameToken().image, 2, childCount);
        }
    }

    Method getAsyncMethod(Class clazz, Boolean hasCustomErrorhandler) throws AbstractParseException {
        Token nameToken = this.getNameToken();
        int count = this.arguments.getParamCount();
        if (nameToken != null && nameToken.image.equalsIgnoreCase("RunAsync") && count > 0) {
            this.validateRunAsyncParams();
            ASTliteral hasCustomErrorhandlerLiteral = new ASTliteral(hasCustomErrorhandler);
            this.arguments.jjtAddChild(hasCustomErrorhandlerLiteral, count);
            ++count;
        }
        try {
            return ASTruntimeCall.findMethod(clazz, nameToken.image, count);
        }
        catch (AbstractParseException mex) {
            mex.setStartToken(nameToken);
            throw mex;
        }
    }

    private Class getBaseClass() {
        try {
            return this.getTranslationContext().getBaseClass();
        }
        catch (RuntimeException ex) {
            return CFPage.class;
        }
    }

    Method getMethod(Class clazz) throws AbstractParseException {
        Token nameToken = this.getNameToken();
        int count = this.arguments.getParamCount();
        if (nameToken.image.equalsIgnoreCase("queryexecute") && count > 1 && this.arguments.children[count - 1] instanceof ASTliteral && count == 3) {
            count = 4;
        }
        try {
            if (this.isNew()) {
                return ASTruntimeCall.findMethod(clazz, nameToken.image, 2);
            }
            return ASTruntimeCall.findMethod(clazz, nameToken.image, count);
        }
        catch (AbstractParseException mex) {
            mex.setStartToken(nameToken);
            throw mex;
        }
    }

    Boolean checkForCustomErrorMethodInAsyncChain() {
        Boolean hasCustomErrorHandler = null;
        if (this instanceof ASTruntimeCall && this.nameToken.image.equalsIgnoreCase("runAsync")) {
            hasCustomErrorHandler = false;
            Node parent = this.jjtGetParent();
            while (parent instanceof ASTruntimeCall) {
                if (((ASTruntimeCall)parent).nameToken.image.equalsIgnoreCase("error")) {
                    hasCustomErrorHandler = true;
                    break;
                }
                parent = parent.jjtGetParent();
            }
        }
        return hasCustomErrorHandler;
    }

    Method getMethod(Class clazz, Boolean isTyped) throws AbstractParseException {
        Token nameToken = this.getNameToken();
        int count = this.arguments.getParamCount();
        if (nameToken != null) {
            String newFuncName = nameToken.image;
            if (nameToken.image.equalsIgnoreCase("ArrayNew")) {
                newFuncName = "__ArrayImpl";
            }
            nameToken.image = newFuncName;
            ExprNode typeLiteral = this.arguments.getTypeDeclaration();
            this.arguments.jjtAddChild(typeLiteral, count);
            ++count;
        }
        try {
            return ASTruntimeCall.findMethod(clazz, nameToken.image, count);
        }
        catch (AbstractParseException mex) {
            mex.setStartToken(nameToken);
            throw mex;
        }
    }

    public ASTfuncparams getParameters() {
        return this.arguments;
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        if (!this.isAssociativeArrayNotation) {
            cfml.visit(this);
            this.arguments.accept(cfml);
        }
    }

    public String getFunctionName() {
        return this.nameToken.image;
    }

    public void setFunctionName(String newName) {
        this.nameToken.image = newName;
    }

    static Method findMethod(Class c, String name, int count) throws AbstractParseException {
        Map map = ExprNode.getMethodMap(c);
        Method method = (Method)map.get(count + name);
        if (method != null) {
            return method;
        }
        Object obj = map.get(name);
        if (obj instanceof Method) {
            method = (Method)obj;
        }
        if (method == null) {
            throw new MethodNotFoundException(count, name, c);
        }
        throw new MethodArgumentMismatchException(name, method.getParameterTypes().length, count);
    }

    public boolean isBuiltin() {
        if (this.isImplicitInitializerNode) {
            return true;
        }
        if (this.hasSimpleReference()) {
            Map map = ExprNode.getMethodMap(this.getBaseClass());
            boolean isBuiltin = map.containsKey(this.getFunctionName());
            if (!isBuiltin) {
                return false;
            }
            boolean isUDFDefined = false;
            try {
                isUDFDefined = this.getTranslationContext().getUdfTable().containsKey(this.getFunctionName().toUpperCase());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (!isUDFDefined) {
                return true;
            }
            return this.getFunctionDef() != null;
        }
        return false;
    }

    public static boolean isBuiltinFunctionName(String s) {
        Map map = ExprNode.getMethodMap(CFComponent.class);
        return map.containsKey(s);
    }

    public boolean isVariadic() {
        boolean result = false;
        if (this.isRuntimeEvaluate() && this.arguments.getParamCount() > 1) {
            result = true;
        }
        return result;
    }

    public boolean isRuntimeEvaluate() {
        boolean result = false;
        if (this.getFunctionName().equalsIgnoreCase(EVALUATE) || this.getFunctionName().equalsIgnoreCase(PRECISIONEVALUATE) || this.getFunctionName().equalsIgnoreCase(ARRAYPUSH) || this.getFunctionName().equalsIgnoreCase(ARRAYUNSHIFT)) {
            result = true;
        }
        return result;
    }

    Method getVariadicMethod() {
        Method result = null;
        if (!this.isVariadic()) {
            throw new CompilerInternalException(this.getNameToken());
        }
        String fName = this.getFunctionName();
        if (fName.equalsIgnoreCase(EVALUATE)) {
            try {
                result = this.getBaseClass().getDeclaredMethod(EVALUATE_VARIADIC, String[].class);
            }
            catch (Exception ex) {
                throw new CompilerInternalException((Object)ex);
            }
        }
        if (fName.equalsIgnoreCase(PRECISIONEVALUATE)) {
            try {
                result = this.getBaseClass().getDeclaredMethod(PRECISION_EVALUATE_VARIADIC, String[].class);
            }
            catch (Exception ex) {
                throw new CompilerInternalException((Object)ex);
            }
        }
        if (fName.equalsIgnoreCase(ARRAYPUSH)) {
            try {
                result = this.getBaseClass().getDeclaredMethod(ARRAYPUSH_VARIADIC, Object[].class);
            }
            catch (Exception ex) {
                throw new CompilerInternalException((Object)ex);
            }
        }
        if (fName.equalsIgnoreCase(ARRAYUNSHIFT)) {
            try {
                result = this.getBaseClass().getDeclaredMethod(ARRAYUNSHIFT_VARIADIC, Object[].class);
            }
            catch (Exception ex) {
                throw new CompilerInternalException((Object)ex);
            }
        }
        return result;
    }

    Token getNameToken() {
        return this.nameToken;
    }

    public boolean hasSimpleReference() {
        return this.isSimpleReference;
    }

    void setSimpleReference(boolean isSimpleReference) {
        this.isSimpleReference = isSimpleReference;
    }

    public boolean isNew() {
        return this.newOperator;
    }

    public void setNew(boolean newOperator) {
        this.newOperator = newOperator;
    }

    public ExprNode getNewArgumentCfc() {
        return this.newArgumentCfc;
    }

    public void setNewArgumentCfc(ExprNode newArgumentCfc) {
        this.newArgumentCfc = newArgumentCfc;
    }

    public boolean isNamedParameterFunctionCall() {
        return this.isNamedParameterFunctionCall;
    }

    public void setNamedParameterFunctionCall(boolean isNamedParameter) {
        this.isNamedParameterFunctionCall = isNamedParameter;
    }
}

