/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfscript;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.Token;

public class ASTvariableDefinition
extends StatementNode {
    String name;
    ExprNode initializer = null;
    Token variableNameToken;
    private boolean isTemp = false;

    ASTvariableDefinition(int id) {
        super(id);
    }

    void setVariableName(Token tName) {
        this.variableNameToken = tName;
        if (tName == null || tName.image.isEmpty()) {
            throw ParseException.wrap(new InvalidVarName(this.variableNameToken), this, this.variableNameToken);
        }
        this.name = tName.image.toUpperCase();
    }

    void setInitializer(ExprNode newInitializer) {
        this.initializer = newInitializer;
        newInitializer.jjtSetParent(this);
        this.setNamedAttribute("INITIALIZER", newInitializer);
    }

    @Override
    public void setNamedAttribute(String key, Node value) {
        if (key.equals("INITIALIZER")) {
            this.initializer = (ExprNode)value;
        }
        super.setNamedAttribute(key, value);
    }

    @Override
    public Node getNamedAttribute(String key) {
        if (key.equals("INITIALIZER")) {
            return this.initializer;
        }
        return super.getNamedAttribute(key);
    }

    void register() {
        ASTfunctionDefinition func = this.getFunctionDef();
        if (func == null) {
            throw ParseException.wrap(new InvalidVarDefinition(this.variableNameToken), this, this.variableNameToken);
        }
        if (func.isParameter(this.name)) {
            throw ParseException.wrap(new VarAlreadyDefinedException(this.name), this, this.getStartToken());
        }
        if (!func.isLocalReference(this.name) && !"LOCAL".equals(this.name)) {
            func.addLocalVariable(this);
        }
    }

    private void checkPosition(ASTfunctionDefinition func) {
        if (func.isLocalReference(this.name)) {
            throw ParseException.wrap(new CannotRedefineException(this.variableNameToken), this, this.getStartToken());
        }
    }

    private boolean checkCfscript(ASTcfscript cfscript) {
        block3: for (int i = 0; i < cfscript.children.length; ++i) {
            switch (cfscript.children[i].id) {
                case 6: {
                    if (cfscript.children[i] != this) continue block3;
                    return true;
                }
                default: {
                    throw ParseException.wrap(new VarPositionException(this.variableNameToken), this, this.variableNameToken);
                }
            }
        }
        return false;
    }

    public void markTemporary() {
        this.isTemp = true;
    }

    public boolean isTemporary() {
        return this.isTemp;
    }

    public static final class InvalidVarName
    extends AbstractParseException {
        InvalidVarName(Token name) {
            super(name);
        }
    }

    public static final class InvalidVarDefinition
    extends AbstractParseException {
        public String varname;

        InvalidVarDefinition(Token name) {
            super(name);
            this.varname = name.image;
        }
    }

    public static final class VarAlreadyDefinedException
    extends AbstractParseException {
        public String m_sName = "";

        VarAlreadyDefinedException(String name) {
            this.m_sName = name;
        }
    }

    public static final class CannotRedefineException
    extends AbstractParseException {
        public String varname;

        CannotRedefineException(Token name) {
            this.varname = name.image;
        }

        CannotRedefineException(String name) {
            this.varname = name;
        }
    }

    public static final class VarPositionException
    extends AbstractParseException {
        public String varname;

        public VarPositionException(Token t) {
            super(t);
            this.varname = t.image;
        }
    }

    public static final class InvalidDestructuringVarDefinition
    extends AbstractParseException {
        InvalidDestructuringVarDefinition(Token name) {
            super(name);
        }
    }
}

