/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

public class AccessModifier {
    public static final int PUBLIC = 4;
    public static final int PRIVATE = 8;
    public static final int PACKAGE = 16;
    public static final int DEFAULT = 16;

    public static int getModifier(int mod) {
        return AccessModifier.isPublic(mod) ? 4 : (AccessModifier.isPrivate(mod) ? 8 : (AccessModifier.isPackage(mod) ? 16 : -1));
    }

    public static boolean isPublic(int mod) {
        return (mod & 4) != 0;
    }

    public static boolean isPrivate(int mod) {
        return (mod & 8) != 0;
    }

    public static boolean isPackage(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isValidAccessModifier(int mod) {
        return AccessModifier.getModifier(mod) != -1;
    }

    public static int getAccessModifier(String s) {
        switch (s.toUpperCase()) {
            case "PRIVATE": {
                return 8;
            }
            case "PUBLIC": {
                return 4;
            }
            case "PACKAGE": {
                return 16;
            }
        }
        throw new RuntimeException("Invalid Access Modifier");
    }
}

