/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfargument;
import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfimport;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTreturnStatement;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.ArrayStructInitializer;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.ConflictingEncodingSpecificationException;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.InvalidTagNestingException;
import coldfusion.compiler.JJTcfml40State;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.compiler.UnmatchedEndTagException;
import coldfusion.compiler.VariableReference;
import coldfusion.compiler.cfml40Constants;
import coldfusion.compiler.cfml40TreeConstants;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.CommonUtil;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.util.BOMReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CFMLParserBase
implements cfml40Constants,
cfml40TreeConstants {
    public static final int CF_COMPONENT = 1;
    public static final int CF_INTERFACE = 2;
    public static final int NONE = 0;
    public static final Random random = new Random(System.nanoTime());
    public static final String IIFE_UDF_FUNCTION = "_invokeIIFE";
    public static final String DESTRUCT_PARAM_ID = "__cf_internal_sdref_";
    public static volatile int IIFE_FUNCTION_COUNT = 1;
    private int moduleAttribute = 0;
    protected boolean precisionEvaluate = false;
    protected boolean withinStaticBlock = false;
    protected boolean supportStatic = false;
    private static String[] tagsInScript = new String[]{"THROW", "ABORT", "INCLUDE", "LOCATION", "DUMP", "LOG", "TRACE", "EXIT"};
    private static final List<String> supportedTypesList = Arrays.asList("COMPONENT", "JAVA", "WEBSERVICE", "DOTNET");
    private static final Set<String> TAGS_NAMES = new HashSet<String>(Arrays.asList("PARAM", "EXIT", "INCLUDE", "ABORT", "THROW", "RETHROW", "FLUSH", "LOGOUT"));
    NeoTranslationContext translationContext;
    private Token firstToken;
    protected Token lastKnownTagStart = null;
    protected Stack bodyTagStack = new Stack();
    private Stack openNodes = new Stack();
    private String inputEncoding;

    protected boolean isPrecisionEvaluate(String methodName) {
        return "PrecisionEvaluate".equalsIgnoreCase(methodName);
    }

    boolean isAccessModifier() {
        String modStr = this.getToken((int)1).image.toUpperCase();
        return modStr.equals("PUBLIC") || modStr.equals("PRIVATE") || modStr.equals("REMOTE") || modStr.equals("PACKAGE");
    }

    boolean isSupportedTag() {
        String modStr = this.getToken((int)1).image.toUpperCase();
        for (int i = 0; i < tagsInScript.length; ++i) {
            if (!modStr.equals(tagsInScript[i])) continue;
            return true;
        }
        return false;
    }

    boolean isInvalidNullVariable() {
        Token nameToken;
        boolean isNullEnabled = FusionContext.isPreserveNullValues();
        return isNullEnabled && (nameToken = this.getToken(1)) != null && CommonUtil.checkNullKey(nameToken.image);
    }

    void addFinalMarker(Node lvar) {
        lvar.setNamedAttribute("IS_FINAL_VARIABLE", new ASTliteral("TRUE"));
    }

    boolean isThrowTag() {
        return "THROW".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isAbortTag() {
        return "ABORT".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isRethrowTag() {
        return "RETHROW".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isIncludeTag() {
        return "INCLUDE".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isSettingTag() {
        return "SETTING".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isExitTag() {
        return "EXIT".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isFlushTag() {
        return "FLUSH".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isLogoutTag() {
        return "LOGOUT".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isComponentToken() {
        return "COMPONENT".equals(this.getToken((int)1).image.toUpperCase());
    }

    boolean isFinalComponentToken() {
        return 140 == this.getToken((int)1).kind && "COMPONENT".equals(this.getToken((int)2).image.toUpperCase());
    }

    boolean isAbstractComponentToken() {
        return 141 == this.getToken((int)1).kind && "COMPONENT".equals(this.getToken((int)2).image.toUpperCase());
    }

    boolean isParamTag() {
        return "PARAM".equals(this.getToken((int)1).image.toUpperCase()) && 129 != this.getToken((int)2).kind;
    }

    boolean isStaticToken() {
        return this.getToken((int)1).image.equalsIgnoreCase("static");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isProperty() {
        if (!"PROPERTY".equals(this.getToken((int)1).image.toUpperCase())) return false;
        Token token = this.getToken(2);
        if (129 == token.kind) return false;
        if (161 == token.kind) return false;
        return true;
    }

    boolean isTagContentDeclaration(String tagName) {
        try {
            return this.getToken((int)2).kind == 129 && this.getToken((int)3).image.equalsIgnoreCase(tagName) && this.getToken((int)4).kind == 69;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isStaticBlockDeclaration() {
        return this.getToken((int)1).image.equalsIgnoreCase("static") && this.getToken((int)2).kind == 69;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRequiredToken() {
        if (!"REQUIRED".equals(this.getToken((int)1).image.toUpperCase())) return false;
        Token token = this.getToken(2);
        if (token.kind == 125) return false;
        if (token.kind == 162) return false;
        return true;
    }

    boolean isQuotedKey() {
        int firstTokenId = this.getToken((int)1).kind;
        int secondTokenId = this.getToken((int)2).kind;
        int thirdTokenId = this.getToken((int)3).kind;
        int fourthTokenId = this.getToken((int)4).kind;
        return (firstTokenId == 55 && secondTokenId == 167 && thirdTokenId == 166 || firstTokenId == 54 && secondTokenId == 164 && thirdTokenId == 163) && (fourthTokenId == 128 || fourthTokenId == 129);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isNewForCfc() {
        try {
            if (!"NEW".equals(this.getToken((int)1).image.toUpperCase())) return false;
            Token token = this.getToken(2);
            if (token.kind == 148) return true;
            if (token.image.equalsIgnoreCase("null")) return true;
            if (token.image.equals("\"")) return true;
            if (!token.image.equals("'")) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isStaticAccessor(int pos) {
        try {
            return this.getToken((int)pos).kind == 148 && this.getToken((int)(pos + 1)).kind == 128 && this.getToken((int)(pos + 2)).kind == 128;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isNew() {
        return "NEW".equals(this.getToken((int)1).image.toUpperCase()) && supportedTypesList.contains(this.getToken((int)2).image.toUpperCase());
    }

    boolean isSpecialFormArgsFunction(Token t) {
        return t.image.equalsIgnoreCase("preservesinglequotes") || t.image.equalsIgnoreCase("quotedvaluelist") || t.image.equalsIgnoreCase("valuelist");
    }

    boolean isNotFunctionDefinition() {
        return this.getToken((int)1).image.equalsIgnoreCase("function") && this.getToken((int)2).kind != 161;
    }

    boolean isNotNewKeyword() {
        boolean result = TAGS_NAMES.contains(this.getToken((int)1).image.toUpperCase());
        if (result) {
            return 161 == this.getToken((int)2).kind;
        }
        return !result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isInitializerAttrValue() {
        Token t1 = this.getToken(1);
        if (!"\"".equals(t1.image)) {
            if (!"'".equals(t1.image)) return false;
        }
        if (!"#".equals(this.getToken((int)2).image)) return false;
        Token t3 = this.getToken(3);
        if ("{".equals(t3.image)) return true;
        if (123 == t3.kind) return true;
        if (!this.isCaseSensitiveOrOrderedStruct(3)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected Map processJavaDocComment(Token currentToken) {
        String javaDocComments = null;
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        Token specialToken = currentToken.specialToken;
        if (specialToken != null) {
            if (this.checkIfSpaceChars(specialToken)) {
                return this.processJavaDocComment(specialToken);
            }
            javaDocComments = specialToken.image;
            int start = javaDocComments.indexOf("/**");
            int end = javaDocComments.indexOf("*/");
            if (start == -1 || end - start < 3) {
                return null;
            }
            javaDocComments = javaDocComments.substring(start + 3, end);
            StringBuilder functionHint = new StringBuilder();
            StringTokenizer comment = new StringTokenizer(javaDocComments, System.getProperty("line.separator"));
            StringBuilder currentValue = new StringBuilder();
            boolean appendToFunctionHint = true;
            ArrayList<String> keyList = new ArrayList<String>();
            while (comment.hasMoreTokens()) {
                String token = comment.nextToken();
                if ((token = token.trim()).startsWith("*")) {
                    token = token.substring(1);
                    token = token.trim();
                }
                if (token.startsWith("@")) {
                    currentValue = new StringBuilder();
                    appendToFunctionHint = false;
                    int keyIndex = token.indexOf(" ");
                    int keyTabIndex = token.indexOf("\t");
                    if (keyIndex == -1) {
                        keyIndex = keyTabIndex;
                    } else if (keyTabIndex != -1) {
                        int n = keyIndex = keyIndex < keyTabIndex ? keyIndex : keyTabIndex;
                    }
                    if (keyIndex != -1) {
                        void var15_17;
                        HashMap valueMap;
                        String string = "yes";
                        String key = token.substring(0, keyIndex);
                        int dotIndex = key.indexOf(".");
                        String customKey = null;
                        if (dotIndex != -1) {
                            customKey = dotIndex + 1 > key.length() ? "" : key.substring(dotIndex + 1).trim();
                            key = key.substring(0, dotIndex).trim();
                        }
                        HashMap hashMap = valueMap = metadata.get(key) != null ? (HashMap)metadata.get(key) : new HashMap();
                        if (keyIndex + 1 < token.length()) {
                            void var15_22;
                            String string3 = token.substring(keyIndex + 1);
                            string3 = string3.trim();
                            if (string3.startsWith("\"") || string3.startsWith("'")) {
                                String string4 = string3.substring(1);
                            }
                            if (var15_22.endsWith("\"") || var15_22.endsWith("'")) {
                                String string5 = var15_22.substring(0, var15_22.length() - 1);
                            }
                        }
                        currentValue.append((String)var15_17);
                        if (customKey == null) {
                            valueMap.put("hint", currentValue);
                        } else {
                            valueMap.put(customKey, currentValue);
                        }
                        metadata.put(key, valueMap);
                        if (keyList.contains(key)) continue;
                        keyList.add(key);
                        continue;
                    }
                    metadata.put(token, "yes");
                    continue;
                }
                if (appendToFunctionHint) {
                    functionHint.append(" ");
                    functionHint.append(token);
                    continue;
                }
                if (token.isEmpty()) continue;
                currentValue.append(" ");
                currentValue.append(token);
            }
            if (!functionHint.toString().trim().equalsIgnoreCase("")) {
                metadata.put("hint", functionHint.toString());
            }
            if (keyList.size() > 0) {
                HashMap valueMap = null;
                for (Object e : keyList) {
                    Object o = metadata.get(e);
                    if (!(o instanceof HashMap)) continue;
                    valueMap = (HashMap)o;
                    for (Object key : valueMap.keySet()) {
                        valueMap.put(key, valueMap.get(key).toString());
                    }
                }
            }
        }
        return metadata;
    }

    private boolean checkIfSpaceChars(Token specialToken) {
        if (specialToken == null) {
            return false;
        }
        char[] spaceChars = new char[]{' ', '\t', '\n', '\r', '\f', '\b'};
        String spaceString = new String(spaceChars);
        char[] special = specialToken.image.toCharArray();
        for (int i = 0; i < special.length; ++i) {
            if (spaceString.indexOf(special[i]) != -1) continue;
            return false;
        }
        return true;
    }

    void createParameterDefinition(ASTparameterDefinition ASTParamDef, Node lvalDeStructRef, Node rvalDeStructRef, int paramIndex) {
        Token keyword = null;
        ASTtagAttribute tagAttribute = null;
        int j = 0;
        ASTcfargument arg = new ASTcfargument(23);
        ASTexprlist exprList = new ASTexprlist(20);
        tagAttribute = new ASTtagAttribute(21);
        keyword = Token.newToken(0);
        keyword.image = "type";
        tagAttribute.setName(keyword);
        Token typeValue = Token.newToken(0);
        typeValue.image = "ASTObjectDestructuring";
        tagAttribute.setConstantValue(typeValue);
        exprList.jjtAddChild(tagAttribute, j++);
        tagAttribute = new ASTtagAttribute(21);
        keyword = Token.newToken(0);
        keyword.image = "name";
        tagAttribute.setName(keyword);
        Token nameValue = Token.newToken(0);
        nameValue.image = DESTRUCT_PARAM_ID + paramIndex;
        tagAttribute.setConstantValue(nameValue);
        exprList.jjtAddChild(tagAttribute, j++);
        arg.setAttrList(exprList);
        ASTParamDef.jjtAddChild(arg, paramIndex);
        if (rvalDeStructRef != null) {
            if (rvalDeStructRef instanceof ArrayStructInitializer) {
                ((ArrayStructInitializer)rvalDeStructRef).setSynthetic(true);
            }
            ASTcfscriptStatement asTcfscriptStatement = new ASTcfscriptStatement(3);
            asTcfscriptStatement.setStatementType(3);
            asTcfscriptStatement.setNamedAttribute("LVAL", lvalDeStructRef);
            asTcfscriptStatement.setNamedAttribute("RVAL", rvalDeStructRef);
            arg.registerArgument(ASTParamDef, asTcfscriptStatement);
        } else {
            arg.registerArgument(ASTParamDef, lvalDeStructRef);
        }
    }

    void createParameterDefinition(ASTparameterDefinition ASTParamDef, ASTexprlist addList, Token type, Token paramName, Node defaultVal, Token required, Token isFinal, int i) {
        Token keyword = null;
        ASTtagAttribute tagAttribute = null;
        int j = 0;
        ASTcfargument arg = new ASTcfargument(23);
        ASTexprlist exprList = new ASTexprlist(20);
        if (type != null) {
            tagAttribute = new ASTtagAttribute(21);
            keyword = Token.newToken(0);
            keyword.image = "type";
            tagAttribute.setName(keyword);
            tagAttribute.setConstantValue(type);
            exprList.jjtAddChild(tagAttribute, j++);
        }
        tagAttribute = new ASTtagAttribute(21);
        keyword = Token.newToken(0);
        keyword.image = "name";
        tagAttribute.setName(keyword);
        tagAttribute.setConstantValue(paramName);
        exprList.jjtAddChild(tagAttribute, j++);
        if (defaultVal != null) {
            if (defaultVal instanceof ASTsimpleVariableReference && ("yes".equalsIgnoreCase(defaultVal.getStartToken().image) || "no".equalsIgnoreCase(defaultVal.getStartToken().image))) {
                defaultVal = new ASTliteral(defaultVal.getStartToken().image, defaultVal);
            }
            tagAttribute = new ASTtagAttribute(21);
            keyword = Token.newToken(0);
            keyword.image = "DEFAULT";
            tagAttribute.setName(keyword);
            tagAttribute.setRuntimeValue(defaultVal);
            exprList.jjtAddChild(tagAttribute, j++);
        }
        tagAttribute = new ASTtagAttribute(21);
        keyword = Token.newToken(0);
        keyword.image = "REQUIRED";
        tagAttribute.setName(keyword);
        String reqValue = "false";
        if (required != null) {
            reqValue = "true";
        }
        Token falseTok = new Token();
        falseTok.image = reqValue;
        tagAttribute.setConstantValue(falseTok);
        exprList.jjtAddChild(tagAttribute, j++);
        if (isFinal != null) {
            tagAttribute = new ASTtagAttribute(21);
            keyword = Token.newToken(0);
            keyword.image = "FINAL";
            tagAttribute.setName(keyword);
            String finalVal = "true";
            Token finalValTok = new Token();
            finalValTok.image = finalVal;
            tagAttribute.setConstantValue(finalValTok);
            exprList.jjtAddChild(tagAttribute, j++);
        }
        if (addList != null) {
            for (int count = 0; count < addList.jjtGetNumChildren(); ++count) {
                exprList.jjtAddChild(addList.jjtGetChild(count), j++);
            }
        }
        arg.setAttrList(exprList);
        ASTParamDef.jjtAddChild(arg, i);
        arg.registerArgument(ASTParamDef, null);
    }

    void createASTTagAttribute(ASTexprlist exprList, String attrName, Token attrValue, int i) {
        ASTtagAttribute tagAttribute = new ASTtagAttribute(21);
        Token keyword = Token.newToken(0);
        keyword.image = attrName;
        tagAttribute.setName(keyword);
        if (attrValue.image != null) {
            attrValue.image = attrValue.image.trim();
        }
        tagAttribute.setConstantValue(attrValue);
        exprList.jjtAddChild(tagAttribute, i);
    }

    void createRuntimeASTTagAttribute(ASTexprlist exprList, String attrName, ExprNode attrValue, int i) {
        ASTtagAttribute tagAttribute = new ASTtagAttribute(21);
        tagAttribute.setParser(this);
        Token keyword = Token.newToken(0);
        keyword.image = attrName;
        tagAttribute.setName(keyword);
        tagAttribute.setRuntimeValue(attrValue);
        exprList.jjtAddChild(tagAttribute, i);
    }

    void createASTTagAttribute(ASTexprlist exprList, String attrName, ExprNode attrValue, int i) {
        ASTliteral attrValueltr = null;
        if (!(attrValue instanceof ASTliteral)) {
            if (!"yes".equalsIgnoreCase(attrValue.getStartToken().image) && !"no".equalsIgnoreCase(attrValue.getStartToken().image)) {
                throw new UnsupportedVariablesException(attrName, attrValue.getStartToken().image);
            }
            attrValueltr = new ASTliteral(attrValue.getStartToken().image, attrValue);
        } else {
            attrValueltr = (ASTliteral)attrValue;
        }
        ASTtagAttribute tagAttribute = new ASTtagAttribute(21);
        Token keyword = Token.newToken(0);
        keyword.image = attrName;
        tagAttribute.setName(keyword);
        String attrValueString = EvaluateEngine._String(attrValueltr);
        Token attrValueToken = Token.newToken(0);
        attrValueToken.image = attrValueString;
        tagAttribute.setConstantValue(attrValueToken);
        exprList.jjtAddChild(tagAttribute, i);
    }

    void createASTTagAttribute(ASTexprlist exprList, String attrName, String attrValue, int i) {
        Token attrValueToken = Token.newToken(0);
        attrValueToken.image = attrValue;
        this.createASTTagAttribute(exprList, attrName, attrValueToken, i);
    }

    void createASTTagAttribute(ASTexprlist exprList, Map metadata, ASTparameterDefinition paramdef, int i) {
        Iterator iter = metadata.entrySet().iterator();
        while (iter.hasNext()) {
            String value1;
            Object key1;
            Node[] args;
            boolean hintlAreadyPresent = false;
            boolean parameterHint = false;
            Map.Entry element = iter.next();
            String key = (String)element.getKey();
            boolean isHint = "hint".equalsIgnoreCase(key);
            if (isHint) {
                int num = exprList.jjtGetNumChildren();
                for (int j = 0; j < num; ++j) {
                    ASTtagAttribute tagattribute = (ASTtagAttribute)exprList.jjtGetChild(j);
                    if (!"hint".equalsIgnoreCase(tagattribute.getName())) continue;
                    hintlAreadyPresent = true;
                    break;
                }
            }
            if (hintlAreadyPresent) continue;
            if (key.length() >= 2 && !isHint) {
                key = key.substring(1);
            }
            Object value = element.getValue();
            if (paramdef != null && (args = paramdef.children) != null) {
                for (int j = 0; j < args.length; ++j) {
                    ASTcfargument arg = (ASTcfargument)args[j];
                    if (!arg.paramName.equalsIgnoreCase(key)) continue;
                    iter.remove();
                    if (arg.attrList == null) continue;
                    if (value instanceof String) {
                        this.createASTTagAttribute(arg.attrList, "hint", (String)value, arg.attrList.children == null ? 0 : arg.attrList.children.length);
                        arg.putAttrNode("hint", new ASTliteral(value));
                    } else {
                        for (Map.Entry element1 : ((Map)value).entrySet()) {
                            key1 = (String)element1.getKey();
                            value1 = (String)element1.getValue();
                            this.createASTTagAttribute(arg.attrList, (String)key1, value1, arg.attrList.children == null ? 0 : arg.attrList.children.length);
                            arg.putAttrNode((String)key1, new ASTliteral(value1));
                        }
                    }
                    parameterHint = true;
                    break;
                }
            }
            if (parameterHint) continue;
            if (value instanceof String) {
                this.createASTTagAttribute(exprList, key, (String)value, i++);
                continue;
            }
            if (value == null) continue;
            String attrValue = (String)((Map)value).get("hint");
            if (attrValue != null && !this.attrExists(key, exprList.children)) {
                this.createASTTagAttribute(exprList, key, attrValue, i++);
            }
            for (Map.Entry o : ((Map)value).entrySet()) {
                Map.Entry element1 = o;
                Object elementKey = element1.getKey();
                if (elementKey == null || "hint".equalsIgnoreCase((String)elementKey)) continue;
                key1 = key + "." + elementKey;
                value1 = (String)element1.getValue();
                this.createASTTagAttribute(exprList, (String)key1, value1, i++);
            }
        }
    }

    private boolean attrExists(String key, Node[] attrList) {
        if (attrList != null) {
            for (Node attr : attrList) {
                if (!(attr instanceof ASTtagAttribute) || !((ASTtagAttribute)attr).getName().equalsIgnoreCase(key)) continue;
                return true;
            }
        }
        return false;
    }

    public static Node getParentNodeOfType(Node node, Class type) {
        if (node == null) {
            return null;
        }
        Node parentNode = node.jjtGetParent();
        if (parentNode == null) {
            return null;
        }
        if (type.isAssignableFrom(parentNode.getClass())) {
            return parentNode;
        }
        if ((parentNode = CFMLParserBase.getParentNodeOfType(parentNode, type)) != null) {
            return parentNode;
        }
        return null;
    }

    public void setModuleAttribute(int type) throws ParseException {
        this.moduleAttribute = type == 1 || type == 2 ? type : 0;
    }

    public int getModuleAttribute() {
        return this.moduleAttribute;
    }

    public boolean isComponent() {
        return this.moduleAttribute == 1;
    }

    public boolean isInterface() {
        return this.moduleAttribute == 2;
    }

    public int getJavaBracesExtraCountInStrings(String image, boolean dQuotes) {
        if (dQuotes) {
            if (image.contains("}")) {
                return 1;
            }
            if (image.contains("{")) {
                return -1;
            }
        }
        return 0;
    }

    public int getJavaBracesExtraCountInComment(String image, boolean inComment) {
        if (inComment) {
            int i = 0;
            for (String str : image.split("\n")) {
                str = str.trim();
                if (i++ != 0 && !str.contains("//")) continue;
                if (str.endsWith("{")) {
                    return -1;
                }
                if (!str.endsWith("}")) continue;
                return 1;
            }
        }
        return 0;
    }

    public int getJavaBracesExtraCountInMultiLineComment(String image, boolean inComment) {
        if (inComment) {
            for (String str : image.split("\n")) {
                if ((str = str.trim()).contains("*/")) break;
                if (str.endsWith("{")) {
                    return -1;
                }
                if (!str.endsWith("}")) continue;
                return 1;
            }
        }
        return 0;
    }

    public boolean isJavaFunction(Node n) {
        if (n instanceof ASTexprlist) {
            ASTexprlist node = (ASTexprlist)n;
            List<Node> childs = node.getAllChildren();
            for (Node child : childs) {
                Node typeNode;
                ASTtagAttribute tagAtr;
                String attrName;
                if (!(child instanceof ASTtagAttribute) || !(attrName = (tagAtr = (ASTtagAttribute)child).getName()).equalsIgnoreCase("type") || !((typeNode = tagAtr.getValueNode()) instanceof ASTliteral)) continue;
                ASTliteral literalNode = (ASTliteral)typeNode;
                String type = (String)literalNode.tokens.get(0);
                if (!type.equalsIgnoreCase("java")) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Token getToken(int var1);

    abstract Node peekNode(int var1);

    abstract Node popNode();

    abstract void pushNode(Node var1);

    public void setTranslationContext(NeoTranslationContext tc) {
        this.translationContext = tc;
    }

    public void setFirstToken(Token t) {
        this.firstToken = t;
    }

    public boolean isKnownTagName(String image) {
        if (image.regionMatches(true, 0, "cfx_", 0, 4)) {
            return true;
        }
        return this.translationContext.isKnownTag(image);
    }

    public boolean validateComponent() {
        String tkImg = this.firstToken.image.trim().toLowerCase();
        return tkImg.startsWith("component") || tkImg.startsWith("//") || tkImg.startsWith("import") || tkImg.startsWith("/*") || tkImg.startsWith("interface");
    }

    protected boolean isFinalComponent() {
        String tkImg = this.firstToken.image.trim().toLowerCase();
        return tkImg.startsWith("final");
    }

    protected boolean isAbstractComponent() {
        String tkImg = this.firstToken.image.trim().toLowerCase();
        return tkImg.startsWith("abstract");
    }

    public boolean isaCFC() {
        String fileName = this.translationContext.getPageFile().getName().toLowerCase();
        return fileName.endsWith(".cfc") || fileName.endsWith(".cfr");
    }

    protected boolean isStartTag() {
        if (this.getToken((int)1).kind == 1) {
            Token t2 = this.getToken(2);
            if (t2.kind == 44 && this.isKnownTagName(t2.image)) {
                this.lastKnownTagStart = t2;
                return true;
            }
        }
        return false;
    }

    protected boolean isBuiltinTag(int builtinKind) {
        int kind = this.getToken((int)1).kind;
        if (kind == 1 || kind == 2) {
            Token t2 = this.getToken(2);
            if (t2.kind == builtinKind) {
                this.lastKnownTagStart = t2;
                return true;
            }
        }
        return false;
    }

    protected boolean isBuiltinTagWithPcData(int builtinKind) {
        try {
            int lookahead = 1;
            int kind = this.getToken((int)lookahead).kind;
            if (kind == 7) {
                kind = this.getToken((int)(++lookahead)).kind;
            }
            if (kind == 1 || kind == 2) {
                Token t2 = this.getToken(++lookahead);
                if (t2.kind == builtinKind) {
                    this.lastKnownTagStart = t2;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean isEndTag() {
        if (this.getToken((int)1).kind == 2) {
            Token t2 = this.getToken(2);
            if (t2.kind == 44 && this.isKnownTagName(t2.image)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isTrivialAngleBracket() {
        Token t1 = this.getToken(1);
        if (t1.kind == 1 || t1.kind == 2) {
            Token t2 = this.getToken(2);
            int kind = t2.kind;
            return kind == 45 || kind == 7 || kind == 8 || kind == 9 || kind == 1 || kind == 2 || kind == 0 || kind == 44 && !this.isKnownTagName(t2.image);
        }
        return false;
    }

    protected boolean isStaticDestructuringOrBlock() {
        int tokenKind;
        return this.supportStatic() && this.isaCFC() && this.getToken((int)1).image.equalsIgnoreCase("static") && ((tokenKind = this.getToken((int)2).kind) == 129 || tokenKind == 69 || tokenKind == 123 || tokenKind == 161 || tokenKind == 140 && this.isDestructuringStart(3));
    }

    protected boolean isFinalVarDeclaration() {
        return this.getToken((int)1).kind == 140 && (this.isVarDeclaration(2) || this.isDestructuringStart(2));
    }

    protected boolean isStaticVarReference() {
        return this.getToken((int)1).kind == 148 && this.getToken((int)2).kind == 128 && this.getToken((int)3).kind == 128;
    }

    protected boolean isLocalLValDeclaration(Token token) {
        Token nextToken = this.getToken(1);
        return nextToken.kind == 148 && token != null && (token.image.equals("var") || token.image.equals("final var"));
    }

    protected boolean isSimpleFinalVarDeclaration() {
        return this.getToken((int)1).kind == 140 && this.isSimpleVarDeclaration(2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSimpleVarDeclaration(int token) {
        if (!this.getToken((int)token).image.equalsIgnoreCase("var")) return false;
        Token t2 = this.getToken(token + 1);
        if (t2.kind == 148) return true;
        if (!t2.image.equalsIgnoreCase("null")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isVarDeclaration(int token) {
        if (!this.getToken((int)token).image.equalsIgnoreCase("var")) return false;
        Token t2 = this.getToken(token + 1);
        if (t2.kind == 148) return true;
        if (t2.kind == 69) return true;
        if (t2.image.equalsIgnoreCase("null")) return true;
        if (t2.kind != 123) return false;
        if (!this.isWithinFunction()) return false;
        return true;
    }

    protected boolean isVariable(int token) {
        Token t = this.getToken(token);
        return t.kind == 148 || t.image.equalsIgnoreCase("null");
    }

    protected boolean isDestructuringStart(int token) {
        Token t = this.getToken(token);
        return t.kind == 123 || t.kind == 69;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isCaseSensitiveStruct() {
        if (!this.getToken((int)1).image.equals("$")) return false;
        Token t2 = this.getToken(2);
        if (t2.kind == 69) return true;
        if (t2.kind != 13) return false;
        return true;
    }

    protected boolean isCaseSensitiveOrderedStruct() {
        return this.getToken((int)1).image.equals("$") && this.getToken((int)2).kind == 123;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isCaseSensitiveOrOrderedStruct(int pos) {
        if (!this.getToken((int)pos).image.equals("$")) return false;
        Token token = this.getToken(pos + 1);
        if (token.kind == 69) return true;
        if (token.kind == 123) return true;
        if (token.kind != 13) return false;
        return true;
    }

    protected boolean isInitializer(int pos) {
        Token token = this.getToken(pos);
        return token.kind == 69 || token.kind == 123 || token.kind == 13;
    }

    protected boolean isReservedKeywordAsVariable() {
        Token t1 = this.getToken(1);
        boolean isValidToken = false;
        boolean isNullEnabled = FusionContext.isPreserveNullValues();
        switch (t1.kind) {
            case 6: 
            case 23: 
            case 24: 
            case 30: 
            case 32: 
            case 37: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 120: 
            case 121: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                isValidToken = true;
                break;
            }
            default: {
                isValidToken = false;
            }
        }
        if (isNullEnabled && t1.kind == 93) {
            isValidToken = true;
        }
        return (isValidToken || t1.image.equalsIgnoreCase("else")) && this.getToken((int)2).kind == 129;
    }

    protected boolean isFunctionAsVarDeclaration() {
        return this.getToken((int)1).kind == 145 && this.getToken((int)2).kind == 129;
    }

    protected boolean notFinallyBlock() {
        Token t1 = this.getToken(1);
        return !(t1.image.equalsIgnoreCase("<") && this.getToken((int)2).image.equalsIgnoreCase("cffinally") || t1.image.equalsIgnoreCase("</") && this.getToken((int)2).image.equalsIgnoreCase("cftry") || t1.image.equalsIgnoreCase("<") && this.getToken((int)2).image.equalsIgnoreCase("cfcatch"));
    }

    protected boolean ISToken(int t2) {
        return this.getToken((int)1).image.equalsIgnoreCase("is") && this.getToken((int)2).kind == t2;
    }

    protected boolean nextTokenAny(int t1, int t2) {
        Token t = this.getToken(2);
        return t.kind == t1 || t.kind == t2;
    }

    protected boolean next2Tokens(int t1, int t2) {
        return this.getToken((int)1).kind == t1 && this.getToken((int)2).kind == t2;
    }

    protected boolean next3Tokens(int t1, int t2, int t3) {
        return this.getToken((int)1).kind == t1 && this.getToken((int)2).kind == t2 && this.getToken((int)3).kind == t3;
    }

    protected boolean nextToken(int t1) {
        return this.getToken((int)1).kind == t1;
    }

    protected boolean next2ndToken(int t1) {
        return this.getToken((int)2).kind == t1;
    }

    protected boolean next3rdToken(int t1) {
        return this.getToken((int)3).kind == t1;
    }

    protected boolean next4thToken(int t1) {
        return this.getToken((int)4).kind == t1;
    }

    protected boolean next5thToken(int t1) {
        return this.getToken((int)5).kind == t1;
    }

    public boolean isTokenAsFunctionName(int pos) {
        Token t1 = this.getToken(pos);
        boolean flag = true;
        switch (t1.kind) {
            case 82: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 116: 
            case 148: {
                flag = true;
                break;
            }
            default: {
                flag = false;
            }
        }
        return flag && this.getToken((int)(pos + 1)).kind == 161;
    }

    protected boolean isFunction() {
        try {
            int pos = 1;
            int condSatisfied = 0;
            while (condSatisfied < 2) {
                Token token = this.getToken(pos);
                int tokenKind = token.kind;
                if (tokenKind == 148 || tokenKind == 82) {
                    ++pos;
                    continue;
                }
                if (tokenKind == 140 || tokenKind == 141 || tokenKind == 82) {
                    int lookAheadPos;
                    int n = lookAheadPos = this.supportStatic && this.getToken((int)(pos + 1)).image.equalsIgnoreCase("static") ? 2 : 1;
                    if (this.getToken((int)(pos + lookAheadPos)).kind == 145 || this.getToken((int)(pos + lookAheadPos + 1)).kind == 145) {
                        return true;
                    }
                }
                if (tokenKind == 145) {
                    ++condSatisfied;
                    if (!this.isTokenAsFunctionName(++pos)) continue;
                    return true;
                }
                if (tokenKind != 123 || this.getToken((int)(++pos)).kind != 124) break;
                ++pos;
            }
            if (condSatisfied == 2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean isIncludeStatementAttribute() {
        return this.getToken((int)1).image.equalsIgnoreCase("runonce");
    }

    protected boolean isFunctionalExpression() {
        return this.getToken((int)1).kind == 161 && this.isIIFE().length() == 0;
    }

    protected String isIIFE() {
        try {
            String lambdasOrExpressionIIFE = "lambdas_or_expression_iife";
            int pos = 1;
            if (this.getToken((int)pos).kind == 161) {
                switch (this.getToken((int)(pos + 1)).kind) {
                    case 145: {
                        if (this.getToken((int)(pos + 2)).kind == 161) {
                            return "closure_iife";
                        }
                        if (this.getToken((int)(pos + 2)).kind != 148 && this.getToken((int)(pos + 2)).kind != 93) break;
                        return "named_closure_iife";
                    }
                    case 161: {
                        switch (this.getToken((int)(pos + 2)).kind) {
                            case 148: {
                                if (this.getToken((int)(pos + 3)).kind == 148) {
                                    if ("required".equalsIgnoreCase(this.getToken((int)(pos + 2)).image)) {
                                        return lambdasOrExpressionIIFE;
                                    }
                                    if (this.getToken((int)(pos + 4)).kind == 129) {
                                        return lambdasOrExpressionIIFE;
                                    }
                                    if (this.getToken((int)(pos + 4)).kind == 125) {
                                        return lambdasOrExpressionIIFE;
                                    }
                                    if (this.getToken((int)(pos + 4)).kind != 162 || this.getToken((int)(pos + 5)).kind != 139) break;
                                    return lambdasOrExpressionIIFE;
                                }
                                if (this.getToken((int)(pos + 3)).kind == 125) {
                                    return lambdasOrExpressionIIFE;
                                }
                                if (this.getToken((int)(pos + 3)).kind == 162 && this.getToken((int)(pos + 4)).kind == 139) {
                                    return lambdasOrExpressionIIFE;
                                }
                                if (this.getToken((int)(pos + 3)).kind != 129) break;
                                return lambdasOrExpressionIIFE;
                            }
                            case 140: {
                                return lambdasOrExpressionIIFE;
                            }
                            case 162: {
                                if (this.getToken((int)(pos + 3)).kind != 139) break;
                                return lambdasOrExpressionIIFE;
                            }
                        }
                        break;
                    }
                    case 148: {
                        if (this.getToken((int)(pos + 2)).kind == 139) {
                            return lambdasOrExpressionIIFE;
                        }
                        if (this.getToken((int)(pos + 2)).kind != 148) break;
                        if ("required".equalsIgnoreCase(this.getToken((int)(pos + 1)).image) && this.getToken((int)(pos + 3)).kind != 148) {
                            return lambdasOrExpressionIIFE;
                        }
                        if (this.getToken((int)(pos + 3)).kind != 129) break;
                        return lambdasOrExpressionIIFE;
                    }
                    case 140: {
                        return lambdasOrExpressionIIFE;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected boolean next4Tokens(int t1, int t2, int t3, int t4) {
        return this.getToken((int)1).kind == t1 && this.getToken((int)2).kind == t2 && this.getToken((int)3).kind == t3 && this.getToken((int)4).kind == t4;
    }

    protected boolean next5Tokens(int t1, int t2, int t3, int t4, int t5) {
        return this.getToken((int)1).kind == t1 && this.getToken((int)2).kind == t2 && this.getToken((int)3).kind == t3 && this.getToken((int)4).kind == t4 && this.getToken((int)5).kind == t5;
    }

    protected boolean isEmptyType(int t1, int t2, int t3, int t4) {
        return this.getToken((int)1).image.equalsIgnoreCase("arraynew") && this.getToken((int)2).kind == t2 && this.getToken((int)3).kind == t3 && this.getToken((int)4).kind == t4;
    }

    protected boolean isTypedArray(int t2) {
        return this.getToken((int)1).image.equalsIgnoreCase("arraynew") && this.getToken((int)2).kind == t2;
    }

    public boolean isBodyTag() {
        return !this.bodyTagStack.empty();
    }

    protected void pushBodyTag(Token t) {
        this.bodyTagStack.push(t);
    }

    protected void popBodyTag() {
        if (this.bodyTagStack.empty()) {
            throw new CompilerInternalException(this.bodyTagStack);
        }
        this.bodyTagStack.pop();
    }

    public static boolean isValidSimpleIdentifier(Token t) {
        return CFMLParserBase.isValidSimpleIdentifier(t.image);
    }

    public static boolean isValidSimpleIdentifier(String image) {
        if (image == null) {
            return false;
        }
        boolean result = Character.isJavaIdentifierStart(image.charAt(0));
        for (int i = 1; result && i < image.length(); result &= Character.isJavaIdentifierPart(image.charAt(i)), ++i) {
        }
        return result;
    }

    protected boolean isOrphanTag(JJTcfml40State jjtree) {
        Node openNode;
        Token t1 = this.getToken(1);
        try {
            openNode = (Node)this.openNodes.peek();
        }
        catch (EmptyStackException ex) {
            openNode = null;
        }
        if (t1.kind == 1) {
            Token t2 = this.getToken(2);
            switch (t2.kind) {
                case 21: 
                case 24: {
                    if (openNode != null && (openNode.getStartToken().kind == 20 || openNode.getStartToken().kind == 21)) break;
                    throw new InvalidTagNestingException(t2, "CFIF");
                }
                case 29: {
                    if (openNode != null && openNode.id == 12) break;
                    throw new InvalidTagNestingException(t2, "CFTRY");
                }
                case 30: {
                    if (openNode != null && openNode.id == 12) break;
                    throw new InvalidTagNestingException(t2, "CFTRY");
                }
                case 33: {
                    if (openNode != null && openNode.id == 18) break;
                    throw new InvalidTagNestingException(t2, "CFFUNCTION");
                }
            }
        }
        return false;
    }

    void jjtreeOpenNodeScope(Node astNode) {
        astNode.setParser(this);
        astNode.setStartToken(this.getToken(1));
        this.openNodes.push(astNode);
    }

    void jjtreeCloseNodeScope(Node astNode) {
        astNode.setEndToken(this.getToken(0));
        this.openNodes.pop();
    }

    private int getOperatorId(Token token) {
        int tokenId = -1;
        switch (token.kind) {
            case 132: {
                tokenId = 200;
                break;
            }
            case 133: {
                tokenId = 201;
                break;
            }
            case 130: {
                tokenId = 204;
                break;
            }
            case 131: {
                tokenId = 205;
                break;
            }
            case 135: {
                tokenId = 203;
                break;
            }
            case 134: {
                tokenId = 202;
                break;
            }
            case 136: {
                tokenId = 207;
                break;
            }
            default: {
                tokenId = -1;
            }
        }
        return tokenId;
    }

    void createMultiAssignOperator(JJTcfml40State jjtree, Token token, Class type) {
        Node rhs = jjtree.popNode();
        Node lhs = jjtree.popNode();
        jjtree.pushNode(lhs);
        jjtree.pushNode(rhs);
        jjtree.pushNode(lhs);
        int operatorId = this.getOperatorId(token);
        ASToperator rhsOp = new ASToperator(operatorId);
        token.image = token.image.substring(0, 1);
        rhsOp.jjtAddChild(jjtree.popNode(), 0);
        rhsOp.jjtAddChild(jjtree.popNode(), 1);
        rhsOp.setOperator(token, operatorId, type);
        rhsOp.setStartToken(token);
        jjtree.pushNode(rhsOp);
        rhsOp.parser = rhs.parser;
        ASToperator assignmentOp = new ASToperator(241);
        Token assignToken = new Token();
        assignToken.image = "=";
        assignmentOp.jjtAddChild(jjtree.popNode(), 1);
        assignmentOp.jjtAddChild(jjtree.popNode(), 0);
        assignmentOp.setOperator(assignToken, 241, type);
        assignmentOp.setStartToken(assignToken);
        jjtree.pushNode(assignmentOp);
        assignmentOp.parser = rhs.parser;
    }

    void createOperator(JJTcfml40State jjtree, Token t, int id, Class type) {
        ASToperator op = new ASToperator(id);
        op.jjtAddChild(jjtree.popNode(), 1);
        op.jjtAddChild(jjtree.popNode(), 0);
        op.setOperator(t, id, type);
        jjtree.pushNode(op);
        op.setStartToken(t);
    }

    void resolvePreIndices(JJTcfml40State jjtree, ASTarrayReference root) {
        Object[] indices = root.indices.toArray();
        for (int i = 0; i < indices.length; ++i) {
            if (!(indices[i] instanceof ASToperator)) continue;
            ASToperator temp = (ASToperator)indices[i];
            if (temp.id == 231 || temp.id == 233 || temp.id == 232 || temp.id == 234) {
                ASTsimpleVariableReference child = (ASTsimpleVariableReference)temp.children[0];
                ASTsimpleVariableReference newChild = new ASTsimpleVariableReference(child.getStartToken());
                newChild.parser = child.parser;
                newChild.setType(child.getType());
                jjtree.pushNode(temp);
                root.indices.set(i, newChild);
                root.setNamedAttribute("INDEX" + i, newChild);
                continue;
            }
            long rnd = random.nextInt();
            if (rnd < 0L) {
                rnd = -1L * rnd;
            }
            String varName = "_tempindex" + rnd;
            Token varNameTok = Token.newToken(0);
            varNameTok.image = varName;
            ASTcfscriptStatement statement = new ASTcfscriptStatement(3);
            statement.parser = temp.parser;
            statement.setStatementType(3);
            statement.setStartToken(temp.getStartToken());
            ASTsimpleVariableReference implictVar = new ASTsimpleVariableReference(varNameTok);
            statement.setNamedAttribute("LVAL", implictVar);
            statement.setNamedAttribute("RVAL", temp);
            if (this.isWithinFunction()) {
                ASTvariableDefinition varDef = new ASTvariableDefinition(6);
                varDef.setVariableName(varNameTok);
                varDef.setStartToken(temp.getStartToken());
                statement.jjtSetParent(varDef);
                varDef.jjtAddChild(statement, 0);
                varDef.markTemporary();
                jjtree.pushNode(varDef);
            } else {
                jjtree.pushNode(statement);
            }
            root.indices.set(i, implictVar);
            root.setNamedAttribute("INDEX" + i, implictVar);
        }
    }

    private boolean isWithinFunction() {
        for (int i = this.openNodes.size() - 1; i >= 0; --i) {
            if (!(this.openNodes.get(i) instanceof ASTcffunction)) continue;
            return true;
        }
        return false;
    }

    void resolvePostIndices(JJTcfml40State jjtree) {
        ASTcfscriptStatement stmt;
        ASToperator temp;
        int i;
        Node top = jjtree.popNode();
        for (i = 0; i < top.children.length; ++i) {
            if (top.children[i] instanceof ASToperator) {
                temp = (ASToperator)top.children[i];
                if (temp.id == 232 || temp.id == 234) continue;
                stmt = new ASTcfscriptStatement(3);
                stmt.setStatementType(4);
                stmt.setParser(temp.parser);
                stmt.jjtSetParent(temp.jjtGetParent());
                stmt.setNamedAttribute("EXPR", temp);
                jjtree.pushNode(stmt);
                continue;
            }
            if (!(top.children[i] instanceof ASTcfscriptStatement) && !(top.children[i] instanceof ASTvariableDefinition)) continue;
            jjtree.pushNode(top.children[i]);
        }
        jjtree.pushNode(top);
        for (i = 0; i < top.children.length; ++i) {
            if (!(top.children[i] instanceof ASToperator)) continue;
            temp = (ASToperator)top.children[i];
            if (temp.id != 232 && temp.id != 234) continue;
            stmt = new ASTcfscriptStatement(3);
            stmt.setStatementType(4);
            stmt.setParser(temp.parser);
            stmt.jjtSetParent(temp.jjtGetParent());
            stmt.setNamedAttribute("EXPR", temp);
            jjtree.pushNode(stmt);
        }
        top.children = null;
    }

    void createTernaryOperator(JJTcfml40State jjtree, Token t1, Token t2, Node n1, Node n2, int id1, int id2, Class type) {
        ASToperator op1 = new ASToperator(id1);
        ASToperator op2 = new ASToperator(id2);
        op2.jjtAddChild(n1, 0);
        op2.jjtAddChild(n2, 1);
        op2.setOperator(t2, id2, type);
        jjtree.pushNode(op2);
        op2.setStartToken(t2);
        op1.jjtAddChild(jjtree.popNode(), 1);
        op1.jjtAddChild(jjtree.popNode(), 0);
        op1.setOperator(t1, id1, type);
        jjtree.pushNode(op1);
        op1.setStartToken(t1);
        op1.parser = this;
        op2.parser = this;
    }

    protected ASTcfscriptStatement createIIFEInvocationNode(ASTfuncparams params) {
        Token callStartToken = Token.newToken(0);
        String functionName = IIFE_UDF_FUNCTION + IIFE_FUNCTION_COUNT;
        ASTruntimeCall astRuntimeCall = new ASTruntimeCall(functionName, callStartToken);
        astRuntimeCall.setArguments(params);
        astRuntimeCall.setSimpleReference(true);
        callStartToken.image = functionName;
        astRuntimeCall.setStartToken(callStartToken);
        astRuntimeCall.setParser(this);
        astRuntimeCall.setType(Objects.class);
        Token varRef = new Token();
        varRef.image = functionName;
        ASTsimpleVariableReference variableReference = new ASTsimpleVariableReference(varRef);
        variableReference.jjtSetParent(astRuntimeCall);
        variableReference.parser = this;
        astRuntimeCall.setStem(variableReference);
        ASTcfscriptStatement scriptStamentNode = new ASTcfscriptStatement(3);
        scriptStamentNode.parser = this;
        scriptStamentNode.setStatementType(4);
        scriptStamentNode.setNamedAttribute("EXPR", astRuntimeCall);
        return scriptStamentNode;
    }

    protected ASTruntimeCall createIIFEExpressionNode(ASTfuncparams params) {
        Token callStartToken = Token.newToken(0);
        String functionName = IIFE_UDF_FUNCTION + IIFE_FUNCTION_COUNT;
        ASTruntimeCall astRuntimeCall = new ASTruntimeCall(functionName, callStartToken);
        astRuntimeCall.setArguments(params);
        astRuntimeCall.setSimpleReference(true);
        callStartToken.image = functionName;
        astRuntimeCall.setStartToken(callStartToken);
        astRuntimeCall.setParser(this);
        astRuntimeCall.setType(Objects.class);
        Token varRef = new Token();
        varRef.image = functionName;
        ASTsimpleVariableReference variableReference = new ASTsimpleVariableReference(varRef);
        variableReference.jjtSetParent(astRuntimeCall);
        variableReference.parser = this;
        astRuntimeCall.setStem(variableReference);
        astRuntimeCall.setIIFE(true);
        return astRuntimeCall;
    }

    protected ASTcfscriptStatement createIIFEDefinitionNode(ASTcffunction function) {
        String functionName = IIFE_UDF_FUNCTION + ++IIFE_FUNCTION_COUNT;
        Token t = new Token();
        t.image = "=";
        Token iifeToken = new Token();
        iifeToken.image = functionName;
        VariableReference lvar = VariableReference.createSimpleReference(iifeToken, null, this);
        ASTcfscriptStatement astStatement = new ASTcfscriptStatement(3);
        astStatement.setStmtSubType(t);
        astStatement.parser = this;
        astStatement.setStatementType(3);
        astStatement.setNamedAttribute("LVAL", lvar);
        astStatement.setNamedAttribute("RVAL", function);
        return astStatement;
    }

    void createNullCoalescingOperator(JJTcfml40State jjtree, Node node, int id, Class type) {
        Node rhs = node;
        Node lhs = jjtree.popNode();
        jjtree.pushNode(lhs);
        jjtree.pushNode(rhs);
        Token token = new Token();
        token.image = "??";
        ASToperator rhsOp = new ASToperator(242);
        rhsOp.jjtAddChild(jjtree.popNode(), 0);
        rhsOp.jjtAddChild(jjtree.popNode(), 1);
        rhsOp.setOperator(token, 242, type);
        rhsOp.setStartToken(token);
        jjtree.pushNode(rhsOp);
        rhsOp.parser = rhs.parser;
    }

    ASTcfscriptStatement createcfScriptStmt(JJTcfml40State jjtree) {
        ASTcfscriptStatement stmt = new ASTcfscriptStatement(3);
        jjtree.peekNode().jjtAddChild(stmt, 0);
        return stmt;
    }

    void swapChildVarDef(JJTcfml40State jjtree, Node[] child) {
        Node top = jjtree.popNode();
        for (int i = 0; i < child.length; ++i) {
            jjtree.pushNode(child[i]);
        }
        jjtree.pushNode(top);
    }

    void createUnaryOperator(JJTcfml40State jjtree, Token t, int id, Class type) {
        ASToperator op = new ASToperator(id);
        op.jjtAddChild(jjtree.popNode(), 0);
        op.setOperator(t, id, type);
        jjtree.pushNode(op);
        op.setStartToken(t);
    }

    public boolean isTagInvocation_old() {
        Token t = this.getToken(1);
        return ("LOCK".equalsIgnoreCase(t.image) || "THREAD".equalsIgnoreCase(t.image) || "TRANSACTION".equalsIgnoreCase(t.image) || "SAVECONTENT".equalsIgnoreCase(t.image)) && !"=".equals(this.getToken((int)2).image);
    }

    public boolean isTagInvocation() {
        String tName = this.getToken((int)1).image.toLowerCase();
        if (!tName.startsWith("cf") && !tName.startsWith("cf_")) {
            return false;
        }
        boolean isKnownTag = false;
        isKnownTag = tName.regionMatches(true, 0, "cfx_", 0, 4) ? true : this.translationContext.isKnownTagNoCustom(tName);
        if (isKnownTag && this.getToken((int)2).image != "(") {
            return false;
        }
        return isKnownTag;
    }

    public boolean isCFLoop() {
        return this.getToken((int)1).image.equalsIgnoreCase("cfloop") && this.getToken((int)2).image.equals("(");
    }

    public boolean isImportTagInvocation() {
        Token t1 = this.getToken(1);
        Token t2 = null;
        Token t3 = null;
        Token t4 = null;
        try {
            t2 = this.getToken(2);
            t3 = this.getToken(3);
            t4 = this.getToken(4);
        }
        catch (Exception e) {
            return false;
        }
        return t2.image == ":" && t1.beginLine == t2.endLine && t2.beginColumn - t1.endColumn == 1 && t3.beginLine == t2.endLine && t3.beginColumn - t2.endColumn == 1 && t4.image == "(" && this.isTagPrefixDefined(t1.image + t2.image);
    }

    private boolean isTagPrefixDefined(String tagPrefix) {
        int count = 0;
        while (true) {
            try {
                String nameSpace;
                Node tagNode = this.peekNode(count);
                if (tagNode instanceof ASTcfimport && (nameSpace = ((ASTcfimport)tagNode).getNamespace()) != null && nameSpace.equalsIgnoreCase(tagPrefix)) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                return false;
            }
            ++count;
        }
    }

    public boolean isTagInvocationAsFunction() {
        boolean isKnownTag;
        Token t = this.getToken(1);
        boolean bl = isKnownTag = "WRITEDUMP".equalsIgnoreCase(t.image) || "WRITELOG".equalsIgnoreCase(t.image) || "TRACE".equalsIgnoreCase(t.image) || "THROW".equalsIgnoreCase(t.image) || "LOCATION".equalsIgnoreCase(t.image);
        if (isKnownTag) {
            Token t1 = null;
            try {
                t1 = this.getToken(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return t1 != null && t1.kind == 161;
        }
        return false;
    }

    protected Class getUnaryMinusLiteralType(Node unaryOpertor) {
        Node node;
        if (unaryOpertor instanceof ASToperator && unaryOpertor.jjtGetNumChildren() == 1 && (node = unaryOpertor.jjtGetChild(0)) instanceof ASTliteral) {
            ASTliteral literal = (ASTliteral)node;
            Vector tokens = literal.tokens;
            if (tokens.size() == 1) {
                Class type = literal.getType();
                if (type == CFInteger.class) {
                    tokens.set(0, ((CFInteger)tokens.get(0)).intValue());
                    literal.setType(Integer.TYPE);
                } else if (type == CFLong.class) {
                    tokens.set(0, ((CFInteger)tokens.get(0)).longValue());
                    literal.setType(Long.TYPE);
                }
                type = literal.getType();
                if (type == Integer.TYPE || type == Long.TYPE) {
                    return type;
                }
            }
        }
        return Double.TYPE;
    }

    protected void matchEndToStartTag(Token tagName, Class tagClass) throws UnmatchedEndTagException {
        int i = 0;
        try {
            do {
                Node n;
                if ((n = this.peekNode(i)).jjtGetNumChildren() == 0 && n.getClass() == tagClass && !((TagNode)n).isEmpty() && ((TagNode)n).getTagName().equalsIgnoreCase(tagName.image)) {
                    if (i == 0) {
                        ((ASTcftag)n).setEmpty();
                    }
                    while (i-- > 0) {
                        try {
                            Node c = this.popNode();
                            c.jjtSetParent(n);
                            n.jjtAddChild(c, i);
                        }
                        catch (Exception badPop) {
                            throw new InvalidEndTagNestingConfigurationException(n.getStartToken(), ((Node)this.openNodes.peek()).getStartToken());
                        }
                    }
                } else {
                    ++i;
                }
            } while (i > 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new UnmatchedEndTagException(tagName);
        }
    }

    protected boolean looksLikeUnmatchedEndTag(ParseException pex) {
        boolean result = pex.getClass() == ParseException.class;
        if (result &= pex.errorToken != null && pex.errorToken.kind == 2 && pex.errorToken.next != null) {
            Token next = pex.errorToken.next;
            result &= next.kind == 44 || next.image != null && next.image.toUpperCase().startsWith("CF");
        }
        return result;
    }

    protected void verifyPageEncoding(ExprNode encoding) {
        String desiredEncoding = EvaluateEngine._String(encoding);
        try {
            if (this.inputEncoding == null || !BOMReader.isEncodingMatch(desiredEncoding, this.inputEncoding)) {
                throw new ConflictingEncodingSpecificationException(desiredEncoding, this.inputEncoding);
            }
            String canonicalEncoding = new InputStreamReader((InputStream)new StringBufferInputStream(""), desiredEncoding).getEncoding();
        }
        catch (UnsupportedEncodingException noEncoding) {
            throw new InvalidEncodingSpecificationException(desiredEncoding);
        }
    }

    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    protected boolean possibleUnterminatedConstruct(Token startToken, Token errorToken) {
        int kind = errorToken.next.kind;
        boolean result = startToken.next == errorToken;
        return result &= kind == 1 || kind == 2 || kind == 3 || kind == 4 || kind == 53 || kind == 52 || kind == 54 || kind == 55;
    }

    protected void addContextLines(ParseException pex) {
        pex._setPageFile(this.translationContext.getPageFile());
        int errorLine = pex.getLine();
        if (errorLine >= 1 && this.firstToken != null) {
            StringBuffer result = new StringBuffer();
            Token t = this.firstToken;
            while (t != null && t.beginLine <= errorLine) {
                if (t.beginLine == errorLine) {
                    if (t.specialToken != null) {
                        result.append(t.specialToken.image);
                    }
                    result.append(t.image);
                }
                t = t.next;
            }
            pex.setSnippet(result.toString());
        }
    }

    public boolean isWithinStaticBlock() {
        return this.withinStaticBlock;
    }

    public void setWithinStaticBlock(boolean flag) {
        this.withinStaticBlock = flag;
    }

    public boolean supportStatic() {
        return this.supportStatic;
    }

    public void setSupportStatic(boolean flag) {
        this.supportStatic = flag;
    }

    public void createImplicitReturnStatement(JJTcfml40State jjtree) {
        ASTcfscriptStatement assignmentStatement = null;
        ASTreturnStatement insertedReturnStatement = null;
        assignmentStatement = (ASTcfscriptStatement)jjtree.peekNode();
        insertedReturnStatement = new ASTreturnStatement(5);
        insertedReturnStatement.setNamedAttribute("RVAL", assignmentStatement.getNamedAttribute("RVAL"));
        jjtree.pushNode(insertedReturnStatement);
    }

    public static class UnsupportedVariablesException
    extends ParseException {
        public String attrparam;
        public String attrvalue;

        UnsupportedVariablesException(String param, String value) {
            this.attrparam = param;
            this.attrvalue = value;
        }
    }

    public class InvalidEndTagNestingConfigurationException
    extends ParseException {
        public Token startTagToken;

        InvalidEndTagNestingConfigurationException(Token st, Token nt) {
            super(nt);
            this.startTagToken = st;
        }

        public String getStartTagName() {
            return this.startTagToken.image;
        }

        public int getStartTagLine() {
            return this.startTagToken.beginLine;
        }

        public int getStartTagColumn() {
            return this.startTagToken.beginColumn;
        }
    }

    public static class InvalidEncodingSpecificationException
    extends ParseException {
        public String desiredEncoding;

        InvalidEncodingSpecificationException(String desiredEncoding) {
            this.desiredEncoding = desiredEncoding;
        }
    }

    public static class PossiblyEmptyCPDException
    extends ParseException {
        PossiblyEmptyCPDException(Token t) {
            super(t);
        }
    }

    public static class UnknownParseElementException
    extends ParseException {
        UnknownParseElementException(Token t) {
            super(t);
        }
    }

    public static class BodyTagParseException
    extends ParseException {
        BodyTagParseException(Token startToken) {
            super(startToken);
        }
    }

    public static class TagLevelParseException
    extends ParseException {
        TagLevelParseException(Token startToken) {
            super(startToken);
        }
    }

    public static class UnsupportedComplexException
    extends ParseException {
        UnsupportedComplexException(Token t) {
            super(t);
        }
    }

    public static class MissingNameException
    extends ParseException {
        MissingNameException(Token t) {
            super(t);
        }
    }

    public static class InvalidTagAttributeException
    extends ParseException {
        InvalidTagAttributeException(Token tagName) {
            super(tagName);
        }
    }

    public static class InvalidScriptStatementException
    extends ParseException {
        InvalidScriptStatementException(Token scriptToken) {
            super(scriptToken);
        }
    }

    public static class UnexpectedExpressionElementException
    extends ParseException {
        UnexpectedExpressionElementException(Token startToken) {
            super(startToken);
        }
    }

    public static class StartOctothorpeMissingException
    extends ParseException {
        StartOctothorpeMissingException(Token startToken) {
            super(startToken);
        }
    }

    public static class EndOctothorpeMissingException
    extends ParseException {
        EndOctothorpeMissingException(Token startToken) {
            super(startToken);
        }
    }

    public static class UnterminatedCommentException
    extends ParseException {
        public int startCommentLine;

        UnterminatedCommentException(int startCommentLine) {
            this.startCommentLine = startCommentLine;
        }
    }

    public static class UnterminatedStringException
    extends ParseException {
        UnterminatedStringException(Token startToken) {
            super(startToken);
        }
    }

    public static class KeywordIdentifierException
    extends ParseException {
        public KeywordIdentifierException(Token errorToken) {
            super(errorToken);
        }
    }

    public static class StaticKeywordAssignmentException
    extends ParseException {
        StaticKeywordAssignmentException(Token t) {
            super(t);
        }
    }

    public static class InvalidSimpleIdentifierException
    extends ParseException {
        InvalidSimpleIdentifierException(Token startToken) {
            super(startToken);
        }
    }
}

