/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.MethodNotFoundException;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.NonConstantExpressionException;
import coldfusion.compiler.StringCharStream;
import coldfusion.compiler.Token;
import coldfusion.compiler.cfml40;
import coldfusion.compiler.cfml40TokenManager;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.util.RuntimeWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class EvaluateEngine {
    private EvaluateEngine() {
    }

    static ASTcfscriptStatement parse(String expr, NeoTranslationContext tc) {
        cfml40TokenManager lexer = new cfml40TokenManager(new StringCharStream(expr), 2);
        cfml40 parser = new cfml40(lexer);
        parser.setTranslationContext(tc);
        return parser.startEvaluate();
    }

    static ASTcfscriptStatement parsePrecisionEvaluate(String expr, NeoTranslationContext tc) {
        cfml40TokenManager lexer = new cfml40TokenManager(new StringCharStream(expr), 2);
        cfml40 parser = new cfml40(lexer);
        parser.setTranslationContext(tc);
        return parser.startPrecisionEvaluate();
    }

    static ExprNode parseCFMLExpr(String expr, NeoTranslationContext tc) {
        ASTcfscriptStatement statement = EvaluateEngine.parse(expr, tc);
        if (statement.getStatementType() == 4) {
            return statement.getExpression("EXPR");
        }
        throw new CompilerInternalException(statement);
    }

    public static String _String(ExprNode node) throws AbstractParseException {
        return Cast._String(EvaluateEngine.evaluateNode(node));
    }

    static final Object evaluateNode(ExprNode n) throws AbstractParseException {
        try {
            switch (n.id) {
                case 226: {
                    return Cast._cast(EvaluateEngine.evaluateNode(n.subexpr(0)), n.getType());
                }
                case 215: {
                    Object value = EvaluateEngine.evaluateNode(n.subexpr(0));
                    if (value instanceof Integer || value instanceof CFInteger) {
                        return -Cast._int(value);
                    }
                    if (value instanceof Long || value instanceof CFLong) {
                        return -Cast._long(value);
                    }
                    return Cast._Object(-Cast._double(EvaluateEngine.evaluateNode(n.subexpr(0))));
                }
                case 200: 
                case 201: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    return EvaluateEngine.evaluateArithmeticOperator((ASToperator)n);
                }
                case 209: 
                case 210: 
                case 213: 
                case 216: 
                case 217: {
                    return EvaluateEngine.evaluateLogicalOperator(n);
                }
                case 214: {
                    return Cast._Object(!Cast._boolean(EvaluateEngine.evaluateNode(n.subexpr(0))));
                }
                case 202: {
                    return EvaluateEngine.evaluateConcat(n);
                }
                case 27: {
                    return EvaluateEngine.evaluatePrimary((ASTliteral)n);
                }
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 235: 
                case 236: 
                case 239: 
                case 240: {
                    return EvaluateEngine.evaluateCompare((ASToperator)n);
                }
                case 237: {
                    return EvaluateEngine.evaluateHook((ASToperator)n);
                }
                case 10001: {
                    return EvaluateEngine.evaluateMethodCall((ASTruntimeCall)n);
                }
                case 10000: 
                case 10002: 
                case 10003: {
                    throw new NonConstantExpressionException(n);
                }
            }
            throw new UnsupportedOperationException("Unable to find an operator implementation for " + n.getClass().getName());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeWrapper(ex);
        }
    }

    private static final Object evaluateArithmeticOperator(ASToperator binop) throws AbstractParseException {
        Object result = EvaluateEngine.evaluateNode(binop.subexpr(0));
        Token operator = binop.getOperator();
        Object rhs = EvaluateEngine.evaluateNode(binop.subexpr(1));
        switch (operator.kind) {
            case 113: {
                result = Cast._Object(Cast._double(result) + Cast._double(rhs));
                break;
            }
            case 114: {
                result = Cast._Object(Cast._double(result) - Cast._double(rhs));
                break;
            }
            case 118: {
                result = Cast._Object(Cast._double(result) * Cast._double(rhs));
                break;
            }
            case 115: {
                result = Cast._Object(Math.pow(Cast._double(result), Cast._double(rhs)));
                break;
            }
            case 119: {
                result = Cast._Object(CfJspPage._div(Cast._double(result), Cast._double(rhs)));
                break;
            }
            case 117: {
                result = Cast._Object(CfJspPage._idiv(Cast._int(result), Cast._int(rhs)));
                break;
            }
            case 116: {
                result = Cast._Object(CfJspPage._mod(Cast._int(result), Cast._int(rhs)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to decode operator " + operator);
            }
        }
        return result;
    }

    private static final Object evaluateCompare(ASToperator comparison) throws AbstractParseException {
        Object vlhs = EvaluateEngine.evaluateNode(comparison.subexpr(0));
        Object vrhs = EvaluateEngine.evaluateNode(comparison.subexpr(1));
        Token operator = comparison.getOperator();
        return Cast._Object(switch (operator.kind) {
            case 100, 104 -> CfJspPage._compare(vlhs, vrhs) == 0.0;
            case 102 -> CfJspPage._strictCompare(vlhs, vrhs) == 0.0;
            case 103 -> CfJspPage._strictCompare(vlhs, vrhs) != 0.0;
            case 101, 105 -> CfJspPage._compare(vlhs, vrhs) != 0.0;
            case 89, 106 -> CfJspPage._compare(vlhs, vrhs) < 0.0;
            case 91, 107 -> CfJspPage._compare(vlhs, vrhs) <= 0.0;
            case 90, 108 -> CfJspPage._compare(vlhs, vrhs) > 0.0;
            case 92, 109 -> CfJspPage._compare(vlhs, vrhs) >= 0.0;
            case 110 -> CfJspPage._contains(Cast._String(vlhs), Cast._String(vrhs));
            case 111 -> !CfJspPage._contains(Cast._String(vlhs), Cast._String(vrhs));
            default -> throw new IllegalArgumentException("Cannot use comparison operator " + operator);
        });
    }

    private static final Object evaluateHook(ASToperator comparison) throws AbstractParseException {
        boolean compExpr = Cast._boolean(EvaluateEngine.evaluateNode(comparison.subexpr(0)));
        if (compExpr) {
            return EvaluateEngine.evaluateNode(comparison.subexpr(1).subexpr(0));
        }
        return EvaluateEngine.evaluateNode(comparison.subexpr(1).subexpr(1));
    }

    private static final Object evaluateLogicalOperator(ExprNode n) throws AbstractParseException {
        Object result = EvaluateEngine.evaluateNode(n.subexpr(0));
        ExprNode right = n.subexpr(1);
        switch (n.id) {
            case 213: {
                result = Cast._Object(Cast._boolean(result) ^ Cast._boolean(EvaluateEngine.evaluateNode(right)));
                break;
            }
            case 216: {
                result = Cast._boolean(result) ? EvaluateEngine.evaluateNode(right) : result;
                break;
            }
            case 217: {
                result = Cast._boolean(result) ? result : EvaluateEngine.evaluateNode(right);
                break;
            }
            case 210: {
                result = Cast._Object(!Cast._boolean(result) | Cast._boolean(EvaluateEngine.evaluateNode(right)));
                break;
            }
            case 209: {
                result = Cast._Object(!(Cast._boolean(result) ^ Cast._boolean(EvaluateEngine.evaluateNode(right))));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to determine boolean value of logical operator " + n.getClass().getName());
            }
        }
        return result;
    }

    private static final Object evaluatePrimary(ASTliteral p) throws AbstractParseException {
        if (p.tokens.size() == 1) {
            Object token = p.tokens.elementAt(0);
            if (token instanceof ExprNode) {
                return EvaluateEngine.evaluateNode((ExprNode)token);
            }
            return token;
        }
        StringBuilder tempstr = new StringBuilder();
        int count = p.tokens.size();
        for (int i = 0; i < count; ++i) {
            Object token = p.tokens.elementAt(i);
            if (token instanceof ExprNode) {
                ExprNode node = (ExprNode)token;
                tempstr.append(Cast._String(EvaluateEngine.evaluateNode(node)));
                continue;
            }
            tempstr.append((String)token);
        }
        return tempstr.toString();
    }

    private static final Object evaluateMethodCall(ASTruntimeCall cRef) throws IllegalAccessException, AbstractParseException {
        try {
            Class<CFPage> c = CFPage.class;
            Method method = cRef.getMethod(c);
            if (!Modifier.isStatic(method.getModifiers()) || method.getReturnType().isAssignableFrom(Void.TYPE) || cRef.getStartToken().image.indexOf(".") > 0) {
                throw new NonConstantExpressionException(cRef);
            }
            ASTfuncparams parameters = cRef.getParameters();
            Object[] parray = new Object[parameters.getParamCount()];
            Class<?>[] parmTypes = method.getParameterTypes();
            for (int i = 0; i < parray.length; ++i) {
                parray[i] = Cast._cast(EvaluateEngine.evaluateNode(parameters.subexpr(i)), parmTypes[i]);
            }
            return method.invoke(null, parray);
        }
        catch (InvocationTargetException ex) {
            try {
                throw ex.getTargetException();
            }
            catch (RuntimeException ex2) {
                throw ex2;
            }
            catch (Error ex2) {
                throw ex2;
            }
            catch (Throwable ex2) {
                throw new RuntimeWrapper(ex2);
            }
        }
        catch (MethodNotFoundException ex) {
            throw ex;
        }
        catch (IllegalAccessException ex) {
            throw ex;
        }
    }

    private static final Object evaluateConcat(ExprNode n) throws AbstractParseException {
        StringBuilder result = new StringBuilder(Cast._String(EvaluateEngine.evaluateNode(n.subexpr(0))));
        int count = n.jjtGetNumChildren();
        for (int i = 1; i < count; ++i) {
            result.append(Cast._String(EvaluateEngine.evaluateNode(n.subexpr(i))));
        }
        return result.toString();
    }
}

