/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.ExprClassLoader;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.FunctionAssembler;
import coldfusion.compiler.InstanceFieldReference;
import coldfusion.compiler.LocalVariableReference;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.OperationNotSupportedException;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.SliceMetadataNode;
import coldfusion.compiler.StaticFieldReference;
import coldfusion.compiler.VariableReference;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFComponent;
import coldfusion.runtime.CFObjectIterable;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CFStringIterable;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.StaticScope;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.Variable;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.Row;
import coldfusion.tagext.validation.CFTypeValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

class ExprAssembler
extends JavaAssembler {
    NeoTranslationContext tc;
    Object pageVar;
    Object valueVar;
    boolean isSafeOperator = false;
    static final String CF_ELVIS_EXP_VAR = "__CF_ELVIS__VAR";
    static final String CF_NULL_COALESCING_EXP_VAR = "__CF_NULL_COALESCING__VAR";
    static final Class CfJspPageClass = CfJspPage.class;
    static final Class CfComponentClass = CFComponent.class;
    static final Class CFPageClass = CFPage.class;
    static final Class CastClass = Cast.class;
    static final Class StringBuilderClass = StringBuilder.class;
    static final Class AttributeCollectionClass = AttributeCollection.class;
    static final Class ArgumentCollectionClass = ArgumentCollection.class;
    static final Class ObjectClass = Object.class;
    static final Class StaticScopeClass = StaticScope.class;
    static final Class UDFMethodClass = UDFMethod.class;
    static final Class VariableClass = Variable.class;
    static final Class CFArrayClass = FastArray.class;
    static final Class MathClass = Math.class;
    static final Class MapClass = Map.class;
    static final Class IteratorClass = Iterator.class;
    static final Class MapEntryClass = Map.Entry.class;
    static final Class StringArrayClass = String[].class;
    static final Class ObjectArrayClass = Object[].class;
    static final Class QueryTableClass = QueryTable.class;
    static final Class QueryTableMetaDataClass = QueryTableMetaData.class;
    static final Class RowClass = Row.class;
    static final Class CFTYpeValidatorClass = CFTypeValidator.class;
    static final Class CFObjectIterableClass = CFObjectIterable.class;
    static final Class CFStringIterableClass = CFStringIterable.class;
    static final Method pow = ExprAssembler.getStaticMethod(MathClass, "pow", new Class[]{doubleClass, doubleClass});
    static final Method ddiv = ExprAssembler.getStaticMethod(CfJspPageClass, "_div", new Class[]{doubleClass, doubleClass});
    static final Method idiv = ExprAssembler.getStaticMethod(CfJspPageClass, "_idiv", new Class[]{intClass, intClass});
    static final Method imod = ExprAssembler.getStaticMethod(CfJspPageClass, "_mod", new Class[]{intClass, intClass});
    static final Method concat = ExprAssembler.getInstanceMethod(StringClass, "concat", new Class[]{StringClass});
    static final Method nullSafeConcat = ExprAssembler.getStaticMethod(CfJspPageClass, "__nullSafeConcat", new Class[]{StringClass, StringClass});
    static final Method append = ExprAssembler.getInstanceMethod(StringBuilderClass, "append", new Class[]{StringClass});
    static final Method toString = ExprAssembler.getInstanceMethod(ObjectClass, "toString", new Class[0]);
    static final Method contains = ExprAssembler.getStaticMethod(CfJspPageClass, "_contains", new Class[]{StringClass, StringClass});
    static final Method compare = ExprAssembler.getStaticMethod(CfJspPageClass, "_compare", new Class[]{ObjectClass, ObjectClass});
    static final Method strictCompare = ExprAssembler.getStaticMethod(CfJspPageClass, "_strictCompare", new Class[]{ObjectClass, ObjectClass});
    static final Method get = ExprAssembler.getInstanceMethod(CfJspPageClass, "_get", new Class[]{StringClass});
    static final Method getVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_get", new Class[]{VariableClass});
    static final Method getSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_get", new Class[]{StringClass, booleanClass});
    static final Method getVarSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_get", new Class[]{VariableClass, booleanClass});
    static final Method set = ExprAssembler.getInstanceMethod(CfJspPageClass, "_set", new Class[]{StringClass, ObjectClass});
    static final Method set_Final = ExprAssembler.getInstanceMethod(CfJspPageClass, "_set_Final", new Class[]{StringClass, ObjectClass});
    static final Method setNonLocalScope = ExprAssembler.getInstanceMethod(CfJspPageClass, "_setNonLocalScope", new Class[]{StringClass, ObjectClass});
    static final Method setVar = ExprAssembler.getInstanceMethod(VariableClass, "set", new Class[]{ObjectClass});
    static final Method setVarDouble = ExprAssembler.getInstanceMethod(VariableClass, "set", new Class[]{Double.TYPE});
    static final Method setVarInteger = ExprAssembler.getInstanceMethod(VariableClass, "set", new Class[]{Integer.TYPE});
    static final Method setVarLong = ExprAssembler.getInstanceMethod(VariableClass, "set", new Class[]{Long.TYPE});
    static final Method setVarBoolean = ExprAssembler.getInstanceMethod(VariableClass, "set", new Class[]{Boolean.TYPE});
    static final Method setArrayVar = ExprAssembler.getInstanceMethod(VariableClass, "setArray", new Class[]{CFArrayClass});
    static final Method getScalar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarize", new Class[]{StringClass});
    static final Method getScalarForWS = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarizeWS", new Class[]{StringClass});
    static final Method getScalarIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarize", new Class[]{StringClass, intClass});
    static final Method getNonLocalScopeVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarizeWithoutLocalScope", new Class[]{StringClass});
    static final Method getNonLocalScopeVarIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarizeWithoutLocalScope", new Class[]{StringClass, intClass});
    static final Method getScalarVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarize", new Class[]{VariableClass});
    static final Method _getScalarVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "__autoscalarize", new Class[]{VariableClass});
    static final Method getScalarObject = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarize", new Class[]{ObjectClass});
    static final Method getScalarVarIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_autoscalarize", new Class[]{VariableClass, intClass});
    static final Method lhsResolveMap = ExprAssembler.getInstanceMethod(CfJspPageClass, "_LhsResolve", new Class[]{MapClass, StringArrayClass});
    static final Method lhsResolveString = ExprAssembler.getInstanceMethod(CfJspPageClass, "_LhsResolve", new Class[]{StringClass, StringArrayClass});
    static final Method lhsResolveVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_LhsResolve", new Class[]{VariableClass, StringArrayClass});
    static final Method resolveMap = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{MapClass, StringArrayClass});
    static final Method resolveString = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{StringClass, StringArrayClass});
    static final Method resolveVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{VariableClass, StringArrayClass});
    static final Method _resolveMap = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolve", new Class[]{MapClass, StringArrayClass});
    static final Method _resolveString = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolve", new Class[]{StringClass, StringArrayClass});
    static final Method _resolveVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolve", new Class[]{VariableClass, StringArrayClass});
    static final Method resolveMapScalar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{MapClass, StringArrayClass});
    static final Method resolveMapScalarIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{MapClass, StringArrayClass, intClass});
    static final Method resolveStringScalar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass});
    static final Method resolveStringScalarWS = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarizeWS", new Class[]{StringClass, StringArrayClass});
    static final Method resolveStringScalarIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, intClass});
    static final Method resolveVarScalar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass});
    static final Method resolveVarScalarIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass, intClass});
    static final Method resolveMapSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{MapClass, StringArrayClass, booleanClass, booleanClass});
    static final Method resolveMapScalarSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{MapClass, StringArrayClass, booleanClass, booleanClass});
    static final Method resolveMapScalarIncrDecrSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{MapClass, StringArrayClass, intClass, booleanClass, booleanClass});
    static final Method resolveStringSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{StringClass, StringArrayClass, booleanClass, booleanClass});
    static final Method resolveStringStemSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{StringClass, StringArrayClass, booleanClass, booleanClass, booleanClass});
    static final Method resolveVarSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{VariableClass, StringArrayClass, booleanClass, booleanClass});
    static final Method resolveVarStemSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolve", new Class[]{VariableClass, StringArrayClass, booleanClass, booleanClass, booleanClass});
    static final Method resolveStringScalarSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, booleanClass, booleanClass});
    static final Method resolveStringScalarStemSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, booleanClass, booleanClass, booleanClass});
    static final Method resolveStringScalarWSSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarizeWS", new Class[]{StringClass, StringArrayClass, booleanClass, booleanClass});
    static final Method resolveStringScalarIncrDecrSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, intClass, booleanClass, booleanClass});
    static final Method resolveStringScalarIncrDecrStemSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, intClass, booleanClass, booleanClass, booleanClass});
    static final Method resolveVarScalarStemSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass, booleanClass, booleanClass, booleanClass});
    static final Method resolveVarScalarIncrDecrSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass, intClass, booleanClass, booleanClass});
    static final Method resolveVarScalarIncrDecrStemSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass, intClass, booleanClass, booleanClass, booleanClass});
    static final Method invokeMethod = ExprAssembler.getInstanceMethod(CfJspPageClass, "_invoke", new Class[]{ObjectClass, StringClass, ObjectArrayClass});
    static final Method invokeAssociativeMethod = ExprAssembler.getInstanceMethod(CfJspPageClass, "_invoke", new Class[]{ObjectClass, ObjectClass, ObjectArrayClass});
    static final Method invokeMethodNamed = ExprAssembler.getInstanceMethod(CfJspPageClass, "_invoke", new Class[]{ObjectClass, StringClass, MapClass});
    static final Method invokeMethodSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_invoke", new Class[]{ObjectClass, StringClass, ObjectArrayClass, booleanClass, booleanClass});
    static final Method invokeMethodNamedSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_invoke", new Class[]{ObjectClass, StringClass, MapClass, booleanClass, booleanClass});
    static final Method invokeAssociativeMethodNamed = ExprAssembler.getInstanceMethod(CfJspPageClass, "_invoke", new Class[]{ObjectClass, ObjectClass, MapClass});
    static final Method createObjectMethod = ExprAssembler.getInstanceMethod(CFPageClass, "_createObject", new Class[]{StringClass, ObjectArrayClass});
    static final Method createObjectNamedArgMethod = ExprAssembler.getInstanceMethod(CFPageClass, "_createObject", new Class[]{StringClass, MapClass});
    static final Method clone = ExprAssembler.getInstanceMethod(StaticScopeClass, "deepClone", new Class[0]);
    static final Method invokeUdf = ExprAssembler.getStaticMethod(CfJspPageClass, "_invokeUDF", new Class[]{ObjectClass, StringClass, CFPageClass, ObjectArrayClass});
    static final Method invokeUdfNamed = ExprAssembler.getStaticMethod(CfJspPageClass, "_invokeUDF", new Class[]{ObjectClass, StringClass, CFPageClass, MapClass});
    static final Method invokeUdfSafe = ExprAssembler.getStaticMethod(CfJspPageClass, "_invokeUDF", new Class[]{ObjectClass, StringClass, CFPageClass, ObjectArrayClass, booleanClass, booleanClass});
    static final Method invokeUdfNamedSafe = ExprAssembler.getStaticMethod(CfJspPageClass, "_invokeUDF", new Class[]{ObjectClass, StringClass, CFPageClass, MapClass, booleanClass, booleanClass});
    static final Method arrayGet1 = ExprAssembler.getStaticMethod(CfJspPageClass, "_arrayGetAt", new Class[]{ObjectClass, ObjectClass});
    static final Method LHSarrayGet1 = ExprAssembler.getStaticMethod(CfJspPageClass, "_LHSarrayGetAt", new Class[]{ObjectClass, ObjectClass, booleanClass});
    static final Method arrayGet1IncrDecr = ExprAssembler.getStaticMethod(CfJspPageClass, "_arrayGetAt", new Class[]{ObjectClass, ObjectClass, intClass});
    static final Method arrayGetN = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{ObjectClass, ObjectArrayClass});
    static final Method LHSarrayGetN = ExprAssembler.getInstanceMethod(CfJspPageClass, "_LHSarrayGetAt", new Class[]{ObjectClass, ObjectArrayClass, booleanClass});
    static final Method arrayGetNIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{ObjectClass, ObjectArrayClass, intClass});
    static final Method arrayGetString1 = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{StringClass, ObjectClass});
    static final Method arrayGetString1IncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{StringClass, ObjectClass, intClass});
    static final Method arrayGetStringN = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{StringClass, ObjectArrayClass});
    static final Method arrayGetStringNIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{StringClass, ObjectArrayClass, intClass});
    static final Method arrayGetVar1 = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{VariableClass, ObjectClass});
    static final Method arrayGetVar1IncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{VariableClass, ObjectClass, intClass});
    static final Method arrayGetVarN = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{VariableClass, ObjectArrayClass});
    static final Method arrayGetVarNIncrDecr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{VariableClass, ObjectArrayClass, intClass});
    static final Method arraySlice = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetSlice", new Class[]{VariableClass, ObjectClass, ObjectClass, ObjectClass});
    static final Method arraySliceStr = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetSlice", new Class[]{StringClass, ObjectClass, ObjectClass, ObjectClass});
    static final Method arrayGetVarNSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{VariableClass, booleanClass, ObjectArrayClass, ObjectArrayClass});
    static final Method arrayGetStringNSafe = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arrayGetAt", new Class[]{StringClass, booleanClass, ObjectArrayClass, ObjectArrayClass});
    static final Method arrayGet1_SAFE = ExprAssembler.getStaticMethod(CfJspPageClass, "__arrayGetAt", new Class[]{ObjectClass, ObjectClass});
    static final Method arrayGet1IncrDecr_SAFE = ExprAssembler.getStaticMethod(CfJspPageClass, "__arrayGetAt", new Class[]{ObjectClass, ObjectClass, intClass});
    static final Method arrayGetN_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{ObjectClass, ObjectArrayClass});
    static final Method arrayGetNIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{ObjectClass, ObjectArrayClass, intClass});
    static final Method arrayGetString1_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{StringClass, ObjectClass});
    static final Method arrayGetString1IncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{StringClass, ObjectClass, intClass});
    static final Method arrayGetStringN_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{StringClass, ObjectArrayClass});
    static final Method arrayGetStringNIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{StringClass, ObjectArrayClass, intClass});
    static final Method arrayGetVar1_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{VariableClass, ObjectClass});
    static final Method arrayGetVar1IncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{VariableClass, ObjectClass, intClass});
    static final Method arrayGetVarN_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{VariableClass, ObjectArrayClass});
    static final Method arrayGetVarNIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__arrayGetAt", new Class[]{VariableClass, ObjectArrayClass, intClass});
    static final Method resolveMapScalar_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{MapClass, StringArrayClass});
    static final Method resolveStringScalarStemSafe_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, booleanClass, booleanClass, booleanClass});
    static final Method resolveMapScalarIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{MapClass, StringArrayClass, intClass});
    static final Method resolveStringScalar_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass});
    static final Method resolveStringScalarIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{StringClass, StringArrayClass, intClass});
    static final Method resolveVarScalar_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass});
    static final Method resolveVarScalarIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__resolveAndAutoscalarize", new Class[]{VariableClass, StringArrayClass, intClass});
    static final Method getScalar_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__autoscalarize", new Class[]{StringClass});
    static final Method getScalarIncrDecr_SAFE = ExprAssembler.getInstanceMethod(CfJspPageClass, "__autoscalarize", new Class[]{StringClass, intClass});
    static final Method _resolveStaticAccessorVariable = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveStaticAccessorVariable", new Class[]{StringClass, ObjectClass, UDFMethodClass});
    static final Method _resolveStaticAccessorVariableValue = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveStaticAccessorVariableValue", new Class[]{StringClass, ObjectClass, UDFMethodClass});
    static final Method _resolveStaticVariable = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveStaticVariable", new Class[]{StaticScopeClass, ObjectClass, UDFMethodClass});
    static final Method _resolveStaticVariableValue = ExprAssembler.getInstanceMethod(CfJspPageClass, "_resolveStaticVariableValue", new Class[]{StaticScopeClass, ObjectClass, UDFMethodClass});
    static final Method linkStaticScope = ExprAssembler.getDeclaredMethod(CfJspPageClass, "linkStaticScope", new Class[]{UDFMethodClass, StaticScopeClass});
    static final Method _declareStaticVariable = ExprAssembler.getInstanceMethod(CfJspPageClass, "_declareStaticVariable", new Class[]{StaticScopeClass, ObjectClass, intClass});
    static final Method cast = ExprAssembler.getStaticMethod(CastClass, "_cast", new Class[]{ObjectClass, ClassClass});
    static final Method arraySetString = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arraySetAt", new Class[]{StringClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetObject = ExprAssembler.getStaticMethod(CfJspPageClass, "_arraySetAt", new Class[]{ObjectClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arraySetAt", new Class[]{VariableClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetForSpread = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arraySetForSpread", new Class[]{VariableClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetForSpreadObj = ExprAssembler.getStaticMethod(CfJspPageClass, "_arraySetForSpread", new Class[]{ObjectClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetStringFinal = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arraySetAtFinal", new Class[]{StringClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetObjectFinal = ExprAssembler.getStaticMethod(CfJspPageClass, "_arraySetAtFinal", new Class[]{ObjectClass, ObjectArrayClass, ObjectClass});
    static final Method arraySetVarFinal = ExprAssembler.getInstanceMethod(CfJspPageClass, "_arraySetAtFinal", new Class[]{VariableClass, ObjectArrayClass, ObjectClass});
    static final Method structSetStringFinal = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt_Final", new Class[]{StringClass, ObjectArrayClass, ObjectClass});
    static final Method structSetVarFinal = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt_Final", new Class[]{VariableClass, ObjectArrayClass, ObjectClass});
    static final Method structSetObjectFinal = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt_Final", new Class[]{ObjectClass, ObjectArrayClass, ObjectClass});
    static final Method structSetString = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt", new Class[]{StringClass, ObjectArrayClass, ObjectClass});
    static final Method structSetStringCase = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt", new Class[]{StringClass, ObjectArrayClass, ObjectClass});
    static final Method structSetVar = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt", new Class[]{VariableClass, ObjectArrayClass, ObjectClass});
    static final Method structSetVarCase = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt", new Class[]{VariableClass, ObjectArrayClass, ObjectClass});
    static final Method structSetObject = ExprAssembler.getInstanceMethod(CfJspPageClass, "_structSetAt", new Class[]{ObjectClass, ObjectArrayClass, ObjectClass});
    static final Method setCurrentLineNo = ExprAssembler.getInstanceMethod(CfJspPageClass, "_setCurrentLineNo", new Class[]{intClass});
    static final Method addBigDecimal = ExprAssembler.getStaticMethod(CfJspPageClass, "_addBD", new Class[]{BigDecimalClass, BigDecimalClass});
    static final Method subtractBigDecimal = ExprAssembler.getStaticMethod(CfJspPageClass, "_subtractBD", new Class[]{BigDecimalClass, BigDecimalClass});
    static final Method multiplyBigDecimal = ExprAssembler.getStaticMethod(CfJspPageClass, "_multiplyBD", new Class[]{BigDecimalClass, BigDecimalClass});
    static final Method divideBigDecimal = ExprAssembler.getStaticMethod(CfJspPageClass, "_divideBD", new Class[]{BigDecimalClass, BigDecimalClass});
    static final Method negateBigDecimal = ExprAssembler.getStaticMethod(CfJspPageClass, "_negateBD", new Class[]{BigDecimalClass});
    static final Method powBigDecimal = ExprAssembler.getStaticMethod(CfJspPageClass, "_powBD", new Class[]{BigDecimalClass, BigDecimalClass});
    static final Method bindInternal = ExprAssembler.getInstanceMethod(LocalScope.class, "bindInternal", new Class[]{StringClass});
    static final Method isNull = ExprAssembler.getInstanceMethod(CfJspPageClass, "_isNull", new Class[]{ObjectClass, Boolean.TYPE});
    static final Method isTruthyValue = ExprAssembler.getStaticMethod(CfJspPageClass, "_isTruthyValue", new Class[]{ObjectClass});
    static final Method mergeToLocal = ExprAssembler.getInstanceMethod(CfJspPageClass, "_mergeToLocal", new Class[]{MapClass, ObjectClass});
    static final Method mapGet = ExprAssembler.getInstanceMethod(MapClass, "get", new Class[]{ObjectClass});
    static final Method getValueOfVar = ExprAssembler.getInstanceMethod(VariableClass, "getValue", new Class[0]);
    static final Constructor newVariableClass = ExprAssembler.getConstructor(VariableClass, new Class[]{StringClass});
    static final Constructor newStringBuilder = ExprAssembler.getConstructor(StringBuilderClass, new Class[]{StringClass});
    static final Constructor newArgumentCollection = ExprAssembler.getConstructor(ArgumentCollectionClass, new Class[]{ObjectArrayClass, ObjectArrayClass});
    static final Constructor newAttributeCollection = ExprAssembler.getConstructor(AttributeCollectionClass, new Class[]{ObjectArrayClass});
    static final Constructor newCFObjectIterable = ExprAssembler.getConstructor(CFObjectIterableClass, new Class[]{ObjectClass});
    static final Constructor newCFStringIterable = ExprAssembler.getConstructor(CFStringIterableClass, new Class[]{StringClass});
    static final Method expandSpreadArgs = ExprAssembler.getStaticMethod(CfJspPageClass, "_expandSpreadArgs", new Class[]{ObjectArrayClass});
    static final Method minusOne = ExprAssembler.getStaticMethod(CfJspPageClass, "__minusOne", new Class[]{Integer.class});
    protected boolean disableLineFeed;

    ExprAssembler() {
    }

    private Object generateInitializerStmtOpCode(Node node) {
        Object label = null;
        if (node instanceof ASTcffunction) {
            ASTcffunction functionNode = (ASTcffunction)node;
            label = this.cast(functionNode, ObjectClass);
        } else {
            label = this.cast((ExprNode)node, ObjectClass);
        }
        return label;
    }

    Object _assembleExpr(ExprNode node, boolean cast) {
        Object label;
        Object spreadLabel = null;
        Class type = node.getType();
        if (node.isSpreadOperationType()) {
            spreadLabel = node instanceof ASTliteral ? this.newinstance(CFStringIterableClass) : this.newinstance(CFObjectIterableClass);
        }
        switch (node.id) {
            case 27: {
                Object value = ((ASTliteral)node).tokens.elementAt(0);
                if (value instanceof ExprNode) {
                    label = this.assembleExpr((ExprNode)value);
                    break;
                }
                label = this.aconst(value);
                break;
            }
            case 226: {
                label = this.cast(node.subexpr(0), type);
                break;
            }
            case 215: {
                label = this.assembleExpr(node.subexpr(0));
                if (type == BigDecimalClass) {
                    this.invoke(negateBigDecimal);
                    break;
                }
                this.neg(type);
                break;
            }
            case 233: {
                label = this.assembleExpr(node.subexpr(0));
                break;
            }
            case 234: {
                label = this.assembleExpr(node.subexpr(0));
                break;
            }
            case 231: {
                label = this.assembleExpr(node.subexpr(0));
                break;
            }
            case 232: {
                label = this.assembleExpr(node.subexpr(0));
                break;
            }
            case 214: {
                label = this.assembleExpr(node.subexpr(0));
                this.ixor1();
                break;
            }
            case 202: {
                label = this.concat(node);
                break;
            }
            case 200: {
                Object label1 = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                label = label1;
                if (type == BigDecimalClass) {
                    this.invoke(addBigDecimal);
                    break;
                }
                this.add(type);
                break;
            }
            case 241: {
                label = this.assembleExpr(node.subexpr(1));
                this.assignVar((ASTsimpleVariableReference)node.subexpr(0), node.subexpr(1));
                break;
            }
            case 201: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                if (type == BigDecimalClass) {
                    this.invoke(subtractBigDecimal);
                    break;
                }
                this.sub(type);
                break;
            }
            case 204: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                if (type == BigDecimalClass) {
                    this.invoke(multiplyBigDecimal);
                    break;
                }
                this.mul(type);
                break;
            }
            case 205: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                if (type == BigDecimalClass) {
                    this.invoke(divideBigDecimal);
                    break;
                }
                this.invoke(ddiv);
                break;
            }
            case 203: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                this.invoke(imod);
                break;
            }
            case 206: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                this.invoke(idiv);
                break;
            }
            case 207: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                if (type == BigDecimalClass) {
                    this.invoke(powBigDecimal);
                    break;
                }
                this.invoke(pow);
                break;
            }
            case 213: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                this.xor(type);
                break;
            }
            case 209: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                this.xor(type);
                this.ixor1();
                break;
            }
            case 210: {
                label = this.assembleExpr(node.subexpr(0));
                this.ixor1();
                this.assembleExpr(node.subexpr(1));
                this.ior();
                break;
            }
            case 216: 
            case 217: {
                label = this.assembleExpr(node.subexpr(0));
                this.dup(type);
                this.cast(type, booleanClass);
                Object branch = node.id == 217 ? this.ifne(null) : this.ifeq(null);
                this.pop(type);
                this.processImplicitInitializerStatementForOperator(node, "INITIALIZERSTMT");
                this.assembleExpr(node.subexpr(1));
                this.setTarget(branch, this.label());
                break;
            }
            case 237: {
                this.isSafeOperator = true;
                boolean isElvisOp = node.subexpr((int)1).children[0] == node.subexpr(0);
                Object elvisVar = this.createLocal(ObjectClass, CF_ELVIS_EXP_VAR);
                label = this.cast(node.subexpr(0), ObjectClass);
                this.store(elvisVar);
                this.load(elvisVar);
                this.invoke(isTruthyValue);
                this.isSafeOperator = false;
                Object l2 = null;
                Object l1 = this.ifne(null);
                this.processImplicitInitializerStatement(node.subexpr(1), "RIGHT-INIT");
                this.generateInitializerStmtOpCode(node.subexpr((int)1).children[1]);
                Object l3 = this.jmp(null);
                if (isElvisOp) {
                    this.setTarget(l1, this.load(elvisVar));
                } else {
                    Object l4 = this.processImplicitInitializerStatement(node.subexpr(1), "LEFT-INIT");
                    l2 = this.generateInitializerStmtOpCode(node.subexpr((int)1).children[0]);
                    this.setTarget(l1, l4 == null ? l2 : l4);
                }
                this.setTarget(l3, this.label());
                break;
            }
            case 242: {
                this.isSafeOperator = true;
                Object null_coalesceVar = this.createLocal(ObjectClass, CF_NULL_COALESCING_EXP_VAR);
                label = this.cast(node.subexpr(1), ObjectClass);
                this.store(null_coalesceVar);
                this.load(null_coalesceVar);
                this.isSafeOperator = false;
                Object l1 = this.ifnonNull(null);
                this.processImplicitInitializerStatement(node, "LEFT-INIT");
                this.generateInitializerStmtOpCode(node.children[0]);
                Object l3 = this.jmp(null);
                this.setTarget(l1, this.load(null_coalesceVar));
                this.setTarget(l3, this.label());
                break;
            }
            case 224: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                this.invoke(contains);
                break;
            }
            case 225: {
                label = this.assembleExpr(node.subexpr(0));
                this.assembleExpr(node.subexpr(1));
                this.invoke(contains);
                this.ixor1();
                break;
            }
            case 222: 
            case 235: {
                label = this.compare2l(node);
                this.iand1();
                this.ixor1();
                break;
            }
            case 239: {
                label = this.strictCompare2l(node);
                this.iand1();
                this.ixor1();
                break;
            }
            case 240: {
                label = this.strictCompare2l(node);
                this.iand1();
                break;
            }
            case 223: 
            case 236: {
                label = this.compare2l(node);
                this.iand1();
                break;
            }
            case 221: 
            case 230: {
                label = this.compare2g(node);
                this.iushr(31);
                this.ixor1();
                break;
            }
            case 220: 
            case 229: {
                label = this.compare2g(node);
                this.ineg();
                this.iushr(31);
                break;
            }
            case 218: 
            case 227: {
                label = this.compare2l(node);
                this.iushr(31);
                break;
            }
            case 219: 
            case 228: {
                label = this.compare2l(node);
                this.ineg();
                this.iushr(31);
                this.ixor1();
                break;
            }
            case 10001: {
                label = this.invoke((ASTruntimeCall)node);
                break;
            }
            case 10002: {
                label = this.get((ASTsimpleVariableReference)node);
                break;
            }
            case 10003: {
                label = this.resolve((ASTstructureReference)node);
                break;
            }
            case 10000: {
                label = this.index((ASTarrayReference)node);
                break;
            }
            case 10004: {
                String localVarName = ((LocalVariableReference)node).name;
                label = this.load(this.findLocal(localVarName));
                break;
            }
            case 10005: {
                StaticFieldReference staticRef = (StaticFieldReference)node;
                label = this.getstatic(staticRef.className, staticRef.name, staticRef.getType());
                break;
            }
            case 10006: {
                InstanceFieldReference fieldRef = (InstanceFieldReference)node;
                label = this.load(this.pageVar);
                this.getfield(fieldRef.name, fieldRef.getType());
                break;
            }
            default: {
                throw new CompilerInternalException((Object)("unknown node type " + node));
            }
        }
        if (node.isSpreadOperationType()) {
            if (node instanceof ASTliteral) {
                this.invokespecial(newCFStringIterable);
            } else {
                this.invokespecial(newCFObjectIterable);
            }
            label = spreadLabel;
        }
        int line = node.getLine();
        if (!this.disableLineFeed && line != -1) {
            this.addLineNumber(label, line);
        }
        return label;
    }

    private Object processImplicitInitializerStatementForOperator(ExprNode node, String attribute) {
        Node implicitInitializer = node.getNamedAttribute(attribute);
        if (implicitInitializer != null) {
            return this.processInitializers(implicitInitializer);
        }
        return null;
    }

    private Object processImplicitInitializerStatement(Node node, String attribute) {
        Node implicitInitializer = node.getNamedAttribute(attribute);
        if (implicitInitializer != null) {
            return this.processInitializers(implicitInitializer);
        }
        return null;
    }

    private Object processInitializers(Node implicitInitializer) {
        if (implicitInitializer == null) {
            return null;
        }
        Object l4 = null;
        if (implicitInitializer.children != null) {
            for (Node n : implicitInitializer.children) {
                Object l = n instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)n).getStatementType() == 3 ? this.assignStatement((ExprNode)n.getNamedAttribute("LVAL"), n.getNamedAttribute("RVAL")) : this.processInitializers(n);
                if (l4 != null) continue;
                l4 = l;
            }
        }
        return l4;
    }

    Object assembleExpr(ExprNode node) {
        Object label = this._assembleExpr(node, false);
        int line = node.getLine();
        if (!this.disableLineFeed && line != -1) {
            this.addLineNumber(label, line);
        }
        return label;
    }

    Method simpleref(ASTsimpleVariableReference ref, Method stringMethod, Method varMethod) {
        this.aconst(ref.getCodegenVariableName().toUpperCase());
        return stringMethod;
    }

    Method simpleref1(ASTsimpleVariableReference ref, Method stringMethod, Method varMethod) {
        this.aconst(ref.getCodegenVariableName().toUpperCase());
        return varMethod;
    }

    private static boolean isIncrDecrOperator(ExprNode OpNode) {
        return OpNode.id == 233 || OpNode.id == 234 || OpNode.id == 232 || OpNode.id == 231;
    }

    private static ExprNode rearrangeNode(ExprNode node) {
        if (node instanceof ASToperator && ExprAssembler.isIncrDecrOperator(node)) {
            Node currentNode = node;
            if (currentNode.children != null) {
                Node parentNode;
                while (!(currentNode == null && currentNode instanceof ASTsimpleVariableReference || currentNode.children == null || currentNode.children.length <= 0)) {
                    currentNode = currentNode.children[0];
                }
                node.children[0] = parentNode = currentNode.jjtGetParent();
                parentNode.jjtSetParent(node);
            }
        }
        return node;
    }

    Object index(ASTarrayReference array) {
        VariableReference stem = array.getStem();
        int incrDecrOp = this.isIncrDecrOperand(array);
        Method stringMethod = null;
        Method varMethod = null;
        if (array.indices.size() == 1) {
            if (stem instanceof ASTsimpleVariableReference) {
                varMethod = this.getArrayGetMethod(array, array.getIndex(0), incrDecrOp);
                stringMethod = incrDecrOp != -1 ? (this.isSafeOperator ? arrayGetString1IncrDecr_SAFE : arrayGetString1IncrDecr) : (this.isSafeOperator ? arrayGetString1_SAFE : arrayGetString1);
                Object label = this.load(this.pageVar);
                if (array.getIndex(0) instanceof SliceMetadataNode) {
                    stringMethod = arraySliceStr;
                    Method get1 = this.simpleref((ASTsimpleVariableReference)stem, stringMethod, varMethod);
                    SliceMetadataNode slicedNode = (SliceMetadataNode)array.getIndex(0);
                    if (slicedNode.getStartIndex() == null) {
                        slicedNode.setStartIndex(new ASTliteral(""));
                    }
                    if (slicedNode.getEndIndex() == null) {
                        slicedNode.setEndIndex(new ASTliteral(""));
                    }
                    if (slicedNode.getStep() == null) {
                        slicedNode.setStep(new ASTliteral(""));
                    }
                    slicedNode.setStartIndex(ExprAssembler.rearrangeNode(slicedNode.getStartIndex()));
                    slicedNode.setEndIndex(ExprAssembler.rearrangeNode(slicedNode.getEndIndex()));
                    slicedNode.setStep(ExprAssembler.rearrangeNode(slicedNode.getStep()));
                    slicedNode.getStartIndex().jjtSetParent(slicedNode.jjtGetParent());
                    slicedNode.getEndIndex().jjtSetParent(slicedNode.jjtGetParent());
                    slicedNode.getStep().jjtSetParent(slicedNode.jjtGetParent());
                    this.cast(slicedNode.getStartIndex(), ObjectClass);
                    this.cast(slicedNode.getEndIndex(), ObjectClass);
                    this.cast(slicedNode.getStep(), ObjectClass);
                    this.invoke(get1);
                    return label;
                }
                if (((ASTsimpleVariableReference)stem).isSafePreHook()) {
                    stringMethod = arrayGetStringNSafe;
                    varMethod = arrayGetVarNSafe;
                    Method getN = this.simpleref((ASTsimpleVariableReference)stem, stringMethod, varMethod);
                    if (((ASTsimpleVariableReference)stem).isSafePreHook()) {
                        this.aconst(((ASTsimpleVariableReference)stem).isSafePreHook());
                    }
                    this.newarray(ObjectClass, array.indices.toArray());
                    if (((ASTsimpleVariableReference)stem).isSafePreHook()) {
                        this.newarray(ObjectClass, array.safeHooks.toArray());
                    }
                    this.invoke(getN);
                    return label;
                }
                Method get1 = this.simpleref((ASTsimpleVariableReference)stem, stringMethod, varMethod);
                if (array.isAfterSpread()) {
                    String counterVarName = ((ASTsimpleVariableReference)stem).getCodegenVariableName() + "__COUNTER";
                    this.load(this.findLocal(counterVarName));
                    this.invoke(minusOne);
                } else {
                    this.cast(array.getIndex(0), ObjectClass);
                }
                if (incrDecrOp != -1) {
                    this.iconst(incrDecrOp);
                }
                this.invoke(get1);
                return label;
            }
            Object label = this.cast(stem, ObjectClass);
            if (array.getStem() instanceof ASTarrayReference && array.isAfterSpread()) {
                ASTarrayReference arrayRef = (ASTarrayReference)array.getStem();
                String counterVarName = ExprAssembler.getArrayCounterVariableName(arrayRef.getStem());
                this.load(this.findLocal(counterVarName));
                this.invoke(minusOne);
            } else {
                this.cast(array.getIndex(0), ObjectClass);
            }
            if (incrDecrOp != -1) {
                this.iconst(incrDecrOp);
                this.invoke(this.isSafeOperator ? arrayGet1IncrDecr_SAFE : arrayGet1IncrDecr);
            } else {
                if (array.isUsedInLHS()) {
                    this.zconst(true);
                }
                this.invoke(array.isUsedInLHS() ? LHSarrayGet1 : (this.isSafeOperator ? arrayGet1_SAFE : arrayGet1));
            }
            return label;
        }
        if (stem instanceof ASTsimpleVariableReference) {
            if (incrDecrOp != -1) {
                stringMethod = this.isSafeOperator ? arrayGetStringNIncrDecr_SAFE : arrayGetStringNIncrDecr;
                varMethod = this.isSafeOperator ? arrayGetVarNIncrDecr_SAFE : arrayGetVarNIncrDecr;
            } else if (((ASTsimpleVariableReference)stem).isSafePreHook()) {
                stringMethod = arrayGetStringNSafe;
                varMethod = arrayGetVarNSafe;
            } else {
                stringMethod = this.isSafeOperator ? arrayGetStringN_SAFE : arrayGetStringN;
                varMethod = this.isSafeOperator ? arrayGetVarN_SAFE : arrayGetVarN;
            }
            Object label = this.load(this.pageVar);
            Method getN = this.simpleref((ASTsimpleVariableReference)stem, stringMethod, varMethod);
            if (((ASTsimpleVariableReference)stem).isSafePreHook()) {
                this.aconst(((ASTsimpleVariableReference)stem).isSafePreHook());
            }
            this.newarray(ObjectClass, array.indices.toArray());
            if (((ASTsimpleVariableReference)stem).isSafePreHook()) {
                this.newarray(ObjectClass, array.safeHooks.toArray());
            }
            if (incrDecrOp != -1) {
                this.iconst(incrDecrOp);
            }
            this.invoke(getN);
            return label;
        }
        Object label = this.load(this.pageVar);
        this.cast(stem, ObjectClass);
        this.newarray(ObjectClass, array.indices.toArray());
        if (incrDecrOp != -1) {
            this.iconst(incrDecrOp);
            this.invoke(this.isSafeOperator ? arrayGetNIncrDecr_SAFE : arrayGetNIncrDecr);
        } else {
            if (array.isUsedInLHS()) {
                this.zconst(true);
            }
            this.invoke(array.isUsedInLHS() ? LHSarrayGetN : (this.isSafeOperator ? arrayGetN_SAFE : arrayGetN));
        }
        return label;
    }

    Object newarray(Class elementType, Object[] elements) {
        int count = elements != null ? elements.length : 0;
        Object label = this.newarray(elementType, count);
        for (int i = 0; i < count; ++i) {
            this.dup(elementType);
            this.iconst(i);
            if (elements[i] instanceof ASTfunctionDefinition) {
                ASTfunctionDefinition functionNode = (ASTfunctionDefinition)elements[i];
                String funcClassName = this.tc.getClassName() + "$func" + functionNode.getCodeGenName();
                this.newinstance(funcClassName);
                this.invokespecial(funcClassName, "<init>");
            } else if (elements[i] instanceof Node) {
                this.cast((ExprNode)elements[i], elementType);
            } else if (elements[i] instanceof AttributeCollection) {
                ArrayList<Object> list = new ArrayList<Object>();
                AttributeCollection coll = (AttributeCollection)elements[i];
                for (String name : coll.keySet()) {
                    Object value = coll.get(name);
                    list.add(name);
                    list.add(value);
                }
                this.newinstance(AttributeCollectionClass);
                this.newarray(elementType, list.toArray());
                this.invokespecial(newAttributeCollection);
            } else if (elements[i] instanceof Object[]) {
                this.newarray(elementType, (Object[])elements[i]);
            } else {
                this.aconst(elements[i]);
            }
            this.aastore();
        }
        return label;
    }

    Object get(ASTsimpleVariableReference var) {
        if (var.isLeafReference) {
            if (var.getCodegenVariableName().equalsIgnoreCase("static") && var.parser.supportStatic()) {
                this.getstatic(this.findField(this.getStaticScopeVarName()));
                return this.invoke(clone);
            }
            Object label = this.load(this.pageVar);
            this.aconst(var.getVariableName().toUpperCase());
            int incrDecrOp = this.isIncrDecrOperand(var);
            if (incrDecrOp != -1) {
                this.iconst(incrDecrOp);
                if (this.isSafeOperator) {
                    this.invoke(getScalarIncrDecr_SAFE);
                } else {
                    this.invoke(getScalarIncrDecr);
                }
            } else if (ExprClassLoader.inWebSocketScope.get() != null) {
                this.invoke(getScalarForWS);
            } else if (this.isSafeOperator) {
                this.invoke(getScalar_SAFE);
            } else {
                this.invoke(this.isSafeOperator ? getScalar_SAFE : getScalar);
            }
            return label;
        }
        int incrDecrOp = this.isIncrDecrOperand(var);
        if (incrDecrOp != -1) {
            throw new OperationNotSupportedException(var.getStartToken());
        }
        Object label = this.load(this.pageVar);
        this.aconst(var.getVariableName().toUpperCase());
        if (var.isSafePreHook()) {
            this.zconst(true);
            this.invoke(getSafe);
        } else {
            this.invoke(get);
        }
        return label;
    }

    Object getNonLocalScopeVar(ASTsimpleVariableReference var) {
        if (var.isLeafReference) {
            Object label = this.load(this.pageVar);
            this.aconst(var.getVariableName().toUpperCase());
            int incrDecrOp = this.isIncrDecrOperand(var);
            if (incrDecrOp != -1) {
                this.iconst(incrDecrOp);
                this.invoke(getNonLocalScopeVarIncrDecr);
            } else {
                this.invoke(getNonLocalScopeVar);
            }
            return label;
        }
        int incrDecrOp = this.isIncrDecrOperand(var);
        if (incrDecrOp != -1) {
            throw new OperationNotSupportedException(var.getStartToken());
        }
        Object label = this.load(this.pageVar);
        this.aconst(var.getVariableName().toUpperCase());
        this.invoke(get);
        return label;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object resolve(ASTstructureReference struct) {
        boolean isSafe;
        VariableReference stem = struct.getStem();
        int incrDecrOp = this.isIncrDecrOperand(struct);
        boolean bl = isSafe = struct.isSafePreHook() || struct.isSafePostHook();
        if (stem instanceof ASTsimpleVariableReference) {
            Method stringMethod = null;
            Method varMethod = null;
            if (incrDecrOp != -1) {
                if (!struct.isLeafReference) throw new OperationNotSupportedException(struct.getStartToken());
                if (isSafe) {
                    if (struct.isSafePostHook() && stem instanceof ASTsimpleVariableReference && ((ASTsimpleVariableReference)struct.getStem()).isSafePreHook()) {
                        stringMethod = resolveStringScalarIncrDecrStemSafe;
                        varMethod = resolveVarScalarIncrDecrStemSafe;
                    } else {
                        stringMethod = resolveStringScalarIncrDecrSafe;
                        varMethod = resolveVarScalarIncrDecrSafe;
                    }
                } else {
                    stringMethod = this.isSafeOperator ? resolveStringScalarIncrDecr_SAFE : resolveStringScalarIncrDecr;
                    varMethod = this.isSafeOperator ? resolveVarScalarIncrDecr_SAFE : resolveVarScalarIncrDecr;
                }
            } else if (isSafe) {
                if (struct.isSafePostHook() && stem instanceof ASTsimpleVariableReference && ((ASTsimpleVariableReference)struct.getStem()).isSafePreHook()) {
                    Method method = struct.isLeafReference ? (ExprClassLoader.inWebSocketScope.get() != null ? resolveStringScalarWSSafe : (this.isSafeOperator ? resolveStringScalarStemSafe_SAFE : resolveStringScalarStemSafe)) : (stringMethod = struct.isLHS ? lhsResolveString : resolveStringStemSafe);
                    varMethod = struct.isLeafReference ? resolveVarScalarStemSafe : (struct.isLHS ? lhsResolveVar : resolveVarStemSafe);
                } else {
                    Method method = struct.isLeafReference ? (ExprClassLoader.inWebSocketScope.get() != null ? resolveStringScalarWSSafe : (this.isSafeOperator ? resolveStringScalar_SAFE : resolveStringScalarSafe)) : (stringMethod = struct.isLHS ? lhsResolveString : resolveStringSafe);
                    varMethod = struct.isLeafReference ? (this.isSafeOperator ? resolveVarScalar_SAFE : resolveVarScalar) : (struct.isLHS ? lhsResolveVar : resolveVarSafe);
                }
            } else {
                Method method = struct.isLeafReference ? (ExprClassLoader.inWebSocketScope.get() != null ? resolveStringScalarWS : (this.isSafeOperator ? resolveStringScalar_SAFE : resolveStringScalar)) : (struct.isLHS ? lhsResolveString : (stringMethod = this.isSafeOperator ? _resolveString : resolveString));
                varMethod = struct.isLeafReference ? (this.isSafeOperator ? resolveVarScalar_SAFE : resolveVarScalar) : (struct.isLHS ? lhsResolveVar : (this.isSafeOperator ? _resolveVar : resolveVar));
            }
            Object label = this.load(this.pageVar);
            Method m = this.simpleref((ASTsimpleVariableReference)stem, stringMethod, varMethod);
            this.newarray(StringClass, struct.getStructureKeys());
            if (incrDecrOp != -1) {
                this.iconst(incrDecrOp);
            }
            if (isSafe) {
                this.zconst(struct.isSafePreHook());
                this.zconst(struct.isSafePostHook());
                if (struct.isSafePostHook() && stem instanceof ASTsimpleVariableReference && ((ASTsimpleVariableReference)struct.getStem()).isSafePreHook()) {
                    this.zconst(true);
                }
            }
            this.invoke(m);
            return label;
        }
        Method resolve = null;
        if (incrDecrOp != -1) {
            if (!struct.isLeafReference) throw new OperationNotSupportedException(struct.getStartToken());
            resolve = isSafe ? resolveMapScalarIncrDecrSafe : (this.isSafeOperator ? resolveMapScalarIncrDecr_SAFE : resolveMapScalarIncrDecr);
        } else {
            resolve = isSafe ? (struct.isLeafReference ? resolveMapScalarSafe : (struct.isLHS ? lhsResolveMap : resolveMapSafe)) : (struct.isLeafReference ? (this.isSafeOperator ? resolveMapScalar_SAFE : resolveMapScalar) : (struct.isLHS ? lhsResolveMap : (this.isSafeOperator ? _resolveMap : resolveMap)));
        }
        Object label = this.load(this.pageVar);
        this.cast(stem, MapClass);
        this.newarray(StringClass, struct.getStructureKeys());
        if (incrDecrOp != -1) {
            this.iconst(incrDecrOp);
        }
        if (isSafe) {
            this.zconst(struct.isSafePreHook());
            this.zconst(struct.isSafePostHook());
        }
        this.invoke(resolve);
        return label;
    }

    Object invoke(ASTfuncparams funcparams) {
        Method method = funcparams.getMethod();
        if (method == null) {
            System.out.println("func method null " + funcparams + " line:col " + funcparams.getStartToken().beginLine + ":" + funcparams.getStartToken().beginColumn + " name " + funcparams.getFunctionName());
            throw new NullPointerException();
        }
        if (funcparams.getLine() != -1) {
            this.generateLineNo(funcparams.getLine());
        }
        Object label = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            label = this.load(this.pageVar);
        }
        if (!funcparams.isVariadic) {
            int count = funcparams.jjtGetNumChildren();
            for (int i = 0; i < count; ++i) {
                if (funcparams.children[i] instanceof ASTfunctionDefinition) {
                    ASTfunctionDefinition functionNode = (ASTfunctionDefinition)funcparams.children[i];
                    if (!functionNode.isClosure()) continue;
                    String funcClassName = this.tc.getClassName() + "$func" + functionNode.getCodeGenName();
                    this.newinstance(funcClassName);
                    Object mLabel = this.invokespecial(funcClassName, "<init>");
                    if (mLabel != null) continue;
                    label = mLabel;
                    continue;
                }
                Object castLabel = this.cast(funcparams.subexpr(i), funcparams.getParamType(i));
                if (label != null) continue;
                label = castLabel;
            }
        } else if (funcparams.getFunctionName().equalsIgnoreCase("arraypush") || funcparams.getFunctionName().equalsIgnoreCase("arrayunshift")) {
            label = this.newarray(funcparams.getParamType(0), funcparams.children);
            if (funcparams.children != null) {
                for (int i = 0; i < funcparams.children.length; ++i) {
                    if (!(funcparams.children[i] instanceof ExprNode) || !((ExprNode)funcparams.children[i]).isSpreadOperationType()) continue;
                    label = this.invoke(expandSpreadArgs);
                    break;
                }
            }
        } else {
            label = this.newarray(StringClass, funcparams.children);
        }
        Object invokeLabel = this.invoke(method);
        if (label == null) {
            label = invokeLabel;
        }
        return label;
    }

    Object invokeNew(ASTfuncparams funcparams, ExprNode cfcName) {
        boolean namedArgFuncCall = false;
        if (funcparams.children != null && funcparams.children[0] instanceof ASTtagAttribute) {
            namedArgFuncCall = true;
        }
        Object label = null;
        label = this.load(this.pageVar);
        this.cast(cfcName, String.class);
        if (namedArgFuncCall) {
            this.newinstance(ArgumentCollectionClass);
            Object[] names = new String[funcparams.children.length];
            Object[] exprs = new ExprNode[funcparams.children.length];
            for (int i = 0; i < funcparams.children.length; ++i) {
                names[i] = ((ASTtagAttribute)funcparams.children[i]).getName();
                exprs[i] = ((ASTtagAttribute)funcparams.children[i]).getValueNode();
            }
            this.newarray(StringClass, names);
            this.newarray(ObjectClass, exprs);
            this.invokespecial(newArgumentCollection);
            this.invoke(createObjectNamedArgMethod);
        } else {
            this.newarray(ObjectClass, funcparams.children);
            if (funcparams.children != null) {
                for (int i = 0; i < funcparams.children.length; ++i) {
                    if (!(funcparams.children[i] instanceof ExprNode) || !((ExprNode)funcparams.children[i]).isSpreadOperationType()) continue;
                    this.invoke(expandSpreadArgs);
                    break;
                }
            }
            this.invoke(createObjectMethod);
        }
        return label;
    }

    private String resolveStemIndices(ASTstructureReference structRef) {
        Node currNode;
        Object keyStr = "";
        for (currNode = structRef; currNode != null && !(currNode instanceof ASTsimpleVariableReference); currNode = currNode.getNamedAttribute("STEM")) {
            keyStr = "." + currNode.getStartToken().image.toUpperCase() + (String)keyStr;
            if (!(currNode instanceof ASTstructureReference) || !currNode.isSafePreHook()) break;
        }
        if (currNode instanceof ASTsimpleVariableReference) {
            keyStr = "." + ((ASTsimpleVariableReference)currNode).getCodegenVariableName() + (String)keyStr;
        }
        return ((String)keyStr).replaceFirst(".", "");
    }

    Object invokeIsNull(ASTfuncparams funcparams) {
        Object label = null;
        label = this.load(this.pageVar);
        ExprNode argument = null;
        if (funcparams.jjtGetNumChildren() != 1) {
            throw new IsNullArgumentException();
        }
        argument = (ExprNode)funcparams.children[0];
        if (this.findAnyRuntimeOrArrayCall(argument)) {
            this.cast(argument, Object.class);
            this.zconst(true);
        } else {
            String argString = "";
            argString = argument instanceof ASTstructureReference && ((ASTstructureReference)argument).isSafePreHook() ? this.resolveStemIndices((ASTstructureReference)argument) : argument.getStartToken().image.toUpperCase();
            if (argString.indexOf(".") != -1) {
                this.aconst(argString);
            } else if (this instanceof FunctionAssembler) {
                Object varLocal = this.findLocal(argString);
                boolean resolved = false;
                if (argument instanceof ASTsimpleVariableReference) {
                    resolved = this.resolveStatic((ASTsimpleVariableReference)argument, varLocal);
                }
                if (!resolved) {
                    if (varLocal != null) {
                        this.load(varLocal);
                    } else {
                        this.aconst(argString);
                    }
                }
            } else {
                Object varField = this.findField(argString);
                boolean resolved = false;
                if (argument instanceof ASTsimpleVariableReference) {
                    resolved = this.resolveStatic((ASTsimpleVariableReference)argument, varField);
                }
                if (!resolved) {
                    if (varField != null) {
                        this.load(this.pageVar);
                        this.getfield(varField);
                    } else {
                        this.aconst(argString);
                    }
                }
            }
            this.zconst(false);
        }
        this.invoke(isNull);
        return label;
    }

    private boolean resolveStatic(ASTsimpleVariableReference var, Object varField) {
        if (var.isStaticAccessor()) {
            this.resolveStaticAccessorVariable(var);
        } else if (var.isStatic()) {
            this.load(this.pageVar);
            this.getstatic(this.findField(this.getStaticScopeVarName()));
            if (varField != null) {
                this.getstatic(varField);
            } else {
                this.aconst(var.getCodegenVariableName());
            }
            if (var.getFunctionDef() != null && var.isLval()) {
                this.aconst(var.getAccessModifier());
                this.invoke(_declareStaticVariable);
            } else {
                if (this instanceof FunctionAssembler) {
                    this.load(((FunctionAssembler)this).functionVar);
                } else {
                    this.aconst(null);
                }
                this.invoke(_resolveStaticVariable);
            }
        } else {
            return false;
        }
        return true;
    }

    private Object resolveStaticValue(String str, boolean isAccessor, String ref) {
        if (isAccessor) {
            return this.resolveStaticAccessorVariableValue(str, ref);
        }
        Object label = this.load(this.pageVar);
        this.getstatic(this.findField(this.getStaticScopeVarName()));
        this.aconst(str);
        if (this instanceof FunctionAssembler) {
            this.load(((FunctionAssembler)this).functionVar);
        } else {
            this.aconst(null);
        }
        this.invoke(_resolveStaticVariableValue);
        return label;
    }

    private void resolveStaticAccessorVariable(ASTsimpleVariableReference ref) {
        this.load(this.pageVar);
        this.aconst(ref.getAccessorReference());
        this.aconst(ref.getCodegenVariableName());
        if (this instanceof FunctionAssembler) {
            this.load(((FunctionAssembler)this).functionVar);
        } else {
            this.aconst(null);
        }
        this.invoke(_resolveStaticAccessorVariable);
    }

    private Object resolveStaticAccessorVariableValue(String variable, String ref) {
        Object label = this.load(this.pageVar);
        this.aconst(ref);
        this.aconst(variable);
        if (this instanceof FunctionAssembler) {
            this.load(((FunctionAssembler)this).functionVar);
        } else {
            this.aconst(null);
        }
        this.invoke(_resolveStaticAccessorVariableValue);
        return label;
    }

    private boolean findAnyRuntimeOrArrayCall(ExprNode node) {
        if (node instanceof VariableReference) {
            for (VariableReference varRef = (VariableReference)node; varRef != null; varRef = varRef.getStem()) {
                if (!(varRef instanceof ASTruntimeCall) && !(varRef instanceof ASTarrayReference)) continue;
                return true;
            }
        }
        return false;
    }

    Object invoke(ASTruntimeCall call) {
        ASTfuncparams funcparams;
        boolean isSafePreHook = call.isSafePreHook();
        boolean isSafePostHook = call.isSafePostHook();
        boolean isSafe = isSafePreHook || isSafePostHook;
        boolean isFunctionalExpression = false;
        if (call.getNameToken() != null) {
            String functionName = call.getFunctionName();
            isFunctionalExpression = functionName.equals("_$$functionExpression$$_");
        }
        if (call.isBuiltin()) {
            if (call.isNew()) {
                return this.invokeNew(call.arguments, call.getNewArgumentCfc());
            }
            if (call.getFunctionName().equalsIgnoreCase("isNull")) {
                return this.invokeIsNull(call.arguments);
            }
            return this.invoke(call.arguments);
        }
        this.generateLineNo(call.getLine());
        if (isFunctionalExpression && call.getStem() instanceof ASTarrayReference) {
            call.setAssociativeArrayNotation(true);
        }
        if (!call.isAssociativeArrayNotation() && (call.hasSimpleReference() || isFunctionalExpression)) {
            funcparams = call.arguments;
            Object label = call.isStaticAccessor() || call.isStatic() || this.isStaticDef(call) ? this.resolveStaticValue(call.getFunctionName(), call.isStaticAccessor(), call.getAccessorReference()) : this.cast(call.getStem(), ObjectClass);
            this.aconst(call.getFunctionName());
            this.load(this.pageVar);
            if (isSafe) {
                this.assembleFuncParams(funcparams, invokeUdfSafe, invokeUdfNamedSafe, isSafePreHook, isSafePostHook);
            } else {
                this.assembleFuncParams(funcparams, invokeUdf, invokeUdfNamed, false, false);
            }
            return label;
        }
        funcparams = call.arguments;
        Object label = this.load(this.pageVar);
        if (isFunctionalExpression) {
            ASTarrayReference asTarrayReference = (ASTarrayReference)call.getStem();
            ExprNode funcName = asTarrayReference.removeIndex();
            call.setFuncName(funcName);
        }
        this.cast(call.getStem(), ObjectClass);
        Method method = invokeMethod;
        Method namedMethod = invokeMethodNamed;
        if (!call.isAssociativeArrayNotation()) {
            this.aconst(call.getFunctionName());
        } else {
            method = invokeAssociativeMethod;
            namedMethod = invokeAssociativeMethodNamed;
            if (call.getFuncName() != null) {
                this.cast(call.getFuncName(), ObjectClass);
            } else {
                this.aconst(call.getFunctionName());
            }
        }
        if (isSafe) {
            this.assembleFuncParams(funcparams, invokeMethodSafe, invokeMethodNamedSafe, isSafePreHook, isSafePostHook);
        } else {
            this.assembleFuncParams(funcparams, method, namedMethod);
        }
        return label;
    }

    private boolean isStaticDef(ASTruntimeCall call) {
        if (call == null) {
            return false;
        }
        ASTfunctionDefinition def = null;
        try {
            def = call.getFunctionDef();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return def != null && def.isStatic();
    }

    void generateLineNo(int lineNo) {
        this.load(this.pageVar);
        this.iconst(lineNo);
        this.invokeVoid(setCurrentLineNo);
    }

    public boolean isUDFClosure(String functionName) {
        Object obj = this.tc.getClosureTable().get(functionName);
        return obj != null;
    }

    private void assembleFuncParams(ASTfuncparams args, Method orderedArgsMethod, Method namedArgsMethod) {
        this.assembleFuncParams(args, orderedArgsMethod, namedArgsMethod, false, false);
    }

    private void assembleFuncParams(ASTfuncparams args, Method orderedArgsMethod, Method namedArgsMethod, boolean isSafePreHook, boolean isSafePostHook) {
        boolean collectionParam = false;
        boolean spreadArgument = false;
        if (args.children != null) {
            for (int i = 0; i < args.children.length; ++i) {
                if (args.children[i] instanceof ASTtagAttribute) {
                    collectionParam = true;
                    break;
                }
                if (!(args.children[i] instanceof ExprNode) || !((ExprNode)args.children[i]).isSpreadOperationType()) continue;
                spreadArgument = true;
            }
        }
        if (collectionParam) {
            this.newinstance(ArgumentCollectionClass);
            Object[] names = new String[args.children.length];
            Object[] exprs = new Node[args.children.length];
            for (int i = 0; i < args.children.length; ++i) {
                if (args.children[i] instanceof ASTtagAttribute) {
                    names[i] = ((ASTtagAttribute)args.children[i]).getName();
                    exprs[i] = ((ASTtagAttribute)args.children[i]).getValueNode();
                    continue;
                }
                names[i] = "Param" + i;
                exprs[i] = args.children[i];
            }
            this.newarray(StringClass, names);
            this.newarray(ObjectClass, exprs);
            if (isSafePreHook || isSafePostHook) {
                this.zconst(isSafePreHook);
                this.zconst(isSafePostHook);
            }
            this.invokespecial(newArgumentCollection);
            this.invoke(namedArgsMethod);
        } else {
            this.newarray(ObjectClass, args.children);
            if (spreadArgument) {
                this.invoke(expandSpreadArgs);
            }
            if (isSafePreHook || isSafePostHook) {
                this.zconst(isSafePreHook);
                this.zconst(isSafePostHook);
            }
            this.invoke(orderedArgsMethod);
        }
    }

    private Object compare2l(ExprNode node) {
        ExprNode lhs = node.subexpr(0);
        ExprNode rhs = node.subexpr(1);
        if (lhs.getType().isPrimitive() && rhs.getType().isPrimitive()) {
            Object label = this.cast(lhs, doubleClass);
            this.cast(rhs, doubleClass);
            this.dcmpl();
            return label;
        }
        Object label = this.cast(node.subexpr(0), ObjectClass);
        this.cast(node.subexpr(1), ObjectClass);
        this.invoke(compare);
        this.dcmpl0();
        return label;
    }

    private Object strictCompare2l(ExprNode node) {
        Object label = this.cast(node.subexpr(0), ObjectClass);
        this.cast(node.subexpr(1), ObjectClass);
        this.invoke(strictCompare);
        this.dcmpl0();
        return label;
    }

    private Object compare2g(ExprNode node) {
        ExprNode lhs = node.subexpr(0);
        ExprNode rhs = node.subexpr(1);
        if (lhs.getType().isPrimitive() && rhs.getType().isPrimitive()) {
            Object label = this.cast(lhs, doubleClass);
            this.cast(rhs, doubleClass);
            this.dcmpg();
            return label;
        }
        Object label = this.cast(node.subexpr(0), ObjectClass);
        this.cast(node.subexpr(1), ObjectClass);
        this.invoke(compare);
        this.dcmpg0();
        return label;
    }

    Object concat(ExprNode op) {
        if (op.children.length == 2) {
            Object label = this.assembleExpr(op.subexpr(0));
            this.assembleExpr(op.subexpr(1));
            if (FusionContext.isPreserveNullValues()) {
                this.invoke(nullSafeConcat);
            } else {
                this.invoke(concat);
            }
            return label;
        }
        Object label = this.newinstance(StringBuilderClass);
        this.assembleExpr(op.subexpr(0));
        this.invokespecial(newStringBuilder);
        for (int i = 1; i < op.children.length; ++i) {
            this.assembleExpr(op.subexpr(i));
            this.invoke(append);
        }
        this.invoke(toString);
        return label;
    }

    private void variable(ASTsimpleVariableReference var) {
        var.declareVariable(var.getCodegenVariableName(), var.isFinalVariable());
    }

    Object assignStatement(ExprNode lval, Node rvalNode) {
        ExprNode rval = (ExprNode)rvalNode;
        if (lval instanceof ASTDestructring) {
            Object label = this.label();
            ((ASTDestructring)lval).handle(rval, this);
            return label;
        }
        switch (lval.id) {
            case 10002: {
                return this.assignVar((ASTsimpleVariableReference)lval, rval);
            }
            case 10000: {
                return this.assignArray((ASTarrayReference)lval, rval);
            }
            case 10003: {
                return this.assignStruct((ASTstructureReference)lval, rval);
            }
            case 27: 
            case 202: {
                return this.assignDynamic(lval, rval);
            }
        }
        throw new ParseException(lval.getStartToken());
    }

    Object assignStatement(ExprNode lval) {
        LocalVariableReference localRef = new LocalVariableReference(lval.jjtGetParent(), "value");
        localRef.setType(ObjectClass);
        return this.assignStatement(lval, localRef);
    }

    private Object assignDynamic(ExprNode lval, ExprNode rval) {
        Object label = this.load(this.pageVar);
        this.cast(lval, StringClass);
        this.assembleExpr(rval);
        this.invoke(set);
        return label;
    }

    private boolean checkIfKeyIsFinal(String[] keys) {
        boolean isFinal = false;
        Map<String, String> finalVarsAsDSKey = null;
        if (this instanceof FunctionAssembler) {
            String funcName = ((FunctionAssembler)this).getFunction().functionName.image.toUpperCase();
            if (this.tc.getFunctionNonLocalPrefixedFinalVariables() != null && this.tc.getFunctionNonLocalPrefixedFinalVariables().get(funcName) != null) {
                finalVarsAsDSKey = this.tc.getFunctionNonLocalPrefixedFinalVariables().get(funcName);
            }
        } else if (this.tc != null) {
            finalVarsAsDSKey = this.tc.getFinalVariablesAsDSKey();
        }
        if (finalVarsAsDSKey != null && !finalVarsAsDSKey.isEmpty() && keys != null && keys.length > 0) {
            for (String key : keys) {
                isFinal = finalVarsAsDSKey.containsKey(key);
                if (!isFinal) continue;
                return isFinal;
            }
        }
        return isFinal;
    }

    private Object assignStruct(ASTstructureReference struct, ExprNode rval) {
        VariableReference stem = struct.getStem();
        if (stem instanceof ASTsimpleVariableReference) {
            Object label = this.load(this.pageVar);
            boolean hasFinalKey = this.checkIfKeyIsFinal(struct.getStructureKeys());
            Method m = null;
            if (hasFinalKey) {
                m = this.simpleref((ASTsimpleVariableReference)stem, structSetStringFinal, structSetVarFinal);
                this.newarray(StringClass, struct.getStructureKeys());
                this.assembleExpr(rval);
                this.invokeVoid(m);
            } else {
                m = this.simpleref((ASTsimpleVariableReference)stem, structSetStringCase, structSetVarCase);
                this.newarray(StringClass, struct.getStructureKeys());
                this.assembleExpr(rval);
                this.invokeVoid(m);
            }
            return label;
        }
        Object label = this.load(this.pageVar);
        this.cast(stem, MapClass);
        this.newarray(StringClass, struct.getStructureKeys());
        this.assembleExpr(rval);
        boolean hasFinalKey = this.checkIfKeyIsFinal(struct.getStructureKeys());
        if (hasFinalKey) {
            this.invokeVoid(structSetObjectFinal);
        } else {
            this.invokeVoid(structSetObject);
        }
        return label;
    }

    private String[] getArrayIndices(ASTarrayReference array) {
        String[] arIndices = null;
        Vector indices = array.indices;
        int size = indices.size();
        if (indices != null && size > 0) {
            arIndices = new String[size];
            for (int index = 0; index < size; ++index) {
                Object elem = indices.get(index);
                String key = null;
                if (elem instanceof ASTsimpleVariableReference) {
                    arIndices[index] = key = ((ASTsimpleVariableReference)elem).getCodegenVariableName();
                    continue;
                }
                if (elem instanceof ASTliteral) {
                    ASTliteral literal = (ASTliteral)elem;
                    if (literal == null || literal.tokens == null || literal.tokens.size() <= 0 || literal.tokens.get(0) == null) continue;
                    arIndices[index] = String.valueOf(literal.tokens.get(0));
                    continue;
                }
                if (!(elem instanceof ASTarrayReference)) continue;
                ASTarrayReference arrayRef = (ASTarrayReference)elem;
                return this.getArrayIndices(arrayRef);
            }
        }
        return arIndices;
    }

    private Object assignArray(ASTarrayReference array, ExprNode rval) {
        if (array.getStem() instanceof ASTsimpleVariableReference) {
            ASTsimpleVariableReference arrayRef = (ASTsimpleVariableReference)array.getStem();
            Object label = this.load(this.pageVar);
            boolean hasFinalKey = this.checkIfKeyIsFinal(this.getArrayIndices(array));
            boolean isSpreadElement = false;
            Method setMethod = hasFinalKey ? arraySetVarFinal : (array.isAfterSpread() || (isSpreadElement = rval != null && rval.children != null && ExprAssembler.isSpreadElement(rval.children[0])) ? arraySetForSpread : arraySetVar);
            Method stringMethod = hasFinalKey ? arraySetStringFinal : arraySetString;
            Method m = this.simpleref(arrayRef, stringMethod, setMethod);
            if (isSpreadElement || array.isAfterSpread()) {
                Object counterVar;
                String counterVarName = arrayRef.getCodegenVariableName() + "__COUNTER";
                if (array.isAfterSpread()) {
                    counterVar = this.findLocal(counterVarName);
                    this.newarray(ObjectClass, new Object[]{counterVar});
                } else {
                    counterVar = this.createLocal(Integer.class, counterVarName);
                    this.newarray(ObjectClass, array.indices.toArray());
                }
                this.assembleExpr(rval);
                this.invoke(m);
                return this.store(counterVar);
            }
            this.newarray(ObjectClass, array.indices.toArray());
            this.assembleExpr(rval);
            this.invokeVoid(m);
            return label;
        }
        Object label = null;
        label = this.cast(array.getStem(), ObjectClass);
        boolean hasFinalKey = this.checkIfKeyIsFinal(this.getArrayIndices(array));
        if (!hasFinalKey && array.getStem() instanceof ASTarrayReference) {
            String counterVarName;
            ASTarrayReference arrayRef = (ASTarrayReference)array.getStem();
            if ((array.isAfterSpread() || rval != null && rval.children != null && ExprAssembler.isSpreadElement(rval.children[0])) && (counterVarName = ExprAssembler.getArrayCounterVariableName(arrayRef.getStem())) != null) {
                Object counterVar;
                if (array.isAfterSpread()) {
                    counterVar = this.findLocal(counterVarName);
                    this.newarray(ObjectClass, new Object[]{counterVar});
                } else {
                    counterVar = this.createLocal(Integer.class, counterVarName);
                    this.newarray(ObjectClass, array.indices.toArray());
                }
                this.assembleExpr(rval);
                this.invoke(arraySetForSpreadObj);
                return this.store(counterVar);
            }
        }
        this.newarray(ObjectClass, array.indices.toArray());
        this.assembleExpr(rval);
        if (hasFinalKey) {
            this.invokeVoid(arraySetObjectFinal);
        } else {
            this.invokeVoid(arraySetObject);
        }
        return label;
    }

    private static boolean isSpreadElement(Node node) {
        if (node instanceof ExprNode) {
            return ((ExprNode)node).isSpreadOperationType();
        }
        return false;
    }

    private static String getArrayCounterVariableName(VariableReference ref) {
        int counter = 0;
        while (ref != null && !(ref instanceof ASTsimpleVariableReference)) {
            ref = ref.getStem();
            ++counter;
        }
        if (ref instanceof ASTsimpleVariableReference) {
            return ((ASTsimpleVariableReference)ref).getCodegenVariableName() + "__COUNTER" + counter;
        }
        return null;
    }

    Object assignVar(ASTsimpleVariableReference var, ExprNode rval) {
        String varName = var.getVariableName().toUpperCase();
        boolean isFinalVar = false;
        if (this instanceof FunctionAssembler) {
            String functionName = ((FunctionAssembler)this).getFunction().functionName.image.toUpperCase();
            Map<String, Map<String, String>> functionNonLocalFinalVars = this.tc.getFunctionNonLocalFinalVariables();
            if (functionName != null && functionNonLocalFinalVars != null && functionNonLocalFinalVars.get(functionName) != null && functionNonLocalFinalVars.get(functionName).containsKey(varName)) {
                isFinalVar = true;
            }
        }
        Object label = this.load(this.pageVar);
        this.aconst(varName);
        this.disableLineFeed = true;
        this.assembleExpr(rval);
        this.disableLineFeed = false;
        if (isFinalVar) {
            this.invokeVoid(set_Final);
        } else {
            this.invokeVoid(set);
        }
        return label;
    }

    Object assignVarNonLocalScope(ASTsimpleVariableReference var, ExprNode rval) {
        String varName = var.getVariableName().toUpperCase();
        Object label = this.load(this.pageVar);
        this.aconst(varName);
        this.assembleExpr(rval);
        this.invokeVoid(setNonLocalScope);
        return label;
    }

    Object declareImplicitVar(Node node, String implicitVarName) {
        String varName = implicitVarName.toUpperCase();
        if (node.getFunctionDef() != null) {
            Object localScopeParam = this.findLocal("__localScope");
            Object implicitVar = this.createLocal(VariableClass, varName);
            Object label = this.load(localScopeParam);
            this.aconst(varName);
            this.invoke(bindInternal);
            this.store(implicitVar);
            return label;
        }
        return null;
    }

    Object cast(ExprNode node, Class to) {
        Object label = this.assembleExpr(node);
        this.cast(node.getType(), to);
        return label;
    }

    Object cast(ASTcffunction node, Class to) {
        String funcClassName = this.tc.getClassName() + "$func" + node.getCodeGenName();
        Object label = this.newinstance(funcClassName);
        this.invokespecial(funcClassName, "<init>");
        this.cast(ASTcffunction.class, to);
        return label;
    }

    @Override
    public void cast(Class from, Class to) {
        if (from == null) {
            from = Object.class;
        }
        if (from != to) {
            if (to == voidClass) {
                this.pop(from);
            } else {
                if (from == voidClass) {
                    throw new IllegalArgumentException("cannot cast void to non-void");
                }
                if (!from.isPrimitive() && !to.isPrimitive()) {
                    if (!to.isAssignableFrom(from)) {
                        if (from != ObjectClass && from.isAssignableFrom(to)) {
                            super.cast(from, to);
                        } else {
                            Method m = Cast.findCastMethod(to, from);
                            if (m != null) {
                                this.cast(from, m.getParameterTypes()[0]);
                                this.invoke(m);
                                super.cast(m.getReturnType(), to);
                            } else {
                                this.cast(from, ObjectClass);
                                this.aconst(to);
                                this.invoke(cast);
                                super.cast(cast.getReturnType(), to);
                            }
                        }
                    }
                } else if (from.isPrimitive() && to.isPrimitive()) {
                    if (Cast.assignable(to, from)) {
                        super.cast(from, to);
                    } else {
                        Method m = Cast.findCastMethod(to, from);
                        if (m != null) {
                            this.cast(from, m.getParameterTypes()[0]);
                            this.invoke(m);
                            super.cast(m.getReturnType(), to);
                        } else if (to != booleanClass && from != booleanClass) {
                            super.cast(from, to);
                        } else {
                            this.cast(from, ObjectClass);
                            this.aconst(to);
                            this.invoke(cast);
                            super.cast(cast.getReturnType(), to);
                        }
                    }
                } else {
                    Method m = Cast.findCastMethod(to, from);
                    if (m != null) {
                        this.cast(from, m.getParameterTypes()[0]);
                        this.invoke(m);
                        super.cast(m.getReturnType(), to);
                    } else {
                        this.cast(from, ObjectClass);
                        this.aconst(to);
                        this.invoke(cast);
                        super.cast(cast.getReturnType(), to);
                    }
                }
            }
        }
    }

    protected int isIncrDecrOperand(VariableReference var) {
        int incrDecrOpId = -1;
        Node OpNode = null;
        if (var.jjtGetParent() != null && var.jjtGetParent().jjtGetParent() != null) {
            boolean isIncrDecrOp;
            OpNode = var.jjtGetParent().jjtGetParent();
            boolean bl = isIncrDecrOp = OpNode.id == 233 || OpNode.id == 234 || OpNode.id == 232 || OpNode.id == 231;
            if (isIncrDecrOp) {
                incrDecrOpId = OpNode.id;
            }
        }
        return incrDecrOpId;
    }

    public Method generateSetVarCode(ExprNode rval) {
        Object value;
        if (rval instanceof ASToperator && rval.id == 226 && (value = this.getNodeValue(rval)) != null) {
            if (value instanceof Double) {
                this.aconst(value);
                return setVarDouble;
            }
            if (value instanceof Integer) {
                this.aconst(value);
                return setVarInteger;
            }
            if (value instanceof Long) {
                this.aconst(value);
                return setVarLong;
            }
            if (value instanceof Boolean) {
                this.aconst(value);
                return setVarBoolean;
            }
        }
        this.cast(rval, ObjectClass);
        return setVar;
    }

    private Method getArrayGetMethod(ASTarrayReference array, ExprNode index, int incrDecrOp) {
        if (index instanceof SliceMetadataNode) {
            Method varMethod = arraySlice;
            return varMethod;
        }
        Method varMethod = incrDecrOp != -1 ? (this.isSafeOperator ? arrayGetVar1IncrDecr_SAFE : arrayGetVar1IncrDecr) : (this.isSafeOperator ? arrayGetVar1_SAFE : arrayGetVar1);
        return varMethod;
    }

    public Object getNodeValue(ExprNode rval) {
        Object value = null;
        ExprNode node = rval;
        if (!(node instanceof ASTliteral) && node.children != null) {
            node = node.subexpr(0);
        }
        if (node instanceof ASTliteral) {
            value = ExprAssembler.getASTLiteralNodeValue(rval, node);
        }
        return value;
    }

    public String getStaticScopeVarName() {
        return this.tc.getClassName() + "$staticScope";
    }

    public static Object getASTLiteralNodeValue(ExprNode parentNode, ExprNode node) {
        Object value = null;
        if (node instanceof ASTliteral) {
            value = ((ASTliteral)node).tokens.get(0);
        }
        return value;
    }

    public class IsNullArgumentException
    extends ApplicationException {
    }

    public class ClosureAssignmentOutsideFunctionException
    extends ApplicationException {
    }
}

